/*
 * Decompiled with CFR 0.152.
 */
package name.fraser.neil.plaintext;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import junit.framework.TestCase;
import name.fraser.neil.plaintext.diff_match_patch;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringEscapeUtils;

public class diff_match_patch_test
extends TestCase {
    private diff_match_patch dmp;
    private diff_match_patch.Operation DELETE = diff_match_patch.Operation.DELETE;
    private diff_match_patch.Operation EQUAL = diff_match_patch.Operation.EQUAL;
    private diff_match_patch.Operation INSERT = diff_match_patch.Operation.INSERT;

    protected void setUp() {
        this.dmp = new diff_match_patch();
    }

    public void testDiffCommonPrefix() {
        diff_match_patch_test.assertEquals((String)"diff_commonPrefix: Null case.", (int)0, (int)this.dmp.diff_commonPrefix("abc", "xyz"));
        diff_match_patch_test.assertEquals((String)"diff_commonPrefix: Non-null case.", (int)4, (int)this.dmp.diff_commonPrefix("1234abcdef", "1234xyz"));
        diff_match_patch_test.assertEquals((String)"diff_commonPrefix: Whole case.", (int)4, (int)this.dmp.diff_commonPrefix("1234", "1234xyz"));
    }

    public void testDiffCommonSuffix() {
        diff_match_patch_test.assertEquals((String)"diff_commonSuffix: Null case.", (int)0, (int)this.dmp.diff_commonSuffix("abc", "xyz"));
        diff_match_patch_test.assertEquals((String)"diff_commonSuffix: Non-null case.", (int)4, (int)this.dmp.diff_commonSuffix("abcdef1234", "xyz1234"));
        diff_match_patch_test.assertEquals((String)"diff_commonSuffix: Whole case.", (int)4, (int)this.dmp.diff_commonSuffix("1234", "xyz1234"));
    }

    public void testDiffCommonOverlap() {
        diff_match_patch_test.assertEquals((String)"diff_commonOverlap: Null case.", (int)0, (int)this.dmp.diff_commonOverlap("", "abcd"));
        diff_match_patch_test.assertEquals((String)"diff_commonOverlap: Whole case.", (int)3, (int)this.dmp.diff_commonOverlap("abc", "abcd"));
        diff_match_patch_test.assertEquals((String)"diff_commonOverlap: No overlap.", (int)0, (int)this.dmp.diff_commonOverlap("123456", "abcd"));
        diff_match_patch_test.assertEquals((String)"diff_commonOverlap: Overlap.", (int)3, (int)this.dmp.diff_commonOverlap("123456xxx", "xxxabcd"));
        diff_match_patch_test.assertEquals((String)"diff_commonOverlap: Unicode.", (int)0, (int)this.dmp.diff_commonOverlap("fi", "\ufb01i"));
    }

    public void testDiffHalfmatch() {
        this.dmp.Diff_Timeout = 1.0f;
        diff_match_patch_test.assertNull((String)"diff_halfMatch: No match #1.", (Object)this.dmp.diff_halfMatch("1234567890", "abcdef"));
        diff_match_patch_test.assertNull((String)"diff_halfMatch: No match #2.", (Object)this.dmp.diff_halfMatch("12345", "23"));
        this.assertArrayEquals("diff_halfMatch: Single Match #1.", new String[]{"12", "90", "a", "z", "345678"}, this.dmp.diff_halfMatch("1234567890", "a345678z"));
        this.assertArrayEquals("diff_halfMatch: Single Match #2.", new String[]{"a", "z", "12", "90", "345678"}, this.dmp.diff_halfMatch("a345678z", "1234567890"));
        this.assertArrayEquals("diff_halfMatch: Single Match #3.", new String[]{"abc", "z", "1234", "0", "56789"}, this.dmp.diff_halfMatch("abc56789z", "1234567890"));
        this.assertArrayEquals("diff_halfMatch: Single Match #4.", new String[]{"a", "xyz", "1", "7890", "23456"}, this.dmp.diff_halfMatch("a23456xyz", "1234567890"));
        this.assertArrayEquals("diff_halfMatch: Multiple Matches #1.", new String[]{"12123", "123121", "a", "z", "1234123451234"}, this.dmp.diff_halfMatch("121231234123451234123121", "a1234123451234z"));
        this.assertArrayEquals("diff_halfMatch: Multiple Matches #2.", new String[]{"", "-=-=-=-=-=", "x", "", "x-=-=-=-=-=-=-="}, this.dmp.diff_halfMatch("x-=-=-=-=-=-=-=-=-=-=-=-=", "xx-=-=-=-=-=-=-="));
        this.assertArrayEquals("diff_halfMatch: Multiple Matches #3.", new String[]{"-=-=-=-=-=", "", "", "y", "-=-=-=-=-=-=-=y"}, this.dmp.diff_halfMatch("-=-=-=-=-=-=-=-=-=-=-=-=y", "-=-=-=-=-=-=-=yy"));
        this.assertArrayEquals("diff_halfMatch: Non-optimal halfmatch.", new String[]{"qHillo", "w", "x", "Hulloy", "HelloHe"}, this.dmp.diff_halfMatch("qHilloHelloHew", "xHelloHeHulloy"));
        this.dmp.Diff_Timeout = 0.0f;
        diff_match_patch_test.assertNull((String)"diff_halfMatch: Optimal no halfmatch.", (Object)this.dmp.diff_halfMatch("qHilloHelloHew", "xHelloHeHulloy"));
    }

    public void testDiffLinesToChars() {
        ArrayList<String> tmpVector = new ArrayList<String>();
        tmpVector.add("");
        tmpVector.add("alpha\n");
        tmpVector.add("beta\n");
        this.assertLinesToCharsResultEquals("diff_linesToChars: Shared lines.", new diff_match_patch.LinesToCharsResult("\u0001\u0002\u0001", "\u0002\u0001\u0002", tmpVector), this.dmp.diff_linesToChars("alpha\nbeta\nalpha\n", "beta\nalpha\nbeta\n"));
        tmpVector.clear();
        tmpVector.add("");
        tmpVector.add("alpha\r\n");
        tmpVector.add("beta\r\n");
        tmpVector.add("\r\n");
        this.assertLinesToCharsResultEquals("diff_linesToChars: Empty string and blank lines.", new diff_match_patch.LinesToCharsResult("", "\u0001\u0002\u0003\u0003", tmpVector), this.dmp.diff_linesToChars("", "alpha\r\nbeta\r\n\r\n\r\n"));
        tmpVector.clear();
        tmpVector.add("");
        tmpVector.add("a");
        tmpVector.add("b");
        this.assertLinesToCharsResultEquals("diff_linesToChars: No linebreaks.", new diff_match_patch.LinesToCharsResult("\u0001", "\u0002", tmpVector), this.dmp.diff_linesToChars("a", "b"));
        int n = 300;
        tmpVector.clear();
        StringBuilder lineList = new StringBuilder();
        StringBuilder charList = new StringBuilder();
        for (int x = 1; x < n + 1; ++x) {
            tmpVector.add(x + "\n");
            lineList.append(x + "\n");
            charList.append(String.valueOf((char)x));
        }
        diff_match_patch_test.assertEquals((int)n, (int)tmpVector.size());
        String lines = lineList.toString();
        String chars = charList.toString();
        diff_match_patch_test.assertEquals((int)n, (int)chars.length());
        tmpVector.add(0, "");
        this.assertLinesToCharsResultEquals("diff_linesToChars: More than 256.", new diff_match_patch.LinesToCharsResult(chars, "", tmpVector), this.dmp.diff_linesToChars(lines, ""));
    }

    public void testDiffCharsToLines() {
        diff_match_patch_test.assertTrue((String)"diff_charsToLines: Equality #1.", (boolean)new diff_match_patch.Diff(this.EQUAL, "a").equals(new diff_match_patch.Diff(this.EQUAL, "a")));
        diff_match_patch_test.assertEquals((String)"diff_charsToLines: Equality #2.", (Object)new diff_match_patch.Diff(this.EQUAL, "a"), (Object)new diff_match_patch.Diff(this.EQUAL, "a"));
        LinkedList<diff_match_patch.Diff> diffs = diff_match_patch_test.diffList(new diff_match_patch.Diff(this.EQUAL, "\u0001\u0002\u0001"), new diff_match_patch.Diff(this.INSERT, "\u0002\u0001\u0002"));
        ArrayList<String> tmpVector = new ArrayList<String>();
        tmpVector.add("");
        tmpVector.add("alpha\n");
        tmpVector.add("beta\n");
        this.dmp.diff_charsToLines(diffs, tmpVector);
        diff_match_patch_test.assertEquals((String)"diff_charsToLines: Shared lines.", diff_match_patch_test.diffList(new diff_match_patch.Diff(this.EQUAL, "alpha\nbeta\nalpha\n"), new diff_match_patch.Diff(this.INSERT, "beta\nalpha\nbeta\n")), diffs);
        int n = 300;
        tmpVector.clear();
        StringBuilder lineList = new StringBuilder();
        StringBuilder charList = new StringBuilder();
        for (int x = 1; x < n + 1; ++x) {
            tmpVector.add(x + "\n");
            lineList.append(x + "\n");
            charList.append(String.valueOf((char)x));
        }
        diff_match_patch_test.assertEquals((int)n, (int)tmpVector.size());
        String lines = lineList.toString();
        String chars = charList.toString();
        diff_match_patch_test.assertEquals((int)n, (int)chars.length());
        tmpVector.add(0, "");
        diffs = diff_match_patch_test.diffList(new diff_match_patch.Diff(this.DELETE, chars));
        this.dmp.diff_charsToLines(diffs, tmpVector);
        diff_match_patch_test.assertEquals((String)"diff_charsToLines: More than 256.", diff_match_patch_test.diffList(new diff_match_patch.Diff(this.DELETE, lines)), diffs);
    }

    public void testDiffCleanupMerge() {
        LinkedList<diff_match_patch.Diff> diffs = diff_match_patch_test.diffList(new diff_match_patch.Diff[0]);
        this.dmp.diff_cleanupMerge(diffs);
        diff_match_patch_test.assertEquals((String)"diff_cleanupMerge: Null case.", diff_match_patch_test.diffList(new diff_match_patch.Diff[0]), diffs);
        diffs = diff_match_patch_test.diffList(new diff_match_patch.Diff(this.EQUAL, "a"), new diff_match_patch.Diff(this.DELETE, "b"), new diff_match_patch.Diff(this.INSERT, "c"));
        this.dmp.diff_cleanupMerge(diffs);
        diff_match_patch_test.assertEquals((String)"diff_cleanupMerge: No change case.", diff_match_patch_test.diffList(new diff_match_patch.Diff(this.EQUAL, "a"), new diff_match_patch.Diff(this.DELETE, "b"), new diff_match_patch.Diff(this.INSERT, "c")), diffs);
        diffs = diff_match_patch_test.diffList(new diff_match_patch.Diff(this.EQUAL, "a"), new diff_match_patch.Diff(this.EQUAL, "b"), new diff_match_patch.Diff(this.EQUAL, "c"));
        this.dmp.diff_cleanupMerge(diffs);
        diff_match_patch_test.assertEquals((String)"diff_cleanupMerge: Merge equalities.", diff_match_patch_test.diffList(new diff_match_patch.Diff(this.EQUAL, "abc")), diffs);
        diffs = diff_match_patch_test.diffList(new diff_match_patch.Diff(this.DELETE, "a"), new diff_match_patch.Diff(this.DELETE, "b"), new diff_match_patch.Diff(this.DELETE, "c"));
        this.dmp.diff_cleanupMerge(diffs);
        diff_match_patch_test.assertEquals((String)"diff_cleanupMerge: Merge deletions.", diff_match_patch_test.diffList(new diff_match_patch.Diff(this.DELETE, "abc")), diffs);
        diffs = diff_match_patch_test.diffList(new diff_match_patch.Diff(this.INSERT, "a"), new diff_match_patch.Diff(this.INSERT, "b"), new diff_match_patch.Diff(this.INSERT, "c"));
        this.dmp.diff_cleanupMerge(diffs);
        diff_match_patch_test.assertEquals((String)"diff_cleanupMerge: Merge insertions.", diff_match_patch_test.diffList(new diff_match_patch.Diff(this.INSERT, "abc")), diffs);
        diffs = diff_match_patch_test.diffList(new diff_match_patch.Diff(this.DELETE, "a"), new diff_match_patch.Diff(this.INSERT, "b"), new diff_match_patch.Diff(this.DELETE, "c"), new diff_match_patch.Diff(this.INSERT, "d"), new diff_match_patch.Diff(this.EQUAL, "e"), new diff_match_patch.Diff(this.EQUAL, "f"));
        this.dmp.diff_cleanupMerge(diffs);
        diff_match_patch_test.assertEquals((String)"diff_cleanupMerge: Merge interweave.", diff_match_patch_test.diffList(new diff_match_patch.Diff(this.DELETE, "ac"), new diff_match_patch.Diff(this.INSERT, "bd"), new diff_match_patch.Diff(this.EQUAL, "ef")), diffs);
        diffs = diff_match_patch_test.diffList(new diff_match_patch.Diff(this.DELETE, "a"), new diff_match_patch.Diff(this.INSERT, "abc"), new diff_match_patch.Diff(this.DELETE, "dc"));
        this.dmp.diff_cleanupMerge(diffs);
        diff_match_patch_test.assertEquals((String)"diff_cleanupMerge: Prefix and suffix detection.", diff_match_patch_test.diffList(new diff_match_patch.Diff(this.EQUAL, "a"), new diff_match_patch.Diff(this.DELETE, "d"), new diff_match_patch.Diff(this.INSERT, "b"), new diff_match_patch.Diff(this.EQUAL, "c")), diffs);
        diffs = diff_match_patch_test.diffList(new diff_match_patch.Diff(this.EQUAL, "x"), new diff_match_patch.Diff(this.DELETE, "a"), new diff_match_patch.Diff(this.INSERT, "abc"), new diff_match_patch.Diff(this.DELETE, "dc"), new diff_match_patch.Diff(this.EQUAL, "y"));
        this.dmp.diff_cleanupMerge(diffs);
        diff_match_patch_test.assertEquals((String)"diff_cleanupMerge: Prefix and suffix detection with equalities.", diff_match_patch_test.diffList(new diff_match_patch.Diff(this.EQUAL, "xa"), new diff_match_patch.Diff(this.DELETE, "d"), new diff_match_patch.Diff(this.INSERT, "b"), new diff_match_patch.Diff(this.EQUAL, "cy")), diffs);
        diffs = diff_match_patch_test.diffList(new diff_match_patch.Diff(this.EQUAL, "a"), new diff_match_patch.Diff(this.INSERT, "ba"), new diff_match_patch.Diff(this.EQUAL, "c"));
        this.dmp.diff_cleanupMerge(diffs);
        diff_match_patch_test.assertEquals((String)"diff_cleanupMerge: Slide edit left.", diff_match_patch_test.diffList(new diff_match_patch.Diff(this.INSERT, "ab"), new diff_match_patch.Diff(this.EQUAL, "ac")), diffs);
        diffs = diff_match_patch_test.diffList(new diff_match_patch.Diff(this.EQUAL, "c"), new diff_match_patch.Diff(this.INSERT, "ab"), new diff_match_patch.Diff(this.EQUAL, "a"));
        this.dmp.diff_cleanupMerge(diffs);
        diff_match_patch_test.assertEquals((String)"diff_cleanupMerge: Slide edit right.", diff_match_patch_test.diffList(new diff_match_patch.Diff(this.EQUAL, "ca"), new diff_match_patch.Diff(this.INSERT, "ba")), diffs);
        diffs = diff_match_patch_test.diffList(new diff_match_patch.Diff(this.EQUAL, "a"), new diff_match_patch.Diff(this.DELETE, "b"), new diff_match_patch.Diff(this.EQUAL, "c"), new diff_match_patch.Diff(this.DELETE, "ac"), new diff_match_patch.Diff(this.EQUAL, "x"));
        this.dmp.diff_cleanupMerge(diffs);
        diff_match_patch_test.assertEquals((String)"diff_cleanupMerge: Slide edit left recursive.", diff_match_patch_test.diffList(new diff_match_patch.Diff(this.DELETE, "abc"), new diff_match_patch.Diff(this.EQUAL, "acx")), diffs);
        diffs = diff_match_patch_test.diffList(new diff_match_patch.Diff(this.EQUAL, "x"), new diff_match_patch.Diff(this.DELETE, "ca"), new diff_match_patch.Diff(this.EQUAL, "c"), new diff_match_patch.Diff(this.DELETE, "b"), new diff_match_patch.Diff(this.EQUAL, "a"));
        this.dmp.diff_cleanupMerge(diffs);
        diff_match_patch_test.assertEquals((String)"diff_cleanupMerge: Slide edit right recursive.", diff_match_patch_test.diffList(new diff_match_patch.Diff(this.EQUAL, "xca"), new diff_match_patch.Diff(this.DELETE, "cba")), diffs);
    }

    public void testDiffCleanupSemanticLossless() {
        LinkedList<diff_match_patch.Diff> diffs = diff_match_patch_test.diffList(new diff_match_patch.Diff[0]);
        this.dmp.diff_cleanupSemanticLossless(diffs);
        diff_match_patch_test.assertEquals((String)"diff_cleanupSemanticLossless: Null case.", diff_match_patch_test.diffList(new diff_match_patch.Diff[0]), diffs);
        diffs = diff_match_patch_test.diffList(new diff_match_patch.Diff(this.EQUAL, "AAA\r\n\r\nBBB"), new diff_match_patch.Diff(this.INSERT, "\r\nDDD\r\n\r\nBBB"), new diff_match_patch.Diff(this.EQUAL, "\r\nEEE"));
        this.dmp.diff_cleanupSemanticLossless(diffs);
        diff_match_patch_test.assertEquals((String)"diff_cleanupSemanticLossless: Blank lines.", diff_match_patch_test.diffList(new diff_match_patch.Diff(this.EQUAL, "AAA\r\n\r\n"), new diff_match_patch.Diff(this.INSERT, "BBB\r\nDDD\r\n\r\n"), new diff_match_patch.Diff(this.EQUAL, "BBB\r\nEEE")), diffs);
        diffs = diff_match_patch_test.diffList(new diff_match_patch.Diff(this.EQUAL, "AAA\r\nBBB"), new diff_match_patch.Diff(this.INSERT, " DDD\r\nBBB"), new diff_match_patch.Diff(this.EQUAL, " EEE"));
        this.dmp.diff_cleanupSemanticLossless(diffs);
        diff_match_patch_test.assertEquals((String)"diff_cleanupSemanticLossless: Line boundaries.", diff_match_patch_test.diffList(new diff_match_patch.Diff(this.EQUAL, "AAA\r\n"), new diff_match_patch.Diff(this.INSERT, "BBB DDD\r\n"), new diff_match_patch.Diff(this.EQUAL, "BBB EEE")), diffs);
        diffs = diff_match_patch_test.diffList(new diff_match_patch.Diff(this.EQUAL, "The c"), new diff_match_patch.Diff(this.INSERT, "ow and the c"), new diff_match_patch.Diff(this.EQUAL, "at."));
        this.dmp.diff_cleanupSemanticLossless(diffs);
        diff_match_patch_test.assertEquals((String)"diff_cleanupSemanticLossless: Word boundaries.", diff_match_patch_test.diffList(new diff_match_patch.Diff(this.EQUAL, "The "), new diff_match_patch.Diff(this.INSERT, "cow and the "), new diff_match_patch.Diff(this.EQUAL, "cat.")), diffs);
        diffs = diff_match_patch_test.diffList(new diff_match_patch.Diff(this.EQUAL, "The-c"), new diff_match_patch.Diff(this.INSERT, "ow-and-the-c"), new diff_match_patch.Diff(this.EQUAL, "at."));
        this.dmp.diff_cleanupSemanticLossless(diffs);
        diff_match_patch_test.assertEquals((String)"diff_cleanupSemanticLossless: Alphanumeric boundaries.", diff_match_patch_test.diffList(new diff_match_patch.Diff(this.EQUAL, "The-"), new diff_match_patch.Diff(this.INSERT, "cow-and-the-"), new diff_match_patch.Diff(this.EQUAL, "cat.")), diffs);
        diffs = diff_match_patch_test.diffList(new diff_match_patch.Diff(this.EQUAL, "a"), new diff_match_patch.Diff(this.DELETE, "a"), new diff_match_patch.Diff(this.EQUAL, "ax"));
        this.dmp.diff_cleanupSemanticLossless(diffs);
        diff_match_patch_test.assertEquals((String)"diff_cleanupSemanticLossless: Hitting the start.", diff_match_patch_test.diffList(new diff_match_patch.Diff(this.DELETE, "a"), new diff_match_patch.Diff(this.EQUAL, "aax")), diffs);
        diffs = diff_match_patch_test.diffList(new diff_match_patch.Diff(this.EQUAL, "xa"), new diff_match_patch.Diff(this.DELETE, "a"), new diff_match_patch.Diff(this.EQUAL, "a"));
        this.dmp.diff_cleanupSemanticLossless(diffs);
        diff_match_patch_test.assertEquals((String)"diff_cleanupSemanticLossless: Hitting the end.", diff_match_patch_test.diffList(new diff_match_patch.Diff(this.EQUAL, "xaa"), new diff_match_patch.Diff(this.DELETE, "a")), diffs);
        diffs = diff_match_patch_test.diffList(new diff_match_patch.Diff(this.EQUAL, "The xxx. The "), new diff_match_patch.Diff(this.INSERT, "zzz. The "), new diff_match_patch.Diff(this.EQUAL, "yyy."));
        this.dmp.diff_cleanupSemanticLossless(diffs);
        diff_match_patch_test.assertEquals((String)"diff_cleanupSemanticLossless: Sentence boundaries.", diff_match_patch_test.diffList(new diff_match_patch.Diff(this.EQUAL, "The xxx."), new diff_match_patch.Diff(this.INSERT, " The zzz."), new diff_match_patch.Diff(this.EQUAL, " The yyy.")), diffs);
    }

    public void testDiffCleanupSemantic() {
        LinkedList<diff_match_patch.Diff> diffs = diff_match_patch_test.diffList(new diff_match_patch.Diff[0]);
        this.dmp.diff_cleanupSemantic(diffs);
        diff_match_patch_test.assertEquals((String)"diff_cleanupSemantic: Null case.", diff_match_patch_test.diffList(new diff_match_patch.Diff[0]), diffs);
        diffs = diff_match_patch_test.diffList(new diff_match_patch.Diff(this.DELETE, "ab"), new diff_match_patch.Diff(this.INSERT, "cd"), new diff_match_patch.Diff(this.EQUAL, "12"), new diff_match_patch.Diff(this.DELETE, "e"));
        this.dmp.diff_cleanupSemantic(diffs);
        diff_match_patch_test.assertEquals((String)"diff_cleanupSemantic: No elimination #1.", diff_match_patch_test.diffList(new diff_match_patch.Diff(this.DELETE, "ab"), new diff_match_patch.Diff(this.INSERT, "cd"), new diff_match_patch.Diff(this.EQUAL, "12"), new diff_match_patch.Diff(this.DELETE, "e")), diffs);
        diffs = diff_match_patch_test.diffList(new diff_match_patch.Diff(this.DELETE, "abc"), new diff_match_patch.Diff(this.INSERT, "ABC"), new diff_match_patch.Diff(this.EQUAL, "1234"), new diff_match_patch.Diff(this.DELETE, "wxyz"));
        this.dmp.diff_cleanupSemantic(diffs);
        diff_match_patch_test.assertEquals((String)"diff_cleanupSemantic: No elimination #2.", diff_match_patch_test.diffList(new diff_match_patch.Diff(this.DELETE, "abc"), new diff_match_patch.Diff(this.INSERT, "ABC"), new diff_match_patch.Diff(this.EQUAL, "1234"), new diff_match_patch.Diff(this.DELETE, "wxyz")), diffs);
        diffs = diff_match_patch_test.diffList(new diff_match_patch.Diff(this.DELETE, "a"), new diff_match_patch.Diff(this.EQUAL, "b"), new diff_match_patch.Diff(this.DELETE, "c"));
        this.dmp.diff_cleanupSemantic(diffs);
        diff_match_patch_test.assertEquals((String)"diff_cleanupSemantic: Simple elimination.", diff_match_patch_test.diffList(new diff_match_patch.Diff(this.DELETE, "abc"), new diff_match_patch.Diff(this.INSERT, "b")), diffs);
        diffs = diff_match_patch_test.diffList(new diff_match_patch.Diff(this.DELETE, "ab"), new diff_match_patch.Diff(this.EQUAL, "cd"), new diff_match_patch.Diff(this.DELETE, "e"), new diff_match_patch.Diff(this.EQUAL, "f"), new diff_match_patch.Diff(this.INSERT, "g"));
        this.dmp.diff_cleanupSemantic(diffs);
        diff_match_patch_test.assertEquals((String)"diff_cleanupSemantic: Backpass elimination.", diff_match_patch_test.diffList(new diff_match_patch.Diff(this.DELETE, "abcdef"), new diff_match_patch.Diff(this.INSERT, "cdfg")), diffs);
        diffs = diff_match_patch_test.diffList(new diff_match_patch.Diff(this.INSERT, "1"), new diff_match_patch.Diff(this.EQUAL, "A"), new diff_match_patch.Diff(this.DELETE, "B"), new diff_match_patch.Diff(this.INSERT, "2"), new diff_match_patch.Diff(this.EQUAL, "_"), new diff_match_patch.Diff(this.INSERT, "1"), new diff_match_patch.Diff(this.EQUAL, "A"), new diff_match_patch.Diff(this.DELETE, "B"), new diff_match_patch.Diff(this.INSERT, "2"));
        this.dmp.diff_cleanupSemantic(diffs);
        diff_match_patch_test.assertEquals((String)"diff_cleanupSemantic: Multiple elimination.", diff_match_patch_test.diffList(new diff_match_patch.Diff(this.DELETE, "AB_AB"), new diff_match_patch.Diff(this.INSERT, "1A2_1A2")), diffs);
        diffs = diff_match_patch_test.diffList(new diff_match_patch.Diff(this.EQUAL, "The c"), new diff_match_patch.Diff(this.DELETE, "ow and the c"), new diff_match_patch.Diff(this.EQUAL, "at."));
        this.dmp.diff_cleanupSemantic(diffs);
        diff_match_patch_test.assertEquals((String)"diff_cleanupSemantic: Word boundaries.", diff_match_patch_test.diffList(new diff_match_patch.Diff(this.EQUAL, "The "), new diff_match_patch.Diff(this.DELETE, "cow and the "), new diff_match_patch.Diff(this.EQUAL, "cat.")), diffs);
        diffs = diff_match_patch_test.diffList(new diff_match_patch.Diff(this.DELETE, "abcxx"), new diff_match_patch.Diff(this.INSERT, "xxdef"));
        this.dmp.diff_cleanupSemantic(diffs);
        diff_match_patch_test.assertEquals((String)"diff_cleanupSemantic: No overlap elimination.", diff_match_patch_test.diffList(new diff_match_patch.Diff(this.DELETE, "abcxx"), new diff_match_patch.Diff(this.INSERT, "xxdef")), diffs);
        diffs = diff_match_patch_test.diffList(new diff_match_patch.Diff(this.DELETE, "abcxxx"), new diff_match_patch.Diff(this.INSERT, "xxxdef"));
        this.dmp.diff_cleanupSemantic(diffs);
        diff_match_patch_test.assertEquals((String)"diff_cleanupSemantic: Overlap elimination.", diff_match_patch_test.diffList(new diff_match_patch.Diff(this.DELETE, "abc"), new diff_match_patch.Diff(this.EQUAL, "xxx"), new diff_match_patch.Diff(this.INSERT, "def")), diffs);
        diffs = diff_match_patch_test.diffList(new diff_match_patch.Diff(this.DELETE, "xxxabc"), new diff_match_patch.Diff(this.INSERT, "defxxx"));
        this.dmp.diff_cleanupSemantic(diffs);
        diff_match_patch_test.assertEquals((String)"diff_cleanupSemantic: Reverse overlap elimination.", diff_match_patch_test.diffList(new diff_match_patch.Diff(this.INSERT, "def"), new diff_match_patch.Diff(this.EQUAL, "xxx"), new diff_match_patch.Diff(this.DELETE, "abc")), diffs);
        diffs = diff_match_patch_test.diffList(new diff_match_patch.Diff(this.DELETE, "abcd1212"), new diff_match_patch.Diff(this.INSERT, "1212efghi"), new diff_match_patch.Diff(this.EQUAL, "----"), new diff_match_patch.Diff(this.DELETE, "A3"), new diff_match_patch.Diff(this.INSERT, "3BC"));
        this.dmp.diff_cleanupSemantic(diffs);
        diff_match_patch_test.assertEquals((String)"diff_cleanupSemantic: Two overlap eliminations.", diff_match_patch_test.diffList(new diff_match_patch.Diff(this.DELETE, "abcd"), new diff_match_patch.Diff(this.EQUAL, "1212"), new diff_match_patch.Diff(this.INSERT, "efghi"), new diff_match_patch.Diff(this.EQUAL, "----"), new diff_match_patch.Diff(this.DELETE, "A"), new diff_match_patch.Diff(this.EQUAL, "3"), new diff_match_patch.Diff(this.INSERT, "BC")), diffs);
    }

    public void testDiffCleanupEfficiency() {
        this.dmp.Diff_EditCost = (short)4;
        LinkedList<diff_match_patch.Diff> diffs = diff_match_patch_test.diffList(new diff_match_patch.Diff[0]);
        this.dmp.diff_cleanupEfficiency(diffs);
        diff_match_patch_test.assertEquals((String)"diff_cleanupEfficiency: Null case.", diff_match_patch_test.diffList(new diff_match_patch.Diff[0]), diffs);
        diffs = diff_match_patch_test.diffList(new diff_match_patch.Diff(this.DELETE, "ab"), new diff_match_patch.Diff(this.INSERT, "12"), new diff_match_patch.Diff(this.EQUAL, "wxyz"), new diff_match_patch.Diff(this.DELETE, "cd"), new diff_match_patch.Diff(this.INSERT, "34"));
        this.dmp.diff_cleanupEfficiency(diffs);
        diff_match_patch_test.assertEquals((String)"diff_cleanupEfficiency: No elimination.", diff_match_patch_test.diffList(new diff_match_patch.Diff(this.DELETE, "ab"), new diff_match_patch.Diff(this.INSERT, "12"), new diff_match_patch.Diff(this.EQUAL, "wxyz"), new diff_match_patch.Diff(this.DELETE, "cd"), new diff_match_patch.Diff(this.INSERT, "34")), diffs);
        diffs = diff_match_patch_test.diffList(new diff_match_patch.Diff(this.DELETE, "ab"), new diff_match_patch.Diff(this.INSERT, "12"), new diff_match_patch.Diff(this.EQUAL, "xyz"), new diff_match_patch.Diff(this.DELETE, "cd"), new diff_match_patch.Diff(this.INSERT, "34"));
        this.dmp.diff_cleanupEfficiency(diffs);
        diff_match_patch_test.assertEquals((String)"diff_cleanupEfficiency: Four-edit elimination.", diff_match_patch_test.diffList(new diff_match_patch.Diff(this.DELETE, "abxyzcd"), new diff_match_patch.Diff(this.INSERT, "12xyz34")), diffs);
        diffs = diff_match_patch_test.diffList(new diff_match_patch.Diff(this.INSERT, "12"), new diff_match_patch.Diff(this.EQUAL, "x"), new diff_match_patch.Diff(this.DELETE, "cd"), new diff_match_patch.Diff(this.INSERT, "34"));
        this.dmp.diff_cleanupEfficiency(diffs);
        diff_match_patch_test.assertEquals((String)"diff_cleanupEfficiency: Three-edit elimination.", diff_match_patch_test.diffList(new diff_match_patch.Diff(this.DELETE, "xcd"), new diff_match_patch.Diff(this.INSERT, "12x34")), diffs);
        diffs = diff_match_patch_test.diffList(new diff_match_patch.Diff(this.DELETE, "ab"), new diff_match_patch.Diff(this.INSERT, "12"), new diff_match_patch.Diff(this.EQUAL, "xy"), new diff_match_patch.Diff(this.INSERT, "34"), new diff_match_patch.Diff(this.EQUAL, "z"), new diff_match_patch.Diff(this.DELETE, "cd"), new diff_match_patch.Diff(this.INSERT, "56"));
        this.dmp.diff_cleanupEfficiency(diffs);
        diff_match_patch_test.assertEquals((String)"diff_cleanupEfficiency: Backpass elimination.", diff_match_patch_test.diffList(new diff_match_patch.Diff(this.DELETE, "abxyzcd"), new diff_match_patch.Diff(this.INSERT, "12xy34z56")), diffs);
        this.dmp.Diff_EditCost = (short)5;
        diffs = diff_match_patch_test.diffList(new diff_match_patch.Diff(this.DELETE, "ab"), new diff_match_patch.Diff(this.INSERT, "12"), new diff_match_patch.Diff(this.EQUAL, "wxyz"), new diff_match_patch.Diff(this.DELETE, "cd"), new diff_match_patch.Diff(this.INSERT, "34"));
        this.dmp.diff_cleanupEfficiency(diffs);
        diff_match_patch_test.assertEquals((String)"diff_cleanupEfficiency: High cost elimination.", diff_match_patch_test.diffList(new diff_match_patch.Diff(this.DELETE, "abwxyzcd"), new diff_match_patch.Diff(this.INSERT, "12wxyz34")), diffs);
        this.dmp.Diff_EditCost = (short)4;
    }

    public void testDiffPrettyHtml() {
        LinkedList<diff_match_patch.Diff> diffs = diff_match_patch_test.diffList(new diff_match_patch.Diff(this.EQUAL, "a\n"), new diff_match_patch.Diff(this.DELETE, "<B>b</B>"), new diff_match_patch.Diff(this.INSERT, "c&d"));
        diff_match_patch_test.assertEquals((String)"diff_prettyHtml:", (String)"<span>a&para;<br></span><del style=\"background:#ffe6e6;\">&lt;B&gt;b&lt;/B&gt;</del><ins style=\"background:#e6ffe6;\">c&amp;d</ins>", (String)this.dmp.diff_prettyHtml(diffs));
    }

    public void testDiffText() {
        LinkedList<diff_match_patch.Diff> diffs = diff_match_patch_test.diffList(new diff_match_patch.Diff(this.EQUAL, "jump"), new diff_match_patch.Diff(this.DELETE, "s"), new diff_match_patch.Diff(this.INSERT, "ed"), new diff_match_patch.Diff(this.EQUAL, " over "), new diff_match_patch.Diff(this.DELETE, "the"), new diff_match_patch.Diff(this.INSERT, "a"), new diff_match_patch.Diff(this.EQUAL, " lazy"));
        diff_match_patch_test.assertEquals((String)"diff_text1:", (String)"jumps over the lazy", (String)this.dmp.diff_text1(diffs));
        diff_match_patch_test.assertEquals((String)"diff_text2:", (String)"jumped over a lazy", (String)this.dmp.diff_text2(diffs));
    }

    public void testDiffDelta() {
        LinkedList<diff_match_patch.Diff> diffs = diff_match_patch_test.diffList(new diff_match_patch.Diff(this.EQUAL, "jump"), new diff_match_patch.Diff(this.DELETE, "s"), new diff_match_patch.Diff(this.INSERT, "ed"), new diff_match_patch.Diff(this.EQUAL, " over "), new diff_match_patch.Diff(this.DELETE, "the"), new diff_match_patch.Diff(this.INSERT, "a"), new diff_match_patch.Diff(this.EQUAL, " lazy"), new diff_match_patch.Diff(this.INSERT, "old dog"));
        String text1 = this.dmp.diff_text1(diffs);
        diff_match_patch_test.assertEquals((String)"diff_text1: Base text.", (String)"jumps over the lazy", (String)text1);
        String delta = this.dmp.diff_toDelta(diffs);
        diff_match_patch_test.assertEquals((String)"diff_toDelta:", (String)"=4\t-1\t+ed\t=6\t-3\t+a\t=5\t+old dog", (String)delta);
        diff_match_patch_test.assertEquals((String)"diff_fromDelta: Normal.", diffs, this.dmp.diff_fromDelta(text1, delta));
        try {
            this.dmp.diff_fromDelta(text1 + "x", delta);
            diff_match_patch_test.fail((String)"diff_fromDelta: Too long.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.dmp.diff_fromDelta(text1.substring(1), delta);
            diff_match_patch_test.fail((String)"diff_fromDelta: Too short.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.dmp.diff_fromDelta("", "+%c3%xy");
            diff_match_patch_test.fail((String)"diff_fromDelta: Invalid character.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        diffs = diff_match_patch_test.diffList(new diff_match_patch.Diff(this.EQUAL, "\u0680 \u0000 \t %"), new diff_match_patch.Diff(this.DELETE, "\u0681 \u0001 \n ^"), new diff_match_patch.Diff(this.INSERT, "\u0682 \u0002 \\ |"));
        text1 = this.dmp.diff_text1(diffs);
        diff_match_patch_test.assertEquals((String)"diff_text1: Unicode text.", (String)"\u0680 \u0000 \t %\u0681 \u0001 \n ^", (String)text1);
        delta = this.dmp.diff_toDelta(diffs);
        diff_match_patch_test.assertEquals((String)"diff_toDelta: Unicode.", (String)"=7\t-7\t+%DA%82 %02 %5C %7C", (String)delta);
        diff_match_patch_test.assertEquals((String)"diff_fromDelta: Unicode.", diffs, this.dmp.diff_fromDelta(text1, delta));
        diffs = diff_match_patch_test.diffList(new diff_match_patch.Diff(this.INSERT, "A-Z a-z 0-9 - _ . ! ~ * ' ( ) ; / ? : @ & = + $ , # "));
        String text2 = this.dmp.diff_text2(diffs);
        diff_match_patch_test.assertEquals((String)"diff_text2: Unchanged characters.", (String)"A-Z a-z 0-9 - _ . ! ~ * ' ( ) ; / ? : @ & = + $ , # ", (String)text2);
        delta = this.dmp.diff_toDelta(diffs);
        diff_match_patch_test.assertEquals((String)"diff_toDelta: Unchanged characters.", (String)"+A-Z a-z 0-9 - _ . ! ~ * ' ( ) ; / ? : @ & = + $ , # ", (String)delta);
        diff_match_patch_test.assertEquals((String)"diff_fromDelta: Unchanged characters.", diffs, this.dmp.diff_fromDelta("", delta));
    }

    public void testDiffXIndex() {
        LinkedList<diff_match_patch.Diff> diffs = diff_match_patch_test.diffList(new diff_match_patch.Diff(this.DELETE, "a"), new diff_match_patch.Diff(this.INSERT, "1234"), new diff_match_patch.Diff(this.EQUAL, "xyz"));
        diff_match_patch_test.assertEquals((String)"diff_xIndex: Translation on equality.", (int)5, (int)this.dmp.diff_xIndex(diffs, 2));
        diffs = diff_match_patch_test.diffList(new diff_match_patch.Diff(this.EQUAL, "a"), new diff_match_patch.Diff(this.DELETE, "1234"), new diff_match_patch.Diff(this.EQUAL, "xyz"));
        diff_match_patch_test.assertEquals((String)"diff_xIndex: Translation on deletion.", (int)1, (int)this.dmp.diff_xIndex(diffs, 3));
    }

    public void testDiffLevenshtein() {
        LinkedList<diff_match_patch.Diff> diffs = diff_match_patch_test.diffList(new diff_match_patch.Diff(this.DELETE, "abc"), new diff_match_patch.Diff(this.INSERT, "1234"), new diff_match_patch.Diff(this.EQUAL, "xyz"));
        diff_match_patch_test.assertEquals((String)"Levenshtein with trailing equality.", (int)4, (int)this.dmp.diff_levenshtein(diffs));
        diffs = diff_match_patch_test.diffList(new diff_match_patch.Diff(this.EQUAL, "xyz"), new diff_match_patch.Diff(this.DELETE, "abc"), new diff_match_patch.Diff(this.INSERT, "1234"));
        diff_match_patch_test.assertEquals((String)"Levenshtein with leading equality.", (int)4, (int)this.dmp.diff_levenshtein(diffs));
        diffs = diff_match_patch_test.diffList(new diff_match_patch.Diff(this.DELETE, "abc"), new diff_match_patch.Diff(this.EQUAL, "xyz"), new diff_match_patch.Diff(this.INSERT, "1234"));
        diff_match_patch_test.assertEquals((String)"Levenshtein with middle equality.", (int)7, (int)this.dmp.diff_levenshtein(diffs));
    }

    public void testDiffBisect() {
        String a = "cat";
        String b = "map";
        LinkedList<diff_match_patch.Diff> diffs = diff_match_patch_test.diffList(new diff_match_patch.Diff(this.DELETE, "c"), new diff_match_patch.Diff(this.INSERT, "m"), new diff_match_patch.Diff(this.EQUAL, "a"), new diff_match_patch.Diff(this.DELETE, "t"), new diff_match_patch.Diff(this.INSERT, "p"));
        diff_match_patch_test.assertEquals((String)"diff_bisect: Normal.", diffs, this.dmp.diff_bisect(a, b, Long.MAX_VALUE));
        diffs = diff_match_patch_test.diffList(new diff_match_patch.Diff(this.DELETE, "cat"), new diff_match_patch.Diff(this.INSERT, "map"));
        diff_match_patch_test.assertEquals((String)"diff_bisect: Timeout.", diffs, this.dmp.diff_bisect(a, b, 0L));
    }

    public void testDiffMain() {
        LinkedList<diff_match_patch.Diff> diffs = diff_match_patch_test.diffList(new diff_match_patch.Diff[0]);
        diff_match_patch_test.assertEquals((String)"diff_main: Null case.", diffs, this.dmp.diff_main("", "", false));
        diffs = diff_match_patch_test.diffList(new diff_match_patch.Diff(this.EQUAL, "abc"));
        diff_match_patch_test.assertEquals((String)"diff_main: Equality.", diffs, this.dmp.diff_main("abc", "abc", false));
        diffs = diff_match_patch_test.diffList(new diff_match_patch.Diff(this.EQUAL, "ab"), new diff_match_patch.Diff(this.INSERT, "123"), new diff_match_patch.Diff(this.EQUAL, "c"));
        diff_match_patch_test.assertEquals((String)"diff_main: Simple insertion.", diffs, this.dmp.diff_main("abc", "ab123c", false));
        diffs = diff_match_patch_test.diffList(new diff_match_patch.Diff(this.EQUAL, "a"), new diff_match_patch.Diff(this.DELETE, "123"), new diff_match_patch.Diff(this.EQUAL, "bc"));
        diff_match_patch_test.assertEquals((String)"diff_main: Simple deletion.", diffs, this.dmp.diff_main("a123bc", "abc", false));
        diffs = diff_match_patch_test.diffList(new diff_match_patch.Diff(this.EQUAL, "a"), new diff_match_patch.Diff(this.INSERT, "123"), new diff_match_patch.Diff(this.EQUAL, "b"), new diff_match_patch.Diff(this.INSERT, "456"), new diff_match_patch.Diff(this.EQUAL, "c"));
        diff_match_patch_test.assertEquals((String)"diff_main: Two insertions.", diffs, this.dmp.diff_main("abc", "a123b456c", false));
        diffs = diff_match_patch_test.diffList(new diff_match_patch.Diff(this.EQUAL, "a"), new diff_match_patch.Diff(this.DELETE, "123"), new diff_match_patch.Diff(this.EQUAL, "b"), new diff_match_patch.Diff(this.DELETE, "456"), new diff_match_patch.Diff(this.EQUAL, "c"));
        diff_match_patch_test.assertEquals((String)"diff_main: Two deletions.", diffs, this.dmp.diff_main("a123b456c", "abc", false));
        this.dmp.Diff_Timeout = 0.0f;
        diffs = diff_match_patch_test.diffList(new diff_match_patch.Diff(this.DELETE, "a"), new diff_match_patch.Diff(this.INSERT, "b"));
        diff_match_patch_test.assertEquals((String)"diff_main: Simple case #1.", diffs, this.dmp.diff_main("a", "b", false));
        diffs = diff_match_patch_test.diffList(new diff_match_patch.Diff(this.DELETE, "Apple"), new diff_match_patch.Diff(this.INSERT, "Banana"), new diff_match_patch.Diff(this.EQUAL, "s are a"), new diff_match_patch.Diff(this.INSERT, "lso"), new diff_match_patch.Diff(this.EQUAL, " fruit."));
        diff_match_patch_test.assertEquals((String)"diff_main: Simple case #2.", diffs, this.dmp.diff_main("Apples are a fruit.", "Bananas are also fruit.", false));
        diffs = diff_match_patch_test.diffList(new diff_match_patch.Diff(this.DELETE, "a"), new diff_match_patch.Diff(this.INSERT, "\u0680"), new diff_match_patch.Diff(this.EQUAL, "x"), new diff_match_patch.Diff(this.DELETE, "\t"), new diff_match_patch.Diff(this.INSERT, "\u0000"));
        diff_match_patch_test.assertEquals((String)"diff_main: Simple case #3.", diffs, this.dmp.diff_main("ax\t", "\u0680x\u0000", false));
        diffs = diff_match_patch_test.diffList(new diff_match_patch.Diff(this.DELETE, "1"), new diff_match_patch.Diff(this.EQUAL, "a"), new diff_match_patch.Diff(this.DELETE, "y"), new diff_match_patch.Diff(this.EQUAL, "b"), new diff_match_patch.Diff(this.DELETE, "2"), new diff_match_patch.Diff(this.INSERT, "xab"));
        diff_match_patch_test.assertEquals((String)"diff_main: Overlap #1.", diffs, this.dmp.diff_main("1ayb2", "abxab", false));
        diffs = diff_match_patch_test.diffList(new diff_match_patch.Diff(this.INSERT, "xaxcx"), new diff_match_patch.Diff(this.EQUAL, "abc"), new diff_match_patch.Diff(this.DELETE, "y"));
        diff_match_patch_test.assertEquals((String)"diff_main: Overlap #2.", diffs, this.dmp.diff_main("abcy", "xaxcxabc", false));
        diffs = diff_match_patch_test.diffList(new diff_match_patch.Diff(this.DELETE, "ABCD"), new diff_match_patch.Diff(this.EQUAL, "a"), new diff_match_patch.Diff(this.DELETE, "="), new diff_match_patch.Diff(this.INSERT, "-"), new diff_match_patch.Diff(this.EQUAL, "bcd"), new diff_match_patch.Diff(this.DELETE, "="), new diff_match_patch.Diff(this.INSERT, "-"), new diff_match_patch.Diff(this.EQUAL, "efghijklmnopqrs"), new diff_match_patch.Diff(this.DELETE, "EFGHIJKLMNOefg"));
        diff_match_patch_test.assertEquals((String)"diff_main: Overlap #3.", diffs, this.dmp.diff_main("ABCDa=bcd=efghijklmnopqrsEFGHIJKLMNOefg", "a-bcd-efghijklmnopqrs", false));
        diffs = diff_match_patch_test.diffList(new diff_match_patch.Diff(this.INSERT, " "), new diff_match_patch.Diff(this.EQUAL, "a"), new diff_match_patch.Diff(this.INSERT, "nd"), new diff_match_patch.Diff(this.EQUAL, " [[Pennsylvania]]"), new diff_match_patch.Diff(this.DELETE, " and [[New"));
        diff_match_patch_test.assertEquals((String)"diff_main: Large equality.", diffs, this.dmp.diff_main("a [[Pennsylvania]] and [[New", " and [[Pennsylvania]]", false));
        this.dmp.Diff_Timeout = 0.1f;
        Object a = "`Twas brillig, and the slithy toves\nDid gyre and gimble in the wabe:\nAll mimsy were the borogoves,\nAnd the mome raths outgrabe.\n";
        Object b = "I am the very model of a modern major general,\nI've information vegetable, animal, and mineral,\nI know the kings of England, and I quote the fights historical,\nFrom Marathon to Waterloo, in order categorical.\n";
        for (int x = 0; x < 10; ++x) {
            a = (String)a + (String)a;
            b = (String)b + (String)b;
        }
        long startTime = System.currentTimeMillis();
        this.dmp.diff_main((String)a, (String)b);
        long endTime = System.currentTimeMillis();
        diff_match_patch_test.assertTrue((String)"diff_main: Timeout min.", (this.dmp.Diff_Timeout * 1000.0f <= (float)(endTime - startTime) ? 1 : 0) != 0);
        diff_match_patch_test.assertTrue((String)"diff_main: Timeout max.", (this.dmp.Diff_Timeout * 1000.0f * 2.0f > (float)(endTime - startTime) ? 1 : 0) != 0);
        this.dmp.Diff_Timeout = 0.0f;
        a = "1234567890\n1234567890\n1234567890\n1234567890\n1234567890\n1234567890\n1234567890\n1234567890\n1234567890\n1234567890\n1234567890\n1234567890\n1234567890\n";
        b = "abcdefghij\nabcdefghij\nabcdefghij\nabcdefghij\nabcdefghij\nabcdefghij\nabcdefghij\nabcdefghij\nabcdefghij\nabcdefghij\nabcdefghij\nabcdefghij\nabcdefghij\n";
        diff_match_patch_test.assertEquals((String)"diff_main: Simple line-mode.", this.dmp.diff_main((String)a, (String)b, true), this.dmp.diff_main((String)a, (String)b, false));
        a = "1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890";
        b = "abcdefghijabcdefghijabcdefghijabcdefghijabcdefghijabcdefghijabcdefghijabcdefghijabcdefghijabcdefghijabcdefghijabcdefghijabcdefghij";
        diff_match_patch_test.assertEquals((String)"diff_main: Single line-mode.", this.dmp.diff_main((String)a, (String)b, true), this.dmp.diff_main((String)a, (String)b, false));
        a = "1234567890\n1234567890\n1234567890\n1234567890\n1234567890\n1234567890\n1234567890\n1234567890\n1234567890\n1234567890\n1234567890\n1234567890\n1234567890\n";
        b = "abcdefghij\n1234567890\n1234567890\n1234567890\nabcdefghij\n1234567890\n1234567890\n1234567890\nabcdefghij\n1234567890\n1234567890\n1234567890\nabcdefghij\n";
        Object[] texts_linemode = diff_match_patch_test.diff_rebuildtexts(this.dmp.diff_main((String)a, (String)b, true));
        System.out.println(texts_linemode[0]);
        System.out.println("=========================================");
        System.out.println(texts_linemode[1]);
        Object[] texts_textmode = diff_match_patch_test.diff_rebuildtexts(this.dmp.diff_main((String)a, (String)b, false));
        this.assertArrayEquals("diff_main: Overlap line-mode.", texts_textmode, texts_linemode);
        try {
            this.dmp.diff_main(null, null);
            diff_match_patch_test.fail((String)"diff_main: Null inputs.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testBaisui() throws Exception {
        String str1 = IOUtils.toString((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/schema.xml"));
        String str2 = IOUtils.toString((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/schema2.xml"));
        LinkedList<diff_match_patch.Diff> differ = this.dmp.diff_main(str1, str2, false);
        StringBuffer result = new StringBuffer();
        for (diff_match_patch.Diff d : differ) {
            if (d.operation == diff_match_patch.Operation.EQUAL) {
                result.append(StringEscapeUtils.escapeXml((String)d.text));
                continue;
            }
            if (d.operation == diff_match_patch.Operation.DELETE) {
                result.append("<strike>").append(StringEscapeUtils.escapeXml((String)d.text)).append("</strike>");
                continue;
            }
            if (d.operation != diff_match_patch.Operation.INSERT) continue;
            result.append("<span class=\"add\">").append(StringEscapeUtils.escapeXml((String)d.text)).append("</span>");
        }
        System.out.println(result);
    }

    public void testMatchAlphabet() {
        HashMap<Character, Integer> bitmask = new HashMap<Character, Integer>();
        bitmask.put(Character.valueOf('a'), 4);
        bitmask.put(Character.valueOf('b'), 2);
        bitmask.put(Character.valueOf('c'), 1);
        diff_match_patch_test.assertEquals((String)"match_alphabet: Unique.", bitmask, this.dmp.match_alphabet("abc"));
        bitmask = new HashMap();
        bitmask.put(Character.valueOf('a'), 37);
        bitmask.put(Character.valueOf('b'), 18);
        bitmask.put(Character.valueOf('c'), 8);
        diff_match_patch_test.assertEquals((String)"match_alphabet: Duplicates.", bitmask, this.dmp.match_alphabet("abcaba"));
    }

    public void testMatchBitap() {
        this.dmp.Match_Distance = 100;
        this.dmp.Match_Threshold = 0.5f;
        diff_match_patch_test.assertEquals((String)"match_bitap: Exact match #1.", (int)5, (int)this.dmp.match_bitap("abcdefghijk", "fgh", 5));
        diff_match_patch_test.assertEquals((String)"match_bitap: Exact match #2.", (int)5, (int)this.dmp.match_bitap("abcdefghijk", "fgh", 0));
        diff_match_patch_test.assertEquals((String)"match_bitap: Fuzzy match #1.", (int)4, (int)this.dmp.match_bitap("abcdefghijk", "efxhi", 0));
        diff_match_patch_test.assertEquals((String)"match_bitap: Fuzzy match #2.", (int)2, (int)this.dmp.match_bitap("abcdefghijk", "cdefxyhijk", 5));
        diff_match_patch_test.assertEquals((String)"match_bitap: Fuzzy match #3.", (int)-1, (int)this.dmp.match_bitap("abcdefghijk", "bxy", 1));
        diff_match_patch_test.assertEquals((String)"match_bitap: Overflow.", (int)2, (int)this.dmp.match_bitap("123456789xx0", "3456789x0", 2));
        diff_match_patch_test.assertEquals((String)"match_bitap: Before start match.", (int)0, (int)this.dmp.match_bitap("abcdef", "xxabc", 4));
        diff_match_patch_test.assertEquals((String)"match_bitap: Beyond end match.", (int)3, (int)this.dmp.match_bitap("abcdef", "defyy", 4));
        diff_match_patch_test.assertEquals((String)"match_bitap: Oversized pattern.", (int)0, (int)this.dmp.match_bitap("abcdef", "xabcdefy", 0));
        this.dmp.Match_Threshold = 0.4f;
        diff_match_patch_test.assertEquals((String)"match_bitap: Threshold #1.", (int)4, (int)this.dmp.match_bitap("abcdefghijk", "efxyhi", 1));
        this.dmp.Match_Threshold = 0.3f;
        diff_match_patch_test.assertEquals((String)"match_bitap: Threshold #2.", (int)-1, (int)this.dmp.match_bitap("abcdefghijk", "efxyhi", 1));
        this.dmp.Match_Threshold = 0.0f;
        diff_match_patch_test.assertEquals((String)"match_bitap: Threshold #3.", (int)1, (int)this.dmp.match_bitap("abcdefghijk", "bcdef", 1));
        this.dmp.Match_Threshold = 0.5f;
        diff_match_patch_test.assertEquals((String)"match_bitap: Multiple select #1.", (int)0, (int)this.dmp.match_bitap("abcdexyzabcde", "abccde", 3));
        diff_match_patch_test.assertEquals((String)"match_bitap: Multiple select #2.", (int)8, (int)this.dmp.match_bitap("abcdexyzabcde", "abccde", 5));
        this.dmp.Match_Distance = 10;
        diff_match_patch_test.assertEquals((String)"match_bitap: Distance test #1.", (int)-1, (int)this.dmp.match_bitap("abcdefghijklmnopqrstuvwxyz", "abcdefg", 24));
        diff_match_patch_test.assertEquals((String)"match_bitap: Distance test #2.", (int)0, (int)this.dmp.match_bitap("abcdefghijklmnopqrstuvwxyz", "abcdxxefg", 1));
        this.dmp.Match_Distance = 1000;
        diff_match_patch_test.assertEquals((String)"match_bitap: Distance test #3.", (int)0, (int)this.dmp.match_bitap("abcdefghijklmnopqrstuvwxyz", "abcdefg", 24));
    }

    public void testMatchMain() {
        diff_match_patch_test.assertEquals((String)"match_main: Equality.", (int)0, (int)this.dmp.match_main("abcdef", "abcdef", 1000));
        diff_match_patch_test.assertEquals((String)"match_main: Null text.", (int)-1, (int)this.dmp.match_main("", "abcdef", 1));
        diff_match_patch_test.assertEquals((String)"match_main: Null pattern.", (int)3, (int)this.dmp.match_main("abcdef", "", 3));
        diff_match_patch_test.assertEquals((String)"match_main: Exact match.", (int)3, (int)this.dmp.match_main("abcdef", "de", 3));
        diff_match_patch_test.assertEquals((String)"match_main: Beyond end match.", (int)3, (int)this.dmp.match_main("abcdef", "defy", 4));
        diff_match_patch_test.assertEquals((String)"match_main: Oversized pattern.", (int)0, (int)this.dmp.match_main("abcdef", "abcdefy", 0));
        this.dmp.Match_Threshold = 0.7f;
        diff_match_patch_test.assertEquals((String)"match_main: Complex match.", (int)4, (int)this.dmp.match_main("I am the very model of a modern major general.", " that berry ", 5));
        this.dmp.Match_Threshold = 0.5f;
        try {
            this.dmp.match_main(null, null, 0);
            diff_match_patch_test.fail((String)"match_main: Null inputs.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testPatchObj() {
        diff_match_patch.Patch p = new diff_match_patch.Patch();
        p.start1 = 20;
        p.start2 = 21;
        p.length1 = 18;
        p.length2 = 17;
        p.diffs = diff_match_patch_test.diffList(new diff_match_patch.Diff(this.EQUAL, "jump"), new diff_match_patch.Diff(this.DELETE, "s"), new diff_match_patch.Diff(this.INSERT, "ed"), new diff_match_patch.Diff(this.EQUAL, " over "), new diff_match_patch.Diff(this.DELETE, "the"), new diff_match_patch.Diff(this.INSERT, "a"), new diff_match_patch.Diff(this.EQUAL, "\nlaz"));
        String strp = "@@ -21,18 +22,17 @@\n jump\n-s\n+ed\n  over \n-the\n+a\n %0Alaz\n";
        diff_match_patch_test.assertEquals((String)"Patch: toString.", (String)strp, (String)p.toString());
    }

    public void testPatchFromText() {
        diff_match_patch_test.assertTrue((String)"patch_fromText: #0.", (boolean)this.dmp.patch_fromText("").isEmpty());
        String strp = "@@ -21,18 +22,17 @@\n jump\n-s\n+ed\n  over \n-the\n+a\n %0Alaz\n";
        diff_match_patch_test.assertEquals((String)"patch_fromText: #1.", (String)strp, (String)this.dmp.patch_fromText(strp).get(0).toString());
        diff_match_patch_test.assertEquals((String)"patch_fromText: #2.", (String)"@@ -1 +1 @@\n-a\n+b\n", (String)this.dmp.patch_fromText("@@ -1 +1 @@\n-a\n+b\n").get(0).toString());
        diff_match_patch_test.assertEquals((String)"patch_fromText: #3.", (String)"@@ -1,3 +0,0 @@\n-abc\n", (String)this.dmp.patch_fromText("@@ -1,3 +0,0 @@\n-abc\n").get(0).toString());
        diff_match_patch_test.assertEquals((String)"patch_fromText: #4.", (String)"@@ -0,0 +1,3 @@\n+abc\n", (String)this.dmp.patch_fromText("@@ -0,0 +1,3 @@\n+abc\n").get(0).toString());
        try {
            this.dmp.patch_fromText("Bad\nPatch\n");
            diff_match_patch_test.fail((String)"patch_fromText: #5.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testPatchToText() {
        String strp = "@@ -21,18 +22,17 @@\n jump\n-s\n+ed\n  over \n-the\n+a\n  laz\n";
        List<diff_match_patch.Patch> patches = this.dmp.patch_fromText(strp);
        diff_match_patch_test.assertEquals((String)"patch_toText: Single.", (String)strp, (String)this.dmp.patch_toText(patches));
        strp = "@@ -1,9 +1,9 @@\n-f\n+F\n oo+fooba\n@@ -7,9 +7,9 @@\n obar\n-,\n+.\n  tes\n";
        patches = this.dmp.patch_fromText(strp);
        diff_match_patch_test.assertEquals((String)"patch_toText: Dual.", (String)strp, (String)this.dmp.patch_toText(patches));
    }

    public void testPatchAddContext() {
        this.dmp.Patch_Margin = (short)4;
        diff_match_patch.Patch p = this.dmp.patch_fromText("@@ -21,4 +21,10 @@\n-jump\n+somersault\n").get(0);
        this.dmp.patch_addContext(p, "The quick brown fox jumps over the lazy dog.");
        diff_match_patch_test.assertEquals((String)"patch_addContext: Simple case.", (String)"@@ -17,12 +17,18 @@\n fox \n-jump\n+somersault\n s ov\n", (String)p.toString());
        p = this.dmp.patch_fromText("@@ -21,4 +21,10 @@\n-jump\n+somersault\n").get(0);
        this.dmp.patch_addContext(p, "The quick brown fox jumps.");
        diff_match_patch_test.assertEquals((String)"patch_addContext: Not enough trailing context.", (String)"@@ -17,10 +17,16 @@\n fox \n-jump\n+somersault\n s.\n", (String)p.toString());
        p = this.dmp.patch_fromText("@@ -3 +3,2 @@\n-e\n+at\n").get(0);
        this.dmp.patch_addContext(p, "The quick brown fox jumps.");
        diff_match_patch_test.assertEquals((String)"patch_addContext: Not enough leading context.", (String)"@@ -1,7 +1,8 @@\n Th\n-e\n+at\n  qui\n", (String)p.toString());
        p = this.dmp.patch_fromText("@@ -3 +3,2 @@\n-e\n+at\n").get(0);
        this.dmp.patch_addContext(p, "The quick brown fox jumps.  The quick brown fox crashes.");
        diff_match_patch_test.assertEquals((String)"patch_addContext: Ambiguity.", (String)"@@ -1,27 +1,28 @@\n Th\n-e\n+at\n  quick brown fox jumps. \n", (String)p.toString());
    }

    public void testPatchMake() {
        LinkedList<diff_match_patch.Patch> patches = this.dmp.patch_make("", "");
        diff_match_patch_test.assertEquals((String)"patch_make: Null case.", (String)"", (String)this.dmp.patch_toText(patches));
        Object text1 = "The quick brown fox jumps over the lazy dog.";
        Object text2 = "That quick brown fox jumped over a lazy dog.";
        String expectedPatch = "@@ -1,8 +1,7 @@\n Th\n-at\n+e\n  qui\n@@ -21,17 +21,18 @@\n jump\n-ed\n+s\n  over \n-a\n+the\n  laz\n";
        patches = this.dmp.patch_make((String)text2, (String)text1);
        diff_match_patch_test.assertEquals((String)"patch_make: Text2+Text1 inputs.", (String)expectedPatch, (String)this.dmp.patch_toText(patches));
        expectedPatch = "@@ -1,11 +1,12 @@\n Th\n-e\n+at\n  quick b\n@@ -22,18 +22,17 @@\n jump\n-s\n+ed\n  over \n-the\n+a\n  laz\n";
        patches = this.dmp.patch_make((String)text1, (String)text2);
        diff_match_patch_test.assertEquals((String)"patch_make: Text1+Text2 inputs.", (String)expectedPatch, (String)this.dmp.patch_toText(patches));
        LinkedList<diff_match_patch.Diff> diffs = this.dmp.diff_main((String)text1, (String)text2, false);
        patches = this.dmp.patch_make(diffs);
        diff_match_patch_test.assertEquals((String)"patch_make: Diff input.", (String)expectedPatch, (String)this.dmp.patch_toText(patches));
        patches = this.dmp.patch_make((String)text1, diffs);
        diff_match_patch_test.assertEquals((String)"patch_make: Text1+Diff inputs.", (String)expectedPatch, (String)this.dmp.patch_toText(patches));
        patches = this.dmp.patch_make((String)text1, (String)text2, diffs);
        diff_match_patch_test.assertEquals((String)"patch_make: Text1+Text2+Diff inputs (deprecated).", (String)expectedPatch, (String)this.dmp.patch_toText(patches));
        patches = this.dmp.patch_make("`1234567890-=[]\\;',./", "~!@#$%^&*()_+{}|:\"<>?");
        diff_match_patch_test.assertEquals((String)"patch_toText: Character encoding.", (String)"@@ -1,21 +1,21 @@\n-%601234567890-=%5B%5D%5C;',./\n+~!@#$%25%5E&*()_+%7B%7D%7C:%22%3C%3E?\n", (String)this.dmp.patch_toText(patches));
        diffs = diff_match_patch_test.diffList(new diff_match_patch.Diff(this.DELETE, "`1234567890-=[]\\;',./"), new diff_match_patch.Diff(this.INSERT, "~!@#$%^&*()_+{}|:\"<>?"));
        diff_match_patch_test.assertEquals((String)"patch_fromText: Character decoding.", diffs, this.dmp.patch_fromText((String)"@@ -1,21 +1,21 @@\n-%601234567890-=%5B%5D%5C;',./\n+~!@#$%25%5E&*()_+%7B%7D%7C:%22%3C%3E?\n").get((int)0).diffs);
        text1 = "";
        for (int x = 0; x < 100; ++x) {
            text1 = (String)text1 + "abcdef";
        }
        text2 = (String)text1 + "123";
        expectedPatch = "@@ -573,28 +573,31 @@\n cdefabcdefabcdefabcdefabcdef\n+123\n";
        patches = this.dmp.patch_make((String)text1, (String)text2);
        diff_match_patch_test.assertEquals((String)"patch_make: Long string with repeats.", (String)expectedPatch, (String)this.dmp.patch_toText(patches));
        try {
            this.dmp.patch_make(null);
            diff_match_patch_test.fail((String)"patch_make: Null inputs.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testPatchSplitMax() {
        LinkedList<diff_match_patch.Patch> patches = this.dmp.patch_make("abcdefghijklmnopqrstuvwxyz01234567890", "XabXcdXefXghXijXklXmnXopXqrXstXuvXwxXyzX01X23X45X67X89X0");
        this.dmp.patch_splitMax(patches);
        diff_match_patch_test.assertEquals((String)"patch_splitMax: #1.", (String)"@@ -1,32 +1,46 @@\n+X\n ab\n+X\n cd\n+X\n ef\n+X\n gh\n+X\n ij\n+X\n kl\n+X\n mn\n+X\n op\n+X\n qr\n+X\n st\n+X\n uv\n+X\n wx\n+X\n yz\n+X\n 012345\n@@ -25,13 +39,18 @@\n zX01\n+X\n 23\n+X\n 45\n+X\n 67\n+X\n 89\n+X\n 0\n", (String)this.dmp.patch_toText(patches));
        patches = this.dmp.patch_make("abcdef1234567890123456789012345678901234567890123456789012345678901234567890uvwxyz", "abcdefuvwxyz");
        String oldToText = this.dmp.patch_toText(patches);
        this.dmp.patch_splitMax(patches);
        diff_match_patch_test.assertEquals((String)"patch_splitMax: #2.", (String)oldToText, (String)this.dmp.patch_toText(patches));
        patches = this.dmp.patch_make("1234567890123456789012345678901234567890123456789012345678901234567890", "abc");
        this.dmp.patch_splitMax(patches);
        diff_match_patch_test.assertEquals((String)"patch_splitMax: #3.", (String)"@@ -1,32 +1,4 @@\n-1234567890123456789012345678\n 9012\n@@ -29,32 +1,4 @@\n-9012345678901234567890123456\n 7890\n@@ -57,14 +1,3 @@\n-78901234567890\n+abc\n", (String)this.dmp.patch_toText(patches));
        patches = this.dmp.patch_make("abcdefghij , h : 0 , t : 1 abcdefghij , h : 0 , t : 1 abcdefghij , h : 0 , t : 1", "abcdefghij , h : 1 , t : 1 abcdefghij , h : 1 , t : 1 abcdefghij , h : 0 , t : 1");
        this.dmp.patch_splitMax(patches);
        diff_match_patch_test.assertEquals((String)"patch_splitMax: #4.", (String)"@@ -2,32 +2,32 @@\n bcdefghij , h : \n-0\n+1\n  , t : 1 abcdef\n@@ -29,32 +29,32 @@\n bcdefghij , h : \n-0\n+1\n  , t : 1 abcdef\n", (String)this.dmp.patch_toText(patches));
    }

    public void testPatchAddPadding() {
        LinkedList<diff_match_patch.Patch> patches = this.dmp.patch_make("", "test");
        diff_match_patch_test.assertEquals((String)"patch_addPadding: Both edges full.", (String)"@@ -0,0 +1,4 @@\n+test\n", (String)this.dmp.patch_toText(patches));
        this.dmp.patch_addPadding(patches);
        diff_match_patch_test.assertEquals((String)"patch_addPadding: Both edges full.", (String)"@@ -1,8 +1,12 @@\n %01%02%03%04\n+test\n %01%02%03%04\n", (String)this.dmp.patch_toText(patches));
        patches = this.dmp.patch_make("XY", "XtestY");
        diff_match_patch_test.assertEquals((String)"patch_addPadding: Both edges partial.", (String)"@@ -1,2 +1,6 @@\n X\n+test\n Y\n", (String)this.dmp.patch_toText(patches));
        this.dmp.patch_addPadding(patches);
        diff_match_patch_test.assertEquals((String)"patch_addPadding: Both edges partial.", (String)"@@ -2,8 +2,12 @@\n %02%03%04X\n+test\n Y%01%02%03\n", (String)this.dmp.patch_toText(patches));
        patches = this.dmp.patch_make("XXXXYYYY", "XXXXtestYYYY");
        diff_match_patch_test.assertEquals((String)"patch_addPadding: Both edges none.", (String)"@@ -1,8 +1,12 @@\n XXXX\n+test\n YYYY\n", (String)this.dmp.patch_toText(patches));
        this.dmp.patch_addPadding(patches);
        diff_match_patch_test.assertEquals((String)"patch_addPadding: Both edges none.", (String)"@@ -5,8 +5,12 @@\n XXXX\n+test\n YYYY\n", (String)this.dmp.patch_toText(patches));
    }

    public void testPatchApply() {
        this.dmp.Match_Distance = 1000;
        this.dmp.Match_Threshold = 0.5f;
        this.dmp.Patch_DeleteThreshold = 0.5f;
        LinkedList<diff_match_patch.Patch> patches = this.dmp.patch_make("", "");
        Object[] results = this.dmp.patch_apply(patches, "Hello world.");
        boolean[] boolArray = (boolean[])results[1];
        String resultStr = results[0] + "\t" + boolArray.length;
        diff_match_patch_test.assertEquals((String)"patch_apply: Null case.", (String)"Hello world.\t0", (String)resultStr);
        patches = this.dmp.patch_make("The quick brown fox jumps over the lazy dog.", "That quick brown fox jumped over a lazy dog.");
        results = this.dmp.patch_apply(patches, "The quick brown fox jumps over the lazy dog.");
        boolArray = (boolean[])results[1];
        resultStr = results[0] + "\t" + boolArray[0] + "\t" + boolArray[1];
        diff_match_patch_test.assertEquals((String)"patch_apply: Exact match.", (String)"That quick brown fox jumped over a lazy dog.\ttrue\ttrue", (String)resultStr);
        results = this.dmp.patch_apply(patches, "The quick red rabbit jumps over the tired tiger.");
        boolArray = (boolean[])results[1];
        resultStr = results[0] + "\t" + boolArray[0] + "\t" + boolArray[1];
        diff_match_patch_test.assertEquals((String)"patch_apply: Partial match.", (String)"That quick red rabbit jumped over a tired tiger.\ttrue\ttrue", (String)resultStr);
        results = this.dmp.patch_apply(patches, "I am the very model of a modern major general.");
        boolArray = (boolean[])results[1];
        resultStr = results[0] + "\t" + boolArray[0] + "\t" + boolArray[1];
        diff_match_patch_test.assertEquals((String)"patch_apply: Failed match.", (String)"I am the very model of a modern major general.\tfalse\tfalse", (String)resultStr);
        patches = this.dmp.patch_make("x1234567890123456789012345678901234567890123456789012345678901234567890y", "xabcy");
        results = this.dmp.patch_apply(patches, "x123456789012345678901234567890-----++++++++++-----123456789012345678901234567890y");
        boolArray = (boolean[])results[1];
        resultStr = results[0] + "\t" + boolArray[0] + "\t" + boolArray[1];
        diff_match_patch_test.assertEquals((String)"patch_apply: Big delete, small change.", (String)"xabcy\ttrue\ttrue", (String)resultStr);
        patches = this.dmp.patch_make("x1234567890123456789012345678901234567890123456789012345678901234567890y", "xabcy");
        results = this.dmp.patch_apply(patches, "x12345678901234567890---------------++++++++++---------------12345678901234567890y");
        boolArray = (boolean[])results[1];
        resultStr = results[0] + "\t" + boolArray[0] + "\t" + boolArray[1];
        diff_match_patch_test.assertEquals((String)"patch_apply: Big delete, big change 1.", (String)"xabc12345678901234567890---------------++++++++++---------------12345678901234567890y\tfalse\ttrue", (String)resultStr);
        this.dmp.Patch_DeleteThreshold = 0.6f;
        patches = this.dmp.patch_make("x1234567890123456789012345678901234567890123456789012345678901234567890y", "xabcy");
        results = this.dmp.patch_apply(patches, "x12345678901234567890---------------++++++++++---------------12345678901234567890y");
        boolArray = (boolean[])results[1];
        resultStr = results[0] + "\t" + boolArray[0] + "\t" + boolArray[1];
        diff_match_patch_test.assertEquals((String)"patch_apply: Big delete, big change 2.", (String)"xabcy\ttrue\ttrue", (String)resultStr);
        this.dmp.Patch_DeleteThreshold = 0.5f;
        this.dmp.Match_Threshold = 0.0f;
        this.dmp.Match_Distance = 0;
        patches = this.dmp.patch_make("abcdefghijklmnopqrstuvwxyz--------------------1234567890", "abcXXXXXXXXXXdefghijklmnopqrstuvwxyz--------------------1234567YYYYYYYYYY890");
        results = this.dmp.patch_apply(patches, "ABCDEFGHIJKLMNOPQRSTUVWXYZ--------------------1234567890");
        boolArray = (boolean[])results[1];
        resultStr = results[0] + "\t" + boolArray[0] + "\t" + boolArray[1];
        diff_match_patch_test.assertEquals((String)"patch_apply: Compensate for failed patch.", (String)"ABCDEFGHIJKLMNOPQRSTUVWXYZ--------------------1234567YYYYYYYYYY890\tfalse\ttrue", (String)resultStr);
        this.dmp.Match_Threshold = 0.5f;
        this.dmp.Match_Distance = 1000;
        patches = this.dmp.patch_make("", "test");
        String patchStr = this.dmp.patch_toText(patches);
        this.dmp.patch_apply(patches, "");
        diff_match_patch_test.assertEquals((String)"patch_apply: No side effects.", (String)patchStr, (String)this.dmp.patch_toText(patches));
        patches = this.dmp.patch_make("The quick brown fox jumps over the lazy dog.", "Woof");
        patchStr = this.dmp.patch_toText(patches);
        this.dmp.patch_apply(patches, "The quick brown fox jumps over the lazy dog.");
        diff_match_patch_test.assertEquals((String)"patch_apply: No side effects with major delete.", (String)patchStr, (String)this.dmp.patch_toText(patches));
        patches = this.dmp.patch_make("", "test");
        results = this.dmp.patch_apply(patches, "");
        boolArray = (boolean[])results[1];
        resultStr = results[0] + "\t" + boolArray[0];
        diff_match_patch_test.assertEquals((String)"patch_apply: Edge exact match.", (String)"test\ttrue", (String)resultStr);
        patches = this.dmp.patch_make("XY", "XtestY");
        results = this.dmp.patch_apply(patches, "XY");
        boolArray = (boolean[])results[1];
        resultStr = results[0] + "\t" + boolArray[0];
        diff_match_patch_test.assertEquals((String)"patch_apply: Near edge exact match.", (String)"XtestY\ttrue", (String)resultStr);
        patches = this.dmp.patch_make("y", "y123");
        results = this.dmp.patch_apply(patches, "x");
        boolArray = (boolean[])results[1];
        resultStr = results[0] + "\t" + boolArray[0];
        diff_match_patch_test.assertEquals((String)"patch_apply: Edge partial match.", (String)"x123\ttrue", (String)resultStr);
    }

    private void assertArrayEquals(String error_msg, Object[] a, Object[] b) {
        List<Object> list_a = Arrays.asList(a);
        List<Object> list_b = Arrays.asList(b);
        diff_match_patch_test.assertEquals((String)error_msg, list_a, list_b);
    }

    private void assertLinesToCharsResultEquals(String error_msg, diff_match_patch.LinesToCharsResult a, diff_match_patch.LinesToCharsResult b) {
        diff_match_patch_test.assertEquals((String)error_msg, (String)a.chars1, (String)b.chars1);
        diff_match_patch_test.assertEquals((String)error_msg, (String)a.chars2, (String)b.chars2);
        diff_match_patch_test.assertEquals((String)error_msg, a.lineArray, b.lineArray);
    }

    private static String[] diff_rebuildtexts(LinkedList<diff_match_patch.Diff> diffs) {
        String[] text = new String[]{"", ""};
        for (diff_match_patch.Diff myDiff : diffs) {
            if (myDiff.operation != diff_match_patch.Operation.INSERT) {
                text[0] = text[0] + myDiff.text;
            }
            if (myDiff.operation == diff_match_patch.Operation.DELETE) continue;
            text[1] = text[1] + myDiff.text;
        }
        return text;
    }

    private static LinkedList<diff_match_patch.Diff> diffList(diff_match_patch.Diff ... diffs) {
        LinkedList<diff_match_patch.Diff> myDiffList = new LinkedList<diff_match_patch.Diff>();
        for (diff_match_patch.Diff myDiff : diffs) {
            myDiffList.add(myDiff);
        }
        return myDiffList;
    }

    public void testDiff() {
        String s1 = "hello";
        String s2 = "hollo";
        StringBuilder compare = new StringBuilder();
        LinkedList<diff_match_patch.Diff> differ = this.dmp.diff_main(s1, s2, true);
        for (diff_match_patch.Diff d : differ) {
            if (d.operation == diff_match_patch.Operation.EQUAL) {
                compare.append(StringEscapeUtils.escapeXml((String)d.text));
                continue;
            }
            if (d.operation == diff_match_patch.Operation.DELETE) {
                compare.append("<span style='text-decoration:line-through;background-color:pink;'>").append(StringEscapeUtils.escapeXml((String)d.text)).append("</span>");
                continue;
            }
            if (d.operation != diff_match_patch.Operation.INSERT) continue;
            compare.append("<span style=\"background-color:#00FF00;\">").append(StringEscapeUtils.escapeXml((String)d.text)).append("</span>");
        }
        System.out.println(compare.toString());
    }
}

