/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.util;

import com.alibaba.citrus.turbine.Context;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.opensymphony.xwork2.ActionContext;
import com.qlangtech.tis.IPluginEnum;
import com.qlangtech.tis.TIS;
import com.qlangtech.tis.coredefine.module.action.PluginItemsParser;
import com.qlangtech.tis.datax.StoreResourceType;
import com.qlangtech.tis.extension.Describable;
import com.qlangtech.tis.extension.Descriptor;
import com.qlangtech.tis.extension.impl.XmlFile;
import com.qlangtech.tis.extension.util.GroovyShellUtil;
import com.qlangtech.tis.manage.IAppSource;
import com.qlangtech.tis.manage.common.Option;
import com.qlangtech.tis.manage.servlet.BasicServlet;
import com.qlangtech.tis.offline.module.action.OfflineDatasourceAction;
import com.qlangtech.tis.plugin.IEndTypeGetter;
import com.qlangtech.tis.plugin.IPluginStore;
import com.qlangtech.tis.plugin.IPluginStoreSave;
import com.qlangtech.tis.plugin.IdentityName;
import com.qlangtech.tis.plugin.PluginStore;
import com.qlangtech.tis.plugin.SetPluginsResult;
import com.qlangtech.tis.plugin.ds.DataSourceFactory;
import com.qlangtech.tis.plugin.ds.DataSourceFactoryPluginStore;
import com.qlangtech.tis.plugin.ds.PostedDSProp;
import com.qlangtech.tis.runtime.module.misc.FormVaildateType;
import com.qlangtech.tis.runtime.module.misc.IControlMsgHandler;
import com.qlangtech.tis.runtime.module.misc.IFieldErrorHandler;
import com.qlangtech.tis.util.AdapterPluginContext;
import com.qlangtech.tis.util.AttrValMap;
import com.qlangtech.tis.util.HeteroEnum;
import com.qlangtech.tis.util.IPluginContext;
import com.qlangtech.tis.util.IPluginItemsProcessor;
import com.qlangtech.tis.util.IPluginWithStore;
import com.qlangtech.tis.util.ItemsSaveResult;
import com.qlangtech.tis.util.UploadPluginMeta;
import com.qlangtech.tis.utils.DBsGetter;
import com.qlangtech.tis.workflow.dao.IWorkflowDAOFacade;
import com.qlangtech.tis.workflow.pojo.DatasourceDb;
import com.qlangtech.tis.workflow.pojo.DatasourceDbCriteria;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Observable;
import java.util.Observer;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class PluginItems
implements IPluginItemsProcessor {
    private final IPluginEnum heteroEnum;
    private final UploadPluginMeta pluginMeta;
    private final IPluginContext pluginContext;
    private final Context context;
    public List<AttrValMap> items;
    private static final Set<Descriptor> dbUpdateEventObservers = Sets.newHashSet();
    private static final PluginItemsSaveObservable observable = new PluginItemsSaveObservable();

    public static void addPluginItemsSaveObserver(PluginItemsSaveObserver obsv) {
        observable.addObserver(obsv);
    }

    public PluginItems(IPluginContext pluginContext, Context context, UploadPluginMeta pluginMeta) {
        this.heteroEnum = pluginMeta.getHeteroEnum();
        this.pluginMeta = pluginMeta;
        this.pluginContext = pluginMeta.isDisableBizSet() ? new AdapterPluginContext(pluginContext){

            public void setBizResult(Context context, Object result) {
            }

            public IFieldErrorHandler.BasicPipelineValidator getPipelineValidator(IFieldErrorHandler.BizLogic logicType) {
                throw new UnsupportedOperationException();
            }
        } : pluginContext;
        this.context = context;
    }

    public final List<AttrValMap> getItems() {
        if (CollectionUtils.isEmpty(this.items)) {
            throw new IllegalStateException("items can not be empty");
        }
        return this.items;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PluginItemsParser validate(IPluginContext module, Context context, int pluginIndex, FormVaildateType verify) {
        ArrayList items = Lists.newArrayList();
        PluginItemsParser parseResult = new PluginItemsParser(items);
        parseResult.pluginItems = this;
        Descriptor.PluginValidateResult validateResult = null;
        AttrValMap attrValMap = null;
        for (int itemIndex = 0; itemIndex < this.items.size(); ++itemIndex) {
            attrValMap = this.items.get(itemIndex);
            try {
                AttrValMap.setCurrentRootPluginValidator((Descriptor)attrValMap.descriptor);
                Descriptor.PluginValidateResult.setValidateItemPos((Context)context, (Integer)pluginIndex, (Integer)itemIndex);
                validateResult = attrValMap.validate((IControlMsgHandler)module, context, Objects.requireNonNull(verify, "verify can not be null"), Optional.empty());
                if (!validateResult.isValid()) {
                    parseResult.faild = true;
                    continue;
                }
                validateResult.setDescriptor(attrValMap.descriptor);
                items.add(validateResult);
                continue;
            }
            finally {
                AttrValMap.removeCurrentRootPluginValidator();
            }
        }
        return parseResult;
    }

    private static List<IdentityName> loadExistDbs(boolean listen2SaveEvent, String ... extendClass) {
        ActionContext actionContext = ActionContext.getContext();
        if (actionContext == null) {
            return Collections.emptyList();
        }
        if (extendClass == null || extendClass.length < 1) {
            throw new IllegalArgumentException("param extendClass can not be null");
        }
        if (actionContext.getServletContext() == null) {
            throw new IllegalStateException("ServletContext can not be null");
        }
        final Descriptor descriptor = (Descriptor)GroovyShellUtil.descriptorThreadLocal.get();
        if (listen2SaveEvent && dbUpdateEventObservers.add(Objects.requireNonNull(descriptor, "descriptor can not be null"))) {
            PluginItems.addPluginItemsSaveObserver(new PluginItemsSaveObserver(){

                @Override
                public void afterSaved(PluginItemsSaveEvent event) {
                    if (event.heteroEnum == HeteroEnum.DATASOURCE) {
                        descriptor.cleanPropertyTypes();
                    }
                }
            });
        }
        IWorkflowDAOFacade wfFacade = BasicServlet.getBeanByType(actionContext.getServletContext(), IWorkflowDAOFacade.class);
        Objects.requireNonNull(wfFacade, "wfFacade can not be null");
        DatasourceDbCriteria dbCriteria = new DatasourceDbCriteria();
        ArrayList extendClazzs = Lists.newArrayList();
        for (String type : extendClass) {
            extendClazzs.add(StringUtils.lowerCase((String)type));
        }
        dbCriteria.createCriteria().andExtendClassIn((List)extendClazzs);
        List dbs = wfFacade.getDatasourceDbDAO().selectByExample(dbCriteria);
        List dsDescs = HeteroEnum.DATASOURCE.descriptors();
        return dbs.stream().map(db -> new DBIdentity((DatasourceDb)db, dsDescs)).collect(Collectors.toList());
    }

    public static List<Option> getExistDbs(String ... extendClass) {
        if (OfflineDatasourceAction.existDbs != null) {
            return OfflineDatasourceAction.existDbs;
        }
        return PluginItems.loadExistDbs(true, extendClass).stream().map(db -> new Option(db.identityValue(), (Object)db.identityValue())).collect(Collectors.toList());
    }

    private IPluginStoreSave<?> getStore(final List<Descriptor.ParseDescribable<?>> dlist) {
        if (this.pluginMeta.getBoolean("skipPluginSave")) {
            return IPluginStoreSave.noneSave;
        }
        IPluginStoreSave<DataSourceFactory> store = null;
        if (this.heteroEnum == HeteroEnum.APP_SOURCE) {
            for (Descriptor.ParseDescribable<?> d : dlist) {
                Object inst = d.getInstance();
                if (!(inst instanceof IdentityName)) continue;
                StoreResourceType resType = ((IAppSource)inst).getResType();
                store = IAppSource.getPluginStore((IPluginContext)this.pluginContext, (StoreResourceType)resType, (String)((IdentityName)d.getInstance()).identityValue());
                break;
            }
            Objects.requireNonNull(store, "plugin type:" + this.heteroEnum.getIdentity() + " can not find relevant Store");
        } else if (this.heteroEnum == HeteroEnum.DATASOURCE || this.pluginContext.isDataSourceAware()) {
            store = new IPluginStoreSave<DataSourceFactory>(){
                PostedDSProp dbExtraProps;
                DataSourceFactoryPluginStore pluginStore;
                {
                    this.dbExtraProps = this.createPostedDSProp(PluginItems.this.pluginMeta);
                    this.pluginStore = TIS.getDataSourceFactoryPluginStore((PostedDSProp)this.dbExtraProps);
                }

                public XmlFile getTargetFile() {
                    return this.pluginStore.getTargetFile();
                }

                private PostedDSProp createPostedDSProp(UploadPluginMeta pluginMeta) {
                    Iterator iterator = dlist.iterator();
                    if (iterator.hasNext()) {
                        Descriptor.ParseDescribable plugin = (Descriptor.ParseDescribable)iterator.next();
                        if (StringUtils.isEmpty((CharSequence)pluginMeta.getExtraParam("dsname"))) {
                            pluginMeta.putExtraParams("dsname", ((IdentityName)plugin.getInstance()).identityValue());
                        }
                        return PostedDSProp.parse((UploadPluginMeta)pluginMeta);
                    }
                    throw new IllegalStateException("has not set\uff1adsname");
                }

                public SetPluginsResult setPlugins(IPluginContext pluginContext, Optional<Context> context, List<Descriptor.ParseDescribable<DataSourceFactory>> dlist2, boolean update) {
                    SetPluginsResult finalResult = new SetPluginsResult(true, false);
                    for (Descriptor.ParseDescribable<DataSourceFactory> plugin : dlist2) {
                        SetPluginsResult result = this.pluginStore.setPlugins(pluginContext, context, Collections.singletonList(plugin), this.dbExtraProps.isUpdate());
                        if (!result.success) {
                            return result;
                        }
                        if (!result.cfgChanged) continue;
                        finalResult.cfgChanged = true;
                    }
                    return finalResult;
                }
            };
        } else if (this.heteroEnum == HeteroEnum.DATAX_WRITER || this.heteroEnum == HeteroEnum.DATAX_READER) {
            store = HeteroEnum.getDataXReaderAndWriterStore((IPluginContext)this.pluginContext, (this.heteroEnum == HeteroEnum.DATAX_READER ? 1 : 0) != 0, (UploadPluginMeta)this.pluginMeta, (Optional)this.pluginMeta.getSubFormFilter());
        } else if (this.heteroEnum == HeteroEnum.uploadCustomizedTPI) {
            store = this.heteroEnum.getPluginStore(this.pluginContext, this.pluginMeta);
        } else if (this.heteroEnum == HeteroEnum.PARAMS_CONFIG || this.heteroEnum == HeteroEnum.PARAMS_CONFIG_USER_ISOLATION) {
            store = this.heteroEnum.getPluginStore(this.pluginContext, this.pluginMeta);
        } else if (this.heteroEnum == HeteroEnum.K8S_DEFAULT_IMAGES) {
            store = this.heteroEnum.getPluginStore(this.pluginContext, this.pluginMeta);
        } else if (this.heteroEnum == HeteroEnum.K8S_FLINK_IMAGES) {
            store = this.heteroEnum.getPluginStore(this.pluginContext, this.pluginMeta);
        } else if (this.heteroEnum == HeteroEnum.K8S_POWERJOB_IMAGES) {
            store = this.heteroEnum.getPluginStore(this.pluginContext, this.pluginMeta);
        } else if (this.heteroEnum == HeteroEnum.K8S_SESSION_WORKER) {
            boolean hasSetDataXId = false;
            Iterator<Descriptor.ParseDescribable<?>> iterator = dlist.iterator();
            if (iterator.hasNext()) {
                Descriptor.ParseDescribable<?> plugin = iterator.next();
                this.pluginMeta.putExtraParams("dataxName", ((IdentityName)plugin.getInstance()).identityValue());
                hasSetDataXId = true;
            }
            if (!hasSetDataXId) {
                throw new IllegalStateException("has not set dataxName");
            }
            store = this.heteroEnum.getPluginStore(this.pluginContext, this.pluginMeta);
        } else if (this.heteroEnum == HeteroEnum.DATAX_WORKER) {
            store = this.heteroEnum.getPluginStore(this.pluginContext, this.pluginMeta);
        } else if (this.heteroEnum == HeteroEnum.appJobWorkerTplReWriter) {
            store = this.heteroEnum.getPluginStore(this.pluginContext, this.pluginMeta);
        } else if (this.heteroEnum == HeteroEnum.noStore) {
            store = this.heteroEnum.getPluginStore(this.pluginContext, this.pluginMeta);
        } else if (this.heteroEnum == HeteroEnum.TRANSFORMER_RULES) {
            store = this.heteroEnum.getPluginStore(this.pluginContext, this.pluginMeta);
        } else if (this.heteroEnum.isAppNameAware()) {
            if (!this.pluginContext.isCollectionAware()) {
                throw new IllegalStateException(this.heteroEnum.getExtensionPoint().getName() + " must be collection aware");
            }
            store = this.heteroEnum.getPluginStore(this.pluginContext, this.pluginMeta);
        } else {
            store = TIS.getPluginStore((Class)this.heteroEnum.getExtensionPoint());
        }
        return Objects.requireNonNull(store, "store can not be null");
    }

    public PluginWithStore getStorePlugins() {
        return new PluginWithStore();
    }

    public ItemsSaveResult save(Context context) {
        Objects.requireNonNull(this.pluginContext, "pluginContext can not be null");
        if (this.items == null) {
            throw new IllegalStateException("prop items can not be null");
        }
        PluginWithStore store = this.getStorePlugins();
        SetPluginsResult result = store.setPlugins(this.pluginContext, Optional.of(context));
        if (!result.success) {
            return new ItemsSaveResult(Collections.emptyList(), result);
        }
        this.notifyNewPluginSaved(store.describableList, result.cfgChanged);
        return new ItemsSaveResult(store.describableList, result);
    }

    private void notifyNewPluginSaved(List<Describable> describableList, boolean cfgChanged) {
        observable.notifyObservers(new PluginItemsSaveEvent(this.pluginContext, this.heteroEnum, describableList, cfgChanged));
    }

    private List<Descriptor.ParseDescribable<?>> getPlugins(List<Describable> describableList) {
        IPluginStore pluginStore;
        AttrValMap attrValMap = null;
        ArrayList dlist = Lists.newArrayList();
        if (this.pluginMeta.isAppend() && (pluginStore = this.heteroEnum.getPluginStore(this.pluginContext, this.pluginMeta)) != null) {
            List plugins = pluginStore.getPlugins();
            boolean firstSkip = false;
            for (Describable p : plugins) {
                if (!firstSkip) {
                    firstSkip = true;
                    Descriptor.ParseDescribable describablesWithMeta = PluginStore.getDescribablesWithMeta((IPluginStore)pluginStore, (Describable)p);
                    dlist.add(describablesWithMeta);
                    continue;
                }
                dlist.add(new Descriptor.ParseDescribable((Object)p));
            }
        }
        for (int i = 0; i < this.items.size(); ++i) {
            attrValMap = this.items.get(i);
            Descriptor.ParseDescribable describable = attrValMap.createDescribable((IControlMsgHandler)this.pluginContext, this.context);
            dlist.add(describable);
            if (describable.subFormFields) continue;
            describableList.add((Describable)describable.getInstance());
        }
        return dlist;
    }

    private <T extends Describable> List<Descriptor.ParseDescribable<T>> convert(List<Descriptor.ParseDescribable<?>> dlist) {
        return dlist.stream().map(r -> r).collect(Collectors.toList());
    }

    public static class PluginItemsSaveEvent {
        public final IPluginContext collectionName;
        public final IPluginEnum heteroEnum;
        public final List<Describable> dlist;
        public final boolean cfgChanged;

        public PluginItemsSaveEvent(IPluginContext collectionName, IPluginEnum heteroEnum, List<Describable> dlist, boolean cfgChanged) {
            this.collectionName = collectionName;
            this.heteroEnum = heteroEnum;
            this.dlist = dlist;
            this.cfgChanged = cfgChanged;
        }
    }

    public static abstract class PluginItemsSaveObserver
    implements Observer {
        @Override
        public final void update(Observable o, Object arg) {
            PluginItemsSaveEvent evt = (PluginItemsSaveEvent)arg;
            if (evt.cfgChanged) {
                this.afterSaved(evt);
            }
        }

        public abstract void afterSaved(PluginItemsSaveEvent var1);
    }

    public static class PluginItemsSaveObservable
    extends Observable {
        @Override
        public void notifyObservers(Object arg) {
            super.setChanged();
            super.notifyObservers(arg);
        }
    }

    public class PluginWithStore
    implements IPluginWithStore {
        final List<Describable> describableList = Lists.newArrayList();
        final IPluginStoreSave<?> store;
        private final List<Descriptor.ParseDescribable<?>> appendHistorical;

        SetPluginsResult setPlugins(IPluginContext pluginContext, Optional<Context> context) {
            return this.store.setPlugins(pluginContext, context, PluginItems.this.convert(this.appendHistorical));
        }

        public <T> List<T> listPlugins() {
            return PluginItems.this.convert(this.appendHistorical).stream().flatMap(d -> d.getSubFormInstances().stream()).map(d -> d).collect(Collectors.toList());
        }

        public PluginWithStore() {
            this.appendHistorical = PluginItems.this.getPlugins(this.describableList);
            this.store = PluginItems.this.getStore(this.appendHistorical);
        }

        public void afterVerified() {
            for (Descriptor.ParseDescribable<?> d : this.appendHistorical) {
                d.getSubFormInstances().forEach(plugin -> {
                    if (plugin instanceof IPluginStore.AfterPluginVerified) {
                        ((IPluginStore.AfterPluginVerified)plugin).afterVerified(this.store);
                    }
                });
            }
        }
    }

    private static class DBIdentity
    implements IdentityName,
    IEndTypeGetter {
        private final DatasourceDb db;
        private final List<Descriptor<DataSourceFactory>> dsDescs;
        private Descriptor _descriptor;

        public DBIdentity(DatasourceDb db, List<Descriptor<DataSourceFactory>> dsDescs) {
            this.db = db;
            this.dsDescs = dsDescs;
        }

        public String identityValue() {
            return this.db.getName();
        }

        public Class<?> getDescribleClass() {
            return this.getDesc().clazz;
        }

        private Descriptor getDesc() {
            if (this._descriptor == null) {
                for (Descriptor<DataSourceFactory> desc : this.dsDescs) {
                    if (!desc.getDisplayName().equalsIgnoreCase(this.db.getExtendClass())) continue;
                    this._descriptor = desc;
                    return this._descriptor;
                }
                throw new IllegalStateException("can not find '" + this.db.getExtendClass() + "' in " + this.dsDescs.stream().map(d -> d.getDisplayName()).collect(Collectors.joining(",")));
            }
            return this._descriptor;
        }

        public IEndTypeGetter.EndType getEndType() {
            Descriptor desc = null;
            desc = this.getDesc();
            if (desc instanceof IEndTypeGetter) {
                return ((IEndTypeGetter)desc).getEndType();
            }
            return null;
        }
    }

    public static class DefaultDBsGetter
    extends DBsGetter {
        public List<IdentityName> getExistDbs(String ... extendClass) {
            return PluginItems.loadExistDbs(false, extendClass);
        }
    }
}

