/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.trigger.biz.dal.dao.impl;

import com.qlangtech.tis.trigger.biz.dal.dao.AppTrigger;
import com.qlangtech.tis.trigger.biz.dal.dao.IJobMetaDataDAO;
import com.qlangtech.tis.trigger.biz.dal.dao.TriggerJob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import junit.framework.Assert;
import org.springframework.jdbc.core.support.JdbcDaoSupport;

public class JobMetaDataDAO
extends JdbcDaoSupport
implements IJobMetaDataDAO {
    private static final String SQL_SELECT_APP = " select aa.job_id,aa.job_type,aa.is_stop  from app_trigger_job_relation aa inner join application bb on (aa.app_id = bb.app_id) where bb.project_name = ? ";
    public static final String SQL_UPDATE_SET_STOP = "update app_trigger_job_relation set is_stop = ? where project_name= ?";

    public TriggerJob queryJob(String appName, Integer jobtype) {
        PreparedStatement statement = null;
        ResultSet result = null;
        TriggerJob job = null;
        Connection conn = null;
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement(" select aa.job_id,aa.job_type,aa.is_stop  from app_trigger_job_relation aa inner join application bb on (aa.app_id = bb.app_id) where bb.project_name = ?  and job_type= ?");
            statement.setString(1, appName);
            statement.setInt(2, jobtype);
            result = statement.executeQuery();
            if (result.next()) {
                job = new TriggerJob();
                job.setJobId(result.getLong(1));
                job.setJobType(result.getInt(2));
                job.setStop("Y".equals(result.getString(3)));
                TriggerJob triggerJob = job;
                return triggerJob;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                result.close();
            }
            catch (Throwable throwable) {}
            try {
                statement.close();
            }
            catch (Throwable throwable) {}
            try {
                conn.close();
            }
            catch (Throwable throwable) {}
        }
        return null;
    }

    public void setStop(String appName, boolean stop) {
        Statement statement = null;
        Connection conn = null;
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement(SQL_UPDATE_SET_STOP);
            statement.setString(1, stop ? "Y" : "N");
            statement.setString(2, appName);
            statement.execute();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                statement.close();
            }
            catch (Throwable throwable) {}
            try {
                conn.close();
            }
            catch (Throwable throwable) {}
        }
    }

    public AppTrigger queryJob(String appName) {
        PreparedStatement statement = null;
        ResultSet result = null;
        Connection conn = null;
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement(SQL_SELECT_APP);
            statement.setString(1, appName);
            result = statement.executeQuery();
            TriggerJob full = null;
            TriggerJob incr = null;
            while (result.next()) {
                if (1 == result.getInt(2)) {
                    full = new TriggerJob();
                    full.setJobId(result.getLong(1));
                    full.setJobType(1);
                    full.setStop("Y".equals(result.getString(3)));
                    continue;
                }
                if (2 != result.getInt(2)) continue;
                incr = new TriggerJob();
                incr.setJobId(result.getLong(1));
                incr.setJobType(2);
                incr.setStop("Y".equals(result.getString(3)));
            }
            Assert.assertNotNull(full);
            Assert.assertNotNull(incr);
            AppTrigger appTrigger = new AppTrigger(full, incr);
            return appTrigger;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                result.close();
            }
            catch (Throwable throwable) {}
            try {
                statement.close();
            }
            catch (Throwable throwable) {}
            try {
                conn.close();
            }
            catch (Throwable throwable) {}
        }
    }
}

