/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.runtime.module.screen;

import com.alibaba.citrus.turbine.Context;
import com.qlangtech.tis.manage.biz.dal.pojo.Server;
import com.qlangtech.tis.manage.biz.dal.pojo.ServerGroup;
import com.qlangtech.tis.manage.biz.dal.pojo.ServerGroupCriteria;
import com.qlangtech.tis.manage.biz.dal.pojo.Snapshot;
import com.qlangtech.tis.manage.common.AppDomainInfo;
import com.qlangtech.tis.manage.common.RunContext;
import com.qlangtech.tis.runtime.module.action.BasicModule;
import com.qlangtech.tis.runtime.pojo.ServerGroupAdapter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class BasicScreen
extends BasicModule {
    private static final long serialVersionUID = 1L;

    public BasicScreen() {
    }

    protected void shallnotShowEnvironment(Context context) {
        context.put("shallnotShowEnvironment", (Object)true);
    }

    public BasicScreen(String groupName) {
        super(groupName);
    }

    public abstract void execute(Context var1) throws Exception;

    protected List<ServerGroupAdapter> createServerGroupAdapterList() {
        return this.createServerGroupAdapterList(true);
    }

    protected List<ServerGroupAdapter> createServerGroupAdapterList(final boolean publishSnapshotIdIsNotNull) {
        final AppDomainInfo domain = this.getAppDomain();
        return this.createServerGroupAdapterList(new ServerGroupCriteriaSetter(){

            @Override
            public void process(ServerGroupCriteria.Criteria criteria) {
                criteria.andAppIdEqualTo(domain.getAppid()).andRuntEnvironmentEqualTo(domain.getRunEnvironment().getId());
                if (publishSnapshotIdIsNotNull) {
                    criteria.andPublishSnapshotIdIsNotNull();
                }
            }
        }, publishSnapshotIdIsNotNull);
    }

    protected List<ServerGroupAdapter> createServerGroupAdapterList(ServerGroupCriteriaSetter setter, boolean publishSnapshotIdIsNotNull) {
        return BasicScreen.createServerGroupAdapterList(setter, publishSnapshotIdIsNotNull, this);
    }

    public static List<ServerGroupAdapter> createServerGroupAdapterList(ServerGroupCriteriaSetter setter, boolean publishSnapshotIdIsNotNull, RunContext daoContext) {
        ServerGroupCriteria criteria = new ServerGroupCriteria();
        ServerGroupCriteria.Criteria query = criteria.createCriteria();
        query.andNotDelete();
        setter.process(query);
        List<ServerGroup> groupList = daoContext.getServerGroupDAO().selectByExample(criteria, 1, 400);
        ArrayList<ServerGroupAdapter> groupAdapterList = new ArrayList<ServerGroupAdapter>();
        for (ServerGroup group : groupList) {
            Snapshot snapshot = new Snapshot();
            int maxSnapshotId = 0;
            if (publishSnapshotIdIsNotNull) {
                snapshot = daoContext.getSnapshotDAO().selectByPrimaryKey(group.getPublishSnapshotId());
                maxSnapshotId = setter.getMaxSnapshotId(group, daoContext);
                if (snapshot == null) {
                    throw new IllegalStateException("group:" + group.getGid() + " has not set PublishSnapshotId,or group.getPublishSnapshotId():" + group.getPublishSnapshotId() + " has any snapshot in db");
                }
            }
            ServerGroupAdapter adapter = new ServerGroupAdapter(group, snapshot);
            adapter.setMaxSnapshotId(maxSnapshotId);
            adapter.addServer(setter.getServers(daoContext, group));
            groupAdapterList.add(adapter);
        }
        return groupAdapterList;
    }

    public static abstract class ServerGroupCriteriaSetter {
        public abstract void process(ServerGroupCriteria.Criteria var1);

        public List<Server> getServers(RunContext daoContext, ServerGroup group) {
            return Collections.emptyList();
        }

        public int getMaxSnapshotId(ServerGroup group, RunContext daoContext) {
            return 0;
        }
    }
}

