/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.runtime.module.action.jarcontent;

import com.alibaba.citrus.turbine.Context;
import com.qlangtech.tis.manage.biz.dal.pojo.Snapshot;
import com.qlangtech.tis.manage.common.ConfigFileReader;
import com.qlangtech.tis.manage.common.PropteryGetter;
import com.qlangtech.tis.manage.common.RunContext;
import com.qlangtech.tis.manage.common.SnapshotDomain;
import com.qlangtech.tis.manage.common.TisUTF8;
import com.qlangtech.tis.runtime.module.action.BasicModule;
import com.qlangtech.tis.runtime.module.misc.IMessageHandler;
import java.util.Date;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaveFileContentAction
extends BasicModule {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(SaveFileContentAction.class);

    public void doGetConfig(Context context) throws Exception {
        byte[] resContent = SaveFileContentAction.getResContent(this, context);
        SaveFileContentAction.setConfigFileContent(this, context, new String(resContent, TisUTF8.get()), true);
    }

    public static byte[] getResContent(BasicModule module, Context context) {
        SnapshotDomain snapshot = SaveFileContentAction.getSnapshot(module, context);
        PropteryGetter cgetter = ConfigFileReader.createPropertyGetter((String)module.getString("restype"));
        return cgetter.getContent(snapshot);
    }

    private static final SnapshotDomain getSnapshot(BasicModule module, Context context) {
        Snapshot sn = (Snapshot)context.get("snapshot");
        if (sn != null) {
            return module.getSnapshotViewDAO().getView(sn.getSnId(), false);
        }
        Integer snapshotId = module.getInt("snapshot");
        SnapshotDomain snapshot = module.getSnapshotViewDAO().getView(snapshotId, false);
        if (snapshot == null) {
            throw new IllegalArgumentException("snapshotId:" + snapshotId + " can not find pojo in db");
        }
        context.put("snap", (Object)snapshot.getSnapshot());
        return snapshot;
    }

    public static void setConfigFileContent(BasicModule basicModule, Context context, String content, boolean editModel) {
        basicModule.setBizResult(context, editModel ? content : StringEscapeUtils.escapeHtml((String)content));
    }

    public static Integer createNewSnapshot(Snapshot snapshot, String memo, RunContext runContext, Long userid, String userName) {
        Integer newId;
        snapshot.setSnId(null);
        snapshot.setUpdateTime(new Date());
        snapshot.setCreateTime(new Date());
        try {
            snapshot.setCreateUserId(userid);
        }
        catch (Throwable e) {
            snapshot.setCreateUserId(Long.valueOf(0L));
        }
        snapshot.setCreateUserName(userName);
        if (StringUtils.isNotEmpty((String)memo)) {
            snapshot.setMemo(memo);
        }
        if ((newId = runContext.getSnapshotDAO().insertSelective(snapshot)) == null) {
            throw new IllegalArgumentException(" have not create a new snapshot id");
        }
        return newId;
    }

    private PropteryGetter createConfigFileGetter(String fileName) {
        if ("schema.xml".equals(fileName)) {
            return ConfigFileReader.FILE_SCHEMA;
        }
        if ("solrconfig.xml".equals(fileName)) {
            return ConfigFileReader.FILE_SOLR;
        }
        throw new IllegalStateException("fileName:" + fileName + " can not match any process");
    }

    private static void saveHasNotModifyMessage(Context context, IMessageHandler messageHandler, Integer snapshotid) {
        messageHandler.addErrorMessage(context, "\u6587\u4ef6\u6ca1\u6709\u53d8\u66f4\uff0c\u4fdd\u6301\u5f53\u524dsnapshot:" + snapshotid);
    }

    public static class CreateSnapshotResult {
        private Integer newSnapshotId;
        private boolean success = false;
        private Snapshot snapshot;

        public Snapshot getSnapshot() {
            return this.snapshot;
        }

        public void setSnapshot(Snapshot snapshot) {
            this.snapshot = snapshot;
        }

        public Integer getNewId() {
            return this.newSnapshotId;
        }

        public void setNewSnapshotId(Integer newId) {
            this.newSnapshotId = newId;
        }

        public boolean isSuccess() {
            return this.success;
        }

        public void setSuccess(boolean success) {
            this.success = success;
        }
    }
}

