/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.runtime.module.action;

import com.alibaba.citrus.turbine.Context;
import com.google.common.collect.Maps;
import com.koubei.web.tag.pager.Pager;
import com.qlangtech.tis.manage.biz.dal.pojo.Department;
import com.qlangtech.tis.manage.biz.dal.pojo.DepartmentCriteria;
import com.qlangtech.tis.manage.biz.dal.pojo.UsrDptRelation;
import com.qlangtech.tis.manage.biz.dal.pojo.UsrDptRelationCriteria;
import com.qlangtech.tis.manage.common.Config;
import com.qlangtech.tis.manage.common.IUser;
import com.qlangtech.tis.manage.common.ManageUtils;
import com.qlangtech.tis.manage.common.Option;
import com.qlangtech.tis.manage.common.UserUtils;
import com.qlangtech.tis.manage.spring.aop.Func;
import com.qlangtech.tis.plugin.license.TISLicense;
import com.qlangtech.tis.runtime.module.action.BasicModule;
import com.qlangtech.tis.runtime.module.action.SysInitializeAction;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import junit.framework.Assert;
import org.apache.commons.lang.StringUtils;

public class UserAction
extends BasicModule {
    private static final long serialVersionUID = 1L;

    public void doGetUserInfo(Context context) throws Exception {
        IUser user = UserUtils.getUser(this.getRequest(), this.getDaoContext());
        Map<String, Object> sysInfo = UserAction.createSysInfo(user);
        Optional firstRowPK = this.getApplicationDAO().selectFirstRowPK();
        sysInfo.put("firstPipelinePK", firstRowPK.isPresent());
        this.setBizResult(context, sysInfo);
    }

    public static Map<String, Object> createSysInfo() {
        return UserAction.createSysInfo(UserUtils.getMockUser(null, null));
    }

    public static Map<String, Object> createSysInfo(IUser user) {
        try {
            HashMap sysInfo = Maps.newHashMap();
            sysInfo.put("usr", Objects.requireNonNull(user, "user can not be null"));
            sysInfo.put("sysInitialized", SysInitializeAction.isSysInitialized());
            sysInfo.put("tisMeta", Config.getMetaProps().tisMetaProps);
            TISLicense tisLicense = TISLicense.load((boolean)false);
            if (tisLicense != null) {
                sysInfo.put("license", tisLicense.hasExpire());
            }
            return sysInfo;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void doGetInitData(Context context) {
        UsrDptRelationCriteria criteria = new UsrDptRelationCriteria();
        criteria.setOrderByClause("create_time desc");
        Pager pager = this.createPager();
        pager.setTotalCount(this.getUsrDptRelationDAO().countByExample(criteria));
        this.setBizResult(context, new BasicModule.PaginationResult(pager, this.getUsrDptRelationDAO().selectByExample(criteria, pager.getCurPage(), pager.getRowsPerPage()), new Object[0]));
    }

    public void doGetChildDpt(Context context) {
        Integer dptid = this.getInt("pid");
        DepartmentCriteria query = new DepartmentCriteria();
        query.createCriteria().andParentIdEqualTo(dptid);
        ArrayList<Option> result = new ArrayList<Option>();
        for (Department dpt : this.getDepartmentDAO().selectByExample(query)) {
            result.add(new Option(dpt.getName(), (Object)String.valueOf(dpt.getDptId())));
        }
        context.put("biz_result", result);
    }

    public void doUsrAdd(Context context) {
        String userAccount = this.getString("userAccount");
        String realName = this.getString("realName");
        String password = this.getString("password");
        Integer dptid = this.getInt("dptid");
        if (StringUtils.isEmpty((String)userAccount)) {
            this.addErrorMessage(context, "\u8bf7\u586b\u5199\u767b\u9646\u8d26\u6237\u540d");
            return;
        }
        if (StringUtils.isEmpty((String)realName)) {
            this.addErrorMessage(context, "\u8bf7\u586b\u5199\u771f\u5b9e\u540d\u79f0");
            return;
        }
        if (StringUtils.isEmpty((String)password)) {
            this.addErrorMessage(context, "\u8bf7\u586b\u5199\u5bc6\u7801");
            return;
        }
        UsrDptRelationCriteria q = new UsrDptRelationCriteria();
        q.createCriteria().andUserNameEqualTo(userAccount);
        if (this.getUsrDptRelationDAO().countByExample(q) > 0) {
            this.addErrorMessage(context, "\u7528\u6237\u201c" + userAccount + "\u201d\u5df2\u7ecf\u5b58\u5728");
            return;
        }
        UsrDptRelation user = new UsrDptRelation();
        user.setUsrId(StringUtils.remove((String)UUID.randomUUID().toString(), (String)"-"));
        user.setUserName(userAccount);
        user.setRealName(realName);
        user.setPassword(ManageUtils.md5(password));
        user.setDptId(dptid);
        user.setCreateTime(new Date());
        user.setUpdateTime(new Date());
        user.setDptId(-1);
        user.setDptName("none");
        user.setrId(-1);
        this.getUsrDptRelationDAO().insertSelective(user);
        this.addActionMessage(context, "\u7528\u6237\u201c" + userAccount + "\u201d\u6dfb\u52a0\u6210\u529f");
    }

    @Func(value="authority_user_manage")
    public void doChangeDepartment(Context context) {
        String usrid = this.getString("usrid");
        Integer selecteddptid = this.getInt("selecteddptid");
        Assert.assertNotNull((Object)usrid);
        Assert.assertNotNull((Object)selecteddptid);
        UsrDptRelation usr = this.getUsrDptRelationDAO().loadFromWriteDB(usrid);
        Assert.assertNotNull((Object)usr);
        Department department = this.getDepartmentDAO().loadFromWriteDB(selecteddptid);
        Assert.assertNotNull((Object)department);
        UsrDptRelationCriteria criteria = new UsrDptRelationCriteria();
        criteria.createCriteria().andUsrIdEqualTo(usrid);
        UsrDptRelation record = new UsrDptRelation();
        record.setDptName(department.getFullName());
        record.setDptId(department.getDptId());
        record.setUpdateTime(new Date());
        this.getUsrDptRelationDAO().updateByExampleSelective(record, criteria);
        this.addActionMessage(context, "\u5df2\u7ecf\u5c06\u7528\u6237\u201c" + usr.getUserName() + "\u201d\u5f52\u5c5e\u5230\u65b0\u7684\u90e8\u95e8\uff1a" + department.getFullName());
    }
}

