/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.runtime.module.action;

import com.alibaba.citrus.turbine.Context;
import com.opensymphony.xwork2.ModelDriven;
import com.qlangtech.tis.manage.UploadJarForm;
import com.qlangtech.tis.manage.biz.dal.pojo.Snapshot;
import com.qlangtech.tis.manage.biz.dal.pojo.UploadResource;
import com.qlangtech.tis.manage.common.ConfigFileReader;
import com.qlangtech.tis.manage.common.ConfigFileValidateResult;
import com.qlangtech.tis.manage.common.PropteryGetter;
import com.qlangtech.tis.manage.common.RunContext;
import com.qlangtech.tis.manage.servlet.DownloadServlet;
import com.qlangtech.tis.manage.spring.aop.Func;
import com.qlangtech.tis.runtime.module.action.BasicModule;
import com.qlangtech.tis.runtime.module.action.SchemaAction;
import com.qlangtech.tis.solrdao.ISchemaPluginContext;
import com.qlangtech.tis.utils.MD5Utils;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import junit.framework.Assert;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class UploadJarAction
extends BasicModule
implements ModelDriven<UploadJarForm> {
    private static final long serialVersionUID = 1L;
    private static final String GROUP_NAME = "uploadjar";
    private UploadJarForm form = new UploadJarForm();

    public UploadJarAction() {
        super(GROUP_NAME);
    }

    public UploadJarForm getModel() {
        return this.form;
    }

    @Func(value="config_upload")
    public void doUploadJar(Context context) throws Exception {
        if (this.form.getSchema() == null || this.form.getConfig() == null) {
            this.addErrorMessage(context, "\u60a8\u9700\u8981\u4e0a\u4f20schema\u548csolrconfig\u6587\u4ef6");
            return;
        }
        Snapshot snapshot = this.parseSnapshot(context, this.form);
        this.addActionMessage(context, "\u6210\u529f\u6dfb\u52a0snapshotID:" + this.getSnapshotDAO().insertSelective(snapshot) + "\u7684\u5feb\u7167\u8bb0\u5f55");
    }

    protected Snapshot parseSnapshot(Context context, UploadJarForm formm, SnapshotCreater snapshotCreater) throws IOException {
        ConfigContentGetter[] getter = this.getContentGetter(formm);
        ConfigFileValidateResult validateValidateResult = null;
        boolean fileValid = true;
        ISchemaPluginContext schemaPlugin = SchemaAction.createSchemaPlugin(this.getCollectionName());
        for (ConfigContentGetter get : getter) {
            validateValidateResult = get.getterStrategy.validate(schemaPlugin, get.content);
            if (validateValidateResult.isValid()) continue;
            this.addErrorMessage(context, validateValidateResult.getValidateResult());
            fileValid = false;
        }
        if (!fileValid) {
            return null;
        }
        Snapshot snapshot = snapshotCreater.create(getter);
        snapshot.setPreSnId(Integer.valueOf(-1));
        return snapshot;
    }

    protected Snapshot parseSnapshot(Context context, UploadJarForm formm) throws IOException {
        return this.parseSnapshot(context, formm, new SnapshotCreater(){

            @Override
            public Snapshot create(ConfigContentGetter[] getter) {
                try {
                    return UploadJarAction.this.createSnapshot(getter);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    public void doDownloadGlobalResource(Context context) throws Exception {
        Integer rid = this.getInt("rid");
        UploadResource resource = this.getUploadResourceDAO().loadFromWriteDB(new Long(rid.intValue()));
        Assert.assertNotNull((String)"resource can not be null", (Object)resource);
        Assert.assertNotNull((String)"resource.getContent() can not null", (Object)resource.getContent());
        Assert.assertEquals((String)("resource type:" + resource.getResourceType() + " rid:" + rid + " is not illegal"), (String)"global_res", (String)resource.getResourceType());
        Assert.assertEquals((String)resource.getMd5Code(), (String)MD5Utils.md5file((byte[])resource.getContent()));
        UploadJarAction.getResponse().setContentType("application/zip");
        DownloadServlet.setDownloadName(UploadJarAction.getResponse(), rid + "_" + System.currentTimeMillis() / 1000L + ".jar");
        IOUtils.write((byte[])resource.getContent(), (OutputStream)UploadJarAction.getResponse().getOutputStream());
    }

    private Snapshot createSnapshot(ConfigContentGetter[] getters) throws IOException {
        Snapshot snapshot = this.createSnapshot();
        for (ConfigContentGetter get : getters) {
            snapshot = this.processConfigFile(get, snapshot);
        }
        return snapshot;
    }

    protected ConfigContentGetter[] getContentGetter(UploadJarForm form) throws IOException {
        ConfigContentGetter[] getters = new ConfigContentGetter[]{new ConfigContentGetter((PropteryGetter)ConfigFileReader.FILE_SCHEMA, form.getSchema()), new ConfigContentGetter(ConfigFileReader.FILE_SOLR, form.getConfig())};
        return getters;
    }

    private Snapshot processConfigFile(ConfigContentGetter getter, Snapshot snapshot) throws IOException {
        if (getter.getContent() == null) {
            return snapshot;
        }
        return this.processFormItem(getter, snapshot);
    }

    public static Snapshot processFormItem(RunContext runContext, ConfigContentGetter getter, Snapshot snapshot) throws IOException {
        UploadResource solrCoreDependedResource = new UploadResource();
        solrCoreDependedResource.setCreateTime(new Date());
        solrCoreDependedResource.setContent(getter.getContent());
        solrCoreDependedResource.setMd5Code(MD5Utils.md5file((byte[])solrCoreDependedResource.getContent()));
        solrCoreDependedResource.setResourceType(getter.getterStrategy.getFileName());
        Integer newid = runContext.getUploadResourceDAO().insertSelective(solrCoreDependedResource);
        return getter.getterStrategy.createNewSnapshot(newid, snapshot);
    }

    private Snapshot processFormItem(ConfigContentGetter getter, Snapshot snapshot) throws IOException {
        return UploadJarAction.processFormItem(this, getter, snapshot);
    }

    public static void main(String[] arg) throws Exception {
    }

    public static class ConfigContentGetter {
        private final PropteryGetter getterStrategy;
        private byte[] content = null;

        protected ConfigContentGetter(PropteryGetter getterStrategy, File formItem) throws IOException {
            this.getterStrategy = getterStrategy;
            try {
                if (formItem != null) {
                    this.content = FileUtils.readFileToByteArray((File)formItem);
                }
            }
            catch (Exception e) {
                throw new RuntimeException("file name:" + getterStrategy.getFileName() + " path:" + formItem.getAbsolutePath() + " is faild");
            }
            finally {
                FileUtils.deleteQuietly((File)formItem);
            }
        }

        public ConfigContentGetter(PropteryGetter getterStrategy, String content) {
            try {
                Assert.assertNotNull((String)"content can not be null", (Object)content);
                this.getterStrategy = getterStrategy;
                this.content = content.getBytes(BasicModule.getEncode());
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }

        public byte[] getContent() throws IOException {
            return this.content;
        }
    }

    public static interface SnapshotCreater {
        public Snapshot create(ConfigContentGetter[] var1);
    }
}

