/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.runtime.module.action;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.qlangtech.tis.manage.common.Option;
import com.qlangtech.tis.util.Memoizer;
import com.qlangtech.tis.web.start.TisSubModule;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;

public class SysInitializeArrangeJars {
    private static final String tis_builder_api = "tis-builder-api(.*)\\.jar";
    private static final String tis_manage_pojo = "tis-manage-pojo(.*)\\.jar";
    private static final String spring_web = "spring-web-(.*)\\.jar";
    private static final String commons_ = "commons-(.*)\\.jar";
    private static final List<SubProj> subDirs = Lists.newArrayList((Object[])new SubProj[]{new SubProj(TisSubModule.TIS_ASSEMBLE, "commons-(.*)\\.jar", new String[0]), new SubProj(TisSubModule.TIS_CONSOLE, "commons-(.*)\\.jar", new String[0])});
    static final Memoizer<String, List<File>> jars = new Memoizer<String, List<File>>(){

        public List<File> compute(String key) {
            return Lists.newArrayList();
        }
    };

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            throw new IllegalStateException("please set uberDir ");
        }
        File uberDir = new File(args[0]);
        if (!uberDir.exists()) {
            throw new IllegalStateException("uberDir is not exist:" + uberDir.getAbsolutePath());
        }
        File subModuleLibDir = null;
        File webStartDir = new File(uberDir, TisSubModule.WEB_START.moduleName + "/lib");
        HashSet existJarFiles = Sets.newHashSet((Object[])webStartDir.list());
        if (existJarFiles.size() < 1) {
            throw new IllegalStateException("webStartDir:" + webStartDir.getAbsolutePath() + " has any jar file");
        }
        for (SubProj sbDir : subDirs) {
            subModuleLibDir = new File(uberDir, sbDir.getName() + "/lib");
            if (!subModuleLibDir.getParentFile().exists()) continue;
            for (String jarFileName : subModuleLibDir.list()) {
                if (!existJarFiles.contains(jarFileName)) continue;
                FileUtils.deleteQuietly((File)new File(subModuleLibDir, jarFileName));
            }
        }
        for (SubProj sbDir : subDirs) {
            subModuleLibDir = new File(uberDir, sbDir.getName() + "/lib");
            if (!subModuleLibDir.getParentFile().exists()) continue;
            for (String jarFileName : subModuleLibDir.list()) {
                if (!sbDir.isMatch(jarFileName)) continue;
                ((List)jars.get((Object)jarFileName)).add(new File(subModuleLibDir, jarFileName));
            }
        }
        for (Map.Entry subModuleJar : jars.getEntries()) {
            System.out.println("process file:" + (String)subModuleJar.getKey());
            boolean first = true;
            for (File f : (List)subModuleJar.getValue()) {
                if (first) {
                    File dest = new File(webStartDir, (String)subModuleJar.getKey());
                    if (dest.exists()) {
                        FileUtils.deleteQuietly((File)f);
                    } else {
                        FileUtils.moveFile((File)f, (File)dest);
                    }
                    first = false;
                    continue;
                }
                FileUtils.deleteQuietly((File)f);
            }
        }
    }

    private static class SubProj
    extends Option {
        private final List<Pattern> retainJars = Lists.newArrayList();

        public SubProj(TisSubModule name, String value, String ... retainJar) {
            super(name.moduleName, (Object)value);
            this.retainJars.add(Pattern.compile(value));
            for (String jar : retainJar) {
                this.retainJars.add(Pattern.compile(jar));
            }
        }

        public boolean isMatch(String jarFileName) {
            for (Pattern p : this.retainJars) {
                if (!p.matcher(jarFileName).matches()) continue;
                return true;
            }
            return false;
        }
    }
}

