/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.runtime.module.action;

import com.alibaba.citrus.turbine.Context;
import com.alibaba.citrus.turbine.impl.DefaultContext;
import com.google.common.collect.Lists;
import com.qlangtech.tis.extension.model.UpdateCenter;
import com.qlangtech.tis.manage.biz.dal.pojo.Department;
import com.qlangtech.tis.manage.biz.dal.pojo.UsrDptRelationCriteria;
import com.qlangtech.tis.manage.common.Config;
import com.qlangtech.tis.manage.common.TisUTF8;
import com.qlangtech.tis.manage.spring.TISDataSourceFactory;
import com.qlangtech.tis.runtime.module.action.BasicModule;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.LineIterator;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class SysInitializeAction
extends BasicModule {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(SysInitializeAction.class);
    private static final int DEPARTMENT_ROOT_ID = 1;
    public static final String ADMIN_ID = "9999";
    public static final String ADMIN_NAME = "admin";
    private static final Pattern PATTERN_ZK_ADDRESS = Pattern.compile("([^/]+)(/.+)$");
    private static Boolean _isSysInitialized;

    public void doInit(Context context) throws Exception {
        File mysqlInitScript = new File(Config.getDataDir(), "sql/tis_console_mysql.sql");
        this.init(context, true, Config.getDbCfg().dbtype, mysqlInitScript);
    }

    @Override
    public String getReturnCode() {
        return super.getReturnCode();
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            throw new IllegalArgumentException("args.length must big than 0");
        }
        File tisConsoleSqlFile = new File(args[0]);
        if (!tisConsoleSqlFile.exists()) {
            throw new IllegalStateException("tisConsoleSqlFile:" + tisConsoleSqlFile.getAbsolutePath() + " is not exist");
        }
        String dbType = args[1];
        SysInitializeAction initAction = SysInitializeAction.createSysInitializeAction();
        DefaultContext context = new DefaultContext();
        initAction.init((Context)context, false, Config.SysDBType.parse((String)dbType), tisConsoleSqlFile);
    }

    public void init(Context context, boolean dockerContainerInit, Config.SysDBType sysDBType, File tisConsoleSqlFile) throws Exception {
        TISDataSourceFactory.SystemDBInit dataSource;
        if (SysInitializeAction.isSysInitialized()) {
            throw new IllegalStateException("tis has initialized:" + SysInitializeAction.getSysInitializedTokenFile().getAbsolutePath());
        }
        Config.TisDbConfig dbCfg = Config.getDbCfg();
        if (sysDBType != dbCfg.dbtype) {
            throw new IllegalStateException("param sysDBType must match with dbCfg:" + dbCfg);
        }
        logger.info("dbCfg detail:{}", (Object)dbCfg);
        if (dockerContainerInit) {
            this.copyDataTarToLocal();
            if (sysDBType == Config.SysDBType.DERBY) {
                SysInitializeAction.touchSysInitializedToken();
                return;
            }
        }
        if ((dataSource = TISDataSourceFactory.createDataSource(sysDBType, dbCfg, false, true)).dbTisConsoleExist(dbCfg)) {
            UsrDptRelationCriteria c = new UsrDptRelationCriteria();
            c.createCriteria().andUsrIdEqualTo(ADMIN_ID);
            if (this.getUsrDptRelationDAO().countByExample(c) > 0) {
                SysInitializeAction.touchSysInitializedToken();
                this.addActionMessage(context, "system has initialized successful");
                return;
            }
        }
        SysInitializeAction.initializeDB(tisConsoleSqlFile, sysDBType);
        this.getUsrDptRelationDAO().addAdminUser();
        this.initializeDepartment();
        SysInitializeAction.touchSysInitializedToken();
    }

    public static boolean isSysInitialized() {
        if (_isSysInitialized == null) {
            File sysInitializedToken = SysInitializeAction.getSysInitializedTokenFile();
            _isSysInitialized = sysInitializedToken.exists();
        }
        return _isSysInitialized;
    }

    static File getSysInitializedTokenFile() {
        return new File(Config.getDataDir(), "system_initialized_token");
    }

    private static void touchSysInitializedToken() throws Exception {
        File sysInitializedToken = SysInitializeAction.getSysInitializedTokenFile();
        FileUtils.touch((File)sysInitializedToken);
        _isSysInitialized = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initializeDB(File tisConsoleSqlFile, Config.SysDBType dbType) throws Exception {
        if (!tisConsoleSqlFile.exists()) {
            throw new IllegalStateException("db init script can not be none:" + tisConsoleSqlFile.getAbsolutePath());
        }
        Config.TisDbConfig dbCfg = Config.getDbCfg();
        TISDataSourceFactory.SystemDBInit dsProcess = null;
        try {
            block29: {
                dsProcess = TISDataSourceFactory.createDataSource(dbType, dbCfg, false, true);
                TISDataSourceFactory.systemDBInitThreadLocal.set(dsProcess);
                try (Connection conn = dsProcess.getDS().getConnection();
                     Statement statement = conn.createStatement();){
                    logger.info("init '" + dbCfg.dbname + "' db and initialize the tables");
                    boolean containTisConsole = dsProcess.dbTisConsoleExist(dbCfg, statement);
                    ArrayList executeSqls = Lists.newArrayList();
                    if (containTisConsole) break block29;
                    boolean execSuccess = false;
                    try {
                        dsProcess.createSysDB(dbCfg, statement);
                        for (String sql : SysInitializeAction.convert2BatchSql(dsProcess, tisConsoleSqlFile)) {
                            try {
                                if (dsProcess.shallSkip(sql)) continue;
                                executeSqls.add(sql);
                                statement.execute(sql);
                            }
                            catch (SQLException e) {
                                logger.error(sql, (Throwable)e);
                                throw e;
                            }
                        }
                        execSuccess = true;
                    }
                    catch (SQLException e) {
                        throw new RuntimeException(executeSqls.stream().collect(Collectors.joining("\n")), e);
                    }
                    finally {
                        if (!execSuccess) {
                            dsProcess.dropDB(dbCfg, statement);
                        }
                    }
                }
            }
            Objects.requireNonNull(dsProcess, "dataSource can not be null");
        }
        finally {
            try {
                dsProcess.close();
            }
            catch (Throwable throwable) {}
        }
    }

    static SysInitializeAction createSysInitializeAction() {
        SysInitializeAction initAction = new SysInitializeAction();
        ClassPathXmlApplicationContext appContext = new ClassPathXmlApplicationContext(new String[]{"classpath:/tis.application.context.xml", "classpath:/tis.application.mockable.context.xml"});
        appContext.getAutowireCapableBeanFactory().autowireBeanProperties((Object)initAction, 1, false);
        return initAction;
    }

    private static List<String> convert2BatchSql(TISDataSourceFactory.SystemDBInit dataSource, File tisConsoleSqlFile) throws Exception {
        LineIterator lineIt = FileUtils.lineIterator((File)tisConsoleSqlFile, (String)TisUTF8.getName());
        ArrayList batchs = Lists.newArrayList();
        StringBuffer result = new StringBuffer();
        String line = null;
        while (lineIt.hasNext()) {
            line = StringUtils.trimToEmpty((String)lineIt.nextLine());
            if (StringUtils.startsWith((String)line, (String)"/*") || StringUtils.startsWith((String)line, (String)"--") || StringUtils.startsWith((String)line, (String)"#") || StringUtils.startsWith((String)line, (String)"//")) continue;
            result.append(line).append(" ");
            if (!StringUtils.endsWith((String)line, (String)";")) continue;
            batchs.add(StringUtils.trimToEmpty((String)dataSource.processSql(result)));
            result = new StringBuffer();
        }
        File targetFile = new File(tisConsoleSqlFile.getParent(), tisConsoleSqlFile.getName() + ".convert");
        FileUtils.write((File)targetFile, (CharSequence)batchs.stream().collect(Collectors.joining("\n")), (Charset)TisUTF8.get(), (boolean)false);
        return batchs;
    }

    void copyDataTarToLocal() throws IOException {
        File tmpDataDir = FileUtils.getTempDirectory();
        File dataDir = Config.getDataDir();
        UpdateCenter.copyDataTarToLocal((File)tmpDataDir, Optional.of(dataDir));
    }

    void initializeDepartment() {
        this.getDepartmentDAO().deleteByPrimaryKey(2);
        this.getDepartmentDAO().deleteByPrimaryKey(1);
        Department dpt = new Department();
        dpt.setLeaf(false);
        dpt.setGmtCreate(new Date());
        dpt.setGmtModified(new Date());
        dpt.setName("tis");
        dpt.setFullName("/tis");
        dpt.setParentId(-1);
        Integer dptId = this.getDepartmentDAO().insertSelective(dpt);
        dpt = new Department();
        dpt.setLeaf(true);
        dpt.setGmtCreate(new Date());
        dpt.setGmtModified(new Date());
        dpt.setName("default");
        dpt.setFullName("/tis/default");
        dpt.setParentId(dptId);
        dptId = this.getDepartmentDAO().insertSelective(dpt);
        if (dptId != 2) {
            throw new IllegalStateException("dptId:" + dptId + " must equal with:2");
        }
    }
}

