/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.runtime.module.action;

import com.alibaba.citrus.turbine.Context;
import com.qlangtech.tis.manage.biz.dal.pojo.FuncCriteria;
import com.qlangtech.tis.manage.biz.dal.pojo.FuncRoleRelation;
import com.qlangtech.tis.manage.biz.dal.pojo.FuncRoleRelationCriteria;
import com.qlangtech.tis.manage.biz.dal.pojo.Role;
import com.qlangtech.tis.manage.biz.dal.pojo.RoleCriteria;
import com.qlangtech.tis.manage.biz.dal.pojo.UsrDptRelation;
import com.qlangtech.tis.manage.biz.dal.pojo.UsrDptRelationCriteria;
import com.qlangtech.tis.manage.spring.aop.Func;
import com.qlangtech.tis.runtime.module.action.BasicModule;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import junit.framework.Assert;
import org.apache.commons.lang.StringUtils;

public class RoleAction
extends BasicModule {
    private static final long serialVersionUID = 1L;
    public static final String selfuncidKEY = "selfuncid";

    @Func(value="authority_func_add")
    public void doAddFunc(Context context) {
        String funckey = StringUtils.trim((String)this.getString("funcKey"));
        String funcName = StringUtils.trim((String)this.getString("funcName"));
        if (StringUtils.isBlank((String)funckey)) {
            this.addErrorMessage(context, "\u8bf7\u8bbe\u7f6eFunckey");
            return;
        }
        if (StringUtils.isBlank((String)funcName)) {
            this.addErrorMessage(context, "\u8bf7\u8bbe\u7f6eFuncName");
            return;
        }
        FuncCriteria fcriteria = new FuncCriteria();
        fcriteria.createCriteria().andFunKeyEqualTo(funckey);
        fcriteria.or(fcriteria.createCriteria().andFuncNameEqualTo(funcName));
        if (this.getFuncDAO().countByExample(fcriteria) > 0) {
            this.addErrorMessage(context, "\u4e0d\u540c\u91cd\u590d\u6dfb\u52a0\u76f8\u540c\u7684Funckey\u6216\u8005FuncName");
            return;
        }
        Integer groupType = this.getInt("groupType");
        Object selType = null;
        if (selType == null) {
            this.addErrorMessage(context, "\u8bf7\u9009\u62e9\u529f\u80fd\u7c7b\u578b");
            return;
        }
        com.qlangtech.tis.manage.biz.dal.pojo.Func func = new com.qlangtech.tis.manage.biz.dal.pojo.Func();
        func.setFuncGroupKey(groupType);
        func.setFunKey(funckey);
        func.setFuncName(funcName);
        func.setGmtCreate(new Date());
        func.setGmtModified(new Date());
        func.setFuncGroupName(selType.getName());
        this.getFuncDAO().insertSelective(func);
        this.addActionMessage(context, "\u5df2\u7ecf\u6210\u529f\u6dfb\u52a0Func" + funcName + "(" + funckey + ")");
    }

    @Func(value="authority_user_role_set")
    public void doSelectRole(Context context) {
        String usrid = this.getString("usrid");
        Integer roleid = this.getInt("roleid");
        Role role = this.getRoleDAO().loadFromWriteDB(roleid);
        Assert.assertNotNull((Object)role);
        UsrDptRelationCriteria ucriteria = new UsrDptRelationCriteria();
        ucriteria.createCriteria().andUsrIdEqualTo(usrid);
        UsrDptRelation record = new UsrDptRelation();
        record.setRoleName(role.getRoleName());
        record.setrId(role.getrId());
        this.getUsrDptRelationDAO().updateByExampleSelective(record, ucriteria);
        this.addActionMessage(context, "\u7528\u6237\u9009\u62e9\u4e86\u65b0\u7684\u89d2\u8272\uff1a\u201c" + role.getRoleName() + "\u201d");
    }

    @Func(value="authority_role_update")
    public void doUpdateRole(Context context) {
        List<Integer> funcids = Arrays.asList(this.getIntAry("funcid"));
        Role role = this.getRoleDAO().loadFromWriteDB(this.getInt("roleid"));
        String roleName = this.getString("rolename");
        role.setRoleName(roleName);
        context.put("role", (Object)role);
        context.put(selfuncidKEY, Collections.unmodifiableCollection(funcids));
        if (StringUtils.isBlank((String)roleName)) {
            this.addErrorMessage(context, "\u8bf7\u6dfb\u5199\u89d2\u8272\u540d\u79f0");
            return;
        }
        RoleCriteria criteria = new RoleCriteria();
        criteria.createCriteria().andRoleNameEqualTo(roleName).andRIdNotEqualTo(role.getrId());
        if (this.getRoleDAO().countByExample(criteria) > 0) {
            this.addErrorMessage(context, "\u89d2\u8272\u540d\u79f0\uff1a\u201c" + roleName + "\u201d\u5df2\u7ecf\u521b\u5efa");
            return;
        }
        if (funcids.size() < 1) {
            this.addErrorMessage(context, "\u8bf7\u4e3a\u65b0\u6dfb\u52a0\u7684\u89d2\u8272\u8bbe\u7f6e\u76f8\u5e94\u7684\u529f\u80fd");
            return;
        }
        FuncRoleRelationCriteria fcriteria = new FuncRoleRelationCriteria();
        fcriteria.createCriteria().andRIdEqualTo(role.getrId());
        List<FuncRoleRelation> rellist = this.getFuncRoleRelationDAO().selectByExample(fcriteria);
        ArrayList<Integer> orignfunclist = new ArrayList<Integer>();
        for (FuncRoleRelation funcRoleRelation : rellist) {
            orignfunclist.add(funcRoleRelation.getFuncId());
        }
        ArrayList<Integer> addfuncs = new ArrayList<Integer>();
        for (Integer funcid : funcids) {
            if (orignfunclist.contains(funcid)) {
                orignfunclist.remove(funcid);
                continue;
            }
            addfuncs.add(funcid);
        }
        for (Integer funcid : orignfunclist) {
            fcriteria = new FuncRoleRelationCriteria();
            fcriteria.createCriteria().andRIdEqualTo(role.getrId()).andFuncIdEqualTo(funcid);
            this.getFuncRoleRelationDAO().deleteByExample(fcriteria);
        }
        Role role2 = new Role();
        role2.setRoleName(roleName);
        RoleCriteria rcriteria = new RoleCriteria();
        rcriteria.createCriteria().andRIdEqualTo(role.getrId());
        this.getRoleDAO().updateByExampleSelective(role2, rcriteria);
        this.createRelation(addfuncs, role);
        this.addActionMessage(context, "\u6210\u529f\u66f4\u65b0\u89d2\u8272\uff1a\u201c" + role.getRoleName() + "\u201d");
    }

    public List<Integer> getSelfuncid() {
        return Arrays.asList(this.getIntAry("funcid"));
    }

    @Func(value="authority_role_add")
    public void doAddRole(Context context) {
        String roleName = this.getString("rolename");
        Integer[] funcids = (Integer[])this.getSelfuncid().toArray();
        if (StringUtils.isBlank((String)roleName)) {
            this.addErrorMessage(context, "\u8bf7\u6dfb\u5199\u89d2\u8272\u540d\u79f0");
            return;
        }
        RoleCriteria criteria = new RoleCriteria();
        criteria.createCriteria().andRoleNameEqualTo(roleName);
        if (this.getRoleDAO().countByExample(criteria) > 0) {
            this.addErrorMessage(context, "\u89d2\u8272\u540d\u79f0\uff1a\u201c" + roleName + "\u201d\u5df2\u7ecf\u521b\u5efa");
            return;
        }
        if (funcids.length < 1) {
            this.addErrorMessage(context, "\u8bf7\u4e3a\u65b0\u6dfb\u52a0\u7684\u89d2\u8272\u8bbe\u7f6e\u76f8\u5e94\u7684\u529f\u80fd");
            return;
        }
        Role role = new Role();
        role.setGmtCreate(new Date());
        role.setGmtModified(new Date());
        role.setRoleName(roleName);
        Integer newRoleId = this.getRoleDAO().insertSelective(role);
        role.setrId(newRoleId);
        this.createRelation(Arrays.asList(funcids), role);
        this.addActionMessage(context, "\u6210\u529f\u6dfb\u52a0\u89d2\u8272\uff1a\u201c" + roleName + "\u201d");
    }

    private void createRelation(List<Integer> funcids, Role role) {
        FuncRoleRelation relation = null;
        com.qlangtech.tis.manage.biz.dal.pojo.Func func = null;
        for (Integer id : funcids) {
            func = this.getFuncDAO().loadFromWriteDB(id);
            if (func == null) continue;
            relation = new FuncRoleRelation();
            relation.setFuncId(func.getFunId());
            relation.setFuncKey(func.getFunKey());
            relation.setFuncName(func.getFuncName());
            relation.setGmtCreate(new Date());
            relation.setGmtModified(new Date());
            relation.setrId(role.getrId());
            relation.setRoleName(role.getRoleName());
            this.getFuncRoleRelationDAO().insertSelective(relation);
        }
    }
}

