/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.runtime.module.action;

import com.alibaba.citrus.turbine.Context;
import com.qlangtech.tis.manage.biz.dal.dao.IDepartmentDAO;
import com.qlangtech.tis.manage.biz.dal.pojo.Department;
import com.qlangtech.tis.manage.biz.dal.pojo.UsrDptRelation;
import com.qlangtech.tis.manage.biz.dal.pojo.UsrDptRelationCriteria;
import com.qlangtech.tis.manage.common.IUser;
import com.qlangtech.tis.manage.common.RunContext;
import com.qlangtech.tis.manage.common.UserUtils;
import com.qlangtech.tis.runtime.module.action.BasicModule;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.json.JsonHierarchicalStreamDriver;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import junit.framework.Assert;

public abstract class OrgAuthorityAction
extends BasicModule {
    private static final long serialVersionUID = 1L;
    private static final XStream xstream = new XStream((HierarchicalStreamDriver)new JsonHierarchicalStreamDriver());

    @Override
    public boolean isEnableDomainView() {
        return false;
    }

    public void doSetDepartment(Context context) throws Exception {
        OrgAuthorityAction.getResponse().setContentType("application/json");
        Integer departmentId = this.getInt("orgadd");
        if (departmentId == null) {
            throw new IllegalArgumentException("departmentId can not be null");
        }
        UsrDptRelationCriteria query = new UsrDptRelationCriteria();
        query.createCriteria().andUsrIdEqualTo(this.getUserId());
        if (this.getUsrDptRelationDAO().countByExample(query) > 0) {
            OrgAuthorityAction.getResponse().getWriter().print("{result:'\u60a8\u5df2\u7ecf\u8bbe\u7f6e\u8fc7\u90e8\u95e8\u4fe1\u606f\u4e86,\u5982\u679c\u8981\u66f4\u6539\u90e8\u95e8\u8bbe\u7f6e\u8bf7\u901a\u77e5\u7ba1\u7406\u5458'}");
            return;
        }
        OrgAuthorityAction.bindUser2Dpt(this, departmentId, UserUtils.getUser(this.getRequest(), this));
        OrgAuthorityAction.getResponse().getWriter().print("{result:'\u60a8\u5df2\u6210\u529f\u8bbe\u7f6e\u90e8\u95e8\u4fe1\u606f'}");
    }

    public static void bindUser2Dpt(RunContext runContext, Integer departmentId, IUser user) {
        Assert.assertNotNull((Object)user);
        UsrDptRelation relation = new UsrDptRelation();
        relation.setCreateTime(new Date());
        relation.setDptId(departmentId);
        relation.setDptName(OrgAuthorityAction.getDepartmentName(runContext.getDepartmentDAO(), departmentId));
        relation.setUsrId(user.getId());
        relation.setUserName(user.getName());
        UsrDptRelationCriteria query = new UsrDptRelationCriteria();
        query.createCriteria().andUsrIdEqualTo(user.getId());
        Assert.assertNotNull((Object)user.getId());
        runContext.getUsrDptRelationDAO().deleteByExample(query);
        runContext.getUsrDptRelationDAO().insertSelective(relation);
    }

    public static String getDepartmentName(IDepartmentDAO departmentDAO, Integer dptId) {
        ArrayList<Department> dptlist = new ArrayList<Department>();
        OrgAuthorityAction.processDepartment(departmentDAO, dptlist, dptId);
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < dptlist.size(); ++i) {
            result.append(((Department)dptlist.get(i)).getName());
            if (i == dptlist.size() - 1) continue;
            result.append("-");
        }
        return result.toString();
    }

    public static void processDepartment(IDepartmentDAO departmentDAO, List<Department> dptlist, Integer dptId) {
        Department department = departmentDAO.loadFromWriteDB(dptId);
        if (department == null) {
            return;
        }
        if (department.getParentId() == null) {
            dptlist.add(department);
            return;
        }
        OrgAuthorityAction.processDepartment(departmentDAO, dptlist, department.getParentId());
        dptlist.add(department);
    }

    public static void main(String[] arg) {
        JsonResult result = new JsonResult();
        System.out.println(xstream.toXML((Object)result));
    }

    static {
        xstream.alias("result", JsonResult.class);
    }

    public static class Entry {
        private final Integer id;
        private final String name;

        Entry(Integer id, String name) {
            this.id = id;
            this.name = name;
        }

        public Integer getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public boolean equals(Object obj) {
            return this.hashCode() == obj.hashCode();
        }

        public int hashCode() {
            return this.id;
        }
    }

    public static class JsonResult {
        private final List<String> error = new ArrayList<String>();
        private final List<String> msg = new ArrayList<String>();
        private final List<String> deleteids = new ArrayList<String>();

        public void addDeleteId(String deleteid) {
            this.deleteids.add(deleteid);
        }

        public void addError(String error) {
            this.error.add(error);
        }

        public void addMsg(String msg) {
            this.msg.add(msg);
        }

        public List<String> getErrors() {
            return this.error;
        }

        public List<String> getMsg() {
            return this.msg;
        }
    }
}

