/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.runtime.module.action;

import com.alibaba.citrus.turbine.Context;
import com.koubei.web.tag.pager.Pager;
import com.qlangtech.tis.ibatis.BasicCriteria;
import com.qlangtech.tis.lang.ILogErrorDetail;
import com.qlangtech.tis.lang.TisException;
import com.qlangtech.tis.manage.biz.dal.dao.IOperationLogDAO;
import com.qlangtech.tis.manage.biz.dal.pojo.OperationLogCriteria;
import com.qlangtech.tis.manage.spring.aop.Func;
import com.qlangtech.tis.pubhook.common.RunEnvironment;
import com.qlangtech.tis.runtime.module.action.BasicModule;
import java.util.List;
import junit.framework.Assert;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class OperationLogAction
extends BasicModule {
    private static final long serialVersionUID = 1L;
    private IOperationLogDAO operationLogDAO;

    public void doGetErrorDetail(Context context) {
        String logFileName = this.getString("logfilename");
        this.setBizResult(context, TisException.getLogError((String)logFileName).getDetail());
    }

    public void doGetErrorLogList(Context context) {
        Pager pager = this.createPager();
        pager.setRowsPerPage(10);
        List errorLogs = TisException.getErrorLogs();
        pager.setTotalCount(errorLogs.size());
        BasicCriteria criteria = new BasicCriteria();
        criteria.setPageSize(Integer.valueOf(pager.getRowsPerPage()));
        criteria.setPage(Integer.valueOf(pager.getCurPage()));
        int fromIndex = criteria.getSkip();
        int toIndex = fromIndex + pager.getRowsPerPage();
        int listSize = errorLogs.size();
        if (toIndex >= listSize) {
            toIndex = listSize;
        }
        List pageView = errorLogs.subList(fromIndex, toIndex);
        pageView.forEach(err -> {
            ILogErrorDetail logError = TisException.getLogError((String)err.getLogFileName());
            err.setAbstractInfo(logError.getAbstractInfo());
        });
        this.setBizResult(context, new BasicModule.PaginationResult(pager, pageView, new Object[0]));
    }

    public void doGetInitData(Context context) {
        OperationLogCriteria query = this.createOperationLogCriteria();
        Pager pager = this.createPager();
        query.setOrderByClause("op_id desc");
        pager.setTotalCount(this.operationLogDAO.countByExample(query));
        this.setBizResult(context, new BasicModule.PaginationResult(pager, this.operationLogDAO.selectByExampleWithoutBLOBs(query, pager.getCurPage(), pager.getRowsPerPage()), new Object[0]));
    }

    protected OperationLogCriteria createOperationLogCriteria() {
        String appName = this.getAppDomain().getAppName();
        OperationLogCriteria lcriteria = new OperationLogCriteria();
        if (StringUtils.isBlank((CharSequence)appName)) {
            return lcriteria;
        }
        RunEnvironment runtime = RunEnvironment.getSysRuntime();
        Assert.assertNotNull((Object)appName);
        OperationLogCriteria.Criteria criteria = lcriteria.createCriteria().andAppNameEqualTo(appName);
        return lcriteria;
    }

    protected int getPageSize() {
        return 10;
    }

    @Func(value="app_build_result_view")
    public void doGetDetail(Context context) throws Exception {
        this.disableNavigationBar(context);
        Integer opid = this.getInt("opid");
        Assert.assertNotNull((Object)opid);
        this.setBizResult(context, this.operationLogDAO.loadFromWriteDB(opid));
    }

    @Autowired
    public void setOperationLogDAO(IOperationLogDAO operationLogDAO) {
        this.operationLogDAO = operationLogDAO;
    }
}

