/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.runtime.module.action;

import com.alibaba.citrus.turbine.Context;
import com.qlangtech.tis.manage.biz.dal.dao.IServerGroupDAO;
import com.qlangtech.tis.manage.biz.dal.pojo.ServerGroup;
import com.qlangtech.tis.manage.biz.dal.pojo.ServerGroupCriteria;
import com.qlangtech.tis.manage.spring.aop.Func;
import com.qlangtech.tis.pubhook.common.RunEnvironment;
import com.qlangtech.tis.runtime.module.action.BasicModule;
import java.io.IOException;
import java.io.Writer;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import junit.framework.Assert;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class GroupAction
extends BasicModule {
    private static final long serialVersionUID = 1L;

    public void doChangeEnvironment(Context context) throws Exception {
        Integer appid = this.getInt("appid");
        Integer runtime = this.getInt("runtime");
        ServerGroupCriteria query = new ServerGroupCriteria();
        query.createCriteria().andRuntEnvironmentEqualTo(Short.valueOf(runtime.shortValue())).andAppIdEqualTo(appid).andNotDelete();
        query.setOrderByClause("group_index desc");
        List<ServerGroup> queryResult = this.getServerGroupDAO().selectByExample(query);
        int groupIndex = 0;
        Iterator<ServerGroup> iterator = queryResult.iterator();
        if (iterator.hasNext()) {
            ServerGroup group = iterator.next();
            groupIndex = group.getGroupIndex() + 1;
        }
        GroupAction.getResponse().getWriter().write(String.valueOf(groupIndex));
    }

    @Override
    public boolean isEnableDomainView() {
        return false;
    }

    public static <T> void writeSuggest2Response(String query, List<T> serverList, SuggestCallback<T> callback, HttpServletResponse response) throws JSONException, IOException {
        JSONArray suggestions = new JSONArray();
        JSONArray d = new JSONArray();
        for (int i = 0; i < serverList.size(); ++i) {
            T pool = serverList.get(i);
            suggestions.put(i, (Object)callback.getLiteral(pool));
            d.put(i, callback.getValue(pool));
        }
        JSONObject json = new JSONObject();
        json.put("query", (Object)query);
        json.put("suggestions", (Object)suggestions);
        json.put("data", (Object)d);
        response.setContentType("json;charset=UTF-8");
        json.write((Writer)response.getWriter());
    }

    @Func(value="app_server_group_set")
    public void doAddGroup(Context context) throws Exception {
        RunEnvironment runtime = RunEnvironment.getEnum((short)this.getShort("runtime"));
        Integer groupIndex = this.getInt("groupIndex");
        Integer appid = this.getInt("appid");
        if (groupIndex == null) {
            this.addErrorMessage(context, "\u8bf7\u586b\u5199\u7ec4\u7f16\u53f7");
            return;
        }
        if (runtime == null) {
            this.addErrorMessage(context, "\u8bf7\u9009\u62e9\u8fd0\u884c\u73af\u5883");
            return;
        }
        Integer publishSnapshotId = -1;
        GroupAction.createGroup(runtime, groupIndex, appid, publishSnapshotId, this.getServerGroupDAO());
        this.addActionMessage(context, "\u3010" + runtime.getDescribe() + "\u3011\u4e2d\u65b0\u521b\u5efa\u4e00\u6761\u670d\u52a1\u5668\u7ec4\u6210\u529f");
    }

    public static Integer createGroup(RunEnvironment runtime, Integer groupIndex, Integer appid, Integer publishSnapshotId, IServerGroupDAO serverGroupDAO) {
        Assert.assertNotNull((Object)appid);
        ServerGroupCriteria query = new ServerGroupCriteria();
        query.createCriteria().andRuntEnvironmentEqualTo(runtime.getId()).andGroupIndexEqualTo(Short.valueOf(groupIndex.shortValue())).andAppIdEqualTo(appid).andNotDelete();
        int serverGroupCount = serverGroupDAO.countByExample(query);
        if (serverGroupCount > 0) {
            throw new IllegalStateException("appid:" + appid + ",groupIndex:" + groupIndex + " relevant group can not duplicate,current serverGroupCount:" + serverGroupCount);
        }
        ServerGroup group = new ServerGroup();
        group.setRuntEnvironment(runtime.getId());
        group.setGroupIndex(Short.valueOf(groupIndex.shortValue()));
        group.setCreateTime(new Date());
        group.setAppId(appid);
        if (publishSnapshotId > 0) {
            group.setPublishSnapshotId(publishSnapshotId);
        }
        return serverGroupDAO.insertSelective(group);
    }

    @Func(value="app_server_set")
    public void doDeleteServer(Context context) throws Exception {
        Integer serverId = this.getInt("serverid");
        Assert.assertNotNull((String)"serverId can not be null", (Object)serverId);
        GroupAction.getResponse().getWriter().write("delete success");
    }

    @Func(value="app_server_group_set")
    public void doDeleteGroup(Context context) throws Exception {
        Integer groupid = this.getInt("groupid");
        Assert.assertNotNull((String)"groupid can not be null", (Object)groupid);
        ServerGroupCriteria query = new ServerGroupCriteria();
        query.createCriteria().andGidEqualTo(groupid);
        this.getServerGroupDAO().deleteByExample(query);
        this.addActionMessage(context, "\u6210\u529f\u5220\u9664\u7ec4ID\uff1a" + groupid);
    }

    public static interface SuggestCallback<T> {
        public Object getValue(T var1);

        public String getLiteral(T var1);
    }
}

