/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.runtime.module.action;

import com.alibaba.citrus.turbine.Context;
import com.qlangtech.tis.coredefine.module.action.DataxAction;
import com.qlangtech.tis.manage.biz.dal.pojo.ApplicationCriteria;
import com.qlangtech.tis.manage.biz.dal.pojo.Department;
import com.qlangtech.tis.manage.biz.dal.pojo.DepartmentCriteria;
import com.qlangtech.tis.manage.biz.dal.pojo.UsrDptRelationCriteria;
import com.qlangtech.tis.manage.common.apps.AppsFetcher;
import com.qlangtech.tis.manage.common.apps.IAppsFetcher;
import com.qlangtech.tis.plugin.annotation.Validator;
import com.qlangtech.tis.runtime.module.action.BasicModule;
import com.qlangtech.tis.runtime.module.action.OrgAuthorityAction;
import com.qlangtech.tis.runtime.module.misc.IControlMsgHandler;
import com.qlangtech.tis.runtime.module.misc.impl.DelegateControl4JsonPostMsgHandler;
import java.util.Date;
import java.util.Map;
import junit.framework.Assert;

public class DepartmentAction
extends BasicModule {
    private static final long serialVersionUID = 1L;

    public void doUpdateDepartment(Context context) {
        final Department department = new Department();
        this.processDepartment(context, department, dpt -> {
            if (dpt.getDptId() == null) {
                throw new IllegalStateException("dpt.getDptId() can not be null");
            }
            Integer dptId = dpt.getDptId();
            try {
                DepartmentCriteria criteria = new DepartmentCriteria();
                criteria.createCriteria().andDptIdEqualTo(dptId).andIsLeaf(true);
                dpt.setDptId(null);
                if (this.getDepartmentDAO().updateByExampleSelective(dpt, criteria) > 0) {
                    DataxAction.cleanDepsCache();
                    this.addActionMessage(context, "\u66f4\u65b0\u90e8\u95e8\uff1a'" + dpt.getName() + "'");
                } else {
                    this.addErrorMessage(context, "\u66f4\u65b0\u90e8\u95e8 '" + dpt.getName() + "' \u5931\u8d25");
                }
            }
            finally {
                dpt.setDptId(dptId);
            }
        }, "dptId", new Validator.FieldValidators(new Validator[]{Validator.require, Validator.integer}){

            public void setFieldVal(String val) {
                department.setDptId(Integer.parseInt(val));
            }
        });
    }

    public void doAddDepartment(Context context) {
        Department department = new Department();
        this.processDepartment(context, department, dpt -> {
            dpt.setDptId(this.getDepartmentDAO().insertSelective(dpt));
            DataxAction.cleanDepsCache();
            this.addActionMessage(context, "\u6210\u529f\u6dfb\u52a0\u90e8\u95e8\uff1a" + dpt.getName());
        }, new Object[0]);
    }

    private boolean processDepartment(Context context, final Department dpt, IDepartmentProcess dptProcess, Object ... validateRuleParams) {
        Map validateRule = Validator.fieldsValidator((Object[])new Object[]{"name", new Validator.FieldValidators(new Validator[]{Validator.require}){

            public void setFieldVal(String val) {
                dpt.setName(val);
            }
        }, "parentId", new Validator.FieldValidators(new Validator[]{Validator.require, Validator.integer}){

            public void setFieldVal(String val) {
                dpt.setParentId(Integer.parseInt(val));
            }
        }, validateRuleParams});
        DelegateControl4JsonPostMsgHandler handler = new DelegateControl4JsonPostMsgHandler((IControlMsgHandler)this, this.parseJsonPost());
        if (!Validator.validate((IControlMsgHandler)handler, (Context)context, (Map)validateRule)) {
            return false;
        }
        Department parentDpt = this.getDepartmentDAO().selectByPrimaryKey(dpt.getParentId());
        dpt.setFullName("/" + parentDpt.getName() + "/" + dpt.getName());
        dpt.setGmtCreate(new Date());
        dpt.setGmtModified(new Date());
        dpt.setLeaf(true);
        dptProcess.process(dpt);
        this.setBizResult(context, dpt);
        return true;
    }

    public void doDeleteDepartment(Context context) {
        final Integer dptid = this.getInt("dptid");
        Assert.assertNotNull((Object)dptid);
        UsrDptRelationCriteria rcriteria = null;
        DepartmentCriteria query = null;
        query = new DepartmentCriteria();
        query.createCriteria().andParentIdEqualTo(dptid);
        if (this.getDepartmentDAO().countByExample(query) > 0) {
            this.addErrorMessage(context, "\u8be5\u90e8\u95e8\u6709\u5b50\u90e8\u95e8\uff0c\u4e0d\u80fd\u5220\u9664");
            return;
        }
        rcriteria = new UsrDptRelationCriteria();
        rcriteria.createCriteria().andDptIdEqualTo(dptid);
        if (this.getUsrDptRelationDAO().countByExample(rcriteria) > 0) {
            this.addErrorMessage(context, "\u6709\u6210\u5458\u5173\u8054\u5728\u8be5\u90e8\u95e8\uff0c\u4e0d\u80fd\u5220\u9664");
            return;
        }
        IAppsFetcher fetcher = this.getAppsFetcher();
        int appsCount = fetcher.count(new AppsFetcher.CriteriaSetter(){

            @Override
            public void set(ApplicationCriteria.Criteria criteria) {
                criteria.andDptIdEqualTo(dptid);
            }
        });
        if (appsCount > 0) {
            this.addErrorMessage(context, "\u8be5\u90e8\u95e8\u4e0b\u6709" + appsCount + "\u4e2a\u5e94\u7528\uff0c\u4e0d\u80fd\u5220\u9664");
            return;
        }
        this.getDepartmentDAO().deleteByPrimaryKey(dptid);
        DataxAction.cleanDepsCache();
        this.addActionMessage(context, "\u5df2\u7ecf\u6210\u529f\u5220\u9664\u90e8\u95e8:" + OrgAuthorityAction.getDepartmentName(this.getDepartmentDAO(), dptid));
    }

    public void doBindUser(Context context) {
    }

    static interface IDepartmentProcess {
        public void process(Department var1);
    }
}

