/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.runtime.module.action;

import com.alibaba.citrus.turbine.Context;
import com.qlangtech.tis.common.utils.Assert;
import com.qlangtech.tis.manage.biz.dal.dao.IClusterSnapshotDAO;
import com.qlangtech.tis.manage.biz.dal.pojo.ClusterSnapshot;
import com.qlangtech.tis.manage.biz.dal.pojo.ClusterSnapshotQuery;
import com.qlangtech.tis.manage.spring.aop.Func;
import com.qlangtech.tis.runtime.module.action.BasicModule;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public class ClusterStateCollectAction
extends BasicModule {
    private static final long serialVersionUID = 1L;
    private IClusterSnapshotDAO clusterSnapshotDAO;
    private static final Map<Integer, IClusterSnapshotQueryGetter> queryTimeSpan = new HashMap<Integer, IClusterSnapshotQueryGetter>();
    public static final ThreadLocal<SimpleDateFormat> dailyFormat = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("HH:mm");
        }
    };
    public static final ThreadLocal<SimpleDateFormat> dateFormat = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("MM/dd");
        }
    };
    private static final int ONE_HOUR = 60;
    public static final int TODAY = 1440;

    @Func(value="cluster_state_collect", sideEffect=false)
    public void doCollect(Context context) throws Exception {
        Integer minute = this.getInt("m");
        Assert.assertNotNull((Object)minute);
        StatusCollectStrategy collectStrategy = ClusterStateCollectAction.getCollectStrategy(this.clusterSnapshotDAO, this.getAppDomain().getAppid(), minute);
        this.setBizResult(context, collectStrategy.getSnapshots());
    }

    public static StatusCollectStrategy getCollectStrategy(final IClusterSnapshotDAO clusterSnapshotDAO, final Integer appId, final int minute) {
        return new StatusCollectStrategy(){
            private List<ClusterSnapshot> snapshots;

            @Override
            public List<ClusterSnapshot> getSnapshots() {
                if (this.snapshots == null) {
                    IClusterSnapshotQueryGetter getter = queryTimeSpan.get(minute);
                    Assert.assertNotNull((String)("time getter:" + minute + " can not be null"), (Object)getter);
                    ClusterSnapshotQuery timeSpanQuery = getter.create();
                    Assert.assertNotNull((String)("time span:" + minute + " can not be null"), (Object)timeSpanQuery);
                    timeSpanQuery.setAppId(appId);
                    List<ClusterSnapshot> snapshots = clusterSnapshotDAO.reportClusterStatus(timeSpanQuery);
                    snapshots.forEach(r -> {
                        r.dateformat = getter.getDateFormat();
                    });
                    this.snapshots = snapshots;
                }
                return this.snapshots;
            }

            @Override
            public ClusterSnapshot.Summary getMetricSummary() {
                ClusterSnapshot.Summary summary = new ClusterSnapshot.Summary();
                this.getSnapshots().forEach(snapshot -> summary.add((ClusterSnapshot)snapshot));
                return summary;
            }
        };
    }

    @Override
    public IClusterSnapshotDAO getClusterSnapshotDAO() {
        return this.clusterSnapshotDAO;
    }

    @Override
    @Autowired
    public void setClusterSnapshotDAO(IClusterSnapshotDAO clusterSnapshotDAO) {
        this.clusterSnapshotDAO = clusterSnapshotDAO;
    }

    static {
        queryTimeSpan.put(60, new IClusterSnapshotQueryGetter(){

            @Override
            public ClusterSnapshotQuery create() {
                return ClusterSnapshotQuery.hour();
            }

            @Override
            public ThreadLocal<SimpleDateFormat> getDateFormat() {
                return dailyFormat;
            }
        });
        queryTimeSpan.put(300, new IClusterSnapshotQueryGetter(){

            @Override
            public ClusterSnapshotQuery create() {
                return ClusterSnapshotQuery.fiveHour();
            }

            @Override
            public ThreadLocal<SimpleDateFormat> getDateFormat() {
                return dailyFormat;
            }
        });
        queryTimeSpan.put(1440, new IClusterSnapshotQueryGetter(){

            @Override
            public ClusterSnapshotQuery create() {
                return ClusterSnapshotQuery.hour24();
            }

            @Override
            public ThreadLocal<SimpleDateFormat> getDateFormat() {
                return dailyFormat;
            }
        });
        queryTimeSpan.put(7200, new IClusterSnapshotQueryGetter(){

            @Override
            public ClusterSnapshotQuery create() {
                return ClusterSnapshotQuery.days15();
            }

            @Override
            public ThreadLocal<SimpleDateFormat> getDateFormat() {
                return dateFormat;
            }
        });
        queryTimeSpan.put(43200, new IClusterSnapshotQueryGetter(){

            @Override
            public ClusterSnapshotQuery create() {
                return ClusterSnapshotQuery.last1Month();
            }

            @Override
            public ThreadLocal<SimpleDateFormat> getDateFormat() {
                return dateFormat;
            }
        });
    }

    static interface IClusterSnapshotQueryGetter {
        public ClusterSnapshotQuery create();

        public ThreadLocal<SimpleDateFormat> getDateFormat();
    }

    public static class PonitStatus {
        private String createTime;
        private String serviceName;
        private int qps;
        private long requestCount;
        private long docNumber;
        private float avgConsumeTimePerRequest;

        public float getAvgConsumeTimePerRequest() {
            return this.avgConsumeTimePerRequest;
        }

        public String getCreateTime() {
            return this.createTime;
        }

        public String getServiceName() {
            return this.serviceName;
        }

        public int getQps() {
            return this.qps;
        }

        public long getRequestCount() {
            return this.requestCount;
        }

        public long getDocNumber() {
            return this.docNumber;
        }
    }

    public static interface StatusCollectStrategy {
        public List<ClusterSnapshot> getSnapshots();

        public ClusterSnapshot.Summary getMetricSummary();
    }
}

