/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.runtime.module.action;

import com.alibaba.citrus.turbine.Context;
import com.opensymphony.xwork2.ModelDriven;
import com.qlangtech.tis.manage.ChangeDomainForm;
import com.qlangtech.tis.manage.biz.dal.pojo.Application;
import com.qlangtech.tis.manage.biz.dal.pojo.ApplicationCriteria;
import com.qlangtech.tis.manage.common.IUser;
import com.qlangtech.tis.manage.common.ManageUtils;
import com.qlangtech.tis.manage.common.RunContext;
import com.qlangtech.tis.manage.common.apps.AppsFetcher;
import com.qlangtech.tis.manage.common.apps.IAppsFetcher;
import com.qlangtech.tis.pubhook.common.Nullable;
import com.qlangtech.tis.pubhook.common.RunEnvironment;
import com.qlangtech.tis.runtime.module.action.BasicModule;
import com.qlangtech.tis.runtime.module.action.GroupAction;
import com.qlangtech.tis.runtime.module.control.AppDomain;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import junit.framework.Assert;
import org.apache.commons.lang.StringUtils;
import org.json.JSONException;

public class ChangeDomainAction
extends BasicModule
implements ModelDriven<ChangeDomainForm> {
    private static final long serialVersionUID = 1L;
    public static final String GROUPNAME = "changedomain";
    public static final String SELECT_APP_NAME = "selectAppDomain";
    public static final String COOKIE_SELECT_APP = "selectAppDomain" + (ManageUtils.isDaily() ? RunEnvironment.DAILY : RunEnvironment.ONLINE);
    private final ChangeDomainForm form = new ChangeDomainForm();
    static final List<Application> emptyAppList = Collections.emptyList();

    @Override
    public boolean isAppNameAware() {
        return false;
    }

    public ChangeDomainAction() {
        super(GROUPNAME);
    }

    public ChangeDomainForm getModel() {
        return this.form;
    }

    public void doChange(Context context) throws Exception {
        Integer appid = this.parseSelectedAppid(this.form, context);
        if (appid == null) {
            return;
        }
        Application app = this.getApplicationDAO().selectByPrimaryKey(appid);
        this.setAppDomainCookie(this.form, app);
        this.return2OriginUrl(this.form);
    }

    public void doChangeRuntimeAjax(Context context) throws Exception {
        ChangeDomainAction.setAppdomainCookie(ChangeDomainAction.getResponse(), this.getRequest(), RunEnvironment.getEnum((String)this.getString("runtime")));
    }

    public void doChangeAppAjax(Context context) throws Exception {
        Integer appid = this.getInt("appid");
        if (appid == null) {
            appid = this.getInt("selappid");
        }
        if (appid == null) {
            this.addErrorMessage(context, "\u8bf7\u9009\u62e9\u5e94\u7528");
            return;
        }
        if (this.getAppDomain() instanceof Nullable) {
            this.addErrorMessage(context, "\u8bf7\u5148\u9009\u62e9\u5e94\u7528\u73af\u5883\uff0c\u65e5\u5e38\uff1f  \u9884\u53d1\uff1f \u7ebf\u4e0a\uff1f");
            return;
        }
        Application app = this.getApplicationDAO().loadFromWriteDB(appid);
        ChangeDomainAction.setAppdomainCookie(ChangeDomainAction.getResponse(), this.getRequest(), this.getAppDomain().getRunEnvironment(), app);
        this.addActionMessage(context, "\u5df2\u7ecf\u5c06\u5f53\u524d\u5e94\u7528\u5207\u6362\u6210:" + AppDomain.getAppDescribe(app));
    }

    private Integer parseSelectedAppid(ChangeDomainForm form, Context context) {
        Integer appid = this.getInt("hiddenAppnamesuggest");
        if (appid != null) {
            return appid;
        }
        if (form.getBizid() == null) {
            this.addErrorMessage(context, "\u8bf7\u9009\u62e9\u4e1a\u52a1\u7ebf");
            return appid;
        }
        appid = form.getAppid();
        if (appid == null) {
            this.addErrorMessage(context, "\u8bf7\u9009\u62e9\u5e94\u7528");
            return appid;
        }
        return appid;
    }

    public void doAppNameSuggestDaily(Context context) throws Exception {
    }

    public void doAppNameSuggest(Context context) throws Exception {
        String appNameFuzzy = StringUtils.trimToEmpty((String)this.getString("query"));
        ChangeDomainAction.processNameSuggest(this.getRequest(), this.getUser(), this, false, appNameFuzzy);
    }

    public static void processNameSuggest(HttpServletRequest request, IUser user, RunContext context, boolean ismaxmatch, String appNameFuzzy) throws JSONException, IOException {
        List<Application> result = !StringUtils.startsWith((String)appNameFuzzy, (String)"search4") ? emptyAppList : ChangeDomainAction.getMatchApps(request, ismaxmatch, appNameFuzzy, user, context);
        GroupAction.writeSuggest2Response(appNameFuzzy, result, new GroupAction.SuggestCallback<Application>(){

            @Override
            public String getLiteral(Application o) {
                return o.getProjectName();
            }

            @Override
            public Object getValue(Application o) {
                return o.getAppId();
            }
        }, ChangeDomainAction.getResponse());
    }

    protected static List<Application> getMatchApps(HttpServletRequest request, boolean isMaxMatch, final String appNameFuzzy, IUser user, RunContext context) {
        IAppsFetcher fetcher = null;
        fetcher = ChangeDomainAction.getAppsFetcher(request, isMaxMatch, user, context);
        return fetcher.getApps(new AppsFetcher.CriteriaSetter(){

            @Override
            public void set(ApplicationCriteria.Criteria criteria) {
                criteria.andProjectNameLike(appNameFuzzy + "%");
            }
        });
    }

    private void setAppDomainCookie(ChangeDomainForm form, Application app) {
        ChangeDomainAction.setAppdomainCookie(ChangeDomainAction.getResponse(), this.getRequest(), RunEnvironment.getEnum((short)form.getRunEnviron().shortValue()), app);
    }

    private static void setAppdomainCookie(HttpServletResponse response, HttpServletRequest request, RunEnvironment runtime, Application app) {
        String host = request.getHeader("Host");
        ChangeDomainAction.addCookie(response, COOKIE_SELECT_APP, (app != null ? app.getProjectName() : ManageUtils.getAppDomain(request).getAppName()) + "_run" + (Serializable)(runtime == null ? "" : runtime.getId()), StringUtils.substringBefore((String)host, (String)":"));
    }

    private static void setAppdomainCookie(HttpServletResponse response, HttpServletRequest request, RunEnvironment runtime) {
        ChangeDomainAction.setAppdomainCookie(response, request, runtime, null);
    }

    private void return2OriginUrl(ChangeDomainForm form) {
        Assert.assertNotNull((String)"parameter form can not be null", (Object)form);
        String referer = form.getGobackurl();
        if (StringUtils.isNotEmpty((String)referer)) {
            // empty if block
        }
    }

    public void doRuntimeChange(Context context) throws Exception {
        this.setAppDomainCookie(this.form, null);
        this.return2OriginUrl(this.form);
    }

    public static void addCookie(HttpServletResponse response, String name, String value, String domain) {
        ChangeDomainAction.addCookie(response, name, value, domain, 259200);
    }

    public static void addCookie(HttpServletResponse response, String name, String value, String domain, int maxAge) {
        Assert.assertNotNull((Object)domain);
        Cookie cookie = new Cookie(name, value);
        cookie.setMaxAge(maxAge);
        cookie.setPath("/");
        cookie.setDomain(domain);
        cookie.setVersion(0);
        response.addCookie(cookie);
    }

    public void doSelectChange(Context context) {
        this.setErrorMsgInvisiable(context);
        Integer bizid = this.getInt("bizid");
        if (bizid == null) {
            return;
        }
        this.setBizResult(context, this.getAppList(bizid));
    }
}

