/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.runtime.module.action;

import com.alibaba.citrus.turbine.Context;
import com.koubei.web.tag.pager.Pager;
import com.qlangtech.tis.manage.biz.dal.pojo.Application;
import com.qlangtech.tis.manage.biz.dal.pojo.ApplicationCriteria;
import com.qlangtech.tis.manage.common.UserUtils;
import com.qlangtech.tis.manage.common.apps.IAppsFetcher;
import com.qlangtech.tis.manage.spring.aop.Func;
import com.qlangtech.tis.runtime.module.action.ApplicationDelegate;
import com.qlangtech.tis.runtime.module.action.BasicModule;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public class AppViewAction
extends BasicModule {
    private static final long serialVersionUID = 1L;
    private Pager pager;

    @Func(value="index_query", sideEffect=false)
    public void doQueryApp(Context context) throws Exception {
        String appNameFuzzy = StringUtils.trimToEmpty((String)this.getString("query"));
        IAppsFetcher fetcher = UserUtils.getAppsFetcher(this.getRequest(), this);
        List<Application> appresult = fetcher.getApps(criteria -> criteria.andProjectNameLike(StringUtils.startsWith((String)appNameFuzzy, (String)"search4") ? appNameFuzzy + "%" : "%" + appNameFuzzy + "%"));
        this.setBizResult(context, appresult);
    }

    public void doGetApps(Context context) throws Exception {
        Integer dptid = this.getInt("dptid", null);
        String appName = this.getString("name");
        Integer dptId = (Integer)context.get("dptId");
        String recept = (String)context.get("recept");
        ApplicationCriteria query = new ApplicationCriteria();
        ApplicationCriteria.Criteria criteria = query.createCriteria();
        if (dptid != null) {
            context.put("bizdomain", (Object)this.getDepartmentDAO().loadFromWriteDB(dptid));
        }
        if (appName != null && !appName.equals("search4")) {
            criteria.andProjectNameLike("%" + appName + "%");
        }
        if (dptId != null) {
            criteria.andDptIdEqualTo(dptId);
        }
        if (recept != null && !StringUtils.isEmpty((String)recept)) {
            criteria.andReceptEqualTo(recept);
        }
        query.setOrderByClause("last_process_time desc,app_id desc");
        int allRows = this.getApplicationDAO().countByExample(query);
        Pager pager = this.getPager();
        List apps = Collections.emptyList();
        pager.setTotalCount(allRows);
        if (allRows < 1) {
            this.setBizResult(context, new BasicModule.PaginationResult(pager, apps, new Object[0]));
            return;
        }
        context.put("recept", (Object)recept);
        context.put("dptId", (Object)dptId);
        apps = this.getApplicationDAO().selectByExample(query, pager.getCurPage(), pager.getRowsPerPage()).stream().map(ApplicationDelegate::new).collect(Collectors.toList());
        this.setBizResult(context, new BasicModule.PaginationResult(pager, apps, new Object[0]));
    }

    public Pager getPager() {
        if (this.pager == null) {
            this.pager = this.createPager();
        }
        return this.pager;
    }
}

