/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.runtime.module.action;

import com.alibaba.citrus.turbine.Context;
import com.alibaba.fastjson.annotation.JSONField;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.opensymphony.xwork2.ModelDriven;
import com.qlangtech.tis.coredefine.biz.FCoreRequest;
import com.qlangtech.tis.coredefine.module.action.CoreAction;
import com.qlangtech.tis.coredefine.module.control.SelectableServer;
import com.qlangtech.tis.datax.IDataxProcessor;
import com.qlangtech.tis.datax.StoreResourceType;
import com.qlangtech.tis.datax.impl.DataxProcessor;
import com.qlangtech.tis.fullbuild.indexbuild.LuceneVersion;
import com.qlangtech.tis.manage.IAppSource;
import com.qlangtech.tis.manage.ISolrAppSource;
import com.qlangtech.tis.manage.biz.dal.pojo.AppTriggerJobRelationCriteria;
import com.qlangtech.tis.manage.biz.dal.pojo.Application;
import com.qlangtech.tis.manage.biz.dal.pojo.ApplicationCriteria;
import com.qlangtech.tis.manage.biz.dal.pojo.Department;
import com.qlangtech.tis.manage.biz.dal.pojo.DepartmentCriteria;
import com.qlangtech.tis.manage.biz.dal.pojo.ServerGroup;
import com.qlangtech.tis.manage.biz.dal.pojo.ServerGroupCriteria;
import com.qlangtech.tis.manage.biz.dal.pojo.Snapshot;
import com.qlangtech.tis.manage.biz.dal.pojo.SnapshotCriteria;
import com.qlangtech.tis.manage.biz.dal.pojo.UploadResourceCriteria;
import com.qlangtech.tis.manage.common.BasicDAO;
import com.qlangtech.tis.manage.common.Option;
import com.qlangtech.tis.manage.common.RunContext;
import com.qlangtech.tis.manage.common.apps.AppsFetcher;
import com.qlangtech.tis.manage.common.apps.IAppsFetcher;
import com.qlangtech.tis.manage.impl.DataFlowAppSource;
import com.qlangtech.tis.manage.servlet.DownloadServlet;
import com.qlangtech.tis.manage.spring.aop.Func;
import com.qlangtech.tis.offline.module.manager.impl.OfflineManager;
import com.qlangtech.tis.openapi.impl.AppKey;
import com.qlangtech.tis.plugin.annotation.Validator;
import com.qlangtech.tis.pubhook.common.RunEnvironment;
import com.qlangtech.tis.runtime.module.action.BasicModule;
import com.qlangtech.tis.runtime.module.action.CreateIndexConfirmModel;
import com.qlangtech.tis.runtime.module.action.IAfterApplicationCreate;
import com.qlangtech.tis.runtime.module.action.SchemaAction;
import com.qlangtech.tis.runtime.module.misc.IFieldErrorHandler;
import com.qlangtech.tis.solrdao.ISchemaPluginContext;
import com.qlangtech.tis.solrdao.SchemaResult;
import com.qlangtech.tis.util.IPluginContext;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import junit.framework.Assert;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class AddAppAction
extends SchemaAction
implements ModelDriven<Application> {
    public static String SOURCE_TYPE_SINGLE_TABLE = "tab";
    public static String SOURCE_TYPE_DF = "df";
    public static AppKey.IAppKeyProcess appKeyProcess = key -> {};
    private static final long serialVersionUID = 1L;
    private OfflineManager offlineManager;
    public static final int FIRST_GROUP_INDEX = 0;
    private final Application app = new Application();
    private static final Pattern pattern = Pattern.compile("version:\\d+");

    public Application getModel() {
        return this.app;
    }

    @Func(value="app_add")
    public void doGetCreateAppMasterData(Context context) throws Exception {
        HashMap masterData = Maps.newHashMap();
        boolean justbizLine = this.getBoolean("justbizLine");
        masterData.put("bizlinelist", this.getBizLineList());
        if (!justbizLine) {
            ArrayList<Option> verList = new ArrayList<Option>();
            for (LuceneVersion v : LuceneVersion.values()) {
                verList.add(new Option(v.getKey(), (Object)v.getKey()));
            }
            masterData.put("tplenum", verList);
            masterData.put("usableWorkflow", this.offlineManager.getUsableWorkflow());
        }
        this.setBizResult(context, masterData);
    }

    @Func(value="app_add", sideEffect=false)
    public void doGetSelectableNodeList(Context context) throws Exception {
        SelectableServer.CoreNode[] nodes = SelectableServer.getCoreNodeInfo(this.getRequest(), this, false, false);
        this.setBizResult(context, nodes);
    }

    @Func(value="app_add")
    public void doCreateCollection(Context context) throws Exception {
        CreateIndexConfirmModel confiemModel = this.parseJsonPost(CreateIndexConfirmModel.class);
        confiemModel.setTplAppId(AddAppAction.getTemplateApp(this).getAppId());
        SchemaResult schemaResult = this.parseSchema(context, ISchemaPluginContext.NULL, confiemModel);
        this.createCollection(context, confiemModel, schemaResult, (ctx, app, publishSnapshotId, schemaContent) -> {
            SchemaAction.CreateSnapshotResult result = new SchemaAction.CreateSnapshotResult();
            result.setSuccess(true);
            Application a = this.getApplicationDAO().selectByName(app.getProjectName());
            if (a == null) {
                throw new IllegalStateException("appname:" + app.getProjectName() + " relevant app can not be find in DB");
            }
            result.setNewSnapshotId(AddAppAction.getPublishSnapshotId(this.getServerGroupDAO(), a));
            return result;
        });
    }

    @Func(value="app_add")
    public void doAdvanceAddApp(Context context) throws Exception {
        CreateIndexConfirmModel confiemModel = this.parseJsonPost(CreateIndexConfirmModel.class);
        confiemModel.setTplAppId(AddAppAction.getTemplateApp(this).getAppId());
        SchemaResult schemaResult = this.parseSchema(context, ISchemaPluginContext.NULL, confiemModel);
        if (!this.createNewApp(context, confiemModel.getAppform(), -1, null, true).isSuccess()) {
            return;
        }
        this.createCollection(context, confiemModel, schemaResult, (ctx, app, publishSnapshotId, schemaContent) -> this.createNewApp(ctx, app, publishSnapshotId, schemaContent));
    }

    protected Optional<Application> createCollection(Context context, CreateIndexConfirmModel confiemModel, SchemaResult schemaResult, ICreateNewApp appCreator) throws Exception {
        ExtendApp extApp = confiemModel.getAppform();
        this.appendPrefix(extApp);
        String workflow = confiemModel.getAppform().getWorkflow();
        if (StringUtils.isBlank((String)workflow)) {
            this.addErrorMessage(context, "\u7f3a\u5c11\u5168\u91cf\u6570\u636e\u6d41\u4fe1\u606f");
            return Optional.empty();
        }
        String[] candidateNodeIps = confiemModel.getCoreNodeCandidate();
        if (candidateNodeIps == null || candidateNodeIps.length < 1) {
            this.addErrorMessage(context, "\u8bf7\u9009\u62e9\u5f15\u64ce\u8282\u70b9");
            return Optional.empty();
        }
        if (!schemaResult.isSuccess()) {
            return Optional.empty();
        }
        Application app = new Application();
        app.setAppId(Integer.valueOf(confiemModel.getTplAppId()));
        Integer publishSnapshotId = AddAppAction.getPublishSnapshotId(this.getServerGroupDAO(), app);
        byte[] content = schemaResult.content;
        SelectableServer.ServerNodeTopology coreNode = confiemModel.getCoreNode();
        int gourpCount = coreNode.getShardCount();
        int repliation = coreNode.getReplicaCount();
        FCoreRequest request = new FCoreRequest(CoreAction.createIps(context, extApp.getProjectName(), candidateNodeIps), gourpCount);
        for (String ip : candidateNodeIps) {
            request.addNodeIps(gourpCount - 1, ip);
        }
        request.setValid(true);
        SchemaAction.CreateAppResult createResult = appCreator.createNewApp(context, extApp, publishSnapshotId, content);
        if (!createResult.isSuccess()) {
            return Optional.of(app);
        }
        IAppSource.save((IPluginContext)this, (String)extApp.getProjectName(), (IAppSource)extApp.createAppSource(this));
        AppKey appKey = AppKey.create(extApp.getProjectName());
        if (!(createResult instanceof SchemaAction.CreateSnapshotResult)) {
            throw new IllegalStateException("instance of createResult must be CreateSnapshotResult");
        }
        SchemaAction.CreateSnapshotResult snapshotResult = (SchemaAction.CreateSnapshotResult)createResult;
        appKey.setTargetSnapshotId((long)snapshotResult.getNewId());
        appKey.setFromCache(false);
        appKeyProcess.process(appKey);
        CoreAction.createCollection(this, context, gourpCount, repliation, request, snapshotResult.getNewId());
        return Optional.of(app);
    }

    @Func(value="app_add", sideEffect=false)
    public void doValidateAppForm(Context context) throws Exception {
        this.errorsPageShow(context);
        ExtendApp app = this.parseJsonPost(ExtendApp.class);
        this.appendPrefix(app);
        this.createNewApp(context, app, -1, null, true);
    }

    private void appendPrefix(ExtendApp app) {
        if (StringUtils.isNotBlank((String)app.getProjectName())) {
            app.setProjectName("search4" + app.getProjectName());
        }
    }

    protected SchemaAction.CreateAppResult createNewApp(Context context, ExtendApp app, int publishSnapshotId, byte[] schemaContent) throws Exception {
        return this.createNewApp(context, app, publishSnapshotId, schemaContent, false);
    }

    private static Integer createNewSnapshot(Snapshot snapshot, String memo, RunContext runContext, Long userid, String userName) {
        Integer newId;
        snapshot.setSnId(null);
        snapshot.setUpdateTime(new Date());
        snapshot.setCreateTime(new Date());
        try {
            snapshot.setCreateUserId(userid);
        }
        catch (Throwable e) {
            snapshot.setCreateUserId(Long.valueOf(0L));
        }
        snapshot.setCreateUserName(userName);
        if (StringUtils.isNotEmpty((String)memo)) {
            snapshot.setMemo(memo);
        }
        if ((newId = runContext.getSnapshotDAO().insertSelective(snapshot)) == null) {
            throw new IllegalArgumentException(" have not create a new snapshot id");
        }
        return newId;
    }

    @Func(value="app_delete")
    public void doDelete(Context context) {
        Integer appid = this.getInt("appid");
        Assert.assertNotNull((String)"appid can not be null", (Object)appid);
        this.rescycleAppDB(appid);
        this.addActionMessage(context, "\u7d22\u5f15\u5b9e\u4f8b\u201c" + this.getAppDomain().getAppName() + "\u201d\u8be5\u5e94\u7528\u88ab\u6210\u529f\u5220\u9664");
    }

    protected void rescycleAppDB(Integer appid) {
        if (appid < 1) {
            throw new IllegalArgumentException("appid can not empty");
        }
        ServerGroupCriteria criteria = new ServerGroupCriteria();
        criteria.createCriteria().andAppIdEqualTo(appid);
        for (ServerGroup sg : this.getServerGroupDAO().selectByExample(criteria)) {
            this.getServerGroupDAO().deleteByPrimaryKey(sg.getGid());
        }
        SnapshotCriteria snCriteria = new SnapshotCriteria();
        snCriteria.createCriteria().andAppidEqualTo(appid);
        HashSet resIds = Sets.newHashSet();
        for (Snapshot snapshot : this.getSnapshotDAO().selectByExample(snCriteria)) {
            resIds.add(snapshot.getResSchemaId());
            this.getSnapshotDAO().deleteByPrimaryKey(snapshot.getSnId());
        }
        UploadResourceCriteria urCriteria = new UploadResourceCriteria();
        urCriteria.createCriteria().andUrIdIn((List)Lists.newArrayList((Iterable)resIds));
        this.getUploadResourceDAO().deleteByExample(urCriteria);
        AppTriggerJobRelationCriteria acriteria = new AppTriggerJobRelationCriteria();
        acriteria.createCriteria().andAppIdEqualTo(appid);
        this.getAppTriggerJobRelationDAO().deleteByExample(acriteria);
        this.getApplicationDAO().deleteByPrimaryKey(appid);
    }

    public static SchemaAction.CreateAppResult createApplication(Application app, Context context, BasicModule module, IAfterApplicationCreate afterAppCreate) throws Exception {
        Integer newAppid = module.getApplicationDAO().insertSelective(app);
        SchemaAction.CreateSnapshotResult snapshotResult = new SchemaAction.CreateSnapshotResult();
        snapshotResult.setNewAppId(newAppid);
        snapshotResult.setSuccess(true);
        SchemaAction.CreateAppResult createAppResult = null;
        createAppResult = afterAppCreate.process(newAppid);
        if (!createAppResult.isSuccess()) {
            return createAppResult;
        }
        int offset = (int)(Math.random() * 10.0);
        return snapshotResult;
    }

    public static Department getDepartment(RunContext runcontext, Integer dptId) {
        DepartmentCriteria criteria = new DepartmentCriteria();
        criteria.createCriteria().andDptIdEqualTo(dptId);
        Iterator<Department> iterator = runcontext.getDepartmentDAO().selectByExample(criteria).iterator();
        if (iterator.hasNext()) {
            Department dpt = iterator.next();
            return dpt;
        }
        throw new IllegalArgumentException("dptId:" + dptId + " can not find any department obj");
    }

    @Func(value="config_upload")
    public void doCopyConfigFromOtherApp(Context context) {
        Integer fromAppId = this.getInt("hiddenAppnamesuggest");
        if (fromAppId == null) {
            fromAppId = this.getInt("combAppid");
        }
        Assert.assertNotNull((String)"fromAppId can not be null", (Object)fromAppId);
        Application fromApp = this.getApplicationDAO().loadFromWriteDB(fromAppId);
        if (fromApp == null) {
            this.addErrorMessage(context, "\u62f7\u8d1d\u6e90\u5e94\u7528\u5df2\u7ecf\u5220\u9664\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9");
            return;
        }
        Integer toAppId = this.getInt("toAppId");
        Assert.assertNotNull((String)"toAppId can not be null", (Object)toAppId);
        Application destinationApp = this.getApplicationDAO().loadFromWriteDB(toAppId);
        if (destinationApp == null) {
            this.addErrorMessage(context, "\u62f7\u8d1d\u76ee\u6807\u5e94\u7528\u5df2\u7ecf\u5220\u9664");
            return;
        }
        ServerGroup group = DownloadServlet.getServerGroup(fromAppId, new Integer(0).shortValue(), this.getAppDomain().getRunEnvironment().getId(), this.getServerGroupDAO());
        if (group == null) {
            this.addErrorMessage(context, "\u62f7\u8d1d\u76ee\u6807\u5e94\u7528\u8fd8\u6ca1\u6709\u5b9a\u4e49\u7ec4");
            return;
        }
        if (group.getPublishSnapshotId() == null) {
            this.addErrorMessage(context, "\u62f7\u8d1d\u76ee\u6807\u5e94\u7528\u8fd8\u6ca1\u6709\u8bbe\u5b9a\u914d\u7f6e\u6587\u4ef6\u7248\u672c");
            return;
        }
        Snapshot newSnapshto = this.getSnapshotDAO().loadFromWriteDB(group.getPublishSnapshotId());
        newSnapshto.setCreateTime(new Date());
        newSnapshto.setUpdateTime(new Date());
        newSnapshto.setPreSnId(newSnapshto.getSnId());
        newSnapshto.setSnId(null);
        newSnapshto.setAppId(toAppId);
        newSnapshto.setMemo("\u4ece\u5e94\u7528\u201c" + fromApp.getProjectName() + "\u201d \u62f7\u8d1d\u800c\u6765");
        try {
            newSnapshto.setCreateUserId(Long.valueOf(Long.parseLong(this.getUserId())));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        newSnapshto.setCreateUserName(this.getLoginUserName());
        this.getSnapshotDAO().insertSelective(newSnapshto);
        this.addActionMessage(context, "\u62f7\u8d1d\u6e90\u5e94\u7528\u201c" + fromApp.getProjectName() + "\u201d\u5df2\u7ecf\u6210\u529f\u590d\u5236\u5230\u76ee\u6807\u5e94\u7528\u201c" + destinationApp.getProjectName() + "\u201d");
    }

    @Func(value="app_update")
    public void doUpdate(Context context) {
        Application form = new Application();
        context.put("app", (Object)form);
        Integer bizid = this.getInt("bizid");
        final Integer appid = this.getInt("appid");
        Assert.assertNotNull((Object)bizid);
        Assert.assertNotNull((Object)appid);
        form.setAppId(appid);
        DepartmentCriteria criteria = new DepartmentCriteria();
        criteria.createCriteria().andDptIdEqualTo(bizid).andLeafEqualTo("Y");
        List<Department> depatment = this.getDepartmentDAO().selectByExample(criteria);
        Assert.assertTrue((String)("dptid:" + bizid + " depatment can not be null "), (depatment.size() == 1 ? 1 : 0) != 0);
        for (Department d : depatment) {
            form.setDptId(d.getDptId());
            form.setDptName(d.getFullName());
        }
        form.setProjectName(this.getString("projectName"));
        form.setRecept(this.getString("recept"));
        if (!AddAppAction.isAppNameValid((IFieldErrorHandler)this, context, "projectName", form)) {
            return;
        }
        form.setIsAutoDeploy(Boolean.valueOf("true".equalsIgnoreCase(this.getString("isautodeploy"))));
        if (!this.validateAppForm(context, form)) {
            return;
        }
        IAppsFetcher fetcher = this.getAppsFetcher();
        fetcher.update(form, new AppsFetcher.CriteriaSetter(){

            @Override
            public void set(ApplicationCriteria.Criteria criteria) {
                criteria.andAppIdEqualTo(appid);
            }
        });
        this.addActionMessage(context, "\u5df2\u7ecf\u6210\u529f\u66f4\u65b0\u5e94\u7528[" + form.getProjectName() + "]");
    }

    public static void main(String[] arg) throws Exception {
    }

    public static boolean isAppNameValid(IFieldErrorHandler msgHandler, Context context, String fieldKey, Application form) {
        boolean valid = Validator.identity.validate(msgHandler, context, fieldKey, form.getProjectName());
        if (!valid) {
            return false;
        }
        if (StringUtils.indexOf((String)form.getProjectName(), (String)"-") > -1) {
            msgHandler.addFieldError(context, fieldKey, "\u540d\u79f0\u4e2d\u4e0d\u80fd\u6709'-'\u5b57\u7b26", new Object[0]);
            return false;
        }
        return true;
    }

    private boolean validateAppForm(Context context, Application app) {
        if (StringUtils.isBlank((String)app.getProjectName())) {
            this.addErrorMessage(context, "\u7d22\u5f15\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        if (StringUtils.isBlank((String)app.getRecept())) {
            this.addErrorMessage(context, "\u63a5\u53e3\u4eba\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        return true;
    }

    @Override
    @Autowired
    public void setOfflineManager(OfflineManager offlineManager) {
        this.offlineManager = offlineManager;
    }

    public void doCopyFromOtherIndex(Context context) throws Exception {
        String colonFrom = this.getString("appname");
        if (StringUtils.startsWith((String)colonFrom, (String)"search4")) {
            throw new IllegalArgumentException("colonFrom:" + colonFrom + " is not start with 'search4'");
        }
        BasicDAO basicDao = (BasicDAO)this.getApplicationDAO();
        DataSource dataSource = basicDao.getDataSource();
        Connection conn = dataSource.getConnection();
        PreparedStatement statement = conn.prepareStatement("select app_id from application where project_name = ?");
        statement.setString(1, colonFrom);
        Integer oldAppId = null;
        ResultSet result = statement.executeQuery();
        if (result.next()) {
            oldAppId = result.getInt(1);
        }
        result.close();
        statement.close();
        Assert.assertNotNull((Object)oldAppId);
        String insertSql = "insert into application(project_name,recept,manager,create_time,update_time, is_auto_deploy, dpt_id,  dpt_name ) select  concat('search4', 'N', SUBSTRING(project_name,8)) as project_name ,recept,manager,create_time,update_time ,'Y' as is_auto_deploy, 8 as dpt_id, '\u6dd8\u5b9d\u7f51-\u4ea7\u54c1\u6280\u672f\u90e8-\u7efc\u5408\u4e1a\u52a1\u5e73\u53f0-\u4e92\u52a8\u4e1a\u52a1\u5e73\u53f0-\u7ec8\u641c' as dpt_name from application where app_id = ?";
        statement = conn.prepareStatement(insertSql);
        statement.setInt(1, oldAppId);
        Assert.assertTrue((boolean)statement.execute());
        statement.close();
        statement = conn.prepareStatement(" SELECT LAST_INSERT_ID()");
        result = statement.executeQuery();
        Integer newAppId = null;
        if (result.next()) {
            newAppId = result.getInt(1);
        }
        Assert.assertNotNull(newAppId);
        result.close();
        statement.close();
        statement = conn.prepareStatement("insert intosnapshot(create_time,update_time,app_id,res_schema_id ,res_solr_id ,res_jar_id ,res_core_prop_id ,res_ds_id ,res_application_id ,pre_sn_id) select create_time,update_time,? as app_id,res_schema_id ,res_solr_id ,res_jar_id ,res_core_prop_id ,res_ds_id ,res_application_id ,pre_sn_id   from snapshot  where sn_id in (select publish_snapshot_id from server_group where publish_snapshot_id is not null and app_id = ?)");
        statement.setInt(1, newAppId);
        statement.setInt(2, oldAppId);
        statement.execute();
        statement.close();
        conn.close();
    }

    public static class ExtendApp
    extends Application {
        private static final long serialVersionUID = 1L;
        private List<Option> selectableDepartment;
        private String[] tabCascadervalues;
        private String dsType;
        private String workflow;

        @JSONField(serialize=false)
        public Integer getWorkFlowId() {
            return Integer.parseInt(StringUtils.substringBefore((String)this.workflow, (String)":"));
        }

        public void setName(String name) {
            this.setProjectName(name);
        }

        public void setWorkflow(String val) {
            this.workflow = val;
        }

        public ISolrAppSource createAppSource(BasicModule module) {
            if (SOURCE_TYPE_SINGLE_TABLE.equals(this.getDsType())) {
                throw new UnsupportedOperationException();
            }
            if (SOURCE_TYPE_DF.equals(this.getDsType())) {
                String workflowName = this.getWorkflow();
                if (StringUtils.isEmpty((String)workflowName)) {
                    throw new IllegalStateException("workflowName can not be null");
                }
                String wfName = StringUtils.split((String)workflowName, (String)":")[1];
                Integer wfId = Integer.parseInt(StringUtils.split((String)workflowName, (String)":")[0]);
                IDataxProcessor process = DataxProcessor.load((IPluginContext)module, (StoreResourceType)StoreResourceType.DataFlow, (String)wfName);
                return new DataFlowAppSource(module.loadDF(wfId), process.getWriter((IPluginContext)module, true));
            }
            throw new IllegalStateException("dsType:" + this.getDsType() + " is not illegal");
        }

        public String[] getTabCascadervalues() {
            return this.tabCascadervalues;
        }

        public void setTabCascadervalues(String[] tabCascadervalues) {
            this.tabCascadervalues = tabCascadervalues;
        }

        public String getDsType() {
            return this.dsType;
        }

        public void setDsType(String dsType) {
            this.dsType = dsType;
        }

        public List<Option> getSelectableDepartment() {
            return this.selectableDepartment;
        }

        public void setSelectableDepartment(List<Option> selectableDepartment) {
            this.selectableDepartment = selectableDepartment;
        }

        public String getWorkflow() {
            return this.workflow;
        }
    }

    public static class AddReplic {
        private String appname;
        private int groupCount;
        private Integer replica;
        private RunEnvironment runtime;
        private List<String> servers;

        public AddReplic(String appname, int groupCount, Integer replica, RunEnvironment runtime, List<String> servers) {
            this.appname = appname;
            this.groupCount = groupCount;
            this.replica = replica;
            this.runtime = runtime;
            this.servers = servers;
        }

        public void publishNewCore() {
        }

        public Map<String, Set<String>> createPublishNewCoreParam() {
            return Collections.emptyMap();
        }
    }

    public static class IpsValidateResult {
        private final Map<String, String> ipsValidateResult = new HashMap<String, String>();
        private boolean success = true;

        public String put(String key, String value) {
            return this.ipsValidateResult.put(key, value);
        }

        public boolean isSuccess() {
            return this.success;
        }

        public boolean isValidate(String ip) {
            Matcher matcher = pattern.matcher(StringUtils.trimToEmpty((String)this.ipsValidateResult.get(ip)));
            return matcher.matches();
        }

        public String getMsg(String ip) {
            return this.ipsValidateResult.get(ip);
        }
    }

    public static interface ICreateNewApp {
        public SchemaAction.CreateAppResult createNewApp(Context var1, ExtendApp var2, int var3, byte[] var4) throws Exception;
    }
}

