/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.openapi.impl;

import com.qlangtech.tis.manage.biz.dal.dao.ISnapshotViewDAO;
import com.qlangtech.tis.manage.biz.dal.pojo.ServerGroup;
import com.qlangtech.tis.manage.common.RunContext;
import com.qlangtech.tis.manage.common.SnapshotDomain;
import com.qlangtech.tis.openapi.SnapshotNotFindException;
import com.qlangtech.tis.openapi.impl.AppKey;
import com.qlangtech.tis.openapi.impl.SnapshotInfoFromRequest;

public class SnapshotDomainGetter {
    private final RunContext runContext;

    public SnapshotDomainGetter(RunContext runContext) {
        this.runContext = runContext;
    }

    public SnapshotDomain getSnapshot(AppKey appKey) throws SnapshotNotFindException {
        SnapshotInfoFromRequest result = new SnapshotInfoFromRequest();
        if (appKey.getTargetSnapshotId() != null && appKey.getTargetSnapshotId() > 0L) {
            result.snapshotId = appKey.getTargetSnapshotId().intValue();
        } else {
            ServerGroup group = this.runContext.getServerGroupDAO().load(appKey.appName, appKey.groupIndex, appKey.runtime.getId());
            if (group == null) {
                throw new SnapshotNotFindException("appName:" + appKey.appName + " groupIndex:" + appKey.groupIndex + " runtime:" + appKey.runtime + " has not a corresponding server group in db");
            }
            if (group.getPublishSnapshotId() == null) {
                throw new SnapshotNotFindException("groupid:" + group.getGid() + " has not set publish snapshot id");
            }
            result.snapshotId = group.getPublishSnapshotId();
        }
        if (!appKey.unmergeglobalparams) {
            result.runtime = appKey.runtime;
        }
        if (result.snapshotId == null) {
            throw new IllegalStateException("result.snapshotId can not be null");
        }
        ISnapshotViewDAO snapshotViewDAO = this.runContext.getSnapshotViewDAO();
        if (snapshotViewDAO == null) {
            throw new IllegalStateException("snapshotViewDAO can not be null");
        }
        return snapshotViewDAO.getView(result.snapshotId);
    }
}

