/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.offline.module.manager.impl;

import com.alibaba.citrus.turbine.Context;
import com.qlangtech.tis.TIS;
import com.qlangtech.tis.datax.impl.DataxReader;
import com.qlangtech.tis.db.parser.DBConfigSuit;
import com.qlangtech.tis.git.GitUtils;
import com.qlangtech.tis.manage.biz.dal.pojo.Application;
import com.qlangtech.tis.manage.biz.dal.pojo.ApplicationCriteria;
import com.qlangtech.tis.manage.common.Option;
import com.qlangtech.tis.offline.DbScope;
import com.qlangtech.tis.offline.module.action.OfflineDatasourceAction;
import com.qlangtech.tis.offline.pojo.TISDb;
import com.qlangtech.tis.offline.pojo.WorkflowPojo;
import com.qlangtech.tis.plugin.KeyedPluginStore;
import com.qlangtech.tis.plugin.ds.DBIdentity;
import com.qlangtech.tis.plugin.ds.DataSourceFactory;
import com.qlangtech.tis.plugin.ds.PostedDSProp;
import com.qlangtech.tis.plugin.ds.TableReflect;
import com.qlangtech.tis.runtime.module.action.BasicModule;
import com.qlangtech.tis.sql.parser.SqlTaskNodeMeta;
import com.qlangtech.tis.util.IPluginContext;
import com.qlangtech.tis.workflow.dao.IWorkflowDAOFacade;
import com.qlangtech.tis.workflow.pojo.DatasourceDb;
import com.qlangtech.tis.workflow.pojo.DatasourceDbCriteria;
import com.qlangtech.tis.workflow.pojo.DatasourceTable;
import com.qlangtech.tis.workflow.pojo.WorkFlow;
import com.qlangtech.tis.workflow.pojo.WorkFlowCriteria;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.json.JSONObject;
import org.xml.sax.InputSource;

public class OfflineManager {
    private IWorkflowDAOFacade workflowDAOFacade;

    public static DataxReader getDBDataxReader(IPluginContext pluginContext, String dbName) {
        KeyedPluginStore pluginStore = DataxReader.getPluginStore(null, (boolean)true, (String)dbName);
        return (DataxReader)pluginStore.getPlugin();
    }

    public void setComDfireTisWorkflowDAOFacade(IWorkflowDAOFacade comDfireTisWorkflowDAOFacade) {
        this.workflowDAOFacade = comDfireTisWorkflowDAOFacade;
    }

    public List<WorkFlow> getUsableWorkflow() {
        WorkFlowCriteria query = new WorkFlowCriteria();
        query.createCriteria();
        query.setOrderByClause("id desc");
        return this.workflowDAOFacade.getWorkFlowDAO().selectByExample(query, 1, 100);
    }

    public DBDataXReaderDescName getDBDataXReaderDescName(String dsName) {
        DataSourceFactory dbPlugin = TIS.getDataBasePlugin((PostedDSProp)new PostedDSProp(DBIdentity.parseId((String)dsName), DbScope.DETAILED));
        DataSourceFactory.BaseDataSourceFactoryDescriptor descriptor = (DataSourceFactory.BaseDataSourceFactoryDescriptor)dbPlugin.getDescriptor();
        Optional defaultDataXReaderDescName = descriptor.getDefaultDataXReaderDescName();
        return new DBDataXReaderDescName(defaultDataXReaderDescName, descriptor);
    }

    public void updateFacadeDBConfig(Integer dbid, TISDb db, BasicModule action, Context context) throws Exception {
        throw new UnsupportedOperationException();
    }

    public void editDatasourceDb(TISDb db, BasicModule action, Context context) throws Exception {
        String dbName = db.getDbName();
        if (StringUtils.isBlank((String)db.getDbId())) {
            throw new IllegalArgumentException("dbid can not be null");
        }
        DatasourceDb d = this.workflowDAOFacade.getDatasourceDbDAO().selectByPrimaryKey(Integer.valueOf(Integer.parseInt(db.getDbId())));
        if (d == null) {
            action.addErrorMessage(context, "db\u4e2d\u627e\u4e0d\u5230\u8fd9\u4e2a\u6570\u636e\u5e93");
            return;
        }
        GitUtils.$().updateDatabase(db, "edit db " + db.getDbName());
        action.addActionMessage(context, "\u6570\u636e\u5e93\u4fee\u6539\u6210\u529f");
        action.setBizResult(context, db.getDbId());
    }

    public List<Option> getUsableDbNames() {
        DatasourceDbCriteria criteria = new DatasourceDbCriteria();
        criteria.createCriteria();
        List dbList = this.workflowDAOFacade.getDatasourceDbDAO().selectByExample(criteria);
        LinkedList<Option> dbNameList = new LinkedList<Option>();
        for (DatasourceDb datasourceDb : dbList) {
            dbNameList.add(new Option(datasourceDb.getName(), (Object)String.valueOf(datasourceDb.getId())));
        }
        return dbNameList;
    }

    public void editWorkflow(WorkflowPojo pojo, BasicModule action, Context context) throws Exception {
        String name = pojo.getName();
        WorkFlowCriteria criteria = new WorkFlowCriteria();
        criteria.createCriteria().andNameEqualTo(name);
        List workflowList = this.workflowDAOFacade.getWorkFlowDAO().selectByExample(criteria);
        if (CollectionUtils.isEmpty((Collection)workflowList)) {
            action.addErrorMessage(context, "\u6ca1\u6709\u540d\u5b57\u4e3a" + name + "\u7684\u5de5\u4f5c\u6d41");
            return;
        }
        WorkFlow workFlow = (WorkFlow)workflowList.get(0);
        if (workFlow.getInChange().intValue() == 0) {
            action.addErrorMessage(context, "\u5de5\u4f5c\u6d41\u4e0d\u5728\u53d8\u66f4\u4e2d");
            return;
        }
        GitUtils.JoinRule task = pojo.getTask();
        if (task == null || StringUtils.isBlank((String)task.getContent())) {
            action.addErrorMessage(context, "\u811a\u672c\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
            return;
        }
        if (!OfflineManager.isXmlValid(task)) {
            action.addErrorMessage(context, "XML\u89e3\u6790\u5931\u8d25\uff0c\u8bf7\u68c0\u6d4bXML\u683c\u5f0f");
            return;
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("name", (Object)name);
        jsonObject.put("task", (Object)pojo.getTask());
        try {
            GitUtils.$().updateWorkflowFile(name, name, jsonObject.toString(1), "update workflow " + name);
        }
        catch (Exception e) {
            action.addErrorMessage(context, "git\u914d\u7f6e\u6587\u4ef6\u4fee\u6539\u5931\u8d25");
            action.addErrorMessage(context, e.getMessage());
        }
    }

    public Collection<OfflineDatasourceAction.DatasourceDb> getDatasourceInfo(Optional<String> dsNameLike) throws Exception {
        DatasourceDbCriteria criteria = new DatasourceDbCriteria();
        DatasourceDbCriteria.Criteria query = criteria.createCriteria();
        dsNameLike.ifPresent(dsName -> query.andNameLike("%" + dsName + "%"));
        List dbList = this.workflowDAOFacade.getDatasourceDbDAO().selectByExample(criteria);
        HashMap<Integer, OfflineDatasourceAction.DatasourceDb> dbsMap = new HashMap<Integer, OfflineDatasourceAction.DatasourceDb>();
        OfflineDatasourceAction.DatasourceDb dsDb = null;
        for (DatasourceDb db : dbList) {
            if (StringUtils.isEmpty((String)db.getExtendClass())) continue;
            dsDb = new OfflineDatasourceAction.DatasourceDb(db.getId(), db.getExtendClass(), db.getOpTime());
            dsDb.setName(db.getName());
            dbsMap.put(db.getId(), dsDb);
        }
        return dbsMap.values();
    }

    public DBConfigSuit getDbConfig(IPluginContext pluginContext, DatasourceDb db) {
        DataSourceFactory facadeStore;
        Objects.requireNonNull(db, "instance of DatasourceDb can not be null");
        DBDataXReaderDescName dbDataXReaderDesc = this.getDBDataXReaderDescName(db.getName());
        DataxReader dbDataxReader = null;
        if (dbDataXReaderDesc.isSupportDataXReader()) {
            dbDataxReader = OfflineManager.getDBDataxReader(pluginContext, db.getName());
        }
        DBConfigSuit dbSuit = new DBConfigSuit(db, dbDataXReaderDesc.isSupportDataXReader(), dbDataxReader != null);
        if (dbDataxReader != null) {
            List selectedTabs = dbDataxReader.getSelectedTabs();
            dbSuit.addTabs(selectedTabs);
        }
        PostedDSProp dbProp = new PostedDSProp(DBIdentity.parseId((String)db.getName()), DbScope.DETAILED);
        DataSourceFactory dsPlugin = TIS.getDataBasePlugin((PostedDSProp)dbProp);
        dbSuit.setDetailed(dsPlugin);
        dsPlugin = facadeStore = TIS.getDataBasePlugin((PostedDSProp)new PostedDSProp(DBIdentity.parseId((String)db.getName()), DbScope.FACADE), (boolean)false);
        if (dsPlugin != null) {
            dbSuit.setFacade(dsPlugin);
        }
        return dbSuit;
    }

    public DBConfigSuit getDbConfig(IPluginContext pluginContext, Integer dbId) {
        return this.getDbConfig(pluginContext, this.getDB(dbId));
    }

    public DatasourceDb getDB(Integer dbId) {
        DatasourceDb db = this.workflowDAOFacade.getDatasourceDbDAO().selectByPrimaryKey(dbId);
        if (db == null) {
            throw new IllegalStateException("dbid:" + dbId + " can not find relevant db object in DB");
        }
        return db;
    }

    public WorkflowPojo getWorkflowConfig(Integer workflowId, boolean isMaster) {
        WorkFlow workFlow = this.workflowDAOFacade.getWorkFlowDAO().selectByPrimaryKey(workflowId);
        if (workFlow == null) {
            throw new IllegalStateException("workflow obj is null");
        }
        return GitUtils.$().getWorkflow(workFlow.getName(), GitUtils.GitBranchInfo.$((String)"xxxxxxxxxxxxxx"));
    }

    public void deleteWorkflow(int id, BasicModule action, Context context) {
        WorkFlow workFlow = this.workflowDAOFacade.getWorkFlowDAO().selectByPrimaryKey(Integer.valueOf(id));
        if (workFlow == null) {
            action.addErrorMessage(context, "\u6570\u636e\u5e93\u6ca1\u6709\u8fd9\u6761\u8bb0\u5f55");
            return;
        }
        if (workFlow.getInChange().intValue() != 0) {
            action.addErrorMessage(context, "\u8be5\u5de5\u4f5c\u6d41\u5728\u53d8\u66f4\u4e2d\uff0c\u65e0\u6cd5\u5220\u9664");
            return;
        }
        ApplicationCriteria applicationCriteria = new ApplicationCriteria();
        applicationCriteria.createCriteria().andWorkFlowIdEqualTo(Integer.valueOf(id));
        List applications = action.getApplicationDAO().selectByExample(applicationCriteria);
        if (!CollectionUtils.isEmpty((Collection)applications)) {
            StringBuilder stringBuilder = new StringBuilder();
            for (Application application : applications) {
                stringBuilder.append(application.getProjectName()).append(", ");
            }
            action.addErrorMessage(context, "\u8bf7\u5148\u5220\u9664\u4e0e\u8be5\u5de5\u4f5c\u6d41\u76f8\u5173\u7684\u7d22\u5f15\uff0c\u76f8\u5173\u7d22\u5f15\u4e3a" + stringBuilder.toString());
            return;
        }
        try {
            GitUtils.GitUser user = GitUtils.GitUser.dft();
            GitUtils.$().deleteWorkflow(workFlow.getName(), user);
            this.workflowDAOFacade.getWorkFlowDAO().deleteByPrimaryKey(Integer.valueOf(id));
            action.addActionMessage(context, "\u5de5\u4f5c\u6d41\u5220\u9664\u6210\u529f");
        }
        catch (Exception e) {
            action.addErrorMessage(context, "\u5de5\u4f5c\u6d41\u5220\u9664\u5931\u8d25");
            action.addErrorMessage(context, e.getMessage());
        }
    }

    public boolean checkTableLogicNameRepeat(String tableLogicName, DatasourceDb db) {
        return false;
    }

    public void syncDbRecord(DatasourceDb datasourceDb, BasicModule action, Context context) {
        try {
            this.workflowDAOFacade.getDatasourceDbDAO().insertSelective(datasourceDb);
            action.setBizResult(context, true);
        }
        catch (Exception e) {
            action.addErrorMessage(context, e.getMessage());
            action.setBizResult(context, false);
        }
    }

    private static boolean isXmlValid(GitUtils.JoinRule xmlStr) {
        boolean result = true;
        try {
            StringReader sr = new StringReader(xmlStr.getContent());
            InputSource is = new InputSource(sr);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.parse(is);
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    public void deleteDbById(int dbId, DbScope dbModel, BasicModule action, Context context) throws Exception {
        DatasourceDb db = this.workflowDAOFacade.getDatasourceDbDAO().selectByPrimaryKey(Integer.valueOf(dbId));
        if (db == null) {
            action.addErrorMessage(context, "\u627e\u4e0d\u5230\u8be5db\uff0cdb id = " + dbId);
            return;
        }
        TIS.deleteDB((String)db.getName(), (DbScope)dbModel);
        if (dbModel == DbScope.DETAILED) {
            this.workflowDAOFacade.getDatasourceDbDAO().deleteByPrimaryKey(Integer.valueOf(dbId));
        }
        action.addActionMessage(context, "\u6210\u529f\u5220\u9664'" + db.getName() + "'");
    }

    public void deleteDatasourceTableById(int tableId, BasicModule action, Context context) {
        throw new UnsupportedOperationException();
    }

    public void deleteWorkflowChange(int workflowId, BasicModule action, Context context) {
        WorkFlow workFlow = this.workflowDAOFacade.getWorkFlowDAO().selectByPrimaryKey(Integer.valueOf(workflowId));
        if (workFlow == null) {
            action.addErrorMessage(context, "\u627e\u4e0d\u5230id\u4e3a" + workflowId + "\u7684\u5de5\u4f5c\u6d41");
            return;
        }
        if (workFlow.getInChange().intValue() == 0) {
            action.addErrorMessage(context, "id\u4e3a" + workflowId + "\u7684\u5de5\u4f5c\u6d41\u4e0d\u5728\u53d8\u66f4\u4e2d");
            return;
        }
        try {
            GitUtils.$().deleteWorkflowBranch(workFlow.getName());
        }
        catch (Exception e) {
            e.printStackTrace();
            action.addErrorMessage(context, "\u5220\u9664\u5206\u652f" + workFlow.getName() + "\u5931\u8d25");
            action.addErrorMessage(context, e.getMessage());
            return;
        }
        int inChange = workFlow.getInChange().intValue();
        if (inChange == 1) {
            this.workflowDAOFacade.getWorkFlowDAO().deleteByPrimaryKey(Integer.valueOf(workflowId));
        } else if (inChange == 2) {
            workFlow.setInChange(new Byte("0"));
            WorkFlowCriteria criteria = new WorkFlowCriteria();
            criteria.createCriteria().andIdEqualTo(Integer.valueOf(workflowId));
            this.workflowDAOFacade.getWorkFlowDAO().updateByExample(workFlow, criteria);
        }
        action.addActionMessage(context, "\u5220\u9664\u53d8\u66f4\u6210\u529f");
    }

    public void confirmWorkflowChange(int workflowId, BasicModule action, Context context) {
        WorkFlow workFlow = this.workflowDAOFacade.getWorkFlowDAO().selectByPrimaryKey(Integer.valueOf(workflowId));
        if (workFlow == null) {
            action.addErrorMessage(context, "\u627e\u4e0d\u5230id\u4e3a" + workflowId + "\u7684\u5de5\u4f5c\u6d41");
            return;
        }
        int inChange = workFlow.getInChange().intValue();
        if (inChange == 0) {
            action.addErrorMessage(context, "id\u4e3a" + workflowId + "\u7684\u5de5\u4f5c\u6d41\u4e0d\u5728\u53d8\u66f4\u4e2d");
            return;
        }
        try {
            GitUtils.$().mergeWorkflowChange(workFlow.getName());
        }
        catch (Exception e) {
            action.addErrorMessage(context, "git\u5206\u652f\u5408\u5e76\u5931\u8d25");
            action.addErrorMessage(context, "\u6b64\u6b21\u53d8\u66f4\u6ca1\u6709\u4efb\u4f55\u914d\u7f6e\u53d8\u52a8\uff0c\u8bf7\u64a4\u9500\u53d8\u66f4");
            action.addErrorMessage(context, e.getMessage());
            return;
        }
        if (inChange == 1) {
            // empty if block
        }
        workFlow.setInChange(new Byte("0"));
        WorkFlowCriteria criteria = new WorkFlowCriteria();
        criteria.createCriteria().andIdEqualTo(Integer.valueOf(workflowId));
        this.workflowDAOFacade.getWorkFlowDAO().updateByExample(workFlow, criteria);
        action.addActionMessage(context, "\u53d8\u66f4\u63d0\u4ea4\u6210\u529f");
    }

    public static class DBDataXReaderDescName {
        public final Optional<String> readerDescName;
        public final DataSourceFactory.BaseDataSourceFactoryDescriptor dsDescriptor;

        public DBDataXReaderDescName(Optional<String> readerDescName, DataSourceFactory.BaseDataSourceFactoryDescriptor dsDescriptor) {
            this.readerDescName = readerDescName;
            this.dsDescriptor = dsDescriptor;
        }

        public boolean isSupportDataXReader() {
            return this.readerDescName.isPresent();
        }

        public String getReaderDescName() {
            return this.readerDescName.get();
        }
    }

    public static class ProcessedTable {
        private final TableReflect tabReflect;
        private final DatasourceTable tabMeta;
        private final DatasourceDb db;

        public ProcessedTable(TableReflect tabReflect, DatasourceDb db, DatasourceTable tabMeta) {
            if (tabReflect == null) {
                throw new IllegalStateException("tabReflect  can not be null");
            }
            if (tabMeta == null) {
                throw new IllegalStateException("tabMeta  can not be null");
            }
            if (db == null) {
                throw new IllegalArgumentException("param db can not be null");
            }
            this.tabReflect = tabReflect;
            this.tabMeta = tabMeta;
            this.db = db;
        }

        public String getDBName() {
            return this.db.getName();
        }

        public String getName() {
            return this.tabMeta.getName();
        }

        public Integer getDbId() {
            return this.tabMeta.getDbId();
        }

        public Integer getId() {
            return this.tabMeta.getId();
        }

        public String getExtraSql() {
            return SqlTaskNodeMeta.processBigContent((String)this.tabReflect.getSql());
        }
    }

    public static interface IConnProcessor {
        public void vist(Connection var1) throws SQLException;
    }
}

