/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.offline.module.action;

import com.alibaba.citrus.turbine.Context;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.koubei.web.tag.pager.Pager;
import com.qlangtech.tis.TIS;
import com.qlangtech.tis.coredefine.module.action.DataxAction;
import com.qlangtech.tis.coredefine.module.action.PluginDescMeta;
import com.qlangtech.tis.coredefine.module.action.TriggerBuildResult;
import com.qlangtech.tis.datax.DataXJobSubmit;
import com.qlangtech.tis.datax.IDataxProcessor;
import com.qlangtech.tis.datax.StoreResourceType;
import com.qlangtech.tis.datax.impl.DataXBasicProcessMeta;
import com.qlangtech.tis.datax.impl.DataxProcessor;
import com.qlangtech.tis.datax.impl.DataxReader;
import com.qlangtech.tis.db.parser.DBConfigSuit;
import com.qlangtech.tis.extension.Descriptor;
import com.qlangtech.tis.extension.DescriptorExtensionList;
import com.qlangtech.tis.extension.PluginFormProperties;
import com.qlangtech.tis.extension.impl.BaseSubFormProperties;
import com.qlangtech.tis.git.GitUtils;
import com.qlangtech.tis.lang.TisException;
import com.qlangtech.tis.manage.biz.dal.pojo.Application;
import com.qlangtech.tis.manage.common.AppDomainInfo;
import com.qlangtech.tis.manage.common.IUser;
import com.qlangtech.tis.manage.common.Option;
import com.qlangtech.tis.manage.servlet.BasicServlet;
import com.qlangtech.tis.manage.spring.aop.Func;
import com.qlangtech.tis.offline.DbScope;
import com.qlangtech.tis.offline.module.action.DuplicateEntitisJudge;
import com.qlangtech.tis.offline.module.manager.impl.OfflineManager;
import com.qlangtech.tis.offline.pojo.TISDb;
import com.qlangtech.tis.offline.pojo.WorkflowPojo;
import com.qlangtech.tis.plugin.IEndTypeGetter;
import com.qlangtech.tis.plugin.IdentityName;
import com.qlangtech.tis.plugin.annotation.IFieldValidator;
import com.qlangtech.tis.plugin.annotation.Validator;
import com.qlangtech.tis.plugin.ds.ColumnMetaData;
import com.qlangtech.tis.plugin.ds.DBIdentity;
import com.qlangtech.tis.plugin.ds.DataSourceFactory;
import com.qlangtech.tis.plugin.ds.DataType;
import com.qlangtech.tis.plugin.ds.ISelectedTab;
import com.qlangtech.tis.plugin.ds.JDBCTypes;
import com.qlangtech.tis.plugin.ds.PostedDSProp;
import com.qlangtech.tis.plugin.ds.TISTable;
import com.qlangtech.tis.plugin.ds.TableNotFoundException;
import com.qlangtech.tis.plugin.ds.TableReflect;
import com.qlangtech.tis.powerjob.IDataFlowTopology;
import com.qlangtech.tis.realtime.yarn.rpc.SynResTarget;
import com.qlangtech.tis.runtime.module.action.BasicModule;
import com.qlangtech.tis.runtime.module.misc.IControlMsgHandler;
import com.qlangtech.tis.runtime.module.misc.IFieldErrorHandler;
import com.qlangtech.tis.runtime.module.misc.impl.DelegateControl4JsonPostMsgHandler;
import com.qlangtech.tis.sql.parser.SqlTaskNode;
import com.qlangtech.tis.sql.parser.SqlTaskNodeMeta;
import com.qlangtech.tis.sql.parser.er.ERRules;
import com.qlangtech.tis.sql.parser.er.PrimaryTableMeta;
import com.qlangtech.tis.sql.parser.er.TabCardinality;
import com.qlangtech.tis.sql.parser.er.TableRelation;
import com.qlangtech.tis.sql.parser.exception.TisSqlFormatException;
import com.qlangtech.tis.sql.parser.meta.ColumnTransfer;
import com.qlangtech.tis.sql.parser.meta.DependencyNode;
import com.qlangtech.tis.sql.parser.meta.NodeType;
import com.qlangtech.tis.sql.parser.meta.Position;
import com.qlangtech.tis.sql.parser.meta.PrimaryLinkKey;
import com.qlangtech.tis.sql.parser.meta.TabExtraMeta;
import com.qlangtech.tis.sql.parser.tuple.creator.EntityName;
import com.qlangtech.tis.trigger.util.JsonUtil;
import com.qlangtech.tis.util.DescriptorsJSON;
import com.qlangtech.tis.util.HeteroList;
import com.qlangtech.tis.util.IPluginContext;
import com.qlangtech.tis.util.UploadPluginMeta;
import com.qlangtech.tis.workflow.dao.IWorkFlowDAO;
import com.qlangtech.tis.workflow.dao.IWorkflowDAOFacade;
import com.qlangtech.tis.workflow.pojo.DatasourceTable;
import com.qlangtech.tis.workflow.pojo.IWorkflow;
import com.qlangtech.tis.workflow.pojo.WorkFlow;
import com.qlangtech.tis.workflow.pojo.WorkFlowBuildHistory;
import com.qlangtech.tis.workflow.pojo.WorkFlowCriteria;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import name.fraser.neil.plaintext.diff_match_patch;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.ServletActionContext;
import org.springframework.beans.factory.annotation.Autowired;

public class OfflineDatasourceAction
extends BasicModule {
    private static final Pattern pattern_table_name = Pattern.compile("[a-z]{1}[\\da-z_]+");
    private static final long serialVersionUID = 1L;
    private OfflineManager offlineManager;
    private static final int COMMITS_LIMIT = 20;
    private static final Pattern DB_ENUM_PATTERN = Pattern.compile("(\\w+?)(\\d+)");
    private static final Pattern WORD_CHARACTER_PATTERN = Pattern.compile("\\w*");
    private static final diff_match_patch DIFF_MATCH_PATCH = new diff_match_patch();
    private IWorkflowDAOFacade offlineDAOFacade;
    public static List<Option> existDbs = null;
    public static final String KEY_DATA_READER_SETTED = "dataReaderSetted";

    private static boolean isWordCharacter(String word) {
        return WORD_CHARACTER_PATTERN.matcher(word).matches();
    }

    @Override
    @Autowired
    public void setOfflineManager(OfflineManager offlineManager) {
        this.offlineManager = offlineManager;
    }

    public static List<Option> getExistDataFlows() {
        WorkFlowCriteria criteria = new WorkFlowCriteria();
        criteria.setOrderByClause("id desc");
        ArrayList opts = Lists.newArrayList();
        Option opt = null;
        IWorkflowDAOFacade wfFacade = BasicServlet.getBeanByType(ServletActionContext.getServletContext(), IWorkflowDAOFacade.class);
        List wfs = wfFacade.getWorkFlowDAO().selectByExample(criteria);
        for (WorkFlow wf : wfs) {
            opt = new Option(wf.getName(), (Object)wf.getName());
            opts.add(opt);
        }
        return opts;
    }

    public void doGetWorkflowId(Context context) throws Exception {
        AppDomainInfo app = this.getAppDomain();
        if (app.getApp().getWorkFlowId() == null) {
            throw new IllegalStateException("WorkFlowId have not been set in collection:" + app.getAppName());
        }
        HashMap result = Maps.newHashMap();
        result.put("workflowId", app.getApp().getWorkFlowId());
        this.setBizResult(context, result);
    }

    @Func(value="datasource_edit", sideEffect=false)
    public void doSelectDbChange(Context context) throws Exception {
        Integer dbid = this.getInt("dbid");
        com.qlangtech.tis.workflow.pojo.DatasourceDb db = this.offlineDAOFacade.getDatasourceDbDAO().selectByPrimaryKey(dbid);
        DataSourceFactory dbPlugin = TIS.getDataBasePlugin((PostedDSProp)new PostedDSProp(DBIdentity.parseId((String)db.getName()), DbScope.DETAILED));
        List tabs = dbPlugin.getTablesInDB().getTabs();
        this.setBizResult(context, tabs.stream().map(t -> new Option(t, t)).collect(Collectors.toList()));
    }

    public void doGetUsableDbNames(Context context) {
        this.setBizResult(context, this.offlineManager.getUsableDbNames());
    }

    private void addPasswordValidator(boolean isNew, final TISDb pojo, Map<String, Validator.FieldValidators> validateRule) {
        Validator[] validatorArray;
        if (isNew) {
            Validator[] validatorArray2 = new Validator[1];
            validatorArray = validatorArray2;
            validatorArray2[0] = Validator.require;
        } else {
            validatorArray = new Validator[]{};
        }
        Validator[] validators = validatorArray;
        validateRule.put("password", new Validator.FieldValidators(validators){

            public void setFieldVal(String val) {
                pojo.setPassword(val);
            }
        });
    }

    private TISTable getTablePojo(Context context) {
        JSONObject form = this.parseJsonPost();
        boolean updateMode = form.getBoolean("isAdd") == false;
        String tableName = form.getString("tableName");
        if (StringUtils.isBlank((String)tableName)) {
            this.addErrorMessage(context, "\u8868\u540d\u4e0d\u80fd\u4e3a\u7a7a");
            return null;
        }
        if (!OfflineDatasourceAction.isWordCharacter(tableName)) {
            this.addErrorMessage(context, "\u8868\u540d\u5fc5\u987b\u7531\u82f1\u6587\u5b57\u7b26\uff0c\u6570\u5b57\u548c\u4e0b\u5212\u7ebf\u7ec4\u6210");
            return null;
        }
        String tableLogicName = tableName;
        Integer partitionNum = form.getIntValue("partitionNum");
        if (partitionNum == null) {
            this.addErrorMessage(context, "\u5206\u533a\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            return null;
        }
        Integer dbId = form.getIntValue("dbId");
        if (dbId == null) {
            this.addErrorMessage(context, "\u6570\u636e\u5e93\u4e0d\u80fd\u4e3a\u7a7a");
            return null;
        }
        Integer partitionInterval = form.getIntValue("partitionInterval");
        if (partitionInterval == null) {
            this.addErrorMessage(context, "\u5206\u533a\u95f4\u9694\u4e0d\u80fd\u4e3a\u7a7a");
            return null;
        }
        String selectSql = form.getString("selectSql");
        if (StringUtils.isBlank((String)selectSql) || StringUtils.contains((String)selectSql, (String)"*")) {
            this.addErrorMessage(context, "sql\u8bed\u53e5\u4e0d\u80fd\u4e3a\u7a7a\u4e14\u4e0d\u80fd\u5305\u542b*");
            return null;
        }
        TISTable tab = new TISTable(tableName, partitionNum.intValue(), dbId, partitionInterval.intValue(), selectSql);
        JSONArray cols = form.getJSONArray("cols");
        JSONObject col = null;
        ColumnMetaData colMeta = null;
        for (int i = 0; i < cols.size(); ++i) {
            col = cols.getJSONObject(i);
            colMeta = new ColumnMetaData(i, col.getString("key"), new DataType(JDBCTypes.parse((int)col.getIntValue("type"))), col.getBoolean("pk").booleanValue());
        }
        if (updateMode) {
            tab.setTabId(form.getInteger("tabId"));
        }
        tab.setDbName(this.offlineDAOFacade.getDatasourceDbDAO().selectByPrimaryKey(dbId).getName());
        return tab;
    }

    @Func(value="datasource_edit")
    public void doAddDatasourceTable(Context context) throws Exception {
        this.errorsPageShow(context);
        TISTable pojo = this.getTablePojo(context);
        if (pojo == null) {
            return;
        }
    }

    public void doGetGitCommitLogs(Context context) throws Exception {
        int projectId;
        String directory = this.getString("directory");
        if (StringUtils.equals((String)"datasource_daily", (String)directory)) {
            projectId = 1375;
        } else if (StringUtils.equals((String)"datasource_online", (String)directory)) {
            projectId = 1375;
        } else if (StringUtils.equals((String)"workflow", (String)directory)) {
            projectId = 1372;
        } else {
            throw new RuntimeException("directory = " + directory + " is wrong!");
        }
        List commits = GitUtils.$().getGitRepositoryCommits(projectId);
        while (commits.size() > 20) {
            commits.remove(commits.size() - 1);
        }
        this.setBizResult(context, commits);
    }

    public void doGetWorkflows(Context context) throws Exception {
        Pager pager = this.createPager();
        IWorkFlowDAO wfDAO = this.getWorkflowDAOFacade().getWorkFlowDAO();
        WorkFlowCriteria query = new WorkFlowCriteria();
        query.createCriteria();
        query.setOrderByClause("id desc");
        pager.setTotalCount(wfDAO.countByExample(query));
        this.setBizResult(context, new BasicModule.PaginationResult(pager, wfDAO.selectByExample(query, pager.getCurPage(), pager.getRowsPerPage()), new Object[0]));
    }

    public void doGetWorkflowTopology(Context context) throws Exception {
        String topology = this.getString("topology");
        if (StringUtils.isEmpty((String)topology)) {
            throw new IllegalStateException("please set param topology");
        }
        IDataxProcessor wf = DataxProcessor.load((IPluginContext)this, (StoreResourceType)StoreResourceType.DataFlow, (String)topology);
        Objects.requireNonNull(wf, "workflow:" + topology + " relevant dataXProcessor can not be null");
        SqlTaskNodeMeta.SqlDataFlowTopology wfTopology = SqlTaskNodeMeta.getSqlDataFlowTopology((String)topology);
        this.setBizResult(context, wfTopology);
    }

    public void doGetWorkflowTopologyERRule(Context context) throws Exception {
        String topology = this.getString("topology");
        if (StringUtils.isEmpty((String)topology)) {
            throw new IllegalStateException("please set param topology");
        }
        SqlTaskNodeMeta.SqlDataFlowTopology wfTopology = SqlTaskNodeMeta.getSqlDataFlowTopology((String)topology);
        this.setBizResult(context, wfTopology.getDumpNodes());
    }

    @Func(value="dataflow_manage", sideEffect=false)
    public void doValidateWorkflowAddJoinComponentForm(Context context) throws Exception {
        JSONObject form = this.parseJsonPost();
        DelegateControl4JsonPostMsgHandler handler = new DelegateControl4JsonPostMsgHandler((IControlMsgHandler)this, form);
        String sql = form.getString("sql");
        String exportName = form.getString("exportName");
        JSONArray dependenceNodes = form.getJSONArray("dependencies");
        final ArrayList dependencyNodes = Lists.newArrayList();
        String validateRuleDependency = "dependencies";
        Map validateRule = Validator.fieldsValidator((Object[])new Object[]{"sql", new Validator.FieldValidators(new Validator[]{Validator.require}){}.addDependency("dependencies"), new IFieldValidator(){

            public boolean validate(IFieldErrorHandler msgHandler, Context context, String fieldKey, String fieldData) {
                Optional sqlErr = SqlTaskNodeMeta.validateSql((String)fieldData, (List)dependencyNodes);
                if (sqlErr.isPresent()) {
                    msgHandler.addFieldError(context, fieldKey, ((TisSqlFormatException)sqlErr.get()).summary(), new Object[0]);
                    return false;
                }
                return true;
            }
        }, "exportName", new Validator.FieldValidators(new Validator[]{Validator.require, Validator.identity}){}, Validator.db_col_name.getFieldValidator(), new IFieldValidator(){

            public boolean validate(IFieldErrorHandler msgHandler, Context context, String fieldKey, String fieldData) {
                return true;
            }
        }, "dependencies", new Validator.FieldValidators(new Validator[]{Validator.require}){

            public void setFieldVal(String val) {
                JSONArray dpts = JSON.parseArray((String)val);
                JSONObject o = null;
                for (int index = 0; index < dpts.size(); ++index) {
                    o = dpts.getJSONObject(index);
                    dependencyNodes.add(OfflineDatasourceAction.createDependencyNode(o));
                }
            }
        }, new IFieldValidator(){

            public boolean validate(IFieldErrorHandler msgHandler, Context context, String fieldKey, String fieldData) {
                JSONArray dpts = JSON.parseArray((String)fieldData);
                if (dpts.size() < 1) {
                    msgHandler.addFieldError(context, fieldKey, "\u8bf7\u9009\u62e9\u4f9d\u8d56\u8868\u8282\u70b9", new Object[0]);
                    return false;
                }
                return true;
            }
        }});
        if (!Validator.validate((IControlMsgHandler)handler, (Context)context, (Map)validateRule)) {
            // empty if block
        }
    }

    private void doUpdateTopology(Context context, TopologyUpdateCallback dbSaverCallback) throws Exception {
        String content = IOUtils.toString((InputStream)this.getRequest().getInputStream(), (String)OfflineDatasourceAction.getEncode());
        JSONObject topology = JSON.parseObject((String)content);
        String topologyName = topology.getString("topologyName");
        if (StringUtils.isEmpty((String)topologyName)) {
            this.addErrorMessage(context, "\u8bf7\u586b\u5199\u6570\u636e\u6d41\u540d\u79f0");
            return;
        }
        File parent = new File(SqlTaskNode.parent, topologyName);
        FileUtils.forceMkdir((File)parent);
        JSONArray nodes = topology.getJSONArray("nodes");
        JSONArray edges = topology.getJSONArray("edges");
        JSONObject o = null;
        JSONObject nodeMeta = null;
        JSONObject nestNodeMeta = null;
        JSONArray joinDependencies = null;
        Object dep = null;
        NodeType nodetype = null;
        DependencyNode dnode = null;
        SqlTaskNodeMeta pnode = null;
        Position pos = null;
        SqlTaskNodeMeta.SqlDataFlowTopology topologyPojo = new SqlTaskNodeMeta.SqlDataFlowTopology();
        SqlTaskNodeMeta.TopologyProfile profile = new SqlTaskNodeMeta.TopologyProfile();
        profile.setName(topologyName);
        profile.setTimestamp(System.currentTimeMillis());
        topologyPojo.setProfile(profile);
        String tabName = null;
        Tab tab = null;
        DuplicateEntitisJudge repeatJudge = new DuplicateEntitisJudge(this, context);
        for (int i = 0; i < nodes.size(); ++i) {
            o = nodes.getJSONObject(i);
            int x = o.getInteger("x");
            if (x < 0) continue;
            int y = o.getInteger("y");
            pos = new Position();
            pos.setX(x);
            pos.setY(y);
            nodeMeta = o.getJSONObject("nodeMeta");
            nestNodeMeta = nodeMeta.getJSONObject("nodeMeta");
            nodetype = NodeType.parse((String)nestNodeMeta.getString("type"));
            if (nodetype == NodeType.DUMP) {
                dnode = new DependencyNode();
                dnode.setDbid(String.valueOf(nodeMeta.get((Object)"dbid")));
                dnode.setId(o.getString("id"));
                tabName = nodeMeta.getString("tabname");
                HashMap dbMap = Maps.newHashMap();
                tab = OfflineDatasourceAction.getDatabase(this, this.offlineManager, this.offlineDAOFacade, dbMap, Integer.parseInt(dnode.getDbid()), tabName);
                dnode.setDbName(tab.db.getName());
                dnode.setName(tab.tab.getName());
                dnode.setTabid(String.valueOf(tabName));
                dnode.setPosition(pos);
                dnode.setType(NodeType.DUMP.getType());
                topologyPojo.addDumpTab(dnode);
                repeatJudge.add(dnode);
                continue;
            }
            if (nodetype == NodeType.JOINER_SQL) {
                pnode = new SqlTaskNodeMeta();
                pnode.setId(o.getString("id"));
                pnode.setPosition(pos);
                pnode.setSql(SqlTaskNodeMeta.processBigContent((String)nodeMeta.getString("sql")));
                pnode.setExportName(nodeMeta.getString("exportName"));
                pnode.setType(NodeType.JOINER_SQL.getType());
                joinDependencies = nodeMeta.getJSONArray("dependencies");
                for (int k = 0; k < joinDependencies.size(); ++k) {
                    dnode = OfflineDatasourceAction.createDependencyNode(joinDependencies.getJSONObject(k));
                    pnode.addDependency(dnode);
                }
                topologyPojo.addNodeMeta(pnode);
                repeatJudge.add(pnode);
                continue;
            }
            throw new IllegalStateException("nodetype:" + nodetype + " is illegal");
        }
        if (!repeatJudge.isSuccess()) {
            return;
        }
        Collection finalNodes = topologyPojo.getFinalNodes().values();
        if (finalNodes.size() > 1) {
            this.addErrorMessage(context, "\u6700\u7ec8\u8f93\u51fa\u8282\u70b9(" + finalNodes.stream().map(r -> r.getExportName()).collect(Collectors.joining(",")) + ")\u4e0d\u80fd\u591a\u4e8e\u4e00\u4e2a");
            return;
        }
        if (finalNodes.size() < 1) {
            // empty if block
        }
        Optional erRule = ERRules.getErRule((String)topologyPojo.getName());
        WorkFlow dataflow = (WorkFlow)dbSaverCallback.execute(this, context, topologyName, topologyPojo);
        this.setBizResult(context, new ERRulesStatus(erRule, dataflow), false);
        SqlTaskNodeMeta.persistence((SqlTaskNodeMeta.SqlDataFlowTopology)topologyPojo, (File)parent);
        IDataxProcessor dfProcessor = DataxProcessor.load((IPluginContext)this, (StoreResourceType)StoreResourceType.DataFlow, (String)topologyName);
        dfProcessor.refresh();
        dbSaverCallback.afterPersistence(this, context, topologyPojo);
        FileUtils.write((File)new File(parent, topologyName + "_content.json"), (CharSequence)content, (String)OfflineDatasourceAction.getEncode(), (boolean)false);
        this.addActionMessage(context, "'" + topologyName + "'\u4fdd\u5b58\u6210\u529f");
    }

    public static DependencyNode createDependencyNode(JSONObject dep) {
        return DependencyNode.create((String)dep.getString("value"), (String)dep.getString("label"), (NodeType)NodeType.DUMP);
    }

    private Integer getWorkflowId(String topologyName) {
        WorkFlowCriteria wc = new WorkFlowCriteria();
        wc.createCriteria().andNameEqualTo(topologyName);
        List workFlows = this.getWorkflowDAOFacade().getWorkFlowDAO().selectByExample(wc);
        Iterator iterator = workFlows.iterator();
        if (iterator.hasNext()) {
            WorkFlow wf = (WorkFlow)iterator.next();
            return wf.getId();
        }
        throw new IllegalStateException("topology:" + topologyName + " can not find workflow record in db");
    }

    public static Tab getDatabase(IPluginContext pluginContext, OfflineManager offlineManager, IWorkflowDAOFacade wfDaoFacade, Map<Integer, com.qlangtech.tis.workflow.pojo.DatasourceDb> dbMap, Integer dbId, String tabName) {
        com.qlangtech.tis.workflow.pojo.DatasourceDb db = null;
        db = dbMap.get(dbId);
        if (db == null) {
            db = wfDaoFacade.getDatasourceDbDAO().selectByPrimaryKey(dbId);
            if (db == null) {
                throw new IllegalStateException("dbId:" + dbId + " relevant 'DatasourceDb' object can not be null");
            }
            dbMap.put(dbId, db);
        }
        DBConfigSuit dbSuit = offlineManager.getDbConfig(pluginContext, db);
        Tab dtab = new Tab(dbSuit.getTab(tabName));
        dtab.setDb(db);
        return dtab;
    }

    public void doGetErRule(Context context) throws Exception {
        String topology = this.getString("topology");
        boolean forceSync = this.getBoolean("sync");
        if (StringUtils.isEmpty((String)topology)) {
            throw new IllegalArgumentException("param 'topology' can not be null");
        }
        ERRules erRule = null;
        if (!ERRules.ruleExist((String)topology)) {
            erRule = new ERRules();
            for (DependencyNode node : this.getDumpNodesFromTopology(topology)) {
                erRule.addDumpNode(node);
            }
        } else {
            erRule = (ERRules)ERRules.getErRule((String)topology).get();
            List oldErRules = erRule.getDumpNodes();
            if (forceSync) {
                List<DependencyNode> dumpNodes = this.getDumpNodesFromTopology(topology);
                List shallBeAdd = dumpNodes.stream().filter(n -> !oldErRules.stream().filter(old -> StringUtils.equals((String)n.getTabid(), (String)old.getTabid())).findAny().isPresent()).collect(Collectors.toList());
                Iterator it = oldErRules.iterator();
                while (it.hasNext()) {
                    DependencyNode old = (DependencyNode)it.next();
                    if (dumpNodes.stream().filter(n -> StringUtils.equals((String)n.getTabid(), (String)old.getTabid())).findAny().isPresent()) continue;
                    it.remove();
                }
                oldErRules.addAll(shallBeAdd);
            }
        }
        this.setBizResult(context, erRule);
    }

    private List<DependencyNode> getDumpNodesFromTopology(String topology) throws Exception {
        SqlTaskNodeMeta.SqlDataFlowTopology wfTopology = SqlTaskNodeMeta.getSqlDataFlowTopology((String)topology);
        return wfTopology.getDumpNodes();
    }

    @Func(value="dataflow_update")
    public void doSaveErRule(Context context) throws Exception {
        JSONObject j = this.parseJsonPost();
        ERRules erRules = new ERRules();
        String topology = j.getString("topologyName");
        if (StringUtils.isEmpty((String)topology)) {
            throw new IllegalArgumentException("param 'topology' can not be empty");
        }
        SqlTaskNodeMeta.SqlDataFlowTopology df = SqlTaskNodeMeta.getSqlDataFlowTopology((String)topology);
        JSONArray edges = j.getJSONArray("edges");
        JSONArray nodes = j.getJSONArray("nodes");
        JSONObject edge = null;
        JSONObject sourceNode = null;
        JSONObject targetNode = null;
        JSONObject linkrule = null;
        JSONArray linkKeyList = null;
        JSONObject link = null;
        JSONObject nodeTuple = null;
        JSONObject node = null;
        JSONObject ermeta = null;
        TableRelation erRelation = null;
        for (int i = 0; i < edges.size(); ++i) {
            edge = edges.getJSONObject(i);
            sourceNode = edge.getJSONObject("sourceNode");
            targetNode = edge.getJSONObject("targetNode");
            linkrule = edge.getJSONObject("linkrule");
            if (linkrule == null) {
                throw new IllegalStateException("linkrule can not be null");
            }
            erRelation = ERRules.$((String)edge.getString("id"), (SqlTaskNodeMeta.SqlDataFlowTopology)df, (String)this.getTableName(targetNode), (String)this.getTableName(sourceNode), (TabCardinality)TabCardinality.parse((String)linkrule.getString("cardinality")));
            linkKeyList = linkrule.getJSONArray("linkKeyList");
            for (int jj = 0; jj < linkKeyList.size(); ++jj) {
                link = linkKeyList.getJSONObject(jj);
                erRelation.addJoinerKey(link.getString("parentKey"), link.getString("childKey"));
            }
            erRules.addRelation(erRelation);
        }
        JSONObject nodeMeta = null;
        JSONObject colTransfer = null;
        DependencyNode dumpNode = null;
        JSONArray columnTransferList = null;
        TabExtraMeta tabMeta = null;
        String sharedKey = null;
        for (int index = 0; index < nodes.size(); ++index) {
            nodeTuple = nodes.getJSONObject(index);
            node = nodeTuple.getJSONObject("node");
            ermeta = node.getJSONObject("extraMeta");
            dumpNode = new DependencyNode();
            if (ermeta != null) {
                tabMeta = new TabExtraMeta();
                tabMeta.setPrimaryIndexTab(ermeta.getBoolean("primaryIndexTab").booleanValue());
                if (tabMeta.isPrimaryIndexTab()) {
                    sharedKey = ermeta.getString("sharedKey");
                    tabMeta.setSharedKey(sharedKey);
                    JSONArray primaryIndexColumnNames = ermeta.getJSONArray("primaryIndexColumnNames");
                    JSONObject primaryIndex = null;
                    ArrayList names = Lists.newArrayList();
                    PrimaryLinkKey plinkKey = null;
                    for (int i = 0; i < primaryIndexColumnNames.size(); ++i) {
                        primaryIndex = primaryIndexColumnNames.getJSONObject(i);
                        plinkKey = new PrimaryLinkKey();
                        plinkKey.setName(primaryIndex.getString("name"));
                        plinkKey.setPk(primaryIndex.getBoolean("pk").booleanValue());
                        names.add(plinkKey);
                    }
                    tabMeta.setPrimaryIndexColumnNames((List)names);
                }
                tabMeta.setMonitorTrigger(ermeta.getBoolean("monitorTrigger").booleanValue());
                tabMeta.setTimeVerColName(null);
                if (tabMeta.isMonitorTrigger()) {
                    tabMeta.setTimeVerColName(ermeta.getString("timeVerColName"));
                }
                columnTransferList = ermeta.getJSONArray("columnTransferList");
                for (int i = 0; i < columnTransferList.size(); ++i) {
                    colTransfer = columnTransferList.getJSONObject(i);
                    tabMeta.addColumnTransfer(new ColumnTransfer(colTransfer.getString("colKey"), colTransfer.getString("transfer"), colTransfer.getString("param")));
                }
                dumpNode.setExtraMeta(tabMeta);
            }
            dumpNode.setId(node.getString("id"));
            nodeMeta = node.getJSONObject("nodeMeta");
            dumpNode.setTabid(nodeMeta.getString("tabid"));
            dumpNode.setDbid(nodeMeta.getString("dbid"));
            Position pos = new Position();
            pos.setX(node.getIntValue("x"));
            pos.setY(node.getIntValue("y"));
            dumpNode.setPosition(pos);
            dumpNode.setName(nodeMeta.getString("tabname"));
            erRules.addDumpNode(dumpNode);
        }
        List primaryTabs = erRules.getPrimaryTabs();
        if (primaryTabs.size() < 1) {
            this.addErrorMessage(context, "\u8fd8\u6ca1\u6709\u5b9a\u4e49ER\u4e3b\u7d22\u5f15\u8868");
            return;
        }
        List pkNames = null;
        for (PrimaryTableMeta meta : primaryTabs) {
            if (StringUtils.isEmpty((String)meta.getSharedKey())) {
                this.addErrorMessage(context, "\u4e3b\u7d22\u5f15\u8868:" + meta.getTabName() + " \u8fd8\u672a\u5b9a\u4e49\u5206\u533a\u952e");
            }
            if ((pkNames = meta.getPrimaryKeyNames()).size() >= 1) continue;
            this.addErrorMessage(context, "\u4e3b\u7d22\u5f15\u8868:" + meta.getTabName() + " \u8fd8\u672a\u5b9a\u4e49\u4e3b\u952e");
        }
        if (this.hasErrors(context)) {
            return;
        }
        ERRules.write((String)topology, (ERRules)erRules);
        long wfId = df.getProfile().getDataflowId();
        if (wfId < 1L) {
            throw new IllegalStateException("topology '" + topology + "' relevant wfid can not be null");
        }
        WorkFlow wf = new WorkFlow();
        wf.setOpTime(new Date());
        WorkFlowCriteria wfCriteria = new WorkFlowCriteria();
        wfCriteria.createCriteria().andIdEqualTo(Integer.valueOf((int)wfId));
        this.getWorkflowDAOFacade().getWorkFlowDAO().updateByExampleSelective(wf, wfCriteria);
    }

    private String getTableName(JSONObject sourceNode) {
        JSONObject nodeMeta = sourceNode.getJSONObject("nodeMeta");
        return nodeMeta.getString("tabname");
    }

    @Func(value="dataflow_update")
    public void doUpdateTopology(Context context) throws Exception {
        this.doUpdateTopology(context, this.createTopologyCreator());
    }

    @Func(value="dataflow_update")
    public void doSaveTopology(Context context) throws Exception {
        this.doUpdateTopology(context, this.createTopologyCreator());
    }

    private CreateTopologyUpdateCallback createTopologyCreator() {
        return new CreateTopologyUpdateCallback(this.getUser(), this.getWorkflowDAOFacade(), true);
    }

    @Func(value="dataflow_update")
    public void doCreateWorkflow(Context context) throws Exception {
        CreateTopologyUpdateCallback createTopology = this.createTopologyCreator();
        Application app = this.parseJsonPost(Application.class);
        String topologyName = app.getProjectName();
        this.setBizResult(context, createTopology.createWorkFlow(topologyName));
    }

    public void doEditWorkflow(Context context) throws Exception {
        WorkflowPojo pojo = this.getWorkflowPojo(context);
        if (pojo == null) {
            return;
        }
        this.offlineManager.editWorkflow(pojo, this, context);
    }

    public void doDeleteWorkflow(Context context) throws Exception {
        Integer id = this.getInt("id");
        if (id == null) {
            this.addErrorMessage(context, "workflow id \u4e0d\u80fd\u4e3a\u7a7a");
            return;
        }
        this.offlineManager.deleteWorkflow(id, this, context);
        this.doGetWorkflows(context);
    }

    private WorkflowPojo getWorkflowPojo(Context context) {
        String name = this.getString("workflowName");
        if (StringUtils.isBlank((String)name)) {
            this.addErrorMessage(context, "\u5de5\u4f5c\u6d41\u540d\u4e0d\u80fd\u4e3a\u7a7a");
            return null;
        }
        if (!OfflineDatasourceAction.isWordCharacter(name)) {
            this.addErrorMessage(context, "\u5de5\u4f5c\u6d41\u540d\u5fc5\u987b\u7531\u82f1\u6587\u5b57\u7b26\uff0c\u6570\u5b57\u548c\u4e0b\u5212\u7ebf\u7ec4\u6210");
            return null;
        }
        String taskScript = this.getString("taskScript");
        if (StringUtils.isBlank((String)taskScript)) {
            this.addErrorMessage(context, "\u811a\u672c\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
            return null;
        }
        return new WorkflowPojo(name, new GitUtils.JoinRule(taskScript));
    }

    public void doGetDatasourceInfo(Context context) throws Exception {
        boolean filterSupportReader = this.getBoolean("filterSupportReader");
        Optional<String> dsNameLike = Optional.ofNullable(this.getString("datasourceName"));
        List<Object> pluginMeta = Collections.emptyList();
        String[] pmeta = this.getStringArray("plugin");
        if (pmeta != null && pmeta.length > 0) {
            pluginMeta = this.getPluginMeta();
        }
        Set filterDescDisplayNames = pluginMeta.stream().map(pm -> pm.getTargetDesc().matchTargetPluginDescName).collect(Collectors.toSet());
        DescriptorExtensionList dbDescs = TIS.get().getDescriptorList(DataSourceFactory.class);
        final Map<String, DataSourceFactory.BaseDataSourceFactoryDescriptor> descMap = dbDescs.stream().map(desc -> (DataSourceFactory.BaseDataSourceFactoryDescriptor)desc).filter(desc -> {
            boolean accept;
            boolean bl = accept = !filterSupportReader || desc.getDefaultDataXReaderDescName().isPresent();
            if (accept && CollectionUtils.isNotEmpty((Collection)filterDescDisplayNames)) {
                return filterDescDisplayNames.contains(desc.getDisplayName());
            }
            return accept;
        }).collect(Collectors.toMap(desc -> StringUtils.lowerCase((String)desc.getDisplayName()), desc -> desc));
        this.setBizResult(context, new ConfigDsMeta(this.offlineManager.getDatasourceInfo(dsNameLike), descMap){

            @Override
            public Collection<DatasourceDb> getDbsSupportDataXReader() {
                return this.dbs.stream().filter(db -> {
                    DataSourceFactory.BaseDataSourceFactoryDescriptor desc = (DataSourceFactory.BaseDataSourceFactoryDescriptor)descMap.get(StringUtils.lowerCase((String)db.extensionDesc));
                    return desc != null;
                }).collect(Collectors.toList());
            }
        });
    }

    public void doGetDatasourceDbById(Context context) {
        Integer dbId = this.getInt("id");
        DBConfigSuit configSuit = this.offlineManager.getDbConfig((IPluginContext)this, dbId);
        this.setBizResult(context, configSuit);
    }

    public void doGetDsTabsVals(Context context) throws IOException {
        JSONObject body = this.parseJsonPost();
        JSONArray tabs = body.getJSONArray("tabs");
        if (tabs == null) {
            throw new IllegalArgumentException("initialize Tabs can not be null");
        }
        List selectedTabs = tabs.stream().map(tab -> (String)tab).collect(Collectors.toList());
        UploadPluginMeta pluginMeta = Objects.requireNonNull(this.getPluginMeta(body), "pluginMeta can not be null");
        HeteroList heteroList = pluginMeta.getHeteroList((IPluginContext)this);
        List readers = heteroList.getItems();
        Object mapCols = null;
        final ArrayList allNewTabs = Lists.newArrayList();
        PluginFormProperties pluginFormPropertyTypes = null;
        HashMap bizResult = Maps.newHashMap();
        HashMap tabDesc = Maps.newHashMap();
        Iterator iterator = readers.iterator();
        if (iterator.hasNext()) {
            DataxReader reader = (DataxReader)iterator.next();
            DescriptorsJSON desc2Json = new DescriptorsJSON(reader.getDescriptor());
            pluginFormPropertyTypes = reader.getDescriptor().getPluginFormPropertyTypes(pluginMeta.getSubFormFilter());
            allNewTabs.addAll(reader.createDefaultTables((IPluginContext)this, selectedTabs, pluginMeta, entry -> tabDesc.put((String)entry.getKey(), JSON.parseObject((String)JsonUtil.toString((Object)desc2Json.getDescriptorsJSON(pluginMeta.getSubFormFilter())))), true));
        }
        Objects.requireNonNull(pluginFormPropertyTypes, "pluginFormPropertyTypes can not be null");
        if (allNewTabs.size() < 1) {
            throw new IllegalStateException("allNewTabs size can not small than 1");
        }
        bizResult.put("tabVals", pluginFormPropertyTypes.accept(new PluginFormProperties.IVisitor(){

            public JSONObject visit(BaseSubFormProperties props) {
                return props.createSubFormVals((Collection)allNewTabs.stream().map(t -> (IdentityName)t).collect(Collectors.toList()));
            }
        }));
        bizResult.put("subformDescriptor", tabDesc);
        this.setBizResult(context, bizResult);
    }

    private UploadPluginMeta getPluginMeta(JSONObject body) {
        String pluginName = body.getString("name");
        boolean require = body.getBooleanValue("require");
        String extraParam = body.getString("extraParam");
        List pluginMetas = UploadPluginMeta.parse((IPluginContext)this, (String[])new String[]{pluginName + ":" + (require ? "require" : "") + "," + extraParam});
        Iterator iterator = pluginMetas.iterator();
        if (iterator.hasNext()) {
            UploadPluginMeta m = (UploadPluginMeta)iterator.next();
            return m;
        }
        throw new IllegalStateException("has not parse meta instance pluginName:" + pluginName);
    }

    public void doGetDatasourceTableById(Context context) throws IOException {
        com.qlangtech.tis.workflow.pojo.DatasourceDb db = this.getDsDb();
        DataxReader dbDataxReader = OfflineManager.getDBDataxReader(this, db.getName());
        this.setBizResult(context, DescriptorsJSON.desc((Descriptor)dbDataxReader.getDescriptor()));
    }

    public void doGetDatasourceTableCols(Context context) throws TableNotFoundException {
        String tableName = this.getString("tabName");
        com.qlangtech.tis.workflow.pojo.DatasourceDb db = this.getDsDb();
        DataxReader dbDataxReader = OfflineManager.getDBDataxReader(this, db.getName());
        List colsMeta = Lists.newArrayList();
        if (dbDataxReader == null) {
            throw TisException.create((String)"\u8be5\u6570\u636e\u6e90\u4e0b\u8fd8\u6ca1\u6709\u9009\u4e2d\u7684\u8868\uff0c\u8bf7\u5148\u70b9\u51fb\u7f16\u8f91\uff0c\u9009\u62e9\u60a8\u6240\u9700\u8981\u7684\u8868");
        }
        colsMeta = dbDataxReader.getTableMetadata(false, (IPluginContext)this, EntityName.parse((String)tableName));
        this.setBizResult(context, colsMeta);
    }

    private com.qlangtech.tis.workflow.pojo.DatasourceDb getDsDb() {
        Integer dbId = this.getInt("id");
        com.qlangtech.tis.workflow.pojo.DatasourceDb db = this.getWorkflowDAOFacade().getDatasourceDbDAO().selectByPrimaryKey(dbId);
        Objects.requireNonNull(db, "db can not be null");
        return db;
    }

    @Func(value="datasource_edit", sideEffect=false)
    public void doReflectTableCols(Context context) throws Exception {
        String topology = this.getString("topology");
        if (StringUtils.isEmpty((String)topology)) {
            throw new IllegalArgumentException("param topology can not be null");
        }
        SqlTaskNodeMeta.SqlDataFlowTopology wfTopology = SqlTaskNodeMeta.getSqlDataFlowTopology((String)topology);
        Map<String, DependencyNode> dumpNodes = wfTopology.getDumpNodes().stream().collect(Collectors.toMap(d -> d.getId(), d -> d));
        JSONArray sqlAry = this.parseJsonArrayPost();
        JSONObject j = null;
        ArrayList colsMeta = Lists.newArrayList();
        SqlCols sqlCols = null;
        DependencyNode dumpNode = null;
        for (int i = 0; i < sqlAry.size(); ++i) {
            j = sqlAry.getJSONObject(i);
            sqlCols = new SqlCols();
            sqlCols.setKey(j.getString("key"));
            String dumpNodeId = sqlCols.getKey();
            dumpNode = dumpNodes.get(dumpNodeId);
            if (dumpNode == null) {
                throw new IllegalStateException("key:" + dumpNodeId + " can not find relevant dump node in topplogy '" + topology + "'");
            }
            DataSourceFactory dsStore = TIS.getDataBasePlugin((PostedDSProp)PostedDSProp.parse((String)dumpNode.getDbName()));
            sqlCols.setCols(dsStore.getTableMetadata(false, (IPluginContext)this, dumpNode.parseEntityName()));
            colsMeta.add(sqlCols);
        }
        this.setBizResult(context, colsMeta);
    }

    @Func(value="dataflow_manage")
    public void doExecuteWorkflow(Context context) throws Exception {
        Integer id = this.getInt("id");
        Boolean dryRun = this.getBoolean("dryRun");
        WorkFlow df = this.getWorkflowDAOFacade().getWorkFlowDAO().selectByPrimaryKey(id);
        WorkFlowBuildHistory latestSuccessWorkflowHistory = this.getDaoContext().getLatestSuccessWorkflowHistory(SynResTarget.transform((Integer)df.getId(), (String)df.getName()));
        DataXJobSubmit jobSubmit = DataXJobSubmit.getDataXJobSubmit();
        Optional<Long> powerJobWorkflowInstanceId = Optional.ofNullable(this.getLong("powerJobWorkflowInstanceId", null));
        TriggerBuildResult buildResult = jobSubmit.triggerWorkflowJob((IControlMsgHandler)this, context, (IWorkflow)df, dryRun, powerJobWorkflowInstanceId, Optional.ofNullable(latestSuccessWorkflowHistory));
        if (buildResult.success) {
            if (buildResult.getTaskid() < 1) {
                throw new IllegalStateException("dataflowid:" + id + " trigger faild,taskId can not be null");
            }
            this.setBizResult(context, buildResult);
        }
    }

    @Func(value="datasource_edit", sideEffect=false)
    public void doGetDsRelevantReaderDesc(Context context) {
        DescriptorExtensionList descriptorList;
        Optional<DataxReader.BaseDataxReaderDescriptor> dataXReaderDesc;
        JSONObject form = this.parseJsonPost();
        Integer dbId = form.getInteger("dbId");
        if (dbId == null) {
            throw new IllegalStateException("dbId can not be null");
        }
        com.qlangtech.tis.workflow.pojo.DatasourceDb db = this.offlineDAOFacade.getDatasourceDbDAO().selectByPrimaryKey(dbId);
        OfflineManager.DBDataXReaderDescName defaultDataXReaderDescName = this.offlineManager.getDBDataXReaderDescName(db.getName());
        HashMap result = Maps.newHashMap();
        if (!defaultDataXReaderDescName.readerDescName.isPresent()) {
            this.addErrorMessage(context, "\u63d2\u4ef6:" + defaultDataXReaderDescName.dsDescriptor.getId() + " \u4e0d\u652f\u6301\u8868\u5bfc\u5165");
            return;
        }
        DataxReader dataxReader = OfflineManager.getDBDataxReader(this, db.getName());
        if (dataxReader != null) {
            result.put(KEY_DATA_READER_SETTED, true);
        }
        if (!(dataXReaderDesc = (descriptorList = TIS.get().getDescriptorList(DataxReader.class)).stream().filter(de -> defaultDataXReaderDescName.getReaderDescName().equals(de.getDisplayName())).map(d -> (DataxReader.BaseDataxReaderDescriptor)d).findFirst()).isPresent()) {
            throw new IllegalStateException("DataXReaderDescName:" + defaultDataXReaderDescName.getReaderDescName() + " can not find relevant DataXReader Descriptor");
        }
        result.put("readerDesc", DescriptorsJSON.desc((Descriptor)((Descriptor)dataXReaderDesc.get())));
        result.put("processMeta", DataXBasicProcessMeta.getDataXBasicProcessMetaByReader(dataXReaderDesc));
        this.setBizResult(context, result);
    }

    @Func(value="datasource_edit", sideEffect=false)
    public void doCheckTableLogicNameRepeat(Context context) {
        JSONObject form = this.parseJsonPost();
        this.errorsPageShow(context);
        boolean updateMode = form.getBoolean("isAdd") == false;
        String table = form.getString("tableName");
        if (StringUtils.isEmpty((String)table)) {
            this.addErrorMessage(context, "\u8868\u540d\u4e0d\u80fd\u4e3a\u7a7a");
            return;
        }
        String tableLogicName = table;
        if (StringUtils.equals((String)"db_config", (String)tableLogicName)) {
            this.addErrorMessage(context, "\u8868\u540d\u4e0d\u80fd\u4e3a'db_config'");
            return;
        }
        Integer dbId = form.getIntValue("dbId");
        com.qlangtech.tis.workflow.pojo.DatasourceDb db = this.offlineDAOFacade.getDatasourceDbDAO().selectByPrimaryKey(dbId);
        if (!updateMode && this.offlineManager.checkTableLogicNameRepeat(tableLogicName, db)) {
            this.addErrorMessage(context, "\u5df2\u7ecf\u6709\u4e86\u76f8\u540c\u903b\u8f91\u540d\u7684\u8868");
            return;
        }
        DataSourceFactory dbPlugin = TIS.getDataBasePlugin((PostedDSProp)new PostedDSProp(DBIdentity.parseId((String)db.getName()), DbScope.DETAILED));
        List cols = null;
        try {
            cols = dbPlugin.getTableMetadata(false, (IPluginContext)this, EntityName.parse((String)table));
            if (cols.size() < 1) {
                this.addErrorMessage(context, "\u8868:[" + table + "]\u6ca1\u6709\u5b9a\u4e49\u5217");
                return;
            }
        }
        catch (TableNotFoundException e) {
            throw new RuntimeException(e);
        }
        StringBuffer extractSQL = ColumnMetaData.buildExtractSQL((String)table, (List)cols);
        TableReflect tableReflect = new TableReflect();
        tableReflect.setCols(cols);
        tableReflect.setSql(extractSQL.toString());
        this.setBizResult(context, tableReflect);
    }

    public void doSyncDb(Context context) {
        Integer dbId = this.getInt("id");
        if (dbId == null) {
            this.addErrorMessage(context, "dbId\u4e0d\u80fd\u4e3a\u7a7a");
            return;
        }
        String dbName = this.getString("dbName");
    }

    public void doSyncTable(Context context) {
        Integer tableId = this.getInt("id");
        if (tableId == null) {
            this.addErrorMessage(context, "table id \u4e0d\u80fd\u4e3a\u7a7a");
            return;
        }
        String tableLogicName = this.getString("tableLogicName");
    }

    public void doSyncDbRecord(Context context) {
        Integer id = this.getInt("id");
        if (id == null) {
            this.addErrorMessage(context, "id\u4e0d\u80fd\u4e3a\u7a7a");
            this.setBizResult(context, false);
            return;
        }
        String name = this.getString("name");
        com.qlangtech.tis.workflow.pojo.DatasourceDb datasourceDb = new com.qlangtech.tis.workflow.pojo.DatasourceDb();
        datasourceDb.setId(id);
        datasourceDb.setName(name);
        datasourceDb.setSyncOnline(new Byte("0"));
        Date now = new Date();
        datasourceDb.setCreateTime(now);
        this.offlineManager.syncDbRecord(datasourceDb, this, context);
    }

    @Func(value="datasource_edit")
    public void doDeleteDatasourceDbById(Context context) throws Exception {
        Integer id = this.getInt("id");
        Objects.requireNonNull(id, "param id can not be null");
        DbScope dbModel = DbScope.parse((String)this.getString("dbModel"));
        this.offlineManager.deleteDbById(id, dbModel, this, context);
    }

    @Func(value="datasource_edit")
    public void doDeleteDatasourceTableById(Context context) {
        Integer id = this.getInt("id");
        this.offlineManager.deleteDatasourceTableById(id, this, context);
    }

    public void doDeleteWorkflowChange(Context context) throws Exception {
        Integer id = this.getInt("id");
        if (id == null) {
            this.addErrorMessage(context, "workflow id\u4e0d\u80fd\u4e3a\u7a7a");
            return;
        }
        this.offlineManager.deleteWorkflowChange(id, this, context);
    }

    public void doConfirmWorkflowChange(Context context) throws Exception {
        Integer id = this.getInt("id");
        if (id == null) {
            this.addErrorMessage(context, "workflow id\u4e0d\u80fd\u4e3a\u7a7a");
            return;
        }
        this.offlineManager.confirmWorkflowChange(id, this, context);
    }

    public void doGetWorkflowConfig(Context context) {
        Integer id = this.getInt("id");
        if (id == null) {
            this.addErrorMessage(context, "\u8bf7\u8f93\u5165\u5de5\u4f5c\u6d41id");
            return;
        }
        this.setBizResult(context, this.offlineManager.getWorkflowConfig(id, true));
    }

    @Override
    @Autowired
    public void setWfDaoFacade(IWorkflowDAOFacade facade) {
        this.offlineDAOFacade = facade;
    }

    public static String getHiveType(int type) {
        switch (type) {
            case -7: 
            case -6: 
            case 4: 
            case 5: {
                return "INT";
            }
            case -5: {
                return "BIGINT";
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                return "DOUBLE";
            }
        }
        return "STRING";
    }

    public static String getDbType(int type) {
        switch (type) {
            case -7: {
                return "BIT";
            }
            case -6: {
                return "TINYINT";
            }
            case 5: {
                return "SMALLINT";
            }
            case 4: {
                return "INTEGER";
            }
            case -5: {
                return "BIGINT";
            }
            case 6: {
                return "FLOAT";
            }
            case 7: {
                return "REAL";
            }
            case 8: {
                return "DOUBLE";
            }
            case 2: {
                return "NUMERIC";
            }
            case 3: {
                return "DECIMAL";
            }
        }
        return "VARCHAR";
    }

    public static class DatasourceDb {
        final int id;
        String name;
        private String iconEndtype;
        private final String extensionDesc;
        List<DatasourceTable> tables;
        private final Date opDate;

        public DatasourceDb(int id, String extensionDesc, Date opDate) {
            if (StringUtils.isEmpty((String)extensionDesc)) {
                throw new IllegalArgumentException("param extensionDesc can not be null");
            }
            this.id = id;
            this.extensionDesc = extensionDesc;
            this.opDate = opDate;
        }

        public Date getOpDate() {
            return this.opDate;
        }

        public String getIconEndtype() {
            return this.iconEndtype;
        }

        public void setIconEndtype(String iconEndtype) {
            this.iconEndtype = iconEndtype;
        }

        public int getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public List<DatasourceTable> getTables() {
            return this.tables;
        }

        public void setTables(List<DatasourceTable> tables) {
            this.tables = tables;
        }

        public void addTable(DatasourceTable datasourceTable) {
            if (this.tables == null) {
                this.tables = new LinkedList<DatasourceTable>();
            }
            this.tables.add(datasourceTable);
        }
    }

    public static class SqlCols {
        private String key;
        List<ColumnMetaData> cols;

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public List<ColumnMetaData> getCols() {
            return this.cols;
        }

        public void setCols(List<ColumnMetaData> cols) {
            this.cols = cols;
        }
    }

    public static class ConfigDsMeta
    extends PluginDescMeta {
        final Collection<DatasourceDb> dbs;

        public ConfigDsMeta(Collection<DatasourceDb> dbs, Map<String, DataSourceFactory.BaseDataSourceFactoryDescriptor> descMap) {
            super(descMap.values());
            this.dbs = dbs;
            this.dbs.forEach(db -> {
                IEndTypeGetter.EndType endType;
                IEndTypeGetter.Icon icon;
                DataSourceFactory.BaseDataSourceFactoryDescriptor desc = (DataSourceFactory.BaseDataSourceFactoryDescriptor)descMap.get(StringUtils.lowerCase((String)db.extensionDesc));
                if (desc != null && (icon = (endType = desc.getEndType()).getIcon()) != null) {
                    db.setIconEndtype(endType.getVal());
                }
            });
        }

        public Collection<DatasourceDb> getDbs() {
            return this.dbs;
        }

        public Collection<DatasourceDb> getDbsSupportDataXReader() {
            return Collections.emptyList();
        }
    }

    private static interface TopologyUpdateCallback {
        public <T> T execute(IPluginContext var1, Context var2, String var3, SqlTaskNodeMeta.SqlDataFlowTopology var4);

        default public void afterPersistence(IPluginContext pluginContext, Context context, SqlTaskNodeMeta.SqlDataFlowTopology topology) {
        }
    }

    public static class CreateTopologyUpdateCallback
    implements TopologyUpdateCallback {
        private final IUser user;
        private final IWorkflowDAOFacade offlineDAOFacade;
        private final boolean idempotent;

        public CreateTopologyUpdateCallback(IUser user, IWorkflowDAOFacade offlineDAOFacade) {
            this(user, offlineDAOFacade, false);
        }

        public CreateTopologyUpdateCallback(IUser user, IWorkflowDAOFacade offlineDAOFacade, boolean idempotent) {
            this.user = user;
            this.offlineDAOFacade = offlineDAOFacade;
            this.idempotent = idempotent;
        }

        @Override
        public void afterPersistence(IPluginContext pluginContext, Context context, SqlTaskNodeMeta.SqlDataFlowTopology topology) {
            DataxAction.generateDataXCfgs(pluginContext, context, StoreResourceType.DataFlow, topology.getName(), false);
            DataXJobSubmit.getPowerJobSubmit().ifPresent(submit -> submit.createWorkflowJob((IControlMsgHandler)pluginContext, context, (IDataFlowTopology)topology));
        }

        public WorkFlow execute(IPluginContext pluginContext, Context context, String tname, SqlTaskNodeMeta.SqlDataFlowTopology topology) {
            String topologyName = topology.getName();
            WorkFlow wf = this.createWorkFlow(topologyName);
            topology.getProfile().setDataflowId((long)wf.getId().intValue());
            return wf;
        }

        public WorkFlow createWorkFlow(String topologyName) {
            if (StringUtils.isEmpty((String)topologyName)) {
                throw new IllegalArgumentException("param topologyName can not be null");
            }
            if (this.idempotent) {
                WorkFlowCriteria wfCriteria = new WorkFlowCriteria();
                wfCriteria.createCriteria().andNameEqualTo(topologyName);
                Iterator iterator = this.offlineDAOFacade.getWorkFlowDAO().selectByExample(wfCriteria).iterator();
                if (iterator.hasNext()) {
                    WorkFlow wf = (WorkFlow)iterator.next();
                    return wf;
                }
            }
            WorkFlow workFlow = new WorkFlow();
            workFlow.setName(topologyName);
            workFlow.setOpUserId(Integer.valueOf(Integer.parseInt(this.user.getId())));
            workFlow.setOpUserName(this.user.getName());
            workFlow.setGitPath(String.valueOf(System.currentTimeMillis()));
            workFlow.setCreateTime(new Date());
            workFlow.setInChange(new Byte("1"));
            Integer dfId = this.offlineDAOFacade.getWorkFlowDAO().insertSelective(workFlow);
            workFlow.setId(dfId);
            return workFlow;
        }
    }

    private static class Tab {
        private com.qlangtech.tis.workflow.pojo.DatasourceDb db;
        private final ISelectedTab tab;

        public Tab(ISelectedTab tab) {
            this.tab = tab;
        }

        public com.qlangtech.tis.workflow.pojo.DatasourceDb getDb() {
            return this.db;
        }

        public void setDb(com.qlangtech.tis.workflow.pojo.DatasourceDb db) {
            this.db = db;
        }

        public ISelectedTab getTab() {
            return this.tab;
        }
    }

    public static class ERRulesStatus {
        private final ERRules erRules;
        private final WorkFlow dataflow;
        private boolean exist;

        public ERRulesStatus(Optional<ERRules> erRules, WorkFlow dataflow) {
            this.dataflow = Objects.requireNonNull(dataflow, "param dataflow can not be null");
            this.exist = erRules.isPresent();
            this.erRules = this.exist ? erRules.get() : null;
        }

        public Integer getId() {
            return this.dataflow.getId();
        }

        public boolean isErExist() {
            return this.exist;
        }

        public boolean isErPrimaryTabSet() {
            if (!this.isErExist()) {
                return false;
            }
            return this.erRules.getPrimaryTabs().size() > 0;
        }
    }

    private class DbEnumShow
    implements Comparable<DbEnumShow> {
        private String dbName;
        private String host;

        DbEnumShow(String dbName, String host) {
            this.dbName = dbName;
            this.host = host;
        }

        public String getDbName() {
            return this.dbName;
        }

        public String getHost() {
            return this.host;
        }

        @Override
        public int compareTo(DbEnumShow o) {
            String dbName = this.getDbName();
            String anotherDbName = o.getDbName();
            if (dbName.length() == anotherDbName.length()) {
                return this.getDbName().compareTo(o.getDbName());
            }
            return dbName.length() - anotherDbName.length();
        }
    }
}

