/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.offline.module.action;

import com.alibaba.citrus.turbine.Context;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.qlangtech.tis.runtime.module.misc.IControlMsgHandler;
import com.qlangtech.tis.sql.parser.SqlTaskNodeMeta;
import com.qlangtech.tis.sql.parser.meta.DependencyNode;
import com.qlangtech.tis.sql.parser.meta.NodeType;
import java.util.Map;
import java.util.Set;

public class DuplicateEntitisJudge {
    private Set<String> relevantEntitis = Sets.newHashSet();
    private Set<String> duplicateEntities = Sets.newHashSet();
    private Map<String, DependencyNode> dumpNodes = Maps.newHashMap();
    private Map<String, SqlTaskNodeMeta> joinNodes = Maps.newHashMap();
    private final Context context;
    private final IControlMsgHandler module;

    public DuplicateEntitisJudge(IControlMsgHandler module, Context context) {
        this.context = context;
        this.module = module;
    }

    public void add(DependencyNode dnode) {
        this.add(dnode.getName());
        this.dumpNodes.put(dnode.getId(), dnode);
    }

    public void add(SqlTaskNodeMeta pnode) {
        this.add(pnode.getExportName());
        this.joinNodes.put(pnode.getId(), pnode);
    }

    public boolean isSuccess() {
        boolean hasDuplicate;
        boolean bl = hasDuplicate = !this.getDuplicateEntities().isEmpty();
        if (hasDuplicate) {
            this.module.addErrorMessage(this.context, "\u540d\u4e3a" + String.join((CharSequence)",", this.getDuplicateEntities()) + " \u7684\u8282\u70b9\u5b58\u5728\u91cd\u590d");
            return false;
        }
        NodeType type = null;
        for (SqlTaskNodeMeta joinNode : this.joinNodes.values()) {
            for (DependencyNode dpt : joinNode.getDependencies()) {
                type = dpt.parseNodeType(false);
                if (type == NodeType.DUMP || type == NodeType.JOINER_SQL) {
                    if (this.dumpNodes.get(dpt.getId()) != null || this.joinNodes.get(dpt.getId()) != null) continue;
                    this.addLackNodeError(joinNode, dpt);
                    continue;
                }
                throw new UnsupportedOperationException(String.valueOf(type));
            }
        }
        return !this.context.hasErrors();
    }

    public void addLackNodeError(SqlTaskNodeMeta joinNode, DependencyNode dpt) {
        this.module.addErrorMessage(this.context, "\u540d\u4e3a'" + joinNode.getExportName() + "' \u7684\u8282\u7684\u4f9d\u8d56\u8282\u70b9'" + dpt.getName() + "'\u4e0d\u5b58\u5728,\u8bf7\u786e\u8ba4\u662f\u5426\u5df2\u7ecf\u5220\u9664\uff1f");
    }

    public Set<String> getDuplicateEntities() {
        return this.duplicateEntities;
    }

    private void add(String entity) {
        if (!this.relevantEntitis.add(entity)) {
            this.duplicateEntities.add(entity);
        }
    }
}

