/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.manage.spring.aop;

import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.ActionProxy;
import com.opensymphony.xwork2.interceptor.MethodFilterInterceptor;
import com.qlangtech.tis.manage.common.IUser;
import com.qlangtech.tis.manage.common.MockContext;
import com.qlangtech.tis.manage.common.RunContextGetter;
import com.qlangtech.tis.manage.common.UserUtils;
import com.qlangtech.tis.manage.common.valve.AjaxValve;
import com.qlangtech.tis.manage.spring.aop.Func;
import com.qlangtech.tis.runtime.module.action.BasicModule;
import com.qlangtech.tis.runtime.module.action.LoginAction;
import com.qlangtech.tis.runtime.module.action.SysInitializeAction;
import com.qlangtech.tis.runtime.module.action.UserAction;
import java.lang.reflect.Method;
import java.util.Collections;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.ServletActionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class AuthorityCheckAdvice
extends MethodFilterInterceptor {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(AuthorityCheckAdvice.class);
    private RunContextGetter daoContextGetter;

    @Autowired
    public final void setRunContextGetter(RunContextGetter daoContextGetter) {
        this.daoContextGetter = daoContextGetter;
    }

    protected boolean applyInterceptor(ActionInvocation invocation) {
        return AuthorityCheckAdvice.inNotForwardProcess();
    }

    protected String doIntercept(ActionInvocation invocation) throws Exception {
        BasicModule action = (BasicModule)invocation.getAction();
        if (!SysInitializeAction.isSysInitialized()) {
            if (!(action instanceof SysInitializeAction)) {
                HttpServletResponse response = ServletActionContext.getResponse();
                AjaxValve.writeInfo2Client(() -> true, response, false, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), UserAction.createSysInfo());
                return "none";
            }
            SysInitializeAction initAction = (SysInitializeAction)action;
            initAction.doInit(new MockContext());
            return initAction.getReturnCode();
        }
        Method method = action.getExecuteMethod();
        Func func = method.getAnnotation(Func.class);
        BasicModule.Rundata rundata = BasicModule.getRundataInstance();
        IUser user = UserUtils.getUser(ServletActionContext.getRequest(), this.daoContextGetter.get());
        if (!user.hasLogin() && !AuthorityCheckAdvice.isProcessLoginOrInConfigNamespace(invocation)) {
            rundata.redirectTo("/runtime/login.htm");
            return "none";
        }
        action.setAuthtoken(user);
        if (func == null) {
            log.debug("target:" + action.getClass().getSimpleName() + ",method:" + method.getName() + " has not set FUNC");
            return invocation.invoke();
        }
        return invocation.invoke();
    }

    public static boolean isProcessLoginOrInConfigNamespace(ActionInvocation invocation) {
        BasicModule action = (BasicModule)invocation.getAction();
        ActionProxy proxy = invocation.getProxy();
        String namespace = proxy.getNamespace();
        return action instanceof UserAction || action instanceof LoginAction || StringUtils.startsWith((CharSequence)namespace, (CharSequence)"/config");
    }

    public static boolean inNotForwardProcess() {
        HttpServletRequest request = ServletActionContext.getRequest();
        return request.getAttribute("emethod") == null;
    }
}

