/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.manage.spring;

import com.qlangtech.tis.manage.common.Config;
import com.qlangtech.tis.web.start.TisAppLaunch;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.web.context.support.ServletContextResourcePatternResolver;
import org.springframework.web.context.support.XmlWebApplicationContext;

public class TISWebApplicationContext
extends XmlWebApplicationContext {
    private static final String RESOURCE_PREFIX_TIS_CLASSPATH = "tis:";

    protected ResourcePatternResolver getResourcePatternResolver() {
        return new TISResourcePatternResolver((ResourceLoader)this);
    }

    protected DefaultListableBeanFactory createBeanFactory() {
        DefaultListableBeanFactory beanFactory = super.createBeanFactory();
        beanFactory.setBeanClassLoader(TISWebApplicationContext.class.getClassLoader());
        return beanFactory;
    }

    private static class TISClassPathResource
    extends ClassPathResource {
        public TISClassPathResource(String path) {
            super(path);
        }

        public InputStream getInputStream() throws IOException {
            try {
                return super.getInputStream();
            }
            catch (IOException e) {
                Config.TestCfgStream stream = Config.openTestCfgStream();
                stream.validate((Throwable)e);
                TisAppLaunch.setTest((boolean)true);
                return stream.getPropsStream();
            }
        }
    }

    private static class TISResourcePatternResolver
    extends ServletContextResourcePatternResolver {
        public TISResourcePatternResolver(ResourceLoader resourceLoader) {
            super(resourceLoader);
        }

        public Resource[] getResources(String locationPattern) throws IOException {
            if (StringUtils.startsWith((String)locationPattern, (String)TISWebApplicationContext.RESOURCE_PREFIX_TIS_CLASSPATH)) {
                return new Resource[]{new TISClassPathResource(StringUtils.substringAfter((String)locationPattern, (String)TISWebApplicationContext.RESOURCE_PREFIX_TIS_CLASSPATH))};
            }
            return super.getResources(locationPattern);
        }
    }
}

