/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.manage.spring;

import com.qlangtech.tis.manage.common.Config;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Objects;
import javax.naming.NamingException;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jndi.JndiAccessor;

public class TISDataSourceFactory
implements FactoryBean<BasicDataSource>,
InitializingBean,
DisposableBean {
    private static final Logger logger = LoggerFactory.getLogger(TISDataSourceFactory.class);
    public static final ThreadLocal<SystemDBInit> systemDBInitThreadLocal = new ThreadLocal();
    public static IDSCreatorInspect dsCreateInspector = new IDSCreatorInspect(){};
    private boolean getDSFromJNDI;
    private BasicDataSource dataSource;
    private final JndiAccessor jndiAccessor = new JndiAccessor();

    public void setGetDSFromJNDI(boolean getDSFromJNDI) {
        this.getDSFromJNDI = getDSFromJNDI;
    }

    public void destroy() throws Exception {
        try {
            this.dataSource.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void afterPropertiesSet() throws Exception {
        Config.TisDbConfig dbType = Config.getDbCfg();
        this.dataSource = TISDataSourceFactory.createDataSource((Config.SysDBType)dbType.dbtype, (Config.TisDbConfig)dbType, (boolean)true, (boolean)false, (boolean)this.getDSFromJNDI, (TISDataSourceFactory)this).dataSource;
    }

    private static BasicDataSource getJndiDatasource(TISDataSourceFactory dsFactory) {
        Objects.requireNonNull(dsFactory, "param dsFactory can not be null");
        try {
            int i = 0;
            while (i < 3) {
                BasicDataSource lookup = (BasicDataSource)dsFactory.jndiAccessor.getJndiTemplate().lookup("java:tisDataSource", BasicDataSource.class);
                if (lookup == null) {
                    Thread.sleep(4000L);
                    continue;
                }
                return lookup;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        throw new IllegalStateException(" can not find jndi datasource:java:tisDataSource instance");
    }

    public BasicDataSource getObject() throws Exception {
        return this.dataSource;
    }

    public Class<BasicDataSource> getObjectType() {
        return BasicDataSource.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public static SystemDBInit createDataSource(Config.SysDBType dbType, Config.TisDbConfig dbCfg, boolean useDBName, boolean dbAutoCreate) {
        if (systemDBInitThreadLocal.get() != null) {
            return systemDBInitThreadLocal.get();
        }
        return TISDataSourceFactory.createDataSource(dbType, dbCfg, useDBName, dbAutoCreate, false, null);
    }

    public static SystemDBInit createDataSource(Config.SysDBType dbType, Config.TisDbConfig dbCfg, boolean useDBName, boolean dbAutoCreate, boolean getDSFromJNDI, TISDataSourceFactory dsFactory) {
        Objects.requireNonNull(dbType, "param dbType can not be null");
        if (StringUtils.isEmpty((String)dbCfg.dbname)) {
            throw new IllegalArgumentException("param dbName can not be null");
        }
        BasicDataSource dataSource = new BasicDataSource();
        if (Config.SysDBType.MySQL == dbType) {
            dataSource.setDriverClassName("com.mysql.jdbc.Driver");
            dataSource.setUrl("jdbc:mysql://" + dbCfg.url + ":" + dbCfg.port + (String)(useDBName ? "/" + dbCfg.dbname : "") + "?useSSL=false&useUnicode=yes&characterEncoding=utf8");
            if (StringUtils.isBlank((String)dbCfg.dbname)) {
                throw new IllegalStateException("dbCfg.dbname in config.properites can not be null");
            }
            dataSource.setUsername(dbCfg.userName);
            dataSource.setPassword(dbCfg.password);
            dataSource.setValidationQuery("select 1");
            return new SystemDBInit(dataSource){

                @Override
                public boolean dbTisConsoleExist(Config.TisDbConfig dbCfg, Statement statement) throws SQLException {
                    boolean containTisConsole = false;
                    try (ResultSet showDatabaseResult = statement.executeQuery("show databases");){
                        while (showDatabaseResult.next()) {
                            if (!dbCfg.dbname.equals(showDatabaseResult.getString(1))) continue;
                            containTisConsole = true;
                        }
                    }
                    return containTisConsole;
                }

                @Override
                public void dropDB(Config.TisDbConfig dbCfg, Statement statement) throws SQLException {
                    statement.execute("drop database if exists " + dbCfg.dbname);
                }

                @Override
                public void createSysDB(Config.TisDbConfig dbCfg, Statement statement) throws SQLException {
                    statement.addBatch("create database " + dbCfg.dbname + ";");
                    statement.addBatch("use " + dbCfg.dbname + ";");
                    statement.executeBatch();
                }

                @Override
                public boolean shallSkip(String sql) {
                    return StringUtils.startsWithIgnoreCase((String)sql, (String)"CREATE DATABASE") || StringUtils.startsWithIgnoreCase((String)sql, (String)"USE");
                }
            };
        }
        if (Config.SysDBType.DERBY == dbType) {
            if (getDSFromJNDI) {
                dataSource = TISDataSourceFactory.getJndiDatasource(dsFactory);
            } else {
                System.setProperty("derby.system.home", Config.getDataDir().getAbsolutePath());
                dataSource.setDriverClassName("org.apache.derby.jdbc.EmbeddedDriver");
                String connURL = "jdbc:derby:" + dbCfg.dbname + ";territory=en_US;collation=TERRITORY_BASED:PRIMARY;create=" + dbAutoCreate;
                dataSource.setUrl(connURL);
                if (!dbAutoCreate) {
                    try {
                        Objects.requireNonNull(dsFactory, "dsFactory can not be null");
                        Objects.requireNonNull(dsFactory.jndiAccessor.getJndiTemplate(), "getJndiTemplate can not be null");
                        dsFactory.jndiAccessor.getJndiTemplate().bind("java:tisDataSource", (Object)dataSource);
                        logger.info("have register the jndi:java:tisDataSource datasource into context");
                    }
                    catch (NamingException e) {
                        throw new RuntimeException("dbAutoCreate:" + dbAutoCreate + "jndi:java:tisDataSource", e);
                    }
                }
            }
            dsCreateInspector.checkDataSource(getDSFromJNDI, dataSource);
            return new SystemDBInit(dataSource){

                @Override
                public boolean dbTisConsoleExist(Config.TisDbConfig dbCfg, Statement statement) throws SQLException {
                    try {
                        statement.executeQuery("select * from application FETCH NEXT 1 ROWS ONLY");
                    }
                    catch (SQLException e) {
                        String theError = e.getSQLState();
                        if (theError.equals("42X05")) {
                            return false;
                        }
                        throw e;
                    }
                    return true;
                }

                @Override
                public String processSql(StringBuffer result) {
                    String sql = StringUtils.remove((String)super.processSql(result), (String)"`");
                    sql = StringUtils.substringBefore((String)sql, (String)";");
                    return sql;
                }

                @Override
                public void dropDB(Config.TisDbConfig dbCfg, Statement statement) throws SQLException {
                    try {
                        statement.execute("drop table application ");
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }

                @Override
                public boolean shallSkip(String sql) {
                    return StringUtils.startsWithIgnoreCase((String)sql, (String)"drop");
                }

                @Override
                public void createSysDB(Config.TisDbConfig dbCfg, Statement statement) throws SQLException {
                }
            };
        }
        throw new IllegalStateException("dbType:" + dbType + " is illegal");
    }

    public static interface IDSCreatorInspect {
        default public void checkDataSource(boolean getDSFromJNDI, BasicDataSource dataSource) {
        }
    }

    public static abstract class SystemDBInit {
        private final BasicDataSource dataSource;

        public SystemDBInit(BasicDataSource dataSource) {
            this.dataSource = dataSource;
        }

        public BasicDataSource getDS() {
            return this.dataSource;
        }

        public boolean dbTisConsoleExist(Config.TisDbConfig dbCfg) throws SQLException {
            try (Connection conn = this.getDS().getConnection();){
                boolean bl;
                block12: {
                    Statement statement = conn.createStatement();
                    try {
                        bl = this.dbTisConsoleExist(dbCfg, statement);
                        if (statement == null) break block12;
                    }
                    catch (Throwable throwable) {
                        if (statement != null) {
                            try {
                                statement.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    statement.close();
                }
                return bl;
            }
        }

        public abstract boolean dbTisConsoleExist(Config.TisDbConfig var1, Statement var2) throws SQLException;

        public abstract void createSysDB(Config.TisDbConfig var1, Statement var2) throws SQLException;

        public void close() {
            try {
                this.dataSource.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }

        public abstract void dropDB(Config.TisDbConfig var1, Statement var2) throws SQLException;

        public String processSql(StringBuffer result) {
            return result.toString();
        }

        public abstract boolean shallSkip(String var1);
    }
}

