/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.manage.spring;

import com.google.common.collect.Lists;
import com.qlangtech.tis.manage.biz.dal.dao.IApplicationDAO;
import com.qlangtech.tis.manage.common.AppAndRuntime;
import com.qlangtech.tis.manage.common.DefaultFilter;
import com.qlangtech.tis.pubhook.common.RunEnvironment;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class EnvironmentBindService<T> {
    static final List<Runnable> cleanableListeners = Lists.newArrayList();
    protected static final Pattern ZK_ADDRESS = Pattern.compile("([^,]+?):\\d+");
    protected final Map<RunEnvironment, T> serviceMap = Collections.synchronizedMap(new HashMap());
    private IApplicationDAO applicationDAO;

    public static void cleanCacheService() {
        cleanableListeners.forEach(runnable -> runnable.run());
    }

    public EnvironmentBindService() {
        cleanableListeners.add(() -> this.serviceMap.clear());
    }

    protected void validateServerIsReachable(String ipaddress) {
    }

    @Autowired
    public void setApplicationDAO(IApplicationDAO applicationDAO) {
        this.applicationDAO = applicationDAO;
    }

    public T getInstance() {
        AppAndRuntime appAndRuntime = AppAndRuntime.getAppAndRuntime();
        if (appAndRuntime == null) {
            appAndRuntime = new AppAndRuntime();
            appAndRuntime.setRuntime(DefaultFilter.getRuntime());
        }
        RunEnvironment runtime = appAndRuntime.getRuntime();
        return this.getInstance(runtime);
    }

    protected final void cleanInstance(RunEnvironment runtime) {
        this.serviceMap.remove(runtime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    T getInstance(RunEnvironment runtime) {
        T service = null;
        T t = this.serviceMap.get(runtime);
        service = t;
        if (t == null) {
            Map<RunEnvironment, T> map = this.serviceMap;
            synchronized (map) {
                T t2 = this.serviceMap.get(runtime);
                service = t2;
                if (t2 == null) {
                    T t3 = this.createSerivce(runtime);
                    service = t3;
                    this.serviceMap.put(runtime, t3);
                }
            }
        }
        if (service == null) {
            throw new IllegalStateException("the current factory can not be null,runtime:" + runtime);
        }
        return service;
    }

    protected abstract T createSerivce(RunEnvironment var1);
}

