/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.manage.servlet;

import com.qlangtech.tis.manage.common.Config;
import com.qlangtech.tis.manage.common.ConfigFileContext;
import com.qlangtech.tis.manage.common.HttpUtils;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletException;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketAdapter;
import org.eclipse.jetty.websocket.servlet.WebSocketServlet;
import org.eclipse.jetty.websocket.servlet.WebSocketServletFactory;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskFeedbackServlet
extends WebSocketServlet {
    private static final Logger logger = LoggerFactory.getLogger(TaskFeedbackServlet.class);
    private static final long serialVersionUID = 1L;

    public void init() throws ServletException {
        super.init();
    }

    public void configure(WebSocketServletFactory factory) {
        factory.getPolicy().setIdleTimeout(240000L);
        factory.getPolicy().setAsyncWriteTimeout(-1L);
        factory.register(FullAssembleLogSocket.class);
    }

    public static class FullAssembleLogSocket
    extends WebSocketAdapter {
        long taskid;
        private final ScheduledExecutorService falconSendScheduler = Executors.newScheduledThreadPool(1);

        public void onWebSocketConnect(Session sess) {
            super.onWebSocketConnect(sess);
            this.taskid = Long.parseLong(this.getParameter("taskid"));
            logger.info("start a new log fetch tasklog status taskid:" + this.taskid);
            this.falconSendScheduler.scheduleAtFixedRate(() -> {
                try {
                    URL url = new URL(Config.getAssembleHost() + "/task_status?taskid=" + this.taskid);
                    JSONObject result = (JSONObject)HttpUtils.processContent((URL)url, (ConfigFileContext.StreamProcess)new ConfigFileContext.StreamProcess<JSONObject>(){

                        public JSONObject p(int status, InputStream stream, Map<String, List<String>> headerFields) {
                            JSONTokener tokener = new JSONTokener((Reader)new InputStreamReader(stream, Charset.forName("utf8")));
                            return new JSONObject(tokener);
                        }
                    });
                    boolean success = result.getBoolean("success");
                    if (success) {
                        this.getRemote().sendString(String.valueOf(result.get("status")));
                    }
                }
                catch (Throwable e) {
                    logger.error(e.getMessage(), e);
                }
            }, 5L, 2L, TimeUnit.SECONDS);
        }

        private String getParameter(String key) {
            Iterator iterator = ((List)this.getSession().getUpgradeRequest().getParameterMap().get(key)).iterator();
            if (iterator.hasNext()) {
                String v = (String)iterator.next();
                return v;
            }
            throw new IllegalArgumentException("key:" + key + " relevant val is not exist in request");
        }

        public void onWebSocketClose(int statusCode, String reason) {
            super.onWebSocketClose(statusCode, reason);
            logger.info("close tasklog status monitor taskid:" + this.taskid);
            this.falconSendScheduler.shutdownNow();
        }
    }
}

