/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.manage.servlet;

import ch.qos.logback.core.helpers.CyclicBuffer;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;
import com.qlangtech.tis.assemble.ExecResult;
import com.qlangtech.tis.assemble.FullbuildPhase;
import com.qlangtech.tis.cloud.ITISCoordinator;
import com.qlangtech.tis.coredefine.module.action.ExtendWorkFlowBuildHistory;
import com.qlangtech.tis.coredefine.module.action.TISK8sDelegate;
import com.qlangtech.tis.datax.DataXName;
import com.qlangtech.tis.exec.ExecutePhaseRange;
import com.qlangtech.tis.fullbuild.phasestatus.PhaseStatusCollection;
import com.qlangtech.tis.manage.servlet.BasicServlet;
import com.qlangtech.tis.manage.spring.ZooKeeperGetter;
import com.qlangtech.tis.pubhook.common.RunEnvironment;
import com.qlangtech.tis.rpc.grpc.log.LogCollectorClient;
import com.qlangtech.tis.rpc.grpc.log.stream.PExecuteState;
import com.qlangtech.tis.rpc.grpc.log.stream.PMonotorTarget;
import com.qlangtech.tis.rpc.grpc.log.stream.PPhaseStatusCollection;
import com.qlangtech.tis.trigger.jst.ILogListener;
import com.qlangtech.tis.trigger.jst.MonotorTarget;
import com.qlangtech.tis.trigger.jst.PayloadMonitorTarget;
import com.qlangtech.tis.trigger.jst.RegisterMonotorTarget;
import com.qlangtech.tis.trigger.socket.ExecuteState;
import com.qlangtech.tis.trigger.socket.LogType;
import com.qlangtech.tis.workflow.dao.IWorkflowDAOFacade;
import com.qlangtech.tis.workflow.pojo.WorkFlowBuildHistory;
import com.tis.hadoop.rpc.AdapterAssembleSvcCompsiteCallback;
import com.tis.hadoop.rpc.RpcServiceReference;
import com.tis.hadoop.rpc.StatusRpcClientFactory;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.StreamObserver;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketAdapter;
import org.eclipse.jetty.websocket.servlet.WebSocketServlet;
import org.eclipse.jetty.websocket.servlet.WebSocketServletFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogFeedbackServlet
extends WebSocketServlet {
    private static final Logger logger = LoggerFactory.getLogger(LogFeedbackServlet.class);
    private static final long serialVersionUID = 1L;
    private RpcServiceReference statusRpc;
    private IWorkflowDAOFacade wfDao;
    private ZooKeeperGetter zkGetter;
    private static final ExecutorService executorService = Executors.newCachedThreadPool();
    private static final JsonFormat.Printer JsonFormatPrinter = JsonFormat.printer();

    private RpcServiceReference getStatusRpc() {
        if (this.statusRpc != null) {
            return this.statusRpc;
        }
        try {
            Objects.requireNonNull(this.zkGetter, "zkGetter can not be null");
            this.statusRpc = StatusRpcClientFactory.getService((ITISCoordinator)((ITISCoordinator)this.zkGetter.getInstance()), (AdapterAssembleSvcCompsiteCallback[])new AdapterAssembleSvcCompsiteCallback[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return this.statusRpc;
    }

    public void configure(WebSocketServletFactory factory) {
        factory.getPolicy().setIdleTimeout(240000L);
        factory.getPolicy().setAsyncWriteTimeout(-1L);
        factory.setCreator((req, rep) -> new LogSocket());
        this.zkGetter = BasicServlet.getBeanByType(this.getServletContext(), ZooKeeperGetter.class);
        this.wfDao = BasicServlet.getBeanByType(this.getServletContext(), IWorkflowDAOFacade.class);
    }

    public static class JSONPojo<T> {
        private LogType logtype;
        private T data;

        public static String serializeJSON(ExecuteState event) {
            return JSON.toJSONString(new JSONPojo<Object>(event.getLogType(), event.getMsg()), (boolean)true);
        }

        public JSONPojo(LogType logtype, T data) {
            this.logtype = logtype;
            this.data = data;
        }

        public String getLogtype() {
            return this.logtype.getValue();
        }

        public void setLogtype(LogType logtype) {
            this.logtype = logtype;
        }

        public T getData() {
            return this.data;
        }

        public void setData(T data) {
            this.data = data;
        }
    }

    static class TagCountMap
    extends HashMap<String, Integer> {
        TagCountMap() {
        }
    }

    public class LogSocket
    extends WebSocketAdapter
    implements ILogListener,
    LogCollectorClient.IPhaseStatusCollectionListener {
        private final Map<LogType, CyclicBuffer<MessageOrBuilder>> logtypes = new HashMap<LogType, CyclicBuffer<MessageOrBuilder>>();
        private DataXName collectionName;
        private int taskid;
        private StreamObserver<PMonotorTarget> pMonotorObserver;
        private ExtendWorkFlowBuildHistory buildTask;
        private Boolean preTaskComplete;

        public void onWebSocketConnect(Session sess) {
            super.onWebSocketConnect(sess);
            this.taskid = Integer.parseInt(this.getParameter("taskid", Collections.singletonList("-1")));
            this.collectionName = DataXName.createDataXPipeline((String)this.getParameter("collection", Collections.singletonList("dummpCollection")));
            List typies = RegisterMonotorTarget.parseLogTypes((DataXName)this.collectionName, (int)this.taskid, (String)this.getParameter("logtype"));
            logger.info("taskid:{},appname:{},typies:{}", new Object[]{this.taskid, this.collectionName, typies.stream().map(t -> String.valueOf(t)).collect(Collectors.joining(","))});
            try {
                if (this.taskid > 0 && typies.size() < 2) {
                    this.buildTask = this.getBuildHistory();
                    this.sendMsg2Client(this.buildTask);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            this.addMonitor(typies);
        }

        private ExtendWorkFlowBuildHistory getBuildHistory() {
            return this.getBuildHistory(null);
        }

        private ExtendWorkFlowBuildHistory getBuildHistory(ExecResult execResult) {
            WorkFlowBuildHistory wfBuildHistory = LogFeedbackServlet.this.wfDao.getWorkFlowBuildHistoryDAO().selectByPrimaryKey(Integer.valueOf(this.taskid));
            if (execResult == null) {
                return new ExtendWorkFlowBuildHistory(wfBuildHistory);
            }
            return new ExtendWorkFlowBuildHistory(wfBuildHistory, execResult);
        }

        private void addMonitor(List<RegisterMonotorTarget> typies) {
            typies.forEach(t -> {
                try {
                    this.addMonitor((MonotorTarget)t);
                }
                catch (Exception e) {
                    logger.error(t.toString(), (Throwable)e);
                    throw new RuntimeException(e);
                }
            });
        }

        public void onWebSocketText(String message) {
            JSONObject body = JSON.parseObject((String)message);
            List logtype = RegisterMonotorTarget.parseLogTypes((DataXName)this.collectionName, (int)this.taskid, (String)body.getString("logtype"));
            this.addMonitor(logtype);
        }

        private StreamObserver<PMonotorTarget> getMonitorSet() {
            if (this.pMonotorObserver == null) {
                this.pMonotorObserver = (StreamObserver)LogFeedbackServlet.this.getStatusRpc().registerMonitorEvent((ILogListener)this);
            }
            return this.pMonotorObserver;
        }

        public boolean isClosed() {
            return this.isNotConnected();
        }

        public synchronized void read(Object evt) {
            try {
                PExecuteState event = (PExecuteState)evt;
                LogType ltype = LogCollectorClient.convert((PExecuteState.LogType)event.getLogType());
                CyclicBuffer<MessageOrBuilder> messageBuffer = null;
                if (this.isConnected() && (messageBuffer = this.logtypes.get(ltype)) != null) {
                    messageBuffer.add((Object)event);
                    this.sendMsg2Client((MessageOrBuilder)event);
                }
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }

        public void onWebSocketClose(int statusCode, String reason) {
            super.onWebSocketClose(statusCode, reason);
            this.getMonitorSet().onCompleted();
            logger.warn("onWebSocketClose:" + this.collectionName + ",statusCode\uff1a" + statusCode + ",reason:" + reason);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addMonitor(MonotorTarget monitorTarget) throws Exception {
            String podName;
            PayloadMonitorTarget mtarget;
            if (RunEnvironment.getSysRuntime() == RunEnvironment.DAILY || monitorTarget.testLogType(new LogType[]{LogType.INCR_SEND})) {
                // empty if block
            }
            Map<LogType, CyclicBuffer<MessageOrBuilder>> map = this.logtypes;
            synchronized (map) {
                CyclicBuffer msgBuffer = null;
                msgBuffer = this.logtypes.get(monitorTarget.getLogType());
                if (msgBuffer != null && !monitorTarget.testLogType(new LogType[]{LogType.INCR_DEPLOY_STATUS_CHANGE, LogType.DATAX_WORKER_POD_LOG})) {
                    for (MessageOrBuilder msg : msgBuffer.asList()) {
                        this.sendMsg2Client(msg);
                    }
                    return;
                }
                if (msgBuffer == null) {
                    msgBuffer = new CyclicBuffer(200);
                    this.logtypes.put(monitorTarget.getLogType(), (CyclicBuffer<MessageOrBuilder>)msgBuffer);
                }
            }
            if (monitorTarget.testLogType(new LogType[]{LogType.DATAX_WORKER_POD_LOG})) {
                mtarget = (PayloadMonitorTarget)monitorTarget;
                podName = mtarget.getPayLoad();
                TISK8sDelegate k8sDelegate = TISK8sDelegate.getK8SDelegate(mtarget.getCollection());
                k8sDelegate.listPodsAndWatchLog(podName, this);
                return;
            }
            if (monitorTarget.testLogType(new LogType[]{LogType.INCR_DEPLOY_STATUS_CHANGE})) {
                mtarget = (PayloadMonitorTarget)monitorTarget;
                podName = mtarget.getPayLoad();
                TISK8sDelegate k8sDelegate = TISK8sDelegate.getK8SDelegate(monitorTarget.getCollection());
                k8sDelegate.listPodsAndWatchLog(podName, this);
                return;
            }
            if (monitorTarget.testLogType(new LogType[]{LogType.FULL, LogType.INCR, LogType.INCR_SEND})) {
                PMonotorTarget.Builder t = PMonotorTarget.newBuilder();
                t.setLogtype(LogCollectorClient.convert((int)monitorTarget.getLogType().typeKind));
                t.setCollection(this.collectionName.getPipelineName());
                if (this.taskid > 0) {
                    t.setTaskid(this.taskid);
                }
                this.getMonitorSet().onNext((Object)t.build());
                return;
            }
            if (!monitorTarget.testLogType(new LogType[]{LogType.BuildPhraseMetrics})) {
                if (monitorTarget.testLogType(new LogType[]{LogType.MQ_TAGS_STATUS})) {
                    throw new UnsupportedOperationException(" has been migrate to IncrControlWebSocketServlet");
                }
                throw new IllegalStateException("monitor type:" + monitorTarget + " is illegal");
            }
            executorService.execute(() -> {
                try {
                    Iterator statIt = LogFeedbackServlet.this.getStatusRpc().buildPhraseStatus(Integer.valueOf(this.taskid));
                    boolean serverSideBreak = true;
                    while (this.isConnected() && statIt.hasNext()) {
                        if (this.process((PPhaseStatusCollection)statIt.next())) continue;
                        serverSideBreak = false;
                        break;
                    }
                    logger.info("exit buildPhraseStatus status monitor,serverSideBreak:{}", (Object)serverSideBreak);
                }
                catch (StatusRuntimeException e) {
                    LogFeedbackServlet.this.getStatusRpc().reConnect();
                    throw e;
                }
                catch (Exception e) {
                    throw new RuntimeException("taskid:" + this.taskid, e);
                }
            });
        }

        public boolean isReady() {
            return !this.isClosed();
        }

        public boolean process(PPhaseStatusCollection ss) throws Exception {
            if (this.isClosed()) {
                return false;
            }
            if (this.buildTask == null) {
                throw new IllegalStateException("taskid:" + this.taskid + " relevant buildTask can not be null");
            }
            PhaseStatusCollection buildState = LogCollectorClient.convert((PPhaseStatusCollection)ss, (ExecutePhaseRange)new ExecutePhaseRange(FullbuildPhase.parse((int)this.buildTask.getDelegate().getStartPhase()), FullbuildPhase.parse((int)this.buildTask.getDelegate().getEndPhase())));
            boolean jobStop = false;
            ExtendWorkFlowBuildHistory status = null;
            if (this.preTaskComplete != null) {
                if (buildState.isComplete() ^ this.preTaskComplete) {
                    int waitTry = 0;
                    while (waitTry++ <= 4) {
                        Thread.sleep(2000L);
                        status = this.getBuildHistory();
                        if (!this.isTerminal(status)) continue;
                        jobStop = true;
                        break;
                    }
                    this.preTaskComplete = buildState.isComplete();
                    if (!jobStop) {
                        status = this.getBuildHistory(buildState.isFaild() ? ExecResult.FAILD : ExecResult.SUCCESS);
                        jobStop = true;
                    }
                }
            } else {
                status = this.getBuildHistory();
                if (this.isTerminal(status)) {
                    jobStop = true;
                }
                this.preTaskComplete = buildState.isComplete();
            }
            if (jobStop && status != null) {
                this.sendMsg2Client(status);
            }
            this.sendMsg2Client(buildState);
            return !jobStop;
        }

        private boolean isTerminal(ExtendWorkFlowBuildHistory status) {
            return ExecResult.parse((int)status.getState()).isComplete();
        }

        public void sendMsg2Client(Object biz) throws IOException {
            this.sendMsg2Client(JSON.toJSONString((Object)biz, (boolean)false));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sendMsg2Client(String jsonContent) throws IOException {
            LogSocket logSocket = this;
            synchronized (logSocket) {
                if (this.isClosed()) {
                    throw new IllegalStateException("ws conn has closed,jsonContent:" + jsonContent);
                }
                this.getRemote().sendString(jsonContent);
            }
        }

        private void sendMsg2Client(MessageOrBuilder biz) throws IOException {
            this.sendMsg2Client(JsonFormatPrinter.print(biz));
        }

        private String getParameter(String key) {
            return this.getParameter(key, Collections.emptyList());
        }

        private String getParameter(String key, List<String> dft) {
            Map params = this.getSession().getUpgradeRequest().getParameterMap();
            Iterator<String> iterator = params.getOrDefault(key, dft).iterator();
            if (iterator.hasNext()) {
                String v = iterator.next();
                return v;
            }
            throw new IllegalArgumentException("key:" + key + " relevant val is not exist in request");
        }
    }
}

