/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.manage.servlet;

import com.qlangtech.tis.manage.biz.dal.dao.IServerGroupDAO;
import com.qlangtech.tis.manage.biz.dal.pojo.Application;
import com.qlangtech.tis.manage.biz.dal.pojo.ServerGroup;
import com.qlangtech.tis.manage.biz.dal.pojo.ServerGroupCriteria;
import com.qlangtech.tis.manage.common.AppDomainInfo;
import com.qlangtech.tis.manage.common.ManageUtils;
import com.qlangtech.tis.manage.common.SnapshotDomain;
import com.qlangtech.tis.manage.servlet.BasicServlet;
import com.qlangtech.tis.manage.servlet.DownloadResource;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;

public class DownloadServlet
extends BasicServlet {
    private static final Pattern download_pattern = Pattern.compile(".+?/download/publish/(\\d+)/(\\d+)/group(\\d+)/r(\\d+)/(" + DownloadServlet.replace("schema.xml|solrconfig.xml") + "|jar)");
    private static final long serialVersionUID = 1L;

    public static String replace(String name) {
        return name.replace(".", "\\.");
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            Matcher matcher = null;
            matcher = this.getURLPattern().matcher(request.getRequestURL());
            if (!matcher.matches()) {
                throw new ServletException("has not match dowload url pattern:" + request.getRequestURL());
            }
            DownloadResource downloadRes = this.getDownloadResource(matcher);
            StringBuffer writer = this.getAppendInfo(request, downloadRes);
            ServletOutputStream output = response.getOutputStream();
            response.setContentType(downloadRes.getContentType());
            DownloadServlet.setDownloadName(response, downloadRes.getFileName());
            response.addHeader("filemd5", downloadRes.getMd5CodeValue());
            response.setContentLength(downloadRes.getFileLength() + writer.length());
            if (writer.length() > 0) {
                output.write(writer.toString().getBytes());
            }
            IOUtils.write((byte[])downloadRes.read(), (OutputStream)output);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static void setDownloadName(HttpServletResponse response, String fileName) {
        response.addHeader("Content-Disposition", "attachment; filename=\"" + fileName + "\"");
    }

    protected StringBuffer getAppendInfo(HttpServletRequest request, DownloadResource downloadRes) throws IOException {
        StringBuffer writer = new StringBuffer();
        writer.append("\n<!--\n");
        writer.append("download date:" + ManageUtils.formatDateYYYYMMdd(new Date())).append("\n");
        writer.append("app:" + downloadRes.getApplication().getProjectName()).append("\n");
        writer.append("request:" + request.getRequestURL()).append("\n");
        writer.append("-->");
        return writer;
    }

    protected Pattern getURLPattern() {
        return download_pattern;
    }

    protected DownloadResource getDownloadResource(Matcher matcher) {
        Integer bizid = Integer.parseInt(matcher.group(1));
        Integer appid = Integer.parseInt(matcher.group(2));
        Short groupIndex = Short.parseShort(matcher.group(3));
        Short runtime = Short.parseShort(matcher.group(4));
        String resourceName = matcher.group(5);
        ServerGroup group = DownloadServlet.getServerGroup(appid, groupIndex, runtime, this.getContext().getServerGroupDAO());
        if (group == null) {
            throw new IllegalStateException("appid:" + appid + ",groupIndex:" + groupIndex + " runtime:" + AppDomainInfo.getRunEnvir(runtime.shortValue()) + " can not find a group");
        }
        if (group.getPublishSnapshotId() == null) {
            throw new IllegalStateException("group id:" + group.getGid() + " group have not set publishSnapshotId");
        }
        Application app = this.getContext().getApplicationDAO().selectByPrimaryKey(appid);
        if (bizid.intValue() != app.getDptId().intValue()) {
            throw new IllegalArgumentException("bizid.intValue()" + bizid + " != app.getBizId()" + app.getDptId());
        }
        SnapshotDomain snapshot = this.getContext().getSnapshotViewDAO().getView(group.getPublishSnapshotId());
        return new DownloadResource(app, snapshot, resourceName);
    }

    public static ServerGroup getServerGroup(Integer appid, Short groupIndex, Short runtime, IServerGroupDAO serverGroupDAO) {
        ServerGroupCriteria gcriteria = new ServerGroupCriteria();
        gcriteria.createCriteria().andGroupIndexEqualTo(groupIndex).andRuntEnvironmentEqualTo(runtime).andAppIdEqualTo(appid);
        List<ServerGroup> groupList = serverGroupDAO.selectByExample(gcriteria);
        Iterator<ServerGroup> iterator = groupList.iterator();
        if (iterator.hasNext()) {
            ServerGroup g = iterator.next();
            return g;
        }
        return null;
    }
}

