/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.manage.servlet;

import com.qlangtech.tis.manage.biz.dal.pojo.Application;
import com.qlangtech.tis.manage.common.ConfigFileReader;
import com.qlangtech.tis.manage.common.PropteryGetter;
import com.qlangtech.tis.manage.common.SnapshotDomain;

public class DownloadResource {
    private final Application application;
    private final SnapshotDomain snapshot;
    private final String resourceName;
    private final PropteryGetter getStrategy;
    public static final String JAR_NAME = "jar";
    public static final String XML_CONTENT_TYPE = "text/xml";
    public static final String JAR_CONTENT_TYPE = "application/zip";

    public DownloadResource(Application application, SnapshotDomain snapshot, String resourceName) {
        this.application = application;
        this.snapshot = snapshot;
        this.resourceName = resourceName;
        this.getStrategy = DownloadResource.getGotStrategy(this);
    }

    public String getContentType() {
        return JAR_NAME.equals(this.resourceName) ? JAR_CONTENT_TYPE : XML_CONTENT_TYPE;
    }

    public int getFileLength() {
        return this.getStrategy.getContent(this.snapshot).length;
    }

    public String getFileName() {
        return this.getStrategy.getFileName();
    }

    public String getMd5CodeValue() {
        return this.getStrategy.getMd5CodeValue(this.snapshot);
    }

    public byte[] read() throws Exception {
        return this.getStrategy.getContent(this.snapshot);
    }

    private static PropteryGetter getGotStrategy(DownloadResource resource) {
        String resourceName = resource.getResourceName();
        if (ConfigFileReader.FILE_SOLR.getFileName().equals(resourceName)) {
            return ConfigFileReader.FILE_SOLR;
        }
        if (ConfigFileReader.FILE_SCHEMA.getFileName().equals(resourceName)) {
            return ConfigFileReader.FILE_SCHEMA;
        }
        throw new IllegalArgumentException("resourceName:" + resourceName + " has not match any file pattern");
    }

    public Application getApplication() {
        return this.application;
    }

    public String getResourceName() {
        return this.resourceName;
    }
}

