/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.manage.common.valve;

import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.ActionProxy;
import com.opensymphony.xwork2.interceptor.MethodFilterInterceptor;
import com.qlangtech.tis.extension.impl.SuFormProperties;
import com.qlangtech.tis.extension.model.UpdateSite;
import com.qlangtech.tis.extension.util.GroovyShellUtil;
import com.qlangtech.tis.lang.ErrorValue;
import com.qlangtech.tis.lang.TisException;
import com.qlangtech.tis.manage.common.MockContext;
import com.qlangtech.tis.manage.common.valve.AjaxValve;
import com.qlangtech.tis.manage.spring.aop.AuthorityCheckAdvice;
import com.qlangtech.tis.plugin.ds.JDBCConnection;
import com.qlangtech.tis.plugin.ds.JDBCConnectionPool;
import com.qlangtech.tis.util.IPluginContext;
import com.qlangtech.tis.utils.FreshmanReadmeToken;
import java.util.ArrayList;
import java.util.Collections;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.ServletActionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

public class TisExceptionInterceptor
extends MethodFilterInterceptor {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(TisExceptionInterceptor.class);
    private PlatformTransactionManager transactionManager;

    @Autowired
    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    protected boolean applyInterceptor(ActionInvocation invocation) {
        return AuthorityCheckAdvice.inNotForwardProcess();
    }

    protected String doIntercept(ActionInvocation invocation) throws Exception {
        HttpServletResponse response = ServletActionContext.getResponse();
        HttpServletRequest request = ServletActionContext.getRequest();
        boolean disableTransaction = Boolean.parseBoolean(request.getParameter("disableTransaction"));
        TransactionStatus status = null;
        if (!disableTransaction) {
            status = this.transactionManager.getTransaction((TransactionDefinition)new DefaultTransactionDefinition());
        }
        ActionProxy proxy = invocation.getProxy();
        AjaxValve.ActionExecResult execResult = null;
        try {
            String string;
            block25: {
                String result2;
                JDBCConnectionPool jdbcConnectionPool;
                block23: {
                    String string2;
                    block24: {
                        block21: {
                            String string3;
                            block22: {
                                jdbcConnectionPool = JDBCConnectionPool.create();
                                try {
                                    if (!FreshmanReadmeToken.hasReadFreshManReadme() && !AuthorityCheckAdvice.isProcessLoginOrInConfigNamespace(invocation)) {
                                        throw TisException.create((ErrorValue)ErrorValue.create((TisException.ErrorCode)TisException.ErrorCode.TIS_FRESHMAN_README_HAVE_NOT_READ, Collections.emptyMap()), (String)TisException.ErrorCode.TIS_FRESHMAN_README_HAVE_NOT_READ.name());
                                    }
                                    JDBCConnection.connectionPool.set(jdbcConnectionPool);
                                    if (!disableTransaction) break block21;
                                    string3 = invocation.invoke();
                                    if (jdbcConnectionPool == null) break block22;
                                }
                                catch (Throwable result2) {
                                    try {
                                        if (jdbcConnectionPool != null) {
                                            try {
                                                jdbcConnectionPool.close();
                                            }
                                            catch (Throwable throwable) {
                                                result2.addSuppressed(throwable);
                                            }
                                        }
                                        throw result2;
                                    }
                                    catch (Throwable e) {
                                        logger.error(e.getMessage(), e);
                                        if (!disableTransaction && !status.isCompleted()) {
                                            this.transactionManager.rollback(status);
                                        }
                                        if (StringUtils.endsWith((CharSequence)proxy.getNamespace(), (CharSequence)"#action")) {
                                            ArrayList<Object> errors = new ArrayList<Object>();
                                            errors.add("\u670d\u52a1\u7aef\u53d1\u751f\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458");
                                            TisException.ErrMsg errMsg = TisException.getErrMsg((Throwable)e);
                                            errors.add(errMsg.writeLogErr());
                                            AjaxValve.writeInfo2Client(() -> false, response, false, errors, Collections.emptyList(), Collections.emptyList(), null);
                                            String string4 = "none";
                                            return string4;
                                        }
                                        throw e;
                                    }
                                }
                                jdbcConnectionPool.close();
                            }
                            return string3;
                        }
                        invocation.getInvocationContext().put(TransactionStatus.class.getSimpleName(), (Object)status);
                        result2 = invocation.invoke();
                        execResult = MockContext.getActionExecResult();
                        if (execResult.isSuccess()) break block23;
                        this.transactionManager.rollback(status);
                        string2 = result2;
                        if (jdbcConnectionPool == null) break block24;
                        jdbcConnectionPool.close();
                    }
                    return string2;
                }
                if (!status.isCompleted()) {
                    this.transactionManager.commit(status);
                }
                string = result2;
                if (jdbcConnectionPool == null) break block25;
                jdbcConnectionPool.close();
            }
            return string;
        }
        finally {
            JDBCConnection.connectionPool.remove();
            SuFormProperties.subFormGetterProcessThreadLocal.remove();
            GroovyShellUtil.pluginThreadLocal.remove();
            UpdateSite.pluginArtsThreadlocal.remove();
            IPluginContext.pluginContextThreadLocal.remove();
        }
    }
}

