/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.manage.common.valve;

import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.ActionProxy;
import com.opensymphony.xwork2.interceptor.MethodFilterInterceptor;
import com.qlangtech.tis.manage.biz.dal.dao.IOperationLogDAO;
import com.qlangtech.tis.manage.biz.dal.pojo.OperationLog;
import com.qlangtech.tis.manage.common.AppDomainInfo;
import com.qlangtech.tis.manage.common.CheckAppDomainExistValve;
import com.qlangtech.tis.manage.common.ConfigFileContext;
import com.qlangtech.tis.manage.common.IUser;
import com.qlangtech.tis.manage.common.MockContext;
import com.qlangtech.tis.manage.common.RunContext;
import com.qlangtech.tis.manage.common.RunContextGetter;
import com.qlangtech.tis.manage.common.TisUTF8;
import com.qlangtech.tis.manage.common.UserUtils;
import com.qlangtech.tis.manage.common.valve.AjaxValve;
import com.qlangtech.tis.manage.common.valve.EmojiRemover;
import com.qlangtech.tis.manage.spring.aop.AuthorityCheckAdvice;
import com.qlangtech.tis.manage.spring.aop.Func;
import com.qlangtech.tis.pubhook.common.Nullable;
import com.qlangtech.tis.runtime.module.action.BasicModule;
import com.qlangtech.tis.runtime.module.misc.FormVaildateType;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.Map;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.ServletActionContext;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;

public class OperationLogInterceptor
extends MethodFilterInterceptor {
    private IOperationLogDAO operationLogDAO;
    private RunContext daoContext;

    protected boolean applyInterceptor(ActionInvocation invocation) {
        return AuthorityCheckAdvice.inNotForwardProcess();
    }

    protected String doIntercept(ActionInvocation invocation) throws Exception {
        BasicModule action = (BasicModule)invocation.getAction();
        Method method = action.getExecuteMethod();
        String result = invocation.invoke();
        Func func = method.getAnnotation(Func.class);
        if (func != null && !func.sideEffect()) {
            return result;
        }
        AppDomainInfo appDomain = CheckAppDomainExistValve.getAppDomain(this.daoContext);
        OperationLog log = new OperationLog();
        log.setOpType(BasicModule.parseMehtodName());
        if (StringUtils.startsWith((CharSequence)log.getOpType(), (CharSequence)"doGet")) {
            return result;
        }
        log.setCreateTime(new Date());
        if (!(appDomain instanceof Nullable)) {
            log.setAppName(appDomain.getAppName());
        }
        ActionProxy proxy = invocation.getProxy();
        HttpServletRequest request = ServletActionContext.getRequest();
        FormVaildateType vaildateType = FormVaildateType.parse((String)request.getParameter(FormVaildateType.VERIFY.getToken()));
        if (vaildateType.isVerify()) {
            return result;
        }
        if (StringUtils.indexOf((CharSequence)request.getClass().getSimpleName(), (CharSequence)"Mock") > -1) {
            return result;
        }
        IUser user = UserUtils.getUser(request, this.daoContext);
        if (user == null) {
            throw new IllegalStateException("user can not be null");
        }
        StringBuffer jsonObject = new StringBuffer();
        JSONObject params = null;
        Map paramsMap = null;
        String url = request.getRequestURL().toString();
        jsonObject.append("request:");
        jsonObject.append(url).append("\n");
        String requestBody = null;
        if (!ConfigFileContext.HTTPMethod.GET.name().equals(request.getMethod())) {
            paramsMap = request.getParameterMap();
            if (paramsMap.size() > 0) {
                params = new JSONObject();
                for (Map.Entry entry : paramsMap.entrySet()) {
                    if (((String[])entry.getValue()).length == 1) {
                        params.put((String)entry.getKey(), (Object)((String[])entry.getValue())[0]);
                        continue;
                    }
                    params.put((String)entry.getKey(), entry.getValue());
                }
                jsonObject.append("params:").append("\n");
                jsonObject.append(params.toString(1)).append("\n");
            }
            try (ServletInputStream input = request.getInputStream();){
                if (!input.isFinished()) {
                    requestBody = IOUtils.toString((InputStream)input, (Charset)TisUTF8.get());
                    jsonObject.append("body:").append("\n");
                    jsonObject.append(EmojiRemover.removeEmoji(requestBody)).append("\n");
                }
            }
        }
        MockContext context = new MockContext();
        jsonObject.append("\n=================================");
        jsonObject.append("response:").append("\n");
        jsonObject.append(AjaxValve.buildResultStruct(context));
        log.setTabName(proxy.getActionName());
        log.setUsrId(user.getId());
        log.setUsrName(user.getName());
        log.setOpDesc(jsonObject.toString());
        this.operationLogDAO.insertSelective(log);
        return result;
    }

    @Autowired
    public void setOperationLogDAO(IOperationLogDAO operationLogDAO) {
        this.operationLogDAO = operationLogDAO;
    }

    @Autowired
    public final void setRunContextGetter(RunContextGetter daoContextGetter) {
        this.daoContext = daoContextGetter.get();
    }
}

