/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.manage.common.valve;

import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.ActionProxy;
import com.opensymphony.xwork2.interceptor.MethodFilterInterceptor;
import com.qlangtech.tis.manage.common.AppDomainInfo;
import com.qlangtech.tis.manage.common.CheckAppDomainExistValve;
import com.qlangtech.tis.manage.common.RunContextGetter;
import com.qlangtech.tis.manage.spring.aop.AuthorityCheckAdvice;
import com.qlangtech.tis.pubhook.common.Nullable;
import com.qlangtech.tis.pubhook.common.RunEnvironment;
import com.qlangtech.tis.runtime.module.action.BasicModule;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class AppDomainSelectedCheckValve
extends MethodFilterInterceptor {
    private static final long serialVersionUID = -6852248426374953157L;
    private static final Map<String, Collection<RunEnvironment>> include_urls = new HashMap<String, Collection<RunEnvironment>>();
    private static final Collection<RunEnvironment> NULL_RUNTIME = Collections.emptyList();
    private Map<String, String> specialForward = new HashMap<String, String>();
    private RunContextGetter daoContextGetter;

    public void setSpecialForward(Map<String, String> specialForward) {
        this.specialForward = specialForward;
    }

    @Autowired
    public final void setRunContextGetter(RunContextGetter daoContextGetter) {
        this.daoContextGetter = daoContextGetter;
    }

    protected boolean applyInterceptor(ActionInvocation invocation) {
        return AuthorityCheckAdvice.inNotForwardProcess();
    }

    protected String doIntercept(ActionInvocation invocation) throws Exception {
        ActionProxy proxy = invocation.getProxy();
        if ("control".equals(StringUtils.split((String)proxy.getNamespace(), (String)"#")[1])) {
            return invocation.invoke();
        }
        BasicModule.Rundata rundata = BasicModule.getRundataInstance();
        AppDomainInfo domain = CheckAppDomainExistValve.getAppDomain(this.daoContextGetter.get());
        String actionTarget = this.getActionTarget(proxy);
        if (!include_urls.containsKey(actionTarget)) {
            return invocation.invoke();
        }
        String specialTarget = this.specialForward.get(actionTarget);
        boolean sensitiveRuntime = true;
        try {
            if (StringUtils.isNotBlank((String)specialTarget)) {
                sensitiveRuntime = "true".equalsIgnoreCase(StringUtils.substringAfter((String)specialTarget, (String)","));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this.isInvalidDomain((BasicModule)proxy.getAction(), domain, sensitiveRuntime)) {
            if (!StringUtils.isNotBlank((String)specialTarget)) {
                rundata.forwardTo("appdomainhasnotselected");
                return "none";
            }
            rundata.forwardTo(StringUtils.substringBefore((String)specialTarget, (String)","));
            return invocation.invoke();
        }
        Collection<RunEnvironment> runtime = include_urls.get(actionTarget);
        if (runtime.contains(domain.getRunEnvironment())) {
            rundata.forwardTo("environmentunuseable");
        }
        return invocation.invoke();
    }

    private String getActionTarget(ActionProxy proxy) {
        return StringUtils.split((String)proxy.getNamespace(), (String)"#")[0] + "/" + proxy.getActionName();
    }

    protected boolean isInvalidDomain(BasicModule basicAction, AppDomainInfo domain, boolean sensitiveRuntime) {
        if (!basicAction.isAppNameAware()) {
            return domain instanceof Nullable;
        }
        return domain instanceof Nullable || domain instanceof AppDomainInfo.EnvironmentAppDomainInfo;
    }

    static {
        include_urls.put("/runtime/index_query", NULL_RUNTIME);
        include_urls.put("/runtime/hsf_monitor", NULL_RUNTIME);
        include_urls.put("/runtime/jarcontent/snapshotset", NULL_RUNTIME);
        include_urls.put("/realtimelog", NULL_RUNTIME);
        include_urls.put("/runtime/cluster_state", NULL_RUNTIME);
        include_urls.put("/runtime/zklockview", NULL_RUNTIME);
        include_urls.put("/runtime/jarcontent/snapshotlist", NULL_RUNTIME);
        include_urls.put("/runtime/hdfs_view", NULL_RUNTIME);
        include_urls.put("/runtime/jarcontent/grouplist", NULL_RUNTIME);
        include_urls.put("/runtime/launchdumpandbuildindex", NULL_RUNTIME);
        include_urls.put("/runtime/triggermonitor", NULL_RUNTIME);
        include_urls.put("/runtime/schema_manage", NULL_RUNTIME);
        include_urls.put("/runtime/server_config_view", NULL_RUNTIME);
        include_urls.put("/coredefine/coredefine", NULL_RUNTIME);
        include_urls.put("/coredefine/coredefine_step1", NULL_RUNTIME);
        include_urls.put("/coredefine/corenodemanage", NULL_RUNTIME);
        include_urls.put("/trigger/app_list", NULL_RUNTIME);
        include_urls.put("/trigger/buildindexmonitor", NULL_RUNTIME);
        include_urls.put("/coredefine/cluster_servers_view", NULL_RUNTIME);
        include_urls.put("/trigger/task_list", NULL_RUNTIME);
        include_urls.put("/runtime/app_trigger_view", NULL_RUNTIME);
    }
}

