/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.manage.common.valve;

import com.alibaba.citrus.turbine.Context;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.opensymphony.xwork2.ActionInvocation;
import com.qlangtech.tis.lang.TisException;
import com.qlangtech.tis.manage.common.IAjaxResult;
import com.qlangtech.tis.manage.common.MockContext;
import com.qlangtech.tis.manage.common.TisUTF8;
import com.qlangtech.tis.runtime.module.misc.DefaultMessageHandler;
import com.qlangtech.tis.runtime.module.misc.impl.DefaultFieldErrorHandler;
import com.qlangtech.tis.runtime.module.misc.impl.ListDetailedItemsErrors;
import com.qlangtech.tis.trigger.util.JsonUtil;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.result.StrutsResultSupport;

public class AjaxValve
extends StrutsResultSupport
implements IAjaxResult {
    private static final long serialVersionUID = -3835145419233595896L;
    public static final String BIZ_RESULT = "biz_result";
    public static final String QUERY_RESULT = "query_result";
    public static final String EXEC_NULL = "exec_null";

    public static StringBuffer buildResultStruct(Context context) {
        ActionExecResult r = new ActionExecResult(context).invoke();
        return AjaxValve.buildResultStruct(r, r.errorPageShow, r.errorMsgList, r.msgList, r.pluginErrorList, r.getBizResult());
    }

    protected void doExecute(String finalLocation, ActionInvocation invocation) throws Exception {
        HttpServletRequest request = ServletActionContext.getRequest();
        HttpServletResponse response = ServletActionContext.getResponse();
        String resultHandler = request.getParameter("resulthandler");
        if (EXEC_NULL.equals(resultHandler)) {
            return;
        }
        this.writeExecuteResult(request, response);
    }

    private void writeExecuteResult(HttpServletRequest request, HttpServletResponse response) throws IOException {
        ActionExecResult actionExecResult = MockContext.getActionExecResult();
        List<Object> errorMsgList = actionExecResult.errorMsgList;
        List<String> msgList = actionExecResult.getMsgList();
        List<List<DefaultFieldErrorHandler.ItemsErrors>> pluginErrorList = actionExecResult.getPluginErrorList();
        Object bizResult = actionExecResult.getBizResult();
        Boolean errorPageShow = actionExecResult.getErrorPageShow();
        AjaxValve.writeInfo2Client(actionExecResult, response, errorPageShow, errorMsgList, msgList, pluginErrorList, bizResult);
    }

    private static List<Object> getErrorMsgList(Context context) {
        return (List)context.get("action_error_msg");
    }

    public static void writeInfo2Client(IExecResult actionExecResult, HttpServletResponse response, Boolean errorPageShow, List<Object> errorMsgList, List<String> msgList, List<List<DefaultFieldErrorHandler.ItemsErrors>> pluginErrorList, Object extendVal) throws IOException {
        StringBuffer result = AjaxValve.buildResultStruct(actionExecResult, errorPageShow, errorMsgList, msgList, pluginErrorList, extendVal);
        AjaxValve.writeJson(response, result);
    }

    private static StringBuffer buildResultStruct(IExecResult actionExecResult, Boolean errorPageShow, List<Object> errorMsgList, List<String> msgList, List<List<DefaultFieldErrorHandler.ItemsErrors>> pluginErrorList, Object extendVal) {
        StringBuffer result = new StringBuffer();
        result.append("{\n");
        result.append(" \"").append("success").append("\":").append(actionExecResult.isSuccess());
        JSONArray errors = AjaxValve.errorMsgListConvert2JsonArray(errorMsgList);
        result.append(",\n \"").append("errormsg").append("\":").append(JsonUtil.toString((Object)errors));
        if (errorPageShow != null) {
            result.append(",\n \"").append("action_error_page_show").append("\":").append(errorPageShow);
        }
        JSONArray msgs = new JSONArray();
        if (msgList != null) {
            for (String msg : msgList) {
                msgs.add((Object)msg);
            }
        }
        result.append(",\n \"").append("msg").append("\":").append(JsonUtil.toString((Object)msgs));
        if (extendVal != null) {
            result.append(",\n \"").append("bizresult").append("\":");
            if (extendVal instanceof org.json.JSONObject) {
                result.append(((org.json.JSONObject)extendVal).toString(1));
            } else if (extendVal instanceof JSONArray) {
                result.append(JsonUtil.toString((Object)((JSONArray)extendVal)));
            } else {
                result.append(JsonUtil.toString((Object)extendVal));
            }
        }
        if (pluginErrorList != null) {
            JSONArray pluginErrs = AjaxValve.pluginErrorListConvert2JsonArray(pluginErrorList);
            result.append(",\n \"").append("errorfields").append("\":");
            result.append(JsonUtil.toString((Object)pluginErrs));
        }
        result.append("\n}");
        return result;
    }

    public static JSONArray pluginErrorListConvert2JsonArray(List<List<DefaultFieldErrorHandler.ItemsErrors>> pluginErrorList) {
        JSONArray pluginErrs = new JSONArray();
        for (List<DefaultFieldErrorHandler.ItemsErrors> onePluginOfItems : Objects.requireNonNull(pluginErrorList, "pluginErrorList can not be null")) {
            JSONArray itemErrs = AjaxValve.convertItemsErrorList(onePluginOfItems);
            pluginErrs.add((Object)itemErrs);
        }
        return pluginErrs;
    }

    public static JSONArray errorMsgListConvert2JsonArray(List<Object> errorMsgList) {
        JSONArray errors = new JSONArray();
        if (errorMsgList != null) {
            for (Object msg : errorMsgList) {
                if (msg instanceof String) {
                    errors.add(msg);
                    continue;
                }
                if (msg instanceof TisException.ErrMsg) {
                    errors.add(msg);
                    continue;
                }
                throw new IllegalStateException("illegal error type:" + msg.getClass().getName());
            }
        }
        return errors;
    }

    private static JSONArray convertItemsErrorList(List<DefaultFieldErrorHandler.ItemsErrors> itemsErrorList) {
        JSONArray itemErrs = new JSONArray();
        for (DefaultFieldErrorHandler.ItemsErrors fieldErrors : itemsErrorList) {
            itemErrs.add((Object)fieldErrors.serial2JSON());
        }
        return itemErrs;
    }

    private static void writeJson(HttpServletResponse response, StringBuffer execResult) throws IOException {
        response.setContentType("text/json;charset=" + TisUTF8.getName());
        response.getWriter().write(execResult.toString());
    }

    public static class ActionExecResult
    implements IExecResult {
        private Context context;
        private List<Object> errorMsgList;
        private List<String> msgList;
        private List<List<DefaultFieldErrorHandler.ItemsErrors>> pluginErrorList;
        private Object bizResult;
        private Boolean errorPageShow;

        public static ActionExecResult create(Context context) {
            return new ActionExecResult(context).invoke();
        }

        public void addErrorMsg(List<String> msgs) {
            this.errorMsgList.addAll(msgs);
        }

        @Override
        public boolean isSuccess() {
            return !(this.errorMsgList != null && !this.errorMsgList.isEmpty() || this.pluginErrorList != null && !this.pluginErrorList.isEmpty());
        }

        public ActionExecResult(Context context) {
            this.context = context;
        }

        public List<String> getMsgList() {
            return this.msgList;
        }

        public List<List<DefaultFieldErrorHandler.ItemsErrors>> getPluginErrorList() {
            return this.pluginErrorList;
        }

        public ListDetailedItemsErrors getItemErrors() {
            List<List<DefaultFieldErrorHandler.ItemsErrors>> pluginErrorList = this.getPluginErrorList();
            if (CollectionUtils.isNotEmpty(pluginErrorList)) {
                for (List<DefaultFieldErrorHandler.ItemsErrors> el : pluginErrorList) {
                    Iterator<DefaultFieldErrorHandler.ItemsErrors> iterator = el.iterator();
                    if (!iterator.hasNext()) continue;
                    DefaultFieldErrorHandler.ItemsErrors e = iterator.next();
                    return (ListDetailedItemsErrors)e;
                }
            }
            return null;
        }

        public Object getBizResult() {
            return this.bizResult;
        }

        public Boolean getErrorPageShow() {
            return this.errorPageShow;
        }

        public List<Object> getErrorMsgs() {
            return this.errorMsgList;
        }

        public JSONObject createErrors() {
            JSONObject errors = new JSONObject();
            if (CollectionUtils.isNotEmpty(this.getErrorMsgs())) {
                errors.put("errormsg", (Object)AjaxValve.errorMsgListConvert2JsonArray(this.getErrorMsgs()));
            }
            if (CollectionUtils.isNotEmpty(this.getPluginErrorList())) {
                errors.put("errorfields", (Object)AjaxValve.pluginErrorListConvert2JsonArray(this.getPluginErrorList()));
            }
            return errors;
        }

        public ActionExecResult invoke() {
            this.errorMsgList = AjaxValve.getErrorMsgList(this.context);
            this.msgList = (List)this.context.get("action_msg");
            this.pluginErrorList = (List)this.context.get("action_error_fields");
            this.bizResult = DefaultMessageHandler.getBizResult(this.context);
            this.errorPageShow = (Boolean)this.context.get("action_error_page_show");
            return this;
        }

        public ActionExecResult setErrorMsg(List<String> errorMsgList) {
            this.errorMsgList = Lists.newArrayList(errorMsgList);
            return this;
        }
    }

    public static interface IExecResult {
        public boolean isSuccess();
    }
}

