/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.manage.common.apps;

import com.qlangtech.tis.manage.biz.dal.dao.IUsrDptRelationDAO;
import com.qlangtech.tis.manage.biz.dal.pojo.Application;
import com.qlangtech.tis.manage.biz.dal.pojo.ApplicationCriteria;
import com.qlangtech.tis.manage.biz.dal.pojo.Department;
import com.qlangtech.tis.manage.biz.dal.pojo.UsrDptRelationCriteria;
import com.qlangtech.tis.manage.common.IUser;
import com.qlangtech.tis.manage.common.RunContext;
import com.qlangtech.tis.manage.common.TriggerCrontab;
import com.qlangtech.tis.manage.common.apps.AppsFetcher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class NormalUserApplicationFetcher
extends AppsFetcher {
    private final AbandonRepeatList belongDpt = new AbandonRepeatList();
    private List<Integer> dptids;

    public NormalUserApplicationFetcher(IUser user, Department department, RunContext context) {
        super(user, department, context);
        this.processDepartment(department, context);
    }

    protected void processDepartment(Department department, RunContext context) {
        this.processBelongDepartment(context.getDepartmentDAO().loadFromWriteDB(department.getDptId()), context);
        this.postCreateBelongDpt(this.belongDpt);
        this.dptids = new ArrayList<Integer>(this.belongDpt.addIds);
    }

    protected void postCreateBelongDpt(List<Department> belongDpt) {
    }

    private void processBelongDepartment(Department department, RunContext context) {
    }

    @Override
    public final List<Application> getApps(AppsFetcher.CriteriaSetter setter) {
        ApplicationCriteria criteria = this.createCriteria(setter);
        criteria.setOrderByClause("app_id desc");
        return this.getApplicationDAO().selectByExample(criteria, 1, 500);
    }

    @Override
    public final int count(AppsFetcher.CriteriaSetter setter) {
        ApplicationCriteria criteria = this.createCriteria(setter);
        return this.getApplicationDAO().countByExample(criteria);
    }

    private ApplicationCriteria createCriteria(AppsFetcher.CriteriaSetter setter) {
        ApplicationCriteria criteria = new ApplicationCriteria();
        setter.set(this.process(criteria.createCriteria()));
        return criteria;
    }

    @Override
    public int update(Application app, AppsFetcher.CriteriaSetter setter) {
        ApplicationCriteria criteria = this.createCriteria(setter);
        return this.getApplicationDAO().updateByExampleSelective(app, criteria);
    }

    protected ApplicationCriteria.Criteria process(ApplicationCriteria.Criteria criteria) {
        return criteria.andDptIdIn(this.dptids);
    }

    @Override
    public List<Department> getDepartmentBelongs(RunContext runcontext) {
        return this.belongDpt;
    }

    @Override
    public List<TriggerCrontab> getTriggerTabs(IUsrDptRelationDAO usrDptRelationDAO) {
        UsrDptRelationCriteria ucriteria = new UsrDptRelationCriteria();
        ucriteria.createCriteria().andDptIdIn(this.dptids).andIsAutoDeploy();
        return usrDptRelationDAO.selectAppDumpJob(ucriteria);
    }

    @Override
    protected List<String> initAuthorityFuncList() {
        return new ArrayList<String>(){

            @Override
            public boolean contains(Object o) {
                return true;
            }
        };
    }

    private static class AbandonRepeatList
    extends ArrayList<Department> {
        private static final long serialVersionUID = 1L;
        private final Set<Integer> addIds = new HashSet<Integer>();

        private AbandonRepeatList() {
        }

        @Override
        public boolean add(Department e) {
            if (this.addIds.contains(e.getDptId())) {
                return false;
            }
            this.addIds.add(e.getDptId());
            return super.add(e);
        }

        @Override
        public boolean addAll(Collection<? extends Department> c) {
            for (Department department : c) {
                this.add(department);
            }
            return true;
        }
    }
}

