/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.manage.common.apps;

import com.qlangtech.tis.manage.biz.dal.dao.IApplicationDAO;
import com.qlangtech.tis.manage.biz.dal.dao.IUsrDptRelationDAO;
import com.qlangtech.tis.manage.biz.dal.pojo.Application;
import com.qlangtech.tis.manage.biz.dal.pojo.ApplicationCriteria;
import com.qlangtech.tis.manage.biz.dal.pojo.Department;
import com.qlangtech.tis.manage.biz.dal.pojo.UsrDptRelation;
import com.qlangtech.tis.manage.common.IUser;
import com.qlangtech.tis.manage.common.RunContext;
import com.qlangtech.tis.manage.common.TriggerCrontab;
import com.qlangtech.tis.manage.common.apps.IAppsFetcher;
import com.qlangtech.tis.manage.common.apps.TerminatorAdminAppsFetcher;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AppsFetcher
implements IAppsFetcher {
    protected final RunContext context;
    protected final IUser user;
    protected final Department dpt;
    private final List<String> authorityFuncList;
    private static final Logger log = LoggerFactory.getLogger(AppsFetcher.class);

    public static IAppsFetcher create(IUser user, RunContext context, boolean maxMach) {
        UsrDptRelation usr = user.getUsr();
        Department dpt = new Department();
        dpt.setDptId(123);
        dpt.setFullName("dpt");
        return new TerminatorAdminAppsFetcher(user, dpt, context);
    }

    public static IAppsFetcher create(IUser user, RunContext context) {
        return AppsFetcher.create(user, context, false);
    }

    @Override
    public boolean hasGrantAuthority(String permissionCode) {
        return this.authorityFuncList.contains(permissionCode);
    }

    protected final IApplicationDAO getApplicationDAO() {
        return this.context.getApplicationDAO();
    }

    protected AppsFetcher(IUser user, Department department, RunContext context) {
        this.context = context;
        this.user = user;
        this.dpt = department;
        this.authorityFuncList = this.initAuthorityFuncList();
        if (user != null && department != null && context != null) {
            log.warn("userid:" + user.getId() + ",name:" + user.getName() + ",class:" + this.getClass().getSimpleName() + ",this.authorityFuncList.class:" + this.authorityFuncList.getClass().getSimpleName() + ",this.authorityFuncList.size:" + this.authorityFuncList.size());
        }
    }

    protected abstract List<String> initAuthorityFuncList();

    @Override
    public abstract List<Application> getApps(CriteriaSetter var1);

    @Override
    public abstract int count(CriteriaSetter var1);

    @Override
    public abstract int update(Application var1, CriteriaSetter var2);

    @Override
    public abstract List<TriggerCrontab> getTriggerTabs(IUsrDptRelationDAO var1);

    public static interface CriteriaSetter {
        public void set(ApplicationCriteria.Criteria var1);
    }
}

