/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.manage.common;

import com.opensymphony.xwork2.ActionChainResult;
import com.opensymphony.xwork2.config.entities.PackageConfig;
import com.opensymphony.xwork2.config.entities.ResultConfig;
import com.qlangtech.tis.manage.common.TerminatorForwardResult;
import com.qlangtech.tis.manage.common.TisActionMapper;
import com.qlangtech.tis.manage.common.TisPackageBasedActionConfigBuilder;
import com.qlangtech.tis.manage.common.valve.AjaxValve;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import org.apache.struts2.convention.ResultMapBuilder;
import org.apache.struts2.convention.annotation.Action;
import org.springframework.util.StringUtils;

public class TisResultMapBuilder
implements ResultMapBuilder {
    private static final ResultConfig ACTION_RESULT_CONFIG = new ResultConfig.Builder("forward", TerminatorForwardResult.class.getName()).build();

    public Map<String, ResultConfig> build(Class<?> actionClass, Action annotation, String actionName, PackageConfig packageConfig) {
        ResultConfig.Builder build = null;
        String resultName = actionClass.getSimpleName();
        HashMap<String, ResultConfig> resultsConfig = new HashMap<String, ResultConfig>();
        resultsConfig.put("forward", ACTION_RESULT_CONFIG);
        Matcher matcher = TisPackageBasedActionConfigBuilder.NAMESPACE_PATTERN.matcher(actionClass.getName());
        if (matcher.matches()) {
            if ("action".equals(matcher.group(2))) {
                String resultCode = resultName + "_ajax";
                build = new ResultConfig.Builder(resultCode, AjaxValve.class.getName());
                resultsConfig.put(resultCode, build.build());
                resultCode = resultName + "_action";
                build = new ResultConfig.Builder(resultCode, ActionChainResult.class.getName());
                build.addParam("actionName", TisActionMapper.addUnderline(resultName).toString());
                build.addParam("namespace", "/" + matcher.group(1) + StringUtils.replace((String)matcher.group(3), (String)".", (String)"/") + "#screen");
                resultsConfig.put(resultCode, build.build());
            }
        } else {
            throw new IllegalStateException("class name :" + actionClass.getName() + " is illegal");
        }
        return resultsConfig;
    }

    private String getViewName(String resultName) {
        char[] simpleClassName = resultName.toCharArray();
        StringBuffer resultKey = new StringBuffer(String.valueOf(Character.toLowerCase(simpleClassName[0])));
        resultKey.append(simpleClassName, 1, simpleClassName.length - 1);
        return resultKey.toString();
    }
}

