/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.manage.common;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.opensymphony.xwork2.ObjectFactory;
import com.opensymphony.xwork2.config.Configuration;
import com.opensymphony.xwork2.config.entities.PackageConfig;
import com.opensymphony.xwork2.inject.Container;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.util.AnnotationUtils;
import com.opensymphony.xwork2.util.finder.ClassFinder;
import com.opensymphony.xwork2.util.finder.Test;
import com.qlangtech.tis.web.start.TisAppLaunch;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import junit.framework.Assert;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.convention.PackageBasedActionConfigBuilder;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.DefaultInterceptorRef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TisPackageBasedActionConfigBuilder
extends PackageBasedActionConfigBuilder {
    private final PackageConfig parentPkgConfig;
    private static final Pattern filePattern = Pattern.compile("jar:(.+?)!.+");
    private static final Logger LOG = LoggerFactory.getLogger(TisPackageBasedActionConfigBuilder.class);
    public static final Pattern NAMESPACE_PATTERN = Pattern.compile("com\\.qlangtech\\.tis\\.(\\w+)\\.module\\.(screen|action|control)(.*)(\\..*)$");
    private String[] tisActionPackages;

    public static void main(String[] args) throws Exception {
        Matcher m = filePattern.matcher("jar:file:/opt/app/spring-boot/tjs/lib/tis.jar!/com/qlangtech/tis/runtime/module/screen");
        if (m.matches()) {
            System.out.println(new URL(m.group(1)));
        }
    }

    @Inject
    public TisPackageBasedActionConfigBuilder(Configuration configuration, Container container, ObjectFactory objectFactory, @Inject(value="struts.convention.redirect.to.slash") String redirectToSlash, @Inject(value="struts.convention.default.parent.package") String defaultParentPackage, @Inject(value="struts.convention.enable.smi.inheritance") String enableSmiInheritance) {
        super(configuration, container, objectFactory, redirectToSlash, defaultParentPackage, enableSmiInheritance);
        this.parentPkgConfig = configuration.getPackageConfig("default");
        Assert.assertNotNull((Object)this.parentPkgConfig);
    }

    protected Test<ClassFinder.ClassInfo> getActionClassTest() {
        return super.getActionClassTest();
    }

    @Inject(value="struts.convention.action.packages", required=false)
    public void setActionPackages(String actionPackages) {
        super.setActionPackages(actionPackages);
        if (StringUtils.isNotBlank((CharSequence)actionPackages)) {
            this.tisActionPackages = actionPackages.split("\\s*[,]\\s*");
        }
    }

    protected ClassFinder buildClassFinder(Test<String> classPackageTest, List<URL> urls) {
        if (TisAppLaunch.isTestMock()) {
            return super.buildClassFinder(classPackageTest, urls);
        }
        try {
            HashSet url = Sets.newHashSet();
            URL l = null;
            Enumeration<URL> res = null;
            for (String scanPackage : this.tisActionPackages) {
                scanPackage = StringUtils.replace((String)scanPackage, (String)".", (String)"/");
                res = this.getClassLoader().getResources(scanPackage);
                while (res.hasMoreElements()) {
                    l = res.nextElement();
                    Matcher m = filePattern.matcher(l.toString());
                    if (!m.matches()) continue;
                    url.add(new URL(m.group(1)));
                }
            }
            return super.buildClassFinder(classPackageTest, (List)Lists.newArrayList((Iterable)url));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected PackageConfig.Builder getPackageConfig(Map<String, PackageConfig.Builder> packageConfigs, String actionNamespace, String actionPackage, Class<?> actionClass, Action action) {
        Matcher matcher = NAMESPACE_PATTERN.matcher(actionClass.getName());
        String name = null;
        if (!matcher.matches()) {
            throw new IllegalStateException("actionPackage:" + actionPackage + " is not a valid actionPackage");
        }
        name = "/" + matcher.group(1) + StringUtils.replace((String)matcher.group(3), (String)".", (String)"/") + "#" + matcher.group(2);
        PackageConfig.Builder pkgConfig = packageConfigs.get(name);
        if (pkgConfig == null) {
            pkgConfig = new PackageConfig.Builder(name).namespace(name).addParent(this.parentPkgConfig);
            pkgConfig.strictMethodInvocation(false);
            packageConfigs.put(name, pkgConfig);
            DefaultInterceptorRef defaultInterceptorRef = (DefaultInterceptorRef)AnnotationUtils.findAnnotation(actionClass, DefaultInterceptorRef.class);
            if (defaultInterceptorRef != null) {
                pkgConfig.defaultInterceptorRef(defaultInterceptorRef.value());
                if (LOG.isTraceEnabled()) {
                    LOG.debug("Setting [#0] as the default interceptor ref for [#1]", (Object)defaultInterceptorRef.value(), (Object)pkgConfig.getName());
                }
            }
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Created package config named [#0] with a namespace [#1]", (Object)name, (Object)actionNamespace);
        }
        return pkgConfig;
    }
}

