/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.manage.common;

import com.qlangtech.tis.manage.common.ActionTool;
import com.qlangtech.tis.manage.common.AppDomainInfo;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class TISHttpServletRequestWrapper
extends HttpServletRequestWrapper {
    private AppDomainInfo domain;
    private Map<String, Cookie> cookieMap;
    private byte[] bodyContent;

    public TISHttpServletRequestWrapper(HttpServletRequest request) {
        super(request);
    }

    public void setAttribute(String name, Object o) {
        try {
            if (ActionTool.REQUEST_DOMAIN_KEY.equals(name) && this.domain == null) {
                this.domain = (AppDomainInfo)o;
            } else {
                super.setAttribute(name, o);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("name:" + name + ",value:" + o, e);
        }
    }

    public void removeAttribute(String name) {
        if (ActionTool.REQUEST_DOMAIN_KEY.equals(name) && this.domain != null) {
            this.domain = null;
        } else {
            super.removeAttribute(name);
        }
    }

    public Cookie getCookie(String name) {
        return this.getCookieMap().get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Cookie> getCookieMap() {
        if (this.cookieMap == null) {
            TISHttpServletRequestWrapper tISHttpServletRequestWrapper = this;
            synchronized (tISHttpServletRequestWrapper) {
                if (this.cookieMap == null) {
                    this.cookieMap = new HashMap<String, Cookie>();
                    Cookie[] cs = this.getCookies();
                    if (cs != null) {
                        for (Cookie c : cs) {
                            this.cookieMap.put(c.getName(), c);
                        }
                    }
                }
            }
        }
        return this.cookieMap;
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.bodyContent != null) {
            return new TisServletInputStream(this.bodyContent);
        }
        ServletInputStream inputStream = super.getInputStream();
        if (inputStream.isFinished()) {
            return inputStream;
        }
        try (ByteArrayOutputStream array = new ByteArrayOutputStream();){
            IOUtils.copy((InputStream)inputStream, (OutputStream)array);
            this.bodyContent = array.toByteArray();
        }
        return new TisServletInputStream(this.bodyContent);
    }

    public void removeCookie(String cookiekey) {
        this.getCookieMap().remove(cookiekey);
    }

    public String[] getParameterValues(String name) {
        String[] params = super.getParameterValues(name);
        if (params != null) {
            return params;
        }
        ArrayList<String> result = new ArrayList<String>();
        int i = 0;
        String value = null;
        while (StringUtils.isNotBlank((CharSequence)(value = this.getParameter(name + "[" + i++ + "]")))) {
            result.add(value);
        }
        return result.toArray(new String[0]);
    }

    public Object getAttribute(String name) {
        if (ActionTool.REQUEST_DOMAIN_KEY.equals(name)) {
            return this.domain;
        }
        return super.getAttribute(name);
    }

    private static class TisServletInputStream
    extends ServletInputStream {
        private final InputStream input;
        boolean finished = false;

        public TisServletInputStream(byte[] content) {
            this.input = new ByteArrayInputStream(content);
        }

        public boolean isFinished() {
            return this.finished;
        }

        public boolean isReady() {
            return true;
        }

        public void setReadListener(ReadListener readListener) {
        }

        public int read() throws IOException {
            int result = this.input.read();
            if (result < 0) {
                this.finished = true;
            }
            return result;
        }

        public void close() throws IOException {
            this.input.close();
        }
    }
}

