/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.manage.common;

import com.qlangtech.tis.manage.common.AppDomainInfo;
import com.qlangtech.tis.manage.common.RunContext;
import com.qlangtech.tis.manage.common.TriggerCrontab;
import com.qlangtech.tis.pubhook.common.Nullable;
import com.qlangtech.tis.pubhook.common.RunEnvironment;
import com.qlangtech.tis.realtime.utils.NetUtils;
import com.qlangtech.tis.runtime.module.action.BasicModule;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class ManageUtils {
    public static final int DELETE = 1;
    public static final int UN_DELETE = 0;
    private RunContext daoContext;
    private HttpServletRequest request;
    private static final SimpleDateFormat TIME_FORMAT = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
    public static final SimpleDateFormat TIME_FORMAT2 = new SimpleDateFormat("yyyy-MM-dd");
    public static final ThreadLocal<SimpleDateFormat> dateFormatyyyyMMddHHmmss = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yyyyMMddHHmmss");
        }
    };
    private static final Pattern SERVLET_PATH = Pattern.compile("/([^\\.^/]+?)\\.[^\\.]+$");
    private static final Pattern SIZE_PATTERN = Pattern.compile("(\\d{1,})\\*(\\d{1,})");

    public static String formatNowYyyyMMddHHmmss() {
        return dateFormatyyyyMMddHHmmss.get().format(new Date());
    }

    public static long formatNowYyyyMMddHHmmss(Date date) {
        return Long.parseLong(dateFormatyyyyMMddHHmmss.get().format(date));
    }

    public static Date getOffsetDate(int offset) {
        Calendar c = Calendar.getInstance();
        c.add(6, offset);
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        return c.getTime();
    }

    public static boolean isDaily() {
        return RunEnvironment.DAILY == RunEnvironment.getSysRuntime();
    }

    public boolean isEmpty(String value) {
        return StringUtils.isEmpty((String)value);
    }

    public String defaultIfEmpty(String value, String defaultValue) {
        if (StringUtils.isBlank((String)value)) {
            return defaultValue;
        }
        return value;
    }

    public static boolean isInPauseState(TriggerCrontab crontab) {
        return ManageUtils.isInPauseState(crontab.getFjobId() != null, crontab.isFstop(), crontab.getIjobId() != null, crontab.isIstop());
    }

    public static String getServerIp() throws UnknownHostException {
        return NetUtils.getHost();
    }

    public static boolean isInPauseState(boolean hasfulldump, boolean fulljobStop, boolean hasincrdump, boolean incrjobStop) {
        if (hasfulldump) {
            return fulljobStop;
        }
        if (hasincrdump) {
            return incrjobStop;
        }
        return true;
    }

    public boolean isNullable(Object o) {
        return o instanceof Nullable;
    }

    @Autowired
    public void setRequest(HttpServletRequest request) {
        this.request = request;
    }

    @Autowired
    public void setDaoContext(RunContext daoContext) {
        this.daoContext = daoContext;
    }

    public static String formatDateYYYYMMdd(Date time) {
        if (time == null) {
            return "";
        }
        return TIME_FORMAT.format(time);
    }

    public static String md5(String value) {
        return DigestUtils.md5Hex((String)value);
    }

    public int getPopLength(String size, boolean w) {
        if (StringUtils.isEmpty((String)size)) {
            return w ? 500 : 400;
        }
        Matcher m = SIZE_PATTERN.matcher(size);
        if (m.matches()) {
            return Integer.parseInt(w ? m.group(1) : m.group(2));
        }
        return 0;
    }

    public static boolean isValidAppDomain(HttpServletRequest request) {
        AppDomainInfo domain = ManageUtils.getAppDomain(request);
        if (domain == null) {
            return false;
        }
        return !(domain instanceof Nullable);
    }

    public static AppDomainInfo getAppDomain(HttpServletRequest request) {
        AppDomainInfo domain = (AppDomainInfo)request.getAttribute(BasicModule.REQUEST_DOMAIN_KEY);
        return domain;
    }

    public AppDomainInfo getAppDomain() {
        return ManageUtils.getAppDomain(this.request);
    }

    public static boolean isDaily(HttpServletRequest request) {
        return ManageUtils.isValidAppDomain(request) && ManageUtils.getAppDomain(request).getRunEnvironment() == RunEnvironment.DAILY;
    }

    public boolean isNotNull(Object o) {
        return o != null;
    }
}

