/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.manage.common;

import com.qlangtech.tis.datax.DataXName;
import com.qlangtech.tis.manage.common.AppAndRuntime;
import com.qlangtech.tis.manage.common.ManageUtils;
import com.qlangtech.tis.manage.common.TISHttpServletRequestWrapper;
import com.qlangtech.tis.manage.common.TISHttpServletResponseWrapper;
import com.qlangtech.tis.manage.common.TisUTF8;
import com.qlangtech.tis.pubhook.common.RunEnvironment;
import com.qlangtech.tis.runtime.module.action.ChangeDomainAction;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import junit.framework.Assert;
import org.apache.commons.lang3.StringUtils;

public final class DefaultFilter
implements Filter {
    private static ThreadLocal<ServletResponse> responseLocal = new ThreadLocal();
    private static ThreadLocal<TISHttpServletRequestWrapper> requestLocal = new ThreadLocal();

    public static ServletResponse getRespone() {
        return responseLocal.get();
    }

    public static TISHttpServletRequestWrapper getReqeust() {
        TISHttpServletRequestWrapper request = requestLocal.get();
        Assert.assertNotNull((String)"request has not been set in local thread", (Object)((Object)request));
        return request;
    }

    private static AppAndRuntime getRuntime(TISHttpServletRequestWrapper request) {
        String key = "request" + ChangeDomainAction.COOKIE_SELECT_APP;
        if (request.getAttribute(key) == null) {
            AppAndRuntime appAndRuntime = new AppAndRuntime();
            String appName = StringUtils.defaultString((String)request.getHeader("appname"), (String)request.getParameter("appname"));
            if (StringUtils.isBlank((CharSequence)appName)) {
                appAndRuntime.setRuntime(RunEnvironment.getSysRuntime());
                request.setAttribute(key, appAndRuntime);
                return appAndRuntime;
            }
            appAndRuntime.setAppName(DataXName.createDataXPipeline((String)appName));
            appAndRuntime.setRuntime(RunEnvironment.getSysRuntime());
            if (!ManageUtils.isDaily() && appAndRuntime.getRuntime() != RunEnvironment.DAILY) {
                request.setAttribute(key, appAndRuntime);
                return appAndRuntime;
            }
            appAndRuntime.setRuntime(DefaultFilter.getRuntime());
            request.setAttribute(key, appAndRuntime);
            return appAndRuntime;
        }
        return (AppAndRuntime)request.getAttribute(key);
    }

    public static RunEnvironment getRuntime() {
        return RunEnvironment.getSysRuntime();
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        request.setCharacterEncoding(TisUTF8.getName());
        response.setCharacterEncoding(TisUTF8.getName());
        TISHttpServletRequestWrapper wrapperRequest = new TISHttpServletRequestWrapper((HttpServletRequest)request);
        TISHttpServletResponseWrapper wrapperResponse = new TISHttpServletResponseWrapper((HttpServletResponse)response);
        responseLocal.set(response);
        requestLocal.set(wrapperRequest);
        AppAndRuntime.setAppAndRuntime((AppAndRuntime)DefaultFilter.getRuntime(wrapperRequest));
        if (ManageUtils.isDaily()) {
            // empty if block
        }
        chain.doFilter((ServletRequest)wrapperRequest, (ServletResponse)wrapperResponse);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }
}

