/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.manage.common;

import com.opensymphony.xwork2.ActionContext;
import com.qlangtech.tis.datax.DataXName;
import com.qlangtech.tis.manage.biz.dal.dao.IApplicationDAO;
import com.qlangtech.tis.manage.biz.dal.pojo.Application;
import com.qlangtech.tis.manage.biz.dal.pojo.ApplicationCriteria;
import com.qlangtech.tis.manage.common.ActionTool;
import com.qlangtech.tis.manage.common.AppAndRuntime;
import com.qlangtech.tis.manage.common.AppDomainInfo;
import com.qlangtech.tis.manage.common.DefaultFilter;
import com.qlangtech.tis.manage.common.RunContext;
import com.qlangtech.tis.pubhook.common.Nullable;
import com.qlangtech.tis.pubhook.common.RunEnvironment;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts2.ServletActionContext;
import org.springframework.beans.factory.annotation.Autowired;

public class CheckAppDomainExistValve {
    @Autowired
    private HttpServletRequest request;
    private static final AppDomainInfo NULL;

    public static AppDomainInfo getAppDomain(RunContext context) {
        HttpServletRequest request = ServletActionContext.getRequest();
        return CheckAppDomainExistValve.getAppDomain(request, context);
    }

    public static void removeAppDomain() {
        if (ActionContext.getContext() != null) {
            HttpServletRequest request = ServletActionContext.getRequest();
            request.removeAttribute(ActionTool.REQUEST_DOMAIN_KEY);
        }
    }

    public static AppDomainInfo getAppDomain(HttpServletRequest request, RunContext context) {
        AppDomainInfo domain = (AppDomainInfo)request.getAttribute(ActionTool.REQUEST_DOMAIN_KEY);
        if (domain != null) {
            return domain;
        }
        AppDomainInfo appDomain = null;
        AppAndRuntime environment = AppAndRuntime.getAppAndRuntime();
        if (environment == null) {
            domain = AppDomainInfo.createAppNotAware(DefaultFilter.getRuntime());
            request.setAttribute(ActionTool.REQUEST_DOMAIN_KEY, (Object)domain);
            return domain;
        }
        try {
            if (environment.getAppName() == null) {
                appDomain = AppDomainInfo.createAppNotAware(environment.getRuntime());
            } else {
                DataXName dataXName = environment.getAppName();
                appDomain = CheckAppDomainExistValve.queryApplication(request, context, dataXName.getPipelineName(), environment.getRuntime());
                if (appDomain == null) {
                    Application app = new Application();
                    app.setProjectName(dataXName.getPipelineName());
                    appDomain = new AppDomainInfo(0, 0, environment.getRuntime(), app);
                }
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        if (appDomain == null) {
            appDomain = CheckAppDomainExistValve.createNull();
        }
        request.setAttribute(ActionTool.REQUEST_DOMAIN_KEY, (Object)appDomain);
        return appDomain;
    }

    public static AppDomainInfo queryApplication(HttpServletRequest request, RunContext context, String appname, RunEnvironment runtime) {
        AppDomainInfo appDomain;
        block0: {
            ApplicationCriteria query = new ApplicationCriteria();
            query.createCriteria().andProjectNameEqualTo(appname);
            appDomain = null;
            Iterator iterator = context.getApplicationDAO().selectByExample(query).iterator();
            if (!iterator.hasNext()) break block0;
            Application app = (Application)iterator.next();
            appDomain = new AppDomainInfo(app.getDptId(), app.getAppId(), runtime, app);
        }
        return appDomain;
    }

    public static AppDomainInfo createNull() {
        return NULL;
    }

    static {
        AppAndRuntime.newAppAndRuntimeConsumer = appRuntime -> {
            if (appRuntime.getAppName() != null) {
                CheckAppDomainExistValve.removeAppDomain();
            }
        };
        NULL = new NullAppDomainInfo(null);
    }

    private static class NullAppDomainInfo
    extends AppDomainInfo
    implements Nullable {
        private NullAppDomainInfo(IApplicationDAO applicationDAO) {
            super(Integer.MAX_VALUE, Integer.MAX_VALUE, RunEnvironment.DAILY, null);
        }

        @Override
        protected void judgeNull(Application application) {
        }

        @Override
        public Integer getAppid() {
            return 0;
        }

        @Override
        public String getAppName() {
            return "";
        }

        @Override
        public Integer getDptid() {
            return -1;
        }

        @Override
        public RunEnvironment getRunEnvironment() {
            return RunEnvironment.DAILY;
        }
    }
}

