/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.manage.common;

import com.qlangtech.tis.manage.biz.dal.pojo.AppType;
import com.qlangtech.tis.manage.biz.dal.pojo.Application;
import com.qlangtech.tis.pubhook.common.RunEnvironment;

public class AppDomainInfo {
    private final Integer dptid;
    private final Integer appid;
    private final RunEnvironment runEnvironment;
    private final Application app;
    private boolean isAutoDeploy;

    public boolean isAutoDeploy() {
        return this.isAutoDeploy;
    }

    public void setAutoDeploy(boolean isAutoDeploy) {
        this.isAutoDeploy = isAutoDeploy;
    }

    public AppDomainInfo(Integer bizid, Integer appid, RunEnvironment runEnvironment, Application app) {
        this.judgeNull(app);
        this.dptid = bizid;
        this.appid = appid;
        this.runEnvironment = runEnvironment;
        this.app = app;
    }

    public final AppType getAppType() {
        return this.getApp().parseAppType();
    }

    public Application getApp() {
        if (this.app == null) {
            throw new IllegalStateException("app can not be null");
        }
        return this.app;
    }

    public String getAppName() {
        return this.app.getProjectName();
    }

    public static AppDomainInfo createAppNotAware(RunEnvironment runEnvironment) {
        return new EnvironmentAppDomainInfo(runEnvironment);
    }

    protected void judgeNull(Application app) {
        if (app == null) {
            throw new IllegalArgumentException("app can not be null");
        }
    }

    public static String getRunEnvir(int runEnvironment) {
        return RunEnvironment.getEnum((short)((short)runEnvironment)).getDescribe();
    }

    public RunEnvironment getRunEnvironment() {
        return this.runEnvironment;
    }

    public Integer getDptid() {
        return this.dptid;
    }

    public Integer getAppid() {
        return this.appid;
    }

    public String toString() {
        return "{appid=" + this.appid + ", runEnvironment=" + this.runEnvironment + "}";
    }

    public static class EnvironmentAppDomainInfo
    extends AppDomainInfo {
        public EnvironmentAppDomainInfo(RunEnvironment runEnvironment) {
            super(-1, -1, runEnvironment, null);
        }

        @Override
        public String getAppName() {
            return "";
        }

        @Override
        protected void judgeNull(Application context) {
        }
    }
}

