/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.manage.biz.dal.pojo;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class ClusterSnapshotQuery {
    private final Date fromTime;
    private final Date toTime;
    private final String sqlmapSuffix;
    private Integer appId;

    public static void main(String[] args) {
        Calendar calendar = ClusterSnapshotQuery.createToday();
        SimpleDateFormat f = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        System.out.println(f.format(calendar.getTime()));
        calendar.add(6, 1);
        System.out.println(f.format(calendar.getTime()));
    }

    public Integer getAppId() {
        return this.appId;
    }

    public void setAppId(Integer appId) {
        this.appId = appId;
    }

    public String getSqlmapSuffix() {
        return this.sqlmapSuffix;
    }

    public static ClusterSnapshotQuery hour() {
        Calendar calendar = Calendar.getInstance();
        Date to = calendar.getTime();
        calendar.add(10, -1);
        return new ClusterSnapshotQuery(calendar.getTime(), to, "last1Hour");
    }

    public static ClusterSnapshotQuery fiveHour() {
        Calendar calendar = Calendar.getInstance();
        Date to = calendar.getTime();
        calendar.add(10, -5);
        Date from = calendar.getTime();
        return new ClusterSnapshotQuery(from, to, "Last5hours");
    }

    public static ClusterSnapshotQuery hour24() {
        Calendar calendar = ClusterSnapshotQuery.createToday();
        Date from = calendar.getTime();
        calendar.add(6, 1);
        Date to = calendar.getTime();
        return new ClusterSnapshotQuery(from, to, "CurrentDay");
    }

    public static ClusterSnapshotQuery days15() {
        Calendar calendar = ClusterSnapshotQuery.createToday();
        calendar.add(6, -1);
        Date to = calendar.getTime();
        calendar.add(6, -15);
        Date from = calendar.getTime();
        return new ClusterSnapshotQuery(from, to, "Last15day");
    }

    public static ClusterSnapshotQuery last1Month() {
        Calendar calendar = ClusterSnapshotQuery.createToday();
        calendar.add(6, -1);
        Date to = calendar.getTime();
        calendar.add(6, -30);
        Date from = calendar.getTime();
        return new ClusterSnapshotQuery(from, to, "Last1month");
    }

    private ClusterSnapshotQuery(Date fromDate, Date toDate, String sqlmapSuffix) {
        this.fromTime = fromDate;
        this.toTime = toDate;
        this.sqlmapSuffix = sqlmapSuffix;
    }

    public Date getFromTime() {
        return this.fromTime;
    }

    public Date getToTime() {
        return this.toTime;
    }

    private static Calendar createToday() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar;
    }
}

