/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.manage.biz.dal.pojo;

import com.alibaba.fastjson.annotation.JSONField;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;

public class ClusterSnapshot
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Date fromTime;
    private Date toTime;
    private Long requestCount;
    private Long updateCount;
    public ThreadLocal<SimpleDateFormat> dateformat;

    @JSONField(serialize=false)
    public Date getFromTime() {
        return this.fromTime;
    }

    public String getLabel() {
        if (this.dateformat == null) {
            throw new IllegalStateException("dateformat can not be null");
        }
        return this.dateformat.get().format(this.getToTime());
    }

    public void setFromTime(Date fromTime) {
        this.fromTime = fromTime;
    }

    @JSONField(serialize=false)
    public Date getToTime() {
        return this.toTime;
    }

    public void setToTime(Date toTime) {
        this.toTime = toTime;
    }

    public Long getRequestCount() {
        return this.requestCount;
    }

    public void setRequestCount(Long requestCount) {
        this.requestCount = requestCount;
    }

    public Long getUpdateCount() {
        return this.updateCount;
    }

    public void setUpdateCount(Long updateCount) {
        this.updateCount = updateCount;
    }

    public static class Summary {
        private long updateCount;
        private long queryCount;

        public void add(ClusterSnapshot snapshot) {
            this.updateCount += snapshot.updateCount.longValue();
            this.queryCount += snapshot.requestCount.longValue();
        }

        public long getUpdateCount() {
            return this.updateCount;
        }

        public long getQueryCount() {
            return this.queryCount;
        }
    }
}

