/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.manage.biz.dal.dao.impl;

import com.qlangtech.tis.manage.biz.dal.dao.IResourceParametersDAO;
import com.qlangtech.tis.manage.biz.dal.dao.ISnapshotDAO;
import com.qlangtech.tis.manage.biz.dal.dao.ISnapshotViewDAO;
import com.qlangtech.tis.manage.biz.dal.dao.IUploadResourceDAO;
import com.qlangtech.tis.manage.biz.dal.pojo.Snapshot;
import com.qlangtech.tis.manage.biz.dal.pojo.SnapshotCriteria;
import com.qlangtech.tis.manage.biz.dal.pojo.UploadResource;
import com.qlangtech.tis.manage.common.BasicDAO;
import com.qlangtech.tis.manage.common.SnapshotDomain;
import com.qlangtech.tis.manage.common.TisUTF8;
import com.qlangtech.tis.utils.MD5Utils;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import junit.framework.Assert;
import org.apache.commons.beanutils.LazyDynaBean;
import org.apache.commons.io.IOUtils;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;

public class SnapshotViewImplDAO
extends BasicDAO<SnapshotDomain, SnapshotCriteria>
implements ISnapshotViewDAO {
    public static final ThreadLocal<MergeData> mergeDataContext = new ThreadLocal<MergeData>(){

        @Override
        protected MergeData initialValue() {
            MergeData initMergeData = new MergeData();
            initMergeData.put("minGramSize", 2);
            initMergeData.put("maxGramSize", 7);
            return initMergeData;
        }
    };
    private ISnapshotDAO snapshotDAO;
    private IUploadResourceDAO uploadResourceDao;
    private IResourceParametersDAO resourceParametersDAO;
    private static final VelocityEngine velocityEngine;

    @Override
    public String getEntityName() {
        return "snapshot_view";
    }

    @Override
    public SnapshotDomain getView(Integer snId, final boolean mergeContextParams) {
        Assert.assertNotNull((String)"param snId ", (Object)snId);
        final Snapshot snapshot = this.snapshotDAO.loadFromWriteDB(snId);
        if (snapshot == null) {
            throw new IllegalArgumentException("snid:" + snId + " relevant record is not exist");
        }
        SnapshotDomain domain = new SnapshotDomain(){
            UploadResource solrConfig;
            UploadResource schema;

            public Snapshot getSnapshot() {
                return snapshot;
            }

            public Integer getAppId() {
                return snapshot.getAppId();
            }

            public UploadResource getSolrConfig() {
                try {
                    if (this.solrConfig == null && snapshot.getResSolrId() != null) {
                        this.solrConfig = SnapshotViewImplDAO.this.uploadResourceDao.loadFromWriteDB(snapshot.getResSolrId());
                        if (mergeContextParams) {
                            SnapshotViewImplDAO.this.mergeSystemParameter(this.solrConfig);
                        }
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                return this.solrConfig;
            }

            public UploadResource getSolrSchema() {
                if (this.schema == null && snapshot.getResSchemaId() != null) {
                    this.schema = SnapshotViewImplDAO.this.uploadResourceDao.loadFromWriteDB(snapshot.getResSchemaId());
                    if (mergeContextParams) {
                        SnapshotViewImplDAO.this.mergeSystemParameter(this.schema);
                    }
                }
                return this.schema;
            }
        };
        return domain;
    }

    public IResourceParametersDAO getResourceParametersDAO() {
        return this.resourceParametersDAO;
    }

    public void setResourceParametersDAO(IResourceParametersDAO resourceParametersDAO) {
        this.resourceParametersDAO = resourceParametersDAO;
    }

    private VelocityContext createContext() {
        VelocityContext velocityContext = new VelocityContext();
        LazyDynaBean cfg = new LazyDynaBean();
        MergeData mergeData = mergeDataContext.get();
        for (Map.Entry entry : mergeData.entrySet()) {
            cfg.set((String)entry.getKey(), entry.getValue());
        }
        velocityContext.put("cfg", (Object)cfg);
        return velocityContext;
    }

    private void mergeSystemParameter(UploadResource resource) {
        OutputStreamWriter writer = null;
        try {
            VelocityContext context = this.createContext();
            byte[] content = resource.getContent();
            ByteArrayOutputStream converted = new ByteArrayOutputStream();
            writer = new OutputStreamWriter((OutputStream)converted, TisUTF8.get());
            velocityEngine.evaluate((Context)context, (Writer)writer, resource.getResourceType(), new String(content, TisUTF8.get()));
            writer.flush();
            resource.setContent(converted.toByteArray());
            resource.setMd5Code(MD5Utils.md5file((byte[])resource.getContent()));
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(writer);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Writer)writer);
    }

    public static void main(String[] args) {
        SnapshotViewImplDAO dao = new SnapshotViewImplDAO();
        UploadResource resource = new UploadResource();
        resource.setResourceType("test");
        String content = "${cfg.minGramSize}";
        resource.setContent(content.getBytes(TisUTF8.get()));
        dao.mergeSystemParameter(resource);
        System.out.println(new String(resource.getContent(), TisUTF8.get()));
    }

    public void setUploadResourceDao(IUploadResourceDAO uploadResourceDao) {
        this.uploadResourceDao = uploadResourceDao;
    }

    public void setSnapshotDAO(ISnapshotDAO snapshotDAO) {
        this.snapshotDAO = snapshotDAO;
    }

    static {
        try {
            velocityEngine = new VelocityEngine();
            Properties prop = new Properties();
            prop.setProperty("runtime.log.logsystem.class", "org.apache.velocity.runtime.log.NullLogChute");
            velocityEngine.init(prop);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static class MergeData
    extends HashMap<String, Object> {
    }
}

