/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.manage.biz.dal.dao.impl;

import com.ibatis.sqlmap.client.SqlMapExecutor;
import com.ibatis.sqlmap.client.SqlMapSession;
import com.qlangtech.tis.manage.biz.dal.dao.IApplicationDAO;
import com.qlangtech.tis.manage.biz.dal.pojo.Application;
import com.qlangtech.tis.manage.biz.dal.pojo.ApplicationCriteria;
import com.qlangtech.tis.manage.common.BasicDAO;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.orm.ibatis.SqlMapClientCallback;

public class ApplicationDAOImpl
extends BasicDAO<Application, ApplicationCriteria>
implements IApplicationDAO {
    @Override
    public String getEntityName() {
        return "application";
    }

    public Optional<String> selectFirstRowPK() {
        return (Optional)this.getSqlMapClientTemplate().execute((SqlMapClientCallback)new SqlMapClientCallback<Optional<String>>(){

            public Optional<String> doInSqlMapClient(SqlMapExecutor executor) throws SQLException {
                SqlMapSession session = (SqlMapSession)executor;
                Connection conn = session.getCurrentConnection();
                try (Statement statement = Objects.requireNonNull(conn, "conn can not b null").createStatement();){
                    ApplicationCriteria criteria = new ApplicationCriteria();
                    criteria.setPage(Integer.valueOf(1));
                    criteria.setPageSize(Integer.valueOf(1));
                    try (ResultSet resultSet = statement.executeQuery("select app_id,project_name from application" + criteria.getPaginationScript());){
                        if (resultSet.next()) {
                            Optional<String> optional = Optional.of(resultSet.getString(1));
                            return optional;
                        }
                    }
                }
                return Optional.empty();
            }
        });
    }

    public Application selectByName(String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new IllegalArgumentException("param name can not be null");
        }
        Application key = new Application();
        key.setProjectName(name);
        return this.load("application.ibatorgenerated_selectByName", key);
    }

    public int countByExample(ApplicationCriteria example) {
        Integer count = this.count("application.ibatorgenerated_countByExample", example);
        return count;
    }

    public int countFromWriteDB(ApplicationCriteria example) {
        Integer count = this.countFromWriterDB("application.ibatorgenerated_countByExample", example);
        return count;
    }

    public int deleteByExample(ApplicationCriteria criteria) {
        return this.deleteRecords("application.ibatorgenerated_deleteByExample", criteria);
    }

    public int deleteByPrimaryKey(Integer appId) {
        Application key = new Application();
        key.setAppId(appId);
        return this.deleteRecords("application.ibatorgenerated_deleteByPrimaryKey", key);
    }

    public Integer insert(Application record) {
        Integer newKey = this.insert("application.ibatorgenerated_insert", record);
        return newKey;
    }

    public Integer insertSelective(Application record) {
        Integer newKey = this.insert("application.ibatorgenerated_insertSelective", record);
        return newKey;
    }

    public List<Application> selectByExample(ApplicationCriteria criteria) {
        return this.selectByExample(criteria, 1, 100);
    }

    public List<Application> selectByExample(ApplicationCriteria example, int page, int pageSize) {
        example.setPage(Integer.valueOf(page));
        example.setPageSize(Integer.valueOf(pageSize));
        List<Application> list = this.list("application.ibatorgenerated_selectByExample", example);
        return list;
    }

    public Application selectByPrimaryKey(Integer appId) {
        Application key = new Application();
        key.setAppId(appId);
        Application record = this.load("application.ibatorgenerated_selectByPrimaryKey", key);
        return record;
    }

    public int updateByExampleSelective(Application record, ApplicationCriteria example) {
        UpdateByExampleParms parms = new UpdateByExampleParms(record, example);
        return this.updateRecords("application.ibatorgenerated_updateByExampleSelective", parms);
    }

    public int updateLastProcessTime(String appname) {
        if (StringUtils.isBlank((CharSequence)appname)) {
            throw new IllegalArgumentException("param appId can not be null");
        }
        ApplicationCriteria criteria = new ApplicationCriteria();
        criteria.createCriteria().andProjectNameEqualTo(appname);
        return this.updateRecords("application.ibatorgenerated_updateLastProcessTime", criteria);
    }

    public int updateByExample(Application record, ApplicationCriteria example) {
        UpdateByExampleParms parms = new UpdateByExampleParms(record, example);
        return this.updateRecords("application.ibatorgenerated_updateByExample", parms);
    }

    public Application loadFromWriteDB(Integer appId) {
        Application key = new Application();
        key.setAppId(appId);
        Application record = this.loadFromWriterDB("application.ibatorgenerated_selectByPrimaryKey", key);
        return record;
    }

    private static class UpdateByExampleParms
    extends ApplicationCriteria {
        private Object record;

        public UpdateByExampleParms(Object record, ApplicationCriteria example) {
            super(example);
            this.record = record;
        }

        public Object getRecord() {
            return this.record;
        }
    }
}

