/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.db.parser;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.qlangtech.tis.extension.Describable;
import com.qlangtech.tis.plugin.ds.DataSourceFactory;
import com.qlangtech.tis.plugin.ds.ISelectedTab;
import com.qlangtech.tis.util.DescribableJSON;
import com.qlangtech.tis.workflow.pojo.DatasourceDb;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public class DBConfigSuit {
    private final DatasourceDb db;
    private final boolean supportDataXReader;
    private final boolean dataReaderSetted;
    private List<ISelectedTab> tabs = Lists.newArrayList();
    private DescribableJSON detailed;
    private DescribableJSON facade;

    public DBConfigSuit(DatasourceDb db, boolean supportDataXReader, boolean dataReaderSetted) {
        this.dataReaderSetted = dataReaderSetted;
        this.supportDataXReader = supportDataXReader;
        this.db = db;
    }

    public List<String> getSelectedTabs() {
        return this.tabs.stream().map(tab -> tab.getName()).collect(Collectors.toList());
    }

    public ISelectedTab getTab(String tab) {
        Optional<ISelectedTab> targetTab = this.tabs.stream().filter(t -> StringUtils.equals((String)t.getName(), (String)tab)).findFirst();
        if (!targetTab.isPresent()) {
            throw new IllegalStateException("target table:" + tab + " can not be empty");
        }
        return targetTab.get();
    }

    public void addTabs(List<ISelectedTab> tabs) {
        this.tabs.addAll(tabs);
    }

    public boolean isSupportDataXReader() {
        return this.supportDataXReader;
    }

    public boolean isDataReaderSetted() {
        return this.dataReaderSetted;
    }

    public Integer getDbId() {
        return this.db.getId();
    }

    public String getName() {
        return this.db.getName();
    }

    public JSONObject getDetailed() throws Exception {
        return this.detailed.getItemJson();
    }

    public JSONObject getFacade() throws Exception {
        if (this.facade == null) {
            return null;
        }
        return this.facade.getItemJson();
    }

    public void setDetailed(DataSourceFactory detailed) {
        if (detailed == null) {
            throw new IllegalStateException("param detailed can not be null");
        }
        this.detailed = new DescribableJSON((Describable)detailed);
    }

    public void setFacade(DataSourceFactory facade) {
        if (facade == null) {
            throw new IllegalStateException("param detailed can not be null");
        }
        this.facade = new DescribableJSON((Describable)facade);
    }
}

