/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.coredefine.module.action;

import com.alibaba.citrus.turbine.Context;
import com.google.common.collect.Maps;
import com.qlangtech.tis.config.k8s.ReplicasSpec;
import com.qlangtech.tis.coredefine.module.action.IDeploymentDetail;
import com.qlangtech.tis.coredefine.module.action.IRCController;
import com.qlangtech.tis.coredefine.module.action.Specification;
import com.qlangtech.tis.coredefine.module.action.TargetResName;
import com.qlangtech.tis.coredefine.module.action.impl.AdapterRCController;
import com.qlangtech.tis.coredefine.module.action.impl.FlinkJobDeploymentDetails;
import com.qlangtech.tis.coredefine.module.action.impl.RcDeployment;
import com.qlangtech.tis.datax.DataXName;
import com.qlangtech.tis.datax.job.DataXJobWorker;
import com.qlangtech.tis.datax.job.JobOrchestrateException;
import com.qlangtech.tis.lang.TisException;
import com.qlangtech.tis.plugin.incr.IncrStreamFactory;
import com.qlangtech.tis.plugin.incr.WatchPodLog;
import com.qlangtech.tis.realtime.yarn.rpc.JobType;
import com.qlangtech.tis.runtime.module.misc.IMessageHandler;
import com.qlangtech.tis.trigger.jst.ILogListener;
import com.qlangtech.tis.util.HeteroEnum;
import com.qlangtech.tis.util.PluginItems;
import java.net.MalformedURLException;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TISK8sDelegate {
    private static final Logger logger = LoggerFactory.getLogger(TISK8sDelegate.class);
    private static final ConcurrentHashMap<String, TISK8sDelegate> colIncrLogMap = new ConcurrentHashMap();
    private final TargetResName indexName;
    private final IRCController incrSync;
    private IDeploymentDetail incrDeployment;
    private long latestIncrDeploymentFetchtime;
    private Map<String, WatchPodLog> watchPodLogMap = Maps.newHashMap();

    public static TISK8sDelegate getK8SDelegate(DataXName collection) {
        TISK8sDelegate delegate = null;
        collection.assetCheckDataAppType();
        delegate = colIncrLogMap.get(collection.getPipelineName());
        if (delegate == null) {
            delegate = colIncrLogMap.computeIfAbsent(collection.getPipelineName(), c -> new TISK8sDelegate((String)c));
        }
        return delegate;
    }

    private TISK8sDelegate(String indexName) {
        if (StringUtils.isEmpty((String)indexName)) {
            throw new IllegalArgumentException("param indexName can not be null");
        }
        if (TargetResName.K8S_DATAX_INSTANCE_NAME.getName().equals(indexName) || DataXJobWorker.K8S_FLINK_CLUSTER_NAME.match(indexName)) {
            final DataXJobWorker dataxWorker = DataXJobWorker.getJobWorker((TargetResName)new TargetResName(indexName));
            this.incrSync = new AdapterRCController(){

                public WatchPodLog listPodAndWatchLog(TargetResName collection, String podName, ILogListener listener) {
                    return dataxWorker.listPodAndWatchLog(podName, listener);
                }
            };
        } else {
            IncrStreamFactory k8sConfig = IncrStreamFactory.getFactory((String)indexName);
            this.incrSync = k8sConfig;
        }
        this.indexName = new TargetResName(indexName);
    }

    public final boolean hasCreated() {
        return this.incrSync.hasCreated(this.indexName);
    }

    public void checkUseable(boolean deploying) {
        this.incrSync.checkUseable(this.indexName, deploying);
    }

    public static void main(String[] args) throws Exception {
        ReplicasSpec incrSpec = new ReplicasSpec();
        incrSpec.setReplicaCount(1);
        incrSpec.setCpuLimit(Specification.parse((String)"2"));
        incrSpec.setCpuRequest(Specification.parse((String)"500m"));
        incrSpec.setMemoryLimit(Specification.parse((String)"2G"));
        incrSpec.setMemoryRequest(Specification.parse((String)"500M"));
        TISK8sDelegate incrK8s = new TISK8sDelegate("search4totalpay");
        incrK8s.isRCDeployment(true);
    }

    public void deploy(ReplicasSpec incrSpec, long timestamp) throws JobOrchestrateException {
        this.incrSync.deploy(this.indexName, incrSpec, timestamp);
    }

    public boolean isRCDeployment(boolean canGetCache) {
        return this.getRcConfig(canGetCache) != null;
    }

    public IDeploymentDetail getRcConfig(boolean canGetCache) {
        long current = System.currentTimeMillis();
        if (!canGetCache || this.incrDeployment == null || current > this.latestIncrDeploymentFetchtime + 40000L) {
            this.latestIncrDeploymentFetchtime = current;
            this.incrDeployment = null;
            this.incrDeployment = this.incrSync.getRCDeployment(this.indexName);
            if (this.incrDeployment == null) {
                return null;
            }
            this.incrDeployment.accept(new IDeploymentDetail.IDeploymentDetailVisitor(){

                public void visit(RcDeployment rcDeployment) {
                    TISK8sDelegate.this.watchPodLogMap.entrySet().removeIf(entry -> !rcDeployment.getPods().stream().filter(p -> StringUtils.equals((String)p.getName(), (String)((String)entry.getKey()))).findFirst().isPresent());
                }

                public void visit(FlinkJobDeploymentDetails details) {
                }
            });
        }
        return this.incrDeployment;
    }

    public void stopIncrProcess(IMessageHandler handler, Context context) {
        IRCController.SupportTriggerSavePointResult vresult = this.incrSync.supportTriggerSavePoint(this.indexName);
        if (!vresult.support) {
            handler.addErrorMessage(context, vresult.getUnSupportReason());
            return;
        }
        try {
            this.incrSync.stopInstance(this.indexName);
            this.cleanResource();
        }
        catch (Exception e) {
            if (this.incrSync.getRCDeployment(this.indexName) == null) {
                this.cleanResource();
            }
            throw new RuntimeException(this.indexName.getName(), e);
        }
    }

    public void removeIncrProcess() {
        try {
            this.incrSync.removeInstance(this.indexName);
            this.cleanResource();
        }
        catch (Throwable e) {
            try {
                if (this.incrSync.getRCDeployment(this.indexName) == null) {
                    this.cleanResource();
                }
            }
            catch (Exception ex) {
                logger.warn(ex.getMessage());
            }
            throw new RuntimeException(this.indexName.getName(), e);
        }
    }

    private void cleanResource() {
        this.incrDeployment = null;
        TISK8sDelegate tisk8sDelegate = colIncrLogMap.remove(this.indexName);
        if (tisk8sDelegate != null) {
            tisk8sDelegate.close();
        }
        JobType.RemoteCallResult remoteCallResult = null;
        try {
            remoteCallResult = JobType.PipelineDelete.assembIncrControlWithResult(this.indexName.getName(), Collections.emptyList(), null);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        if (remoteCallResult == null || !remoteCallResult.success) {
            throw TisException.create((String)("piple:" + this.indexName + " delete faild,detail:" + (remoteCallResult != null ? remoteCallResult.msg : "")));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void listPodsAndWatchLog(String podName, ILogListener listener) {
        if (StringUtils.isEmpty((String)podName)) {
            throw new IllegalArgumentException("illegal argument 'podName' can not be null");
        }
        WatchPodLog watchPodLog = null;
        TISK8sDelegate tISK8sDelegate = this;
        synchronized (tISK8sDelegate) {
            watchPodLog = this.watchPodLogMap.get(podName);
            if (watchPodLog == null) {
                watchPodLog = this.incrSync.listPodAndWatchLog(this.indexName, podName, listener);
                this.watchPodLogMap.put(podName, watchPodLog);
            } else {
                watchPodLog.addListener(listener);
            }
        }
    }

    public void close() {
        this.watchPodLogMap.values().forEach(r -> r.close());
    }

    static {
        PluginItems.addPluginItemsSaveObserver(new PluginItems.PluginItemsSaveObserver(){

            @Override
            public void afterSaved(PluginItems.PluginItemsSaveEvent event) {
                if (!event.cfgChanged) {
                    return;
                }
                if (event.heteroEnum == HeteroEnum.PARAMS_CONFIG || event.heteroEnum == HeteroEnum.INCR_STREAM_CONFIG) {
                    colIncrLogMap.values().forEach(r -> r.close());
                    colIncrLogMap.clear();
                }
            }
        });
    }
}

