/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.coredefine.module.action;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.qlangtech.tis.TIS;
import com.qlangtech.tis.extension.model.UpdateCenter;
import com.qlangtech.tis.extension.model.UpdateSite;
import com.qlangtech.tis.install.InstallState;
import com.qlangtech.tis.maven.plugins.tpi.PluginClassifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginWillInstall {
    private static final Logger logger = LoggerFactory.getLogger(PluginWillInstall.class);
    private String name;
    private Optional<PluginClassifier> classifier;
    private boolean multiClassifier;
    private static final ExecutorService executorService = Executors.newSingleThreadExecutor();

    public static List<PluginWillInstall> parse(JSONArray pluginsInstall) {
        ArrayList willBeInstall = Lists.newArrayList();
        PluginWillInstall pi = null;
        for (int i = 0; i < pluginsInstall.size(); ++i) {
            JSONObject willInstall = pluginsInstall.getJSONObject(i);
            String pluginName = willInstall.getString("name");
            Optional<PluginClassifier> classifier = Optional.empty();
            String c = null;
            c = willInstall.getString("selectedClassifier");
            if (StringUtils.isNotEmpty((CharSequence)c)) {
                classifier = Optional.of(PluginClassifier.create((String)c));
            }
            pi = new PluginWillInstall(pluginName, classifier, willInstall.getBooleanValue("multiClassifier"));
            willBeInstall.add(pi);
        }
        return willBeInstall;
    }

    public static Future<Boolean> installPlugins(List<PluginWillInstall> pluginsInstall) {
        long start = System.currentTimeMillis();
        boolean dynamicLoad = true;
        UUID correlationId = UUID.randomUUID();
        final UpdateCenter updateCenter = TIS.get().getUpdateCenter();
        final ArrayList<Future> installJobs = new ArrayList<Future>();
        PluginWillInstall willInstall = null;
        String pluginName = null;
        UpdateSite.Plugin plugin = null;
        ArrayList coords = Lists.newArrayList();
        ArrayList batch = new ArrayList();
        for (int i = 0; i < pluginsInstall.size(); ++i) {
            willInstall = pluginsInstall.get(i);
            pluginName = willInstall.getName();
            Optional<PluginClassifier> classifier = willInstall.getSelectedClassifier();
            if (StringUtils.isEmpty((CharSequence)pluginName)) {
                throw new IllegalStateException("plugin name can not empty");
            }
            plugin = updateCenter.getPlugin(pluginName);
            coords.add(Pair.of((Object)plugin, classifier));
        }
        for (Pair coord : coords) {
            ((UpdateSite.Plugin)coord.getLeft()).validateLicense();
            Future installJob = ((UpdateSite.Plugin)coord.getLeft()).deploy(true, correlationId, (Optional)coord.getRight(), batch);
            installJobs.add(installJob);
        }
        UpdateCenter updateCenter2 = updateCenter;
        Objects.requireNonNull(updateCenter2);
        installJobs.add(updateCenter.addJob((UpdateCenter.UpdateCenterJob)new UpdateCenter.CompleteBatchJob(updateCenter2, batch, start, correlationId)));
        TIS tis = TIS.get();
        tis.setInstallState(InstallState.INITIAL_PLUGINS_INSTALLING);
        updateCenter.persistInstallStatus();
        return executorService.submit(new Callable<Boolean>(){

            /*
             * Exception decompiling
             */
            @Override
            public Boolean call() throws Exception {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[DOLOOP]], but top level block is 5[WHILELOOP]
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        });
    }

    public PluginWillInstall(String name, Optional<PluginClassifier> selectedClassifier, boolean multiClassifier) {
        this.name = name;
        this.classifier = selectedClassifier;
        this.multiClassifier = multiClassifier;
    }

    public PluginWillInstall(String name) {
        this(name, Optional.empty(), false);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Optional<PluginClassifier> getSelectedClassifier() {
        return this.classifier;
    }

    public boolean isPresentPluginClassifier() {
        return this.getSelectedClassifier().isPresent();
    }

    public void setSelectedClassifier(Optional<PluginClassifier> selectedClassifier) {
        this.classifier = selectedClassifier;
    }

    public boolean isMultiClassifier() {
        return this.multiClassifier;
    }

    public void setMultiClassifier(boolean multiClassifier) {
        this.multiClassifier = multiClassifier;
    }

    private static /* synthetic */ Boolean lambda$installPlugins$0() throws Exception {
        return false;
    }
}

